/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.jdkport;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import org.gnit.lucenekmp.jdkport.ByteBuffer;
import org.gnit.lucenekmp.jdkport.CharBuffer;
import org.gnit.lucenekmp.jdkport.Character;
import org.gnit.lucenekmp.jdkport.Charset;
import org.gnit.lucenekmp.jdkport.CharsetDecoder;
import org.gnit.lucenekmp.jdkport.CharsetEncoder;
import org.gnit.lucenekmp.jdkport.CoderResult;
import org.gnit.lucenekmp.jdkport.JavaLangAccess;
import org.gnit.lucenekmp.jdkport.StandardCharsets;
import org.gnit.lucenekmp.jdkport.Surrogate;
import org.gnit.lucenekmp.jdkport.Unicode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \n2\u00020\u0001:\u0003\b\t\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u000b"}, d2={"Lorg/gnit/lucenekmp/jdkport/UTF_8;", "Lorg/gnit/lucenekmp/jdkport/Unicode;", "<init>", "()V", "newDecoder", "Lorg/gnit/lucenekmp/jdkport/CharsetDecoder;", "newEncoder", "Lorg/gnit/lucenekmp/jdkport/CharsetEncoder;", "Decoder", "Encoder", "Companion", "core"})
public final class UTF_8
extends Unicode {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final JavaLangAccess JLA = JavaLangAccess.INSTANCE;

    public UTF_8() {
        super("UTF-8", StandardCharsets.Companion.aliases_UTF_8());
    }

    @Override
    @NotNull
    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    @Override
    @NotNull
    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tJ&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\tR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lorg/gnit/lucenekmp/jdkport/UTF_8$Companion;", "", "<init>", "()V", "updatePositions", "", "src", "Lorg/gnit/lucenekmp/jdkport/ByteBuffer;", "sp", "", "dst", "Lorg/gnit/lucenekmp/jdkport/CharBuffer;", "dp", "JLA", "Lorg/gnit/lucenekmp/jdkport/JavaLangAccess;", "getJLA", "()Lorg/gnit/lucenekmp/jdkport/JavaLangAccess;", "core"})
    public static final class Companion {
        private Companion() {
        }

        public final void updatePositions(@NotNull ByteBuffer src, int sp, @NotNull CharBuffer dst, int dp) {
            Intrinsics.checkNotNullParameter((Object)src, (String)"src");
            Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
            src.setPosition(sp - src.arrayOffset());
            dst.setPosition(dp - dst.arrayOffset());
        }

        public final void updatePositions(@NotNull CharBuffer src, int sp, @NotNull ByteBuffer dst, int dp) {
            Intrinsics.checkNotNullParameter((Object)src, (String)"src");
            Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
            src.setPosition(sp - src.arrayOffset());
            dst.setPosition(dp - dst.arrayOffset());
        }

        @NotNull
        public final JavaLangAccess getJLA() {
            return JLA;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0018\u0010\f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u001a\u0010\r\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014\u00a8\u0006\u000f"}, d2={"Lorg/gnit/lucenekmp/jdkport/UTF_8$Decoder;", "Lorg/gnit/lucenekmp/jdkport/CharsetDecoder;", "cs", "Lorg/gnit/lucenekmp/jdkport/Charset;", "<init>", "(Lorg/gnit/lucenekmp/jdkport/Charset;)V", "decodeArrayLoop", "Lorg/gnit/lucenekmp/jdkport/CoderResult;", "src", "Lorg/gnit/lucenekmp/jdkport/ByteBuffer;", "dst", "Lorg/gnit/lucenekmp/jdkport/CharBuffer;", "decodeBufferLoop", "decodeLoop", "Companion", "core"})
    private static final class Decoder
    extends CharsetDecoder {
        @NotNull
        public static final Companion Companion = new Companion(null);

        public Decoder(@NotNull Charset cs) {
            Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
            super(cs, 1.0f, 1.0f);
        }

        @Nullable
        public final CoderResult decodeArrayLoop(@NotNull ByteBuffer src, @NotNull CharBuffer dst) {
            Intrinsics.checkNotNullParameter((Object)src, (String)"src");
            Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
            byte[] sa = src.array();
            int soff = src.arrayOffset();
            int sp = soff + src.getPosition();
            int sl = soff + src.getLimit();
            char[] da = dst.array();
            int doff = dst.arrayOffset();
            int dp = doff + dst.getPosition();
            int dl = doff + dst.getLimit();
            int n = Companion.getJLA().decodeASCII(sa, sp, da, dp, Math.min(sl - sp, dl - dp));
            sp += n;
            dp += n;
            while (sp < sl) {
                byte b3;
                byte b2;
                int srcRemaining;
                int b1 = sa[sp];
                if (b1 >= 0) {
                    if (dp >= dl) {
                        return Decoder.Companion.xflow(src, sp, sl, dst, dp, 1);
                    }
                    da[dp++] = (char)b1;
                    ++sp;
                    continue;
                }
                if (b1 >> 5 == -2 && (b1 & 0x1E) != 0) {
                    if (sl - sp < 2 || dp >= dl) {
                        return Decoder.Companion.xflow(src, sp, sl, dst, dp, 2);
                    }
                    byte b22 = sa[sp + 1];
                    if (Decoder.Companion.isNotContinuation(b22)) {
                        return Decoder.Companion.malformedForLength(src, sp, dst, dp, 1);
                    }
                    da[dp++] = (char)(b1 << 6 ^ b22 ^ 0xF80);
                    sp += 2;
                    continue;
                }
                if (b1 >> 4 == -2) {
                    srcRemaining = sl - sp;
                    if (srcRemaining < 3 || dp >= dl) {
                        if (srcRemaining > 1 && Decoder.Companion.isMalformed3_2(b1, sa[sp + 1])) {
                            return Decoder.Companion.malformedForLength(src, sp, dst, dp, 1);
                        }
                        return Decoder.Companion.xflow(src, sp, sl, dst, dp, 3);
                    }
                    b2 = sa[sp + 1];
                    b3 = sa[sp + 2];
                    if (Decoder.Companion.isMalformed3(b1, b2, b3)) {
                        return Decoder.Companion.malformed(src, sp, dst, dp, 3);
                    }
                    char c = (char)(b1 << 12 ^ b2 << 6 ^ (b3 ^ 0xFFFE1F80));
                    if (CharsKt.isSurrogate((char)c)) {
                        return Decoder.Companion.malformedForLength(src, sp, dst, dp, 3);
                    }
                    da[dp++] = c;
                    sp += 3;
                    continue;
                }
                if (b1 >> 3 == -2) {
                    srcRemaining = sl - sp;
                    if (srcRemaining < 4 || dl - dp < 2) {
                        if ((b1 &= 0xFF) > 244 || srcRemaining > 1 && Decoder.Companion.isMalformed4_2(b1, sa[sp + 1] & 0xFF)) {
                            return Decoder.Companion.malformedForLength(src, sp, dst, dp, 1);
                        }
                        if (srcRemaining > 2 && Decoder.Companion.isMalformed4_3(sa[sp + 2])) {
                            return Decoder.Companion.malformedForLength(src, sp, dst, dp, 2);
                        }
                        return Decoder.Companion.xflow(src, sp, sl, dst, dp, 4);
                    }
                    b2 = sa[sp + 1];
                    b3 = sa[sp + 2];
                    byte b4 = sa[sp + 3];
                    int uc = b1 << 18 ^ b2 << 12 ^ b3 << 6 ^ (b4 ^ 0x381F80);
                    if (Decoder.Companion.isMalformed4(b2, b3, b4) || !Character.Companion.isSupplementaryCodePoint(uc)) {
                        return Decoder.Companion.malformed(src, sp, dst, dp, 4);
                    }
                    da[dp++] = Character.Companion.highSurrogate(uc);
                    da[dp++] = Character.Companion.lowSurrogate(uc);
                    sp += 4;
                    continue;
                }
                return Decoder.Companion.malformed(src, sp, dst, dp, 1);
            }
            return Decoder.Companion.xflow(src, sp, sl, dst, dp, 0);
        }

        @Nullable
        public final CoderResult decodeBufferLoop(@NotNull ByteBuffer src, @NotNull CharBuffer dst) {
            Intrinsics.checkNotNullParameter((Object)src, (String)"src");
            Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
            int mark = src.getPosition();
            int limit = src.getLimit();
            while (mark < limit) {
                byte b3;
                byte b2;
                int srcRemaining;
                int b1 = src.get();
                if (b1 >= 0) {
                    if (dst.remaining() < 1) {
                        return Decoder.Companion.xflow(src, mark, 1);
                    }
                    dst.put((char)b1);
                    ++mark;
                    continue;
                }
                if (b1 >> 5 == -2 && (b1 & 0x1E) != 0) {
                    if (limit - mark < 2 || dst.remaining() < 1) {
                        return Decoder.Companion.xflow(src, mark, 2);
                    }
                    byte b22 = src.get();
                    if (Decoder.Companion.isNotContinuation(b22)) {
                        return Decoder.Companion.malformedForLength(src, mark, 1);
                    }
                    dst.put((char)(b1 << 6 ^ b22 ^ 0xF80));
                    mark += 2;
                    continue;
                }
                if (b1 >> 4 == -2) {
                    srcRemaining = limit - mark;
                    if (srcRemaining < 3 || dst.remaining() < 1) {
                        if (srcRemaining > 1 && Decoder.Companion.isMalformed3_2(b1, src.get())) {
                            return Decoder.Companion.malformedForLength(src, mark, 1);
                        }
                        return Decoder.Companion.xflow(src, mark, 3);
                    }
                    b2 = src.get();
                    if (Decoder.Companion.isMalformed3(b1, b2, b3 = src.get())) {
                        return Decoder.Companion.malformed(src, mark, 3);
                    }
                    char c = (char)(b1 << 12 ^ b2 << 6 ^ (b3 ^ 0xFFFE1F80));
                    if (CharsKt.isSurrogate((char)c)) {
                        return Decoder.Companion.malformedForLength(src, mark, 3);
                    }
                    dst.put(c);
                    mark += 3;
                    continue;
                }
                if (b1 >> 3 == -2) {
                    srcRemaining = limit - mark;
                    if (srcRemaining < 4 || dst.remaining() < 2) {
                        if ((b1 &= 0xFF) > 244 || srcRemaining > 1 && Decoder.Companion.isMalformed4_2(b1, src.get() & 0xFF)) {
                            return Decoder.Companion.malformedForLength(src, mark, 1);
                        }
                        if (srcRemaining > 2 && Decoder.Companion.isMalformed4_3(src.get())) {
                            return Decoder.Companion.malformedForLength(src, mark, 2);
                        }
                        return Decoder.Companion.xflow(src, mark, 4);
                    }
                    b2 = src.get();
                    b3 = src.get();
                    byte b4 = src.get();
                    int uc = b1 << 18 ^ b2 << 12 ^ b3 << 6 ^ (b4 ^ 0x381F80);
                    if (Decoder.Companion.isMalformed4(b2, b3, b4) || !Character.Companion.isSupplementaryCodePoint(uc)) {
                        return Decoder.Companion.malformed(src, mark, 4);
                    }
                    dst.put(Character.Companion.highSurrogate(uc));
                    dst.put(Character.Companion.lowSurrogate(uc));
                    mark += 4;
                    continue;
                }
                return Decoder.Companion.malformed(src, mark, 1);
            }
            return Decoder.Companion.xflow(src, mark, 0);
        }

        @Override
        @Nullable
        protected CoderResult decodeLoop(@NotNull ByteBuffer src, @NotNull CharBuffer dst) {
            Intrinsics.checkNotNullParameter((Object)src, (String)"src");
            Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
            if (src.hasArray() && dst.hasArray()) {
                return this.decodeArrayLoop(src, dst);
            }
            return this.decodeBufferLoop(src, dst);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J \u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007H\u0002J\u0018\u0010\f\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007H\u0002J \u0010\r\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007H\u0002J\u0018\u0010\u000f\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007H\u0002J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0007H\u0002J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0007H\u0002J2\u0010\u0016\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0007H\u0002J\"\u0010\u0016\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0007H\u0002J2\u0010\u001c\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u0007H\u0002J\"\u0010\u001c\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u0007H\u0002J8\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0007H\u0002J \u0010\u001e\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0007H\u0002\u00a8\u0006 "}, d2={"Lorg/gnit/lucenekmp/jdkport/UTF_8$Decoder$Companion;", "", "<init>", "()V", "isNotContinuation", "", "b", "", "isMalformed3", "b1", "b2", "b3", "isMalformed3_2", "isMalformed4", "b4", "isMalformed4_2", "isMalformed4_3", "malformedN", "Lorg/gnit/lucenekmp/jdkport/CoderResult;", "src", "Lorg/gnit/lucenekmp/jdkport/ByteBuffer;", "nb", "malformed", "sp", "dst", "Lorg/gnit/lucenekmp/jdkport/CharBuffer;", "dp", "mark", "malformedForLength", "malformedNB", "xflow", "sl", "core"})
        public static final class Companion {
            private Companion() {
            }

            private final boolean isNotContinuation(int b) {
                return (b & 0xC0) != 128;
            }

            private final boolean isMalformed3(int b1, int b2, int b3) {
                return b1 == -32 && (b2 & 0xE0) == 128 || (b2 & 0xC0) != 128 || (b3 & 0xC0) != 128;
            }

            private final boolean isMalformed3_2(int b1, int b2) {
                return b1 == -32 && (b2 & 0xE0) == 128 || (b2 & 0xC0) != 128;
            }

            private final boolean isMalformed4(int b2, int b3, int b4) {
                return (b2 & 0xC0) != 128 || (b3 & 0xC0) != 128 || (b4 & 0xC0) != 128;
            }

            private final boolean isMalformed4_2(int b1, int b2) {
                return b1 == 240 && (b2 < 144 || b2 > 191) || b1 == 244 && (b2 & 0xF0) != 128 || (b2 & 0xC0) != 128;
            }

            private final boolean isMalformed4_3(int b3) {
                return (b3 & 0xC0) != 128;
            }

            private final CoderResult malformedN(ByteBuffer src, int nb) {
                switch (nb) {
                    case 1: 
                    case 2: {
                        return CoderResult.Companion.malformedForLength(1);
                    }
                    case 3: {
                        byte b1 = src.get();
                        byte b2 = src.get();
                        return CoderResult.Companion.malformedForLength(b1 == -32 && (b2 & 0xE0) == 128 || this.isNotContinuation(b2) ? 1 : 2);
                    }
                    case 4: {
                        int b1 = src.get() & 0xFF;
                        int b2 = src.get() & 0xFF;
                        if (b1 > 244 || b1 == 240 && (b2 < 144 || b2 > 191) || b1 == 244 && (b2 & 0xF0) != 128 || this.isNotContinuation(b2)) {
                            return CoderResult.Companion.malformedForLength(1);
                        }
                        if (this.isNotContinuation(src.get())) {
                            return CoderResult.Companion.malformedForLength(2);
                        }
                        return CoderResult.Companion.malformedForLength(3);
                    }
                }
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }

            private final CoderResult malformed(ByteBuffer src, int sp, CharBuffer dst, int dp, int nb) {
                src.position(sp - src.arrayOffset());
                CoderResult cr = this.malformedN(src, nb);
                UTF_8.Companion.updatePositions(src, sp, dst, dp);
                return cr;
            }

            private final CoderResult malformed(ByteBuffer src, int mark, int nb) {
                src.position(mark);
                CoderResult cr = this.malformedN(src, nb);
                src.position(mark);
                return cr;
            }

            private final CoderResult malformedForLength(ByteBuffer src, int sp, CharBuffer dst, int dp, int malformedNB) {
                UTF_8.Companion.updatePositions(src, sp, dst, dp);
                return CoderResult.Companion.malformedForLength(malformedNB);
            }

            private final CoderResult malformedForLength(ByteBuffer src, int mark, int malformedNB) {
                src.position(mark);
                return CoderResult.Companion.malformedForLength(malformedNB);
            }

            private final CoderResult xflow(ByteBuffer src, int sp, int sl, CharBuffer dst, int dp, int nb) {
                UTF_8.Companion.updatePositions(src, sp, dst, dp);
                return nb == 0 || sl - sp < nb ? CoderResult.Companion.getUNDERFLOW() : CoderResult.Companion.getOVERFLOW();
            }

            private final CoderResult xflow(ByteBuffer src, int mark, int nb) {
                src.position(mark);
                return nb == 0 || src.remaining() < nb ? CoderResult.Companion.getUNDERFLOW() : CoderResult.Companion.getOVERFLOW();
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\b\n\u0002\b\b\b\u0002\u0018\u0000  2\u00020\u0001:\u0001 B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014JH\u0010\u0015\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u0019J\u0016\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0018\u0010\u001f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/gnit/lucenekmp/jdkport/UTF_8$Encoder;", "Lorg/gnit/lucenekmp/jdkport/CharsetEncoder;", "cs", "Lorg/gnit/lucenekmp/jdkport/Charset;", "<init>", "(Lorg/gnit/lucenekmp/jdkport/Charset;)V", "canEncode", "", "c", "", "isLegalReplacement", "repl", "", "sgp", "Lorg/gnit/lucenekmp/jdkport/Surrogate$Parser;", "encodeArrayLoop", "Lorg/gnit/lucenekmp/jdkport/CoderResult;", "src", "Lorg/gnit/lucenekmp/jdkport/CharBuffer;", "dst", "Lorg/gnit/lucenekmp/jdkport/ByteBuffer;", "encodeArrayLoopSlow", "sa", "", "sp", "", "sl", "da", "dp", "dl", "encodeBufferLoop", "encodeLoop", "Companion", "core"})
    private static final class Encoder
    extends CharsetEncoder {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private Surrogate.Parser sgp;

        public Encoder(@NotNull Charset cs) {
            Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
            super(cs, 1.1f, 3.0f, null, 8, null);
        }

        @Override
        public boolean canEncode(char c) {
            return !CharsKt.isSurrogate((char)c);
        }

        @Override
        public boolean isLegalReplacement(@NotNull byte[] repl) {
            Intrinsics.checkNotNullParameter((Object)repl, (String)"repl");
            return repl.length == 1 && repl[0] >= 0 || super.isLegalReplacement(repl);
        }

        @NotNull
        public final CoderResult encodeArrayLoop(@NotNull CharBuffer src, @NotNull ByteBuffer dst) {
            Intrinsics.checkNotNullParameter((Object)src, (String)"src");
            Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
            char[] sa = src.array();
            int sp = src.arrayOffset() + src.position();
            int sl = src.arrayOffset() + src.getLimit();
            byte[] da = dst.array();
            int dp = dst.arrayOffset() + dst.getPosition();
            int dl = dst.arrayOffset() + dst.getLimit();
            int n = JavaLangAccess.INSTANCE.encodeASCII(sa, sp, da, dp, Math.min(sl - sp, dl - dp));
            dp += n;
            if ((sp += n) < sl) {
                CoderResult coderResult = this.encodeArrayLoopSlow(src, sa, sp, sl, dst, da, dp, dl);
                Intrinsics.checkNotNull((Object)coderResult);
                return coderResult;
            }
            Companion.updatePositions(src, sp, dst, dp);
            return CoderResult.Companion.getUNDERFLOW();
        }

        @Nullable
        public final CoderResult encodeArrayLoopSlow(@NotNull CharBuffer src, @NotNull char[] sa, int sp, int sl, @NotNull ByteBuffer dst, @NotNull byte[] da, int dp, int dl) {
            int sp2;
            Intrinsics.checkNotNullParameter((Object)src, (String)"src");
            Intrinsics.checkNotNullParameter((Object)sa, (String)"sa");
            Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
            Intrinsics.checkNotNullParameter((Object)da, (String)"da");
            int dp2 = dp;
            for (sp2 = sp; sp2 < sl; ++sp2) {
                char c = sa[sp2];
                if (c < '\u0080') {
                    if (dp2 >= dl) {
                        return Encoder.Companion.overflow(src, sp2, dst, dp2);
                    }
                    da[dp2++] = (byte)c;
                    continue;
                }
                if (c < '\u0800') {
                    if (dl - dp2 < 2) {
                        return Encoder.Companion.overflow(src, sp2, dst, dp2);
                    }
                    da[dp2++] = (byte)(0xC0 | c >> 6);
                    da[dp2++] = (byte)(0x80 | c & 0x3F);
                    continue;
                }
                if (CharsKt.isSurrogate((char)c)) {
                    if (this.sgp == null) {
                        this.sgp = new Surrogate.Parser();
                    }
                    Surrogate.Parser parser = this.sgp;
                    Intrinsics.checkNotNull((Object)parser);
                    int uc = parser.parse(c, sa, sp2, sl);
                    if (uc < 0) {
                        Companion.updatePositions(src, sp2, dst, dp2);
                        Surrogate.Parser parser2 = this.sgp;
                        Intrinsics.checkNotNull((Object)parser2);
                        return parser2.error();
                    }
                    if (dl - dp2 < 4) {
                        return Encoder.Companion.overflow(src, sp2, dst, dp2);
                    }
                    da[dp2++] = (byte)(0xF0 | uc >> 18);
                    da[dp2++] = (byte)(0x80 | uc >> 12 & 0x3F);
                    da[dp2++] = (byte)(0x80 | uc >> 6 & 0x3F);
                    da[dp2++] = (byte)(0x80 | uc & 0x3F);
                    ++sp2;
                    continue;
                }
                if (dl - dp2 < 3) {
                    return Encoder.Companion.overflow(src, sp2, dst, dp2);
                }
                da[dp2++] = (byte)(0xE0 | c >> 12);
                da[dp2++] = (byte)(0x80 | c >> 6 & 0x3F);
                da[dp2++] = (byte)(0x80 | c & 0x3F);
            }
            Companion.updatePositions(src, sp2, dst, dp2);
            return CoderResult.Companion.getUNDERFLOW();
        }

        @NotNull
        public final CoderResult encodeBufferLoop(@NotNull CharBuffer src, @NotNull ByteBuffer dst) {
            Intrinsics.checkNotNullParameter((Object)src, (String)"src");
            Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
            int mark = src.position();
            while (src.hasRemaining()) {
                char c = src.get();
                if (c < '\u0080') {
                    if (!dst.hasRemaining()) {
                        return Encoder.Companion.overflow(src, mark);
                    }
                    v0 = dst.put((byte)c);
                } else if (c < '\u0800') {
                    if (dst.remaining() < 2) {
                        return Encoder.Companion.overflow(src, mark);
                    }
                    dst.put((byte)(0xC0 | c >> 6));
                    v0 = dst.put((byte)(0x80 | c & 0x3F));
                } else if (CharsKt.isSurrogate((char)c)) {
                    if (this.sgp == null) {
                        this.sgp = new Surrogate.Parser();
                    }
                    Surrogate.Parser parser = this.sgp;
                    Intrinsics.checkNotNull((Object)parser);
                    int uc = parser.parse(c, src);
                    if (uc < 0) {
                        src.setPosition(mark);
                        Surrogate.Parser parser2 = this.sgp;
                        Intrinsics.checkNotNull((Object)parser2);
                        CoderResult coderResult = parser2.error();
                        Intrinsics.checkNotNull((Object)coderResult);
                        return coderResult;
                    }
                    if (dst.remaining() < 4) {
                        return Encoder.Companion.overflow(src, mark);
                    }
                    dst.put((byte)(0xF0 | uc >> 18));
                    dst.put((byte)(0x80 | uc >> 12 & 0x3F));
                    dst.put((byte)(0x80 | uc >> 6 & 0x3F));
                    dst.put((byte)(0x80 | uc & 0x3F));
                    v0 = Integer.valueOf(mark++);
                } else {
                    if (dst.remaining() < 3) {
                        return Encoder.Companion.overflow(src, mark);
                    }
                    dst.put((byte)(0xE0 | c >> 12));
                    dst.put((byte)(0x80 | c >> 6 & 0x3F));
                    v0 = dst.put((byte)(0x80 | c & 0x3F));
                }
                ++mark;
            }
            src.setPosition(mark);
            return CoderResult.Companion.getUNDERFLOW();
        }

        @Override
        @NotNull
        protected CoderResult encodeLoop(@NotNull CharBuffer src, @NotNull ByteBuffer dst) {
            Intrinsics.checkNotNullParameter((Object)src, (String)"src");
            Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
            if (src.hasArray() && dst.hasArray()) {
                return this.encodeArrayLoop(src, dst);
            }
            return this.encodeBufferLoop(src, dst);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tH\u0002J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\tH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/gnit/lucenekmp/jdkport/UTF_8$Encoder$Companion;", "", "<init>", "()V", "overflow", "Lorg/gnit/lucenekmp/jdkport/CoderResult;", "src", "Lorg/gnit/lucenekmp/jdkport/CharBuffer;", "sp", "", "dst", "Lorg/gnit/lucenekmp/jdkport/ByteBuffer;", "dp", "mark", "core"})
        public static final class Companion {
            private Companion() {
            }

            private final CoderResult overflow(CharBuffer src, int sp, ByteBuffer dst, int dp) {
                UTF_8.Companion.updatePositions(src, sp, dst, dp);
                return CoderResult.Companion.getOVERFLOW();
            }

            private final CoderResult overflow(CharBuffer src, int mark) {
                src.setPosition(mark);
                return CoderResult.Companion.getOVERFLOW();
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

