/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.search;

import java.io.IOException;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.gnit.lucenekmp.index.Term;
import org.gnit.lucenekmp.index.Terms;
import org.gnit.lucenekmp.index.TermsEnum;
import org.gnit.lucenekmp.search.MultiTermQuery;
import org.gnit.lucenekmp.search.QueryVisitor;
import org.gnit.lucenekmp.util.Accountable;
import org.gnit.lucenekmp.util.AttributeSource;
import org.gnit.lucenekmp.util.RamUsageEstimator;
import org.gnit.lucenekmp.util.automaton.Automaton;
import org.gnit.lucenekmp.util.automaton.CompiledAutomaton;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 +2\u00020\u00012\u00020\u0002:\u0001+B+\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0014J\b\u0010\u001f\u001a\u00020 H\u0016J\u0013\u0010!\u001a\u00020\b2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0096\u0002J\u0012\u0010$\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010%H\u0016J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/gnit/lucenekmp/search/AutomatonQuery;", "Lorg/gnit/lucenekmp/search/MultiTermQuery;", "Lorg/gnit/lucenekmp/util/Accountable;", "term", "Lorg/gnit/lucenekmp/index/Term;", "automaton", "Lorg/gnit/lucenekmp/util/automaton/Automaton;", "isBinary", "", "rewriteMethod", "Lorg/gnit/lucenekmp/search/MultiTermQuery$RewriteMethod;", "<init>", "(Lorg/gnit/lucenekmp/index/Term;Lorg/gnit/lucenekmp/util/automaton/Automaton;ZLorg/gnit/lucenekmp/search/MultiTermQuery$RewriteMethod;)V", "getTerm", "()Lorg/gnit/lucenekmp/index/Term;", "getAutomaton", "()Lorg/gnit/lucenekmp/util/automaton/Automaton;", "compiled", "Lorg/gnit/lucenekmp/util/automaton/CompiledAutomaton;", "getCompiled", "()Lorg/gnit/lucenekmp/util/automaton/CompiledAutomaton;", "isAutomatonBinary", "()Z", "ramBytesUsed", "", "getTermsEnum", "Lorg/gnit/lucenekmp/index/TermsEnum;", "terms", "Lorg/gnit/lucenekmp/index/Terms;", "atts", "Lorg/gnit/lucenekmp/util/AttributeSource;", "hashCode", "", "equals", "obj", "", "toString", "", "field", "visit", "", "visitor", "Lorg/gnit/lucenekmp/search/QueryVisitor;", "Companion", "core"})
public class AutomatonQuery
extends MultiTermQuery
implements Accountable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Term term;
    @NotNull
    private final Automaton automaton;
    @NotNull
    private final CompiledAutomaton compiled;
    private final boolean isAutomatonBinary;
    private final long ramBytesUsed;
    private static final long BASE_RAM_BYTES = RamUsageEstimator.Companion.shallowSizeOfInstance(Reflection.getOrCreateKotlinClass(AutomatonQuery.class));

    public AutomatonQuery(@NotNull Term term, @NotNull Automaton automaton, boolean isBinary, @NotNull MultiTermQuery.RewriteMethod rewriteMethod) {
        Intrinsics.checkNotNullParameter((Object)term, (String)"term");
        Intrinsics.checkNotNullParameter((Object)automaton, (String)"automaton");
        Intrinsics.checkNotNullParameter((Object)rewriteMethod, (String)"rewriteMethod");
        super(term.field(), rewriteMethod);
        this.term = term;
        this.automaton = automaton;
        this.compiled = new CompiledAutomaton(this.automaton, false, true, isBinary);
        this.isAutomatonBinary = isBinary;
        this.ramBytesUsed = BASE_RAM_BYTES + this.getTerm().ramBytesUsed() + this.automaton.ramBytesUsed() + this.compiled.ramBytesUsed();
    }

    public /* synthetic */ AutomatonQuery(Term term, Automaton automaton, boolean bl, MultiTermQuery.RewriteMethod rewriteMethod, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            rewriteMethod = MultiTermQuery.Companion.getCONSTANT_SCORE_BLENDED_REWRITE();
        }
        this(term, automaton, bl, rewriteMethod);
    }

    @NotNull
    protected Term getTerm() {
        return this.term;
    }

    @NotNull
    protected final Automaton getAutomaton() {
        return this.automaton;
    }

    @NotNull
    protected final CompiledAutomaton getCompiled() {
        return this.compiled;
    }

    public final boolean isAutomatonBinary() {
        return this.isAutomatonBinary;
    }

    @Override
    @NotNull
    protected TermsEnum getTermsEnum(@NotNull Terms terms, @NotNull AttributeSource atts) throws IOException {
        Intrinsics.checkNotNullParameter((Object)terms, (String)"terms");
        Intrinsics.checkNotNullParameter((Object)atts, (String)"atts");
        return this.compiled.getTermsEnum(terms);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = prime * result + this.compiled.hashCode();
        result = prime * result + (this.getTerm() == null ? 0 : this.getTerm().hashCode());
        return result;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        Class<?> clazz = this.getClass();
        Object object = obj;
        Intrinsics.checkNotNull((Object)object);
        if (clazz != object.getClass()) {
            return false;
        }
        AutomatonQuery other = (AutomatonQuery)obj;
        if (!Intrinsics.areEqual((Object)this.compiled, (Object)other.compiled)) {
            return false;
        }
        return !(this.getTerm() == null ? other.getTerm() != null : !Intrinsics.areEqual((Object)this.getTerm(), (Object)other.getTerm()));
    }

    @Override
    @NotNull
    public String toString(@Nullable String field) {
        StringBuilder buffer = new StringBuilder();
        if (!Intrinsics.areEqual((Object)this.getTerm().field(), (Object)field)) {
            buffer.append(this.getTerm().field());
            buffer.append(":");
        }
        buffer.append(Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName());
        buffer.append(" {");
        buffer.append('\n');
        buffer.append(this.automaton.toString());
        buffer.append("}");
        String string = buffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Override
    public void visit(@NotNull QueryVisitor visitor2) {
        Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
        if (visitor2.acceptField(this.getField())) {
            this.compiled.visit(visitor2, this, this.getField());
        }
    }

    @Override
    public long ramBytesUsed() {
        return this.ramBytesUsed;
    }

    @Override
    @NotNull
    public Collection<Accountable> getChildResources() {
        return Accountable.super.getChildResources();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/gnit/lucenekmp/search/AutomatonQuery$Companion;", "", "<init>", "()V", "BASE_RAM_BYTES", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

