/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KClasses;
import org.gnit.lucenekmp.index.IndexReaderContext;
import org.gnit.lucenekmp.index.LeafReaderContext;
import org.gnit.lucenekmp.index.Term;
import org.gnit.lucenekmp.index.TermState;
import org.gnit.lucenekmp.index.TermStates;
import org.gnit.lucenekmp.jdkport.FloatExtKt;
import org.gnit.lucenekmp.search.BooleanClause;
import org.gnit.lucenekmp.search.BooleanQuery;
import org.gnit.lucenekmp.search.BoostQuery;
import org.gnit.lucenekmp.search.DisjunctionMaxQuery;
import org.gnit.lucenekmp.search.IndexSearcher;
import org.gnit.lucenekmp.search.Query;
import org.gnit.lucenekmp.search.QueryVisitor;
import org.gnit.lucenekmp.search.TermQuery;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.gnit.lucenekmp.util.IOSupplier;
import org.gnit.lucenekmp.util.InPlaceMergeSorter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 #2\u00020\u0001:\u0004 !\"#B7\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0003\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0096\u0002J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0000H\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0012\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0017H\u0016J\u0010\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016R\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/gnit/lucenekmp/search/BlendedTermQuery;", "Lorg/gnit/lucenekmp/search/Query;", "terms", "", "Lorg/gnit/lucenekmp/index/Term;", "boosts", "", "contexts", "Lorg/gnit/lucenekmp/index/TermStates;", "rewriteMethod", "Lorg/gnit/lucenekmp/search/BlendedTermQuery$RewriteMethod;", "<init>", "([Lorg/gnit/lucenekmp/index/Term;[F[Lorg/gnit/lucenekmp/index/TermStates;Lorg/gnit/lucenekmp/search/BlendedTermQuery$RewriteMethod;)V", "[Lorg/gnit/lucenekmp/index/Term;", "[Lorg/gnit/lucenekmp/index/TermStates;", "equals", "", "other", "", "equalsTo", "hashCode", "", "toString", "", "field", "rewrite", "indexSearcher", "Lorg/gnit/lucenekmp/search/IndexSearcher;", "visit", "", "visitor", "Lorg/gnit/lucenekmp/search/QueryVisitor;", "Builder", "RewriteMethod", "DisjunctionMaxRewrite", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nBlendedTermQuery.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlendedTermQuery.kt\norg/gnit/lucenekmp/search/BlendedTermQuery\n+ 2 ArrayUtil.kt\norg/gnit/lucenekmp/util/ArrayUtil$Companion\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,297:1\n748#2:298\n759#2,2:299\n3829#3:301\n4344#3,2:302\n37#4:304\n36#4,3:305\n*S KotlinDebug\n*F\n+ 1 BlendedTermQuery.kt\norg/gnit/lucenekmp/search/BlendedTermQuery\n*L\n215#1:298\n215#1:299,2\n249#1:301\n249#1:302,2\n250#1:304\n250#1:305,3\n*E\n"})
public final class BlendedTermQuery
extends Query {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Term[] terms;
    @NotNull
    private final float[] boosts;
    @NotNull
    private final TermStates[] contexts;
    @NotNull
    private final RewriteMethod rewriteMethod;
    @NotNull
    private static final RewriteMethod BOOLEAN_REWRITE = new RewriteMethod(){

        public Query rewrite(Query[] subQueries) {
            Intrinsics.checkNotNullParameter((Object)subQueries, (String)"subQueries");
            BooleanQuery.Builder merged = new BooleanQuery.Builder();
            for (Query query : subQueries) {
                merged.add(query, BooleanClause.Occur.SHOULD);
            }
            return merged.build();
        }
    };
    @NotNull
    private static final RewriteMethod DISJUNCTION_MAX_REWRITE = new DisjunctionMaxRewrite(0.01f);

    private BlendedTermQuery(final Term[] terms, final float[] boosts, final TermStates[] contexts, RewriteMethod rewriteMethod) {
        if (!(terms.length == boosts.length)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(terms.length == contexts.length)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.terms = terms;
        this.boosts = boosts;
        this.contexts = contexts;
        this.rewriteMethod = rewriteMethod;
        new InPlaceMergeSorter(){

            @Override
            protected void swap(int i, int j) {
                Term tmpTerm = terms[i];
                terms[i] = terms[j];
                terms[j] = tmpTerm;
                TermStates tmpContext = contexts[i];
                contexts[i] = contexts[j];
                contexts[j] = tmpContext;
                float tmpBoost = boosts[i];
                boosts[i] = boosts[j];
                boosts[j] = tmpBoost;
            }

            @Override
            protected int compare(int i, int j) {
                return terms[i].compareTo(terms[j]);
            }
        }.sort(0, terms.length);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return this.sameClassAs(other) && this.equalsTo((BlendedTermQuery)KClasses.cast((KClass)Reflection.getOrCreateKotlinClass(this.getClass()), (Object)other));
    }

    private final boolean equalsTo(BlendedTermQuery other) {
        return Arrays.equals(this.terms, other.terms) && Arrays.equals(this.contexts, other.contexts) && Arrays.equals(this.boosts, other.boosts) && Intrinsics.areEqual((Object)this.rewriteMethod, (Object)other.rewriteMethod);
    }

    @Override
    public int hashCode() {
        int h = this.classHash();
        h = 31 * h + Arrays.hashCode(this.terms);
        h = 31 * h + Arrays.hashCode(this.contexts);
        h = 31 * h + Arrays.hashCode(this.boosts);
        h = 31 * h + this.rewriteMethod.hashCode();
        return h;
    }

    @Override
    @NotNull
    public String toString(@Nullable String field) {
        StringBuilder builder = new StringBuilder("Blended(");
        int n = this.terms.length;
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                builder.append(" ");
            }
            Query termQuery = new TermQuery(this.terms[i]);
            if (!(this.boosts[i] == 1.0f)) {
                termQuery = new BoostQuery(termQuery, this.boosts[i]);
            }
            builder.append(termQuery.toString(field));
        }
        builder.append(")");
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Query rewrite(@NotNull IndexSearcher indexSearcher) {
        void from$iv$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)indexSearcher, (String)"indexSearcher");
        ArrayUtil.Companion companion = ArrayUtil.Companion;
        TermStates[] array$iv22 = this.contexts;
        boolean $i$f$copyArray = false;
        void var6_8 = this_$iv;
        TermStates[] termStatesArray = array$iv22;
        int n = 0;
        int to$iv$iv = array$iv22.length;
        boolean $i$f$copyOfSubArray = false;
        int subLength$iv$iv = to$iv$iv - from$iv$iv;
        int n2 = 0;
        TermStates[] termStatesArray2 = new TermStates[subLength$iv$iv];
        while (n2 < subLength$iv$iv) {
            void array$iv$iv;
            int n3 = n2++;
            termStatesArray2[n3] = array$iv$iv[from$iv$iv + n3];
        }
        TermStates[] contexts = termStatesArray2;
        int array$iv22 = contexts.length;
        for (int i = 0; i < array$iv22; ++i) {
            if (contexts[i] != null) {
                TermStates termStates = contexts[i];
                Intrinsics.checkNotNull((Object)termStates);
                if (termStates.wasBuiltFor(indexSearcher.getTopReaderContext())) continue;
            }
            contexts[i] = TermStates.Companion.build(indexSearcher, this.terms[i], true);
        }
        int df = 0;
        long ttf = 0L;
        int array$iv$iv = contexts.length;
        for (int this_$iv$iv = 0; this_$iv$iv < array$iv$iv; ++this_$iv$iv) {
            TermStates ctx;
            TermStates termStates = ctx = contexts[this_$iv$iv];
            Intrinsics.checkNotNull((Object)termStates);
            df = Math.max(df, termStates.docFreq());
            ttf += ctx.totalTermFreq();
        }
        array$iv$iv = contexts.length;
        for (int i = 0; i < array$iv$iv; ++i) {
            IndexReaderContext indexReaderContext = indexSearcher.getTopReaderContext();
            TermStates termStates = contexts[i];
            Intrinsics.checkNotNull((Object)termStates);
            contexts[i] = BlendedTermQuery.Companion.adjustFrequencies(indexReaderContext, termStates, df, ttf);
        }
        Query[] termQueries = new Query[this.terms.length];
        n = this.terms.length;
        for (int i = 0; i < n; ++i) {
            Term term = this.terms[i];
            TermStates termStates = contexts[i];
            Intrinsics.checkNotNull((Object)termStates);
            termQueries[i] = new TermQuery(term, termStates);
            if (this.boosts[i] == 1.0f) continue;
            Query query = termQueries[i];
            Intrinsics.checkNotNull((Object)query);
            termQueries[i] = new BoostQuery(query, this.boosts[i]);
        }
        return this.rewriteMethod.rewrite(termQueries);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visit(@NotNull QueryVisitor visitor2) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
        Term[] $this$filter$iv = this.terms;
        boolean $i$f$filter = false;
        Term[] termArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        int n = ((void)$this$filterTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void t = element$iv$iv = $this$filterTo$iv$iv[i];
            boolean bl = false;
            if (!visitor2.acceptField(t.field())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Term[] termsToVisit = thisCollection$iv.toArray(new Term[0]);
        if (!(termsToVisit.length == 0)) {
            QueryVisitor v = visitor2.getSubVisitor(BooleanClause.Occur.SHOULD, this);
            v.consumeTerms(this, Arrays.copyOf(termsToVisit, termsToVisit.length));
        }
    }

    public /* synthetic */ BlendedTermQuery(Term[] terms, float[] boosts, TermStates[] contexts, RewriteMethod rewriteMethod, DefaultConstructorMarker $constructor_marker) {
        this(terms, boosts, contexts, rewriteMethod);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0010J\u000e\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\bJ\u0016\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0016J \u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\rJ\u0006\u0010\u0018\u001a\u00020\u0019R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\u0007X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/gnit/lucenekmp/search/BlendedTermQuery$Builder;", "", "<init>", "()V", "numTerms", "", "terms", "", "Lorg/gnit/lucenekmp/index/Term;", "[Lorg/gnit/lucenekmp/index/Term;", "boosts", "", "contexts", "Lorg/gnit/lucenekmp/index/TermStates;", "[Lorg/gnit/lucenekmp/index/TermStates;", "rewriteMethod", "Lorg/gnit/lucenekmp/search/BlendedTermQuery$RewriteMethod;", "setRewriteMethod", "rewiteMethod", "add", "term", "boost", "", "context", "build", "Lorg/gnit/lucenekmp/search/BlendedTermQuery;", "core"})
    @SourceDebugExtension(value={"SMAP\nBlendedTermQuery.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlendedTermQuery.kt\norg/gnit/lucenekmp/search/BlendedTermQuery$Builder\n+ 2 ArrayUtil.kt\norg/gnit/lucenekmp/util/ArrayUtil$Companion\n*L\n1#1,297:1\n217#2,5:298\n189#2,2:303\n222#2:305\n217#2,5:306\n189#2,2:311\n222#2:313\n759#2,2:314\n759#2,2:316\n*S KotlinDebug\n*F\n+ 1 BlendedTermQuery.kt\norg/gnit/lucenekmp/search/BlendedTermQuery$Builder\n*L\n81#1:298,5\n81#1:303,2\n81#1:305\n83#1:306,5\n83#1:311,2\n83#1:313\n94#1:314,2\n96#1:316,2\n*E\n"})
    public static final class Builder {
        private int numTerms;
        @NotNull
        private Term[] terms = new Term[0];
        @NotNull
        private float[] boosts = new float[0];
        @NotNull
        private TermStates[] contexts = new TermStates[0];
        @NotNull
        private RewriteMethod rewriteMethod = Companion.getDISJUNCTION_MAX_REWRITE();

        @NotNull
        public final Builder setRewriteMethod(@NotNull RewriteMethod rewiteMethod) {
            Intrinsics.checkNotNullParameter((Object)rewiteMethod, (String)"rewiteMethod");
            this.rewriteMethod = rewiteMethod;
            return this;
        }

        @NotNull
        public final Builder add(@NotNull Term term) {
            Intrinsics.checkNotNullParameter((Object)term, (String)"term");
            return this.add(term, 1.0f);
        }

        @NotNull
        public final Builder add(@NotNull Term term, float boost) {
            Intrinsics.checkNotNullParameter((Object)term, (String)"term");
            return this.add(term, boost, null);
        }

        @NotNull
        public final Builder add(@NotNull Term term, float boost, @Nullable TermStates context) {
            Object[] objectArray;
            Term[] termArray;
            int n;
            int n2;
            Object[] objectArray2;
            TermStates[] array$iv$iv;
            boolean $i$f$growExactNullable;
            int newLength$iv$iv;
            int newLength$iv;
            ArrayUtil.Companion this_$iv;
            TermStates[] array$iv;
            int minSize$iv;
            Intrinsics.checkNotNullParameter((Object)term, (String)"term");
            if (this.numTerms >= IndexSearcher.Companion.getMaxClauseCount()) {
                throw new IndexSearcher.TooManyClauses(null, 1, null);
            }
            ArrayUtil.Companion companion = ArrayUtil.Companion;
            Term[] termArray2 = this.terms;
            int n3 = this.numTerms + 1;
            Builder builder = this;
            boolean $i$f$growNullable = false;
            if (minSize$iv < 0) {
                throw new Exception("size must be positive (got " + minSize$iv + "): likely integer overflow?");
            }
            if (array$iv.length < minSize$iv) {
                newLength$iv = this_$iv.oversize(minSize$iv, 4);
                void var9_10 = this_$iv;
                void var10_11 = array$iv;
                newLength$iv$iv = newLength$iv;
                $i$f$growExactNullable = false;
                if (newLength$iv$iv < array$iv$iv.length) {
                    throw new IndexOutOfBoundsException("newLength (" + newLength$iv$iv + ") < array.size (" + array$iv$iv.length + ")");
                }
                objectArray2 = new Term[newLength$iv$iv];
                for (n2 = 0; n2 < newLength$iv$iv; ++n2) {
                    n = n2;
                    objectArray2[n] = n < array$iv$iv.length ? array$iv$iv[n] : null;
                }
                termArray = objectArray2;
            } else {
                termArray = array$iv;
            }
            builder.terms = termArray;
            this.boosts = ArrayUtil.Companion.grow(this.boosts, this.numTerms + 1);
            this_$iv = ArrayUtil.Companion;
            array$iv = this.contexts;
            minSize$iv = this.numTerms + 1;
            builder = this;
            $i$f$growNullable = false;
            if (minSize$iv < 0) {
                throw new Exception("size must be positive (got " + minSize$iv + "): likely integer overflow?");
            }
            if (array$iv.length < minSize$iv) {
                newLength$iv = this_$iv.oversize(minSize$iv, 4);
                ArrayUtil.Companion this_$iv$iv = this_$iv;
                array$iv$iv = array$iv;
                newLength$iv$iv = newLength$iv;
                $i$f$growExactNullable = false;
                if (newLength$iv$iv < array$iv$iv.length) {
                    throw new IndexOutOfBoundsException("newLength (" + newLength$iv$iv + ") < array.size (" + array$iv$iv.length + ")");
                }
                objectArray2 = new TermStates[newLength$iv$iv];
                for (n2 = 0; n2 < newLength$iv$iv; ++n2) {
                    n = n2;
                    TermStates termStates = n < array$iv$iv.length ? array$iv$iv[n] : null;
                    objectArray2[n] = termStates;
                }
                objectArray = objectArray2;
            } else {
                objectArray = array$iv;
            }
            builder.contexts = objectArray;
            this.terms[this.numTerms] = term;
            this.boosts[this.numTerms] = boost;
            this.contexts[this.numTerms] = context;
            ++this.numTerms;
            return this;
        }

        @NotNull
        public final BlendedTermQuery build() {
            TermStates[] array$iv;
            int n;
            int from$iv;
            ArrayUtil.Companion companion = ArrayUtil.Companion;
            Term[] termArray = this.terms;
            boolean bl = false;
            int to$iv = this.numTerms;
            boolean $i$f$copyOfSubArray = false;
            int subLength$iv = to$iv - from$iv;
            int n2 = 0;
            Object[] objectArray = new Term[subLength$iv];
            while (n2 < subLength$iv) {
                n = n2++;
                objectArray[n] = array$iv[from$iv + n];
            }
            ArrayUtil.Companion this_$iv = ArrayUtil.Companion;
            array$iv = this.contexts;
            from$iv = 0;
            to$iv = this.numTerms;
            float[] fArray = ArrayUtil.Companion.copyOfSubArray(this.boosts, 0, this.numTerms);
            Term[] termArray2 = objectArray;
            $i$f$copyOfSubArray = false;
            subLength$iv = to$iv - from$iv;
            n2 = 0;
            objectArray = new TermStates[subLength$iv];
            while (n2 < subLength$iv) {
                n = n2++;
                objectArray[n] = array$iv[from$iv + n];
            }
            Object[] objectArray2 = objectArray;
            DefaultConstructorMarker defaultConstructorMarker = null;
            RewriteMethod rewriteMethod = this.rewriteMethod;
            Object[] objectArray3 = objectArray2;
            float[] fArray2 = fArray;
            Term[] termArray3 = termArray2;
            return new BlendedTermQuery(termArray3, fArray2, (TermStates[])objectArray3, rewriteMethod, defaultConstructorMarker);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lorg/gnit/lucenekmp/search/BlendedTermQuery$Companion;", "", "<init>", "()V", "BOOLEAN_REWRITE", "Lorg/gnit/lucenekmp/search/BlendedTermQuery$RewriteMethod;", "getBOOLEAN_REWRITE", "()Lorg/gnit/lucenekmp/search/BlendedTermQuery$RewriteMethod;", "DISJUNCTION_MAX_REWRITE", "getDISJUNCTION_MAX_REWRITE", "adjustFrequencies", "Lorg/gnit/lucenekmp/index/TermStates;", "readerContext", "Lorg/gnit/lucenekmp/index/IndexReaderContext;", "ctx", "artificialDf", "", "artificialTtf", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RewriteMethod getBOOLEAN_REWRITE() {
            return BOOLEAN_REWRITE;
        }

        @NotNull
        public final RewriteMethod getDISJUNCTION_MAX_REWRITE() {
            return DISJUNCTION_MAX_REWRITE;
        }

        private final TermStates adjustFrequencies(IndexReaderContext readerContext, TermStates ctx, int artificialDf, long artificialTtf) throws IOException {
            List<LeafReaderContext> leaves = readerContext.leaves();
            TermStates newCtx = new TermStates(readerContext);
            int n = ((Collection)leaves).size();
            for (int i = 0; i < n; ++i) {
                TermState termState2;
                IOSupplier<TermState> supplier = ctx.get(leaves.get(i));
                if (supplier == null || (termState2 = supplier.get()) == null) continue;
                newCtx.register(termState2, i);
            }
            newCtx.accumulateStatistics(artificialDf, artificialTtf);
            return newCtx;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001b\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\tH\u0016\u00a2\u0006\u0002\u0010\nJ\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0096\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/gnit/lucenekmp/search/BlendedTermQuery$DisjunctionMaxRewrite;", "Lorg/gnit/lucenekmp/search/BlendedTermQuery$RewriteMethod;", "tieBreakerMultiplier", "", "<init>", "(F)V", "rewrite", "Lorg/gnit/lucenekmp/search/Query;", "subQueries", "", "([Lorg/gnit/lucenekmp/search/Query;)Lorg/gnit/lucenekmp/search/Query;", "equals", "", "other", "", "hashCode", "", "core"})
    public static final class DisjunctionMaxRewrite
    extends RewriteMethod {
        private final float tieBreakerMultiplier;

        public DisjunctionMaxRewrite(float tieBreakerMultiplier) {
            this.tieBreakerMultiplier = tieBreakerMultiplier;
        }

        @Override
        @NotNull
        public Query rewrite(@NotNull Query[] subQueries) {
            Intrinsics.checkNotNullParameter((Object)subQueries, (String)"subQueries");
            return new DisjunctionMaxQuery(ArraysKt.toMutableList((Object[])subQueries), this.tieBreakerMultiplier);
        }

        public boolean equals(@Nullable Object other) {
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            DisjunctionMaxRewrite that = (DisjunctionMaxRewrite)other;
            return this.tieBreakerMultiplier == that.tieBreakerMultiplier;
        }

        public int hashCode() {
            return 31 * Reflection.getOrCreateKotlinClass(this.getClass()).hashCode() + FloatExtKt.floatToIntBits(FloatCompanionObject.INSTANCE, this.tieBreakerMultiplier);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007H&\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lorg/gnit/lucenekmp/search/BlendedTermQuery$RewriteMethod;", "", "<init>", "()V", "rewrite", "Lorg/gnit/lucenekmp/search/Query;", "subQueries", "", "([Lorg/gnit/lucenekmp/search/Query;)Lorg/gnit/lucenekmp/search/Query;", "core"})
    public static abstract class RewriteMethod {
        protected RewriteMethod() {
        }

        @NotNull
        public abstract Query rewrite(@NotNull Query[] var1);
    }
}

