/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.search.BulkScorer;
import org.gnit.lucenekmp.search.DocIdSetIterator;
import org.gnit.lucenekmp.search.LeafCollector;
import org.gnit.lucenekmp.search.Scorable;
import org.gnit.lucenekmp.search.Scorer;
import org.gnit.lucenekmp.search.ScorerUtil;
import org.gnit.lucenekmp.util.Bits;
import org.gnit.lucenekmp.util.MathUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001'B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u0003H\u0002J*\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u0003H\u0016J2\u0010\"\u001a\u00020#2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u0018H\u0002J\b\u0010%\u001a\u00020&H\u0016R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u000e\u0010\u000e\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/gnit/lucenekmp/search/BlockMaxConjunctionBulkScorer;", "Lorg/gnit/lucenekmp/search/BulkScorer;", "maxDoc", "", "scorers", "", "Lorg/gnit/lucenekmp/search/Scorer;", "<init>", "(ILjava/util/List;)V", "", "[Lorg/gnit/lucenekmp/search/Scorer;", "iterators", "Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "[Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "lead1", "lead2", "scorer1", "Lorg/gnit/lucenekmp/search/Scorable;", "scorer2", "scorable", "Lorg/gnit/lucenekmp/search/BlockMaxConjunctionBulkScorer$DocAndScore;", "sumOfOtherClauses", "", "computeMaxScore", "", "windowMin", "windowMax", "score", "collector", "Lorg/gnit/lucenekmp/search/LeafCollector;", "acceptDocs", "Lorg/gnit/lucenekmp/util/Bits;", "min", "max", "scoreWindow", "", "maxWindowScore", "cost", "", "DocAndScore", "core"})
@SourceDebugExtension(value={"SMAP\nBlockMaxConjunctionBulkScorer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlockMaxConjunctionBulkScorer.kt\norg/gnit/lucenekmp/search/BlockMaxConjunctionBulkScorer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,203:1\n1#2:204\n37#3:205\n36#3,3:206\n37#3:215\n36#3,3:216\n6181#4,2:209\n11228#4:211\n11563#4,3:212\n*S KotlinDebug\n*F\n+ 1 BlockMaxConjunctionBulkScorer.kt\norg/gnit/lucenekmp/search/BlockMaxConjunctionBulkScorer\n*L\n31#1:205\n31#1:206,3\n34#1:215\n34#1:216,3\n32#1:209,2\n34#1:211\n34#1:212,3\n*E\n"})
public final class BlockMaxConjunctionBulkScorer
extends BulkScorer {
    @NotNull
    private final Scorer[] scorers;
    @NotNull
    private final DocIdSetIterator[] iterators;
    @NotNull
    private final DocIdSetIterator lead1;
    @NotNull
    private final DocIdSetIterator lead2;
    @NotNull
    private final Scorable scorer1;
    @NotNull
    private final Scorable scorer2;
    @NotNull
    private final DocAndScore scorable;
    @NotNull
    private final double[] sumOfOtherClauses;
    private final int maxDoc;

    /*
     * WARNING - void declaration
     */
    public BlockMaxConjunctionBulkScorer(int maxDoc, @NotNull List<Scorer> scorers) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(scorers, (String)"scorers");
        this.scorable = new DocAndScore();
        if (!(scorers.size() > 1)) {
            boolean $i$a$-require-BlockMaxConjunctionBulkScorer$22 = false;
            String $i$a$-require-BlockMaxConjunctionBulkScorer$22 = "Expected 2 or more scorers, got " + scorers.size();
            throw new IllegalArgumentException($i$a$-require-BlockMaxConjunctionBulkScorer$22.toString());
        }
        Collection $this$toTypedArray$iv = scorers;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        this.scorers = thisCollection$iv.toArray(new Scorer[0]);
        Object[] $this$sortBy$iv = this.scorers;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.length > 1) {
            ArraysKt.sortWith((Object[])$this$sortBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Scorer it = (Scorer)a;
                    boolean bl = false;
                    Comparable comparable = Long.valueOf(it.iterator().cost());
                    it = (Scorer)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.iterator().cost()));
                }
            });
        }
        $this$sortBy$iv = this.scorers;
        BlockMaxConjunctionBulkScorer blockMaxConjunctionBulkScorer = this;
        boolean $i$f$map = false;
        thisCollection$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void p0;
            void item$iv$iv;
            void var11_15 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.iterator());
        }
        $this$toTypedArray$iv = (List)destination$iv$iv;
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        blockMaxConjunctionBulkScorer.iterators = thisCollection$iv.toArray(new DocIdSetIterator[0]);
        this.lead1 = ScorerUtil.INSTANCE.likelyImpactsEnum(this.iterators[0]);
        this.lead2 = ScorerUtil.INSTANCE.likelyImpactsEnum(this.iterators[1]);
        this.scorer1 = ScorerUtil.INSTANCE.likelyTermScorer(this.scorers[0]);
        this.scorer2 = ScorerUtil.INSTANCE.likelyTermScorer(this.scorers[1]);
        this.sumOfOtherClauses = new double[this.scorers.length];
        int n2 = this.sumOfOtherClauses.length;
        for (int i = 0; i < n2; ++i) {
            this.sumOfOtherClauses[i] = Double.POSITIVE_INFINITY;
        }
        this.maxDoc = maxDoc;
    }

    private final float computeMaxScore(int windowMin, int windowMax) throws IOException {
        int i;
        int n = this.scorers.length;
        for (int i2 = 0; i2 < n; ++i2) {
            this.scorers[i2].advanceShallow(windowMin);
        }
        double maxWindowScore = 0.0;
        int n2 = this.scorers.length;
        for (i = 0; i < n2; ++i) {
            float maxClauseScore = this.scorers[i].getMaxScore(windowMax);
            this.sumOfOtherClauses[i] = maxClauseScore;
            maxWindowScore += (double)maxClauseScore;
        }
        for (i = this.sumOfOtherClauses.length - 2; -1 < i; --i) {
            double[] dArray = this.sumOfOtherClauses;
            int n3 = i;
            dArray[n3] = dArray[n3] + this.sumOfOtherClauses[i + 1];
        }
        return (float)maxWindowScore;
    }

    @Override
    public int score(@NotNull LeafCollector collector2, @Nullable Bits acceptDocs, int min, int max) throws IOException {
        Intrinsics.checkNotNullParameter((Object)collector2, (String)"collector");
        collector2.setScorer(this.scorable);
        int windowMin = Math.max(this.lead1.docID(), min);
        while (windowMin < max) {
            int windowMax = Math.min(this.scorers[0].advanceShallow(windowMin), max - 1);
            float maxWindowScore = Float.POSITIVE_INFINITY;
            if (0.0f < this.scorable.getMinCompetitiveScore()) {
                maxWindowScore = this.computeMaxScore(windowMin, windowMax);
            }
            this.scoreWindow(collector2, acceptDocs, windowMin, windowMax + 1, maxWindowScore);
            windowMin = Math.max(this.lead1.docID(), windowMax + 1);
        }
        return windowMin >= this.maxDoc ? Integer.MAX_VALUE : windowMin;
    }

    private final void scoreWindow(LeafCollector collector2, Bits acceptDocs, int min, int max, float maxWindowScore) throws IOException {
        if (maxWindowScore < this.scorable.getMinCompetitiveScore()) {
            return;
        }
        if (this.lead1.docID() < min) {
            this.lead1.advance(min);
        }
        double sumOfOtherMaxScoresAt1 = this.sumOfOtherClauses[1];
        int doc = this.lead1.docID();
        block0: while (doc < max) {
            int next;
            double currentScore;
            if (acceptDocs != null && !acceptDocs.get(doc)) {
                doc = this.lead1.nextDoc();
                continue;
            }
            boolean hasMinCompetitiveScore = this.scorable.getMinCompetitiveScore() > 0.0f;
            double d = currentScore = hasMinCompetitiveScore ? (double)this.scorer1.score() : 0.0;
            if (hasMinCompetitiveScore && (float)MathUtil.INSTANCE.sumUpperBound(currentScore + sumOfOtherMaxScoresAt1, this.scorers.length) < this.scorable.getMinCompetitiveScore()) {
                doc = this.lead1.nextDoc();
                continue;
            }
            if (this.lead2.docID() < doc && (next = this.lead2.advance(doc)) != doc) {
                doc = this.lead1.advance(next);
                continue;
            }
            if (!(this.lead2.docID() == doc)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (hasMinCompetitiveScore) {
                currentScore += (double)this.scorer2.score();
            }
            int n = this.iterators.length;
            for (int i = 2; i < n; ++i) {
                int next2;
                if (hasMinCompetitiveScore && (float)MathUtil.INSTANCE.sumUpperBound(currentScore + this.sumOfOtherClauses[i], this.scorers.length) < this.scorable.getMinCompetitiveScore()) {
                    doc = this.lead1.nextDoc();
                    continue block0;
                }
                if (this.iterators[i].docID() < doc && (next2 = this.iterators[i].advance(doc)) != doc) {
                    doc = this.lead1.advance(next2);
                    continue block0;
                }
                if (!(this.iterators[i].docID() == doc)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                if (!hasMinCompetitiveScore) continue;
                currentScore += (double)this.scorers[i].score();
            }
            if (!hasMinCompetitiveScore) {
                for (Scorer scorer2 : this.scorers) {
                    currentScore += (double)scorer2.score();
                }
            }
            this.scorable.setScore((float)currentScore);
            collector2.collect(doc);
            if (maxWindowScore < this.scorable.getMinCompetitiveScore()) {
                return;
            }
            doc = this.lead1.nextDoc();
        }
    }

    @Override
    public long cost() {
        return this.lead1.cost();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR$\u0010\u000b\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\u0007\"\u0004\b\r\u0010\t\u00a8\u0006\u000e"}, d2={"Lorg/gnit/lucenekmp/search/BlockMaxConjunctionBulkScorer$DocAndScore;", "Lorg/gnit/lucenekmp/search/Scorable;", "<init>", "()V", "score", "", "getScore", "()F", "setScore", "(F)V", "minScore", "minCompetitiveScore", "getMinCompetitiveScore", "setMinCompetitiveScore", "core"})
    private static final class DocAndScore
    extends Scorable {
        private float score;
        private float minCompetitiveScore;

        public final float getScore() {
            return this.score;
        }

        public final void setScore(float f) {
            this.score = f;
        }

        @Override
        public float getMinCompetitiveScore() {
            return this.minCompetitiveScore;
        }

        @Override
        public void setMinCompetitiveScore(float minScore) {
            this.setMinCompetitiveScore(minScore);
        }

        @Override
        public float score() throws IOException {
            return this.score;
        }
    }
}

