/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.reflect.KClass;
import kotlin.reflect.KClasses;
import org.gnit.lucenekmp.index.TermStates;
import org.gnit.lucenekmp.jdkport.Objects;
import org.gnit.lucenekmp.search.BooleanClause;
import org.gnit.lucenekmp.search.BooleanWeight;
import org.gnit.lucenekmp.search.BoostQuery;
import org.gnit.lucenekmp.search.ConstantScoreQuery;
import org.gnit.lucenekmp.search.IndexSearcher;
import org.gnit.lucenekmp.search.MatchAllDocsQuery;
import org.gnit.lucenekmp.search.MatchNoDocsQuery;
import org.gnit.lucenekmp.search.Multiset;
import org.gnit.lucenekmp.search.Query;
import org.gnit.lucenekmp.search.QueryVisitor;
import org.gnit.lucenekmp.search.ScoreMode;
import org.gnit.lucenekmp.search.TermQuery;
import org.gnit.lucenekmp.search.Weight;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010!\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u001f\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010)\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0006\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002:\u00014B\u001f\b\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\fJ\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00010\u00102\u0006\u0010\u0012\u001a\u00020\u000fJ\u0019\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00010\u00072\u0006\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\u0002\u0010\u001aJ\u000f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00030\u001cH\u0096\u0002J\u0006\u0010\u001d\u001a\u00020\u0000J \u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00192\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0016J\u0012\u0010*\u001a\u00020+2\b\u0010,\u001a\u0004\u0018\u00010+H\u0016J\u0013\u0010-\u001a\u00020\u00142\b\u0010.\u001a\u0004\u0018\u00010/H\u0096\u0002J\u0010\u00100\u001a\u00020\u00142\u0006\u00101\u001a\u00020\u0000H\u0002J\b\u00102\u001a\u00020\u0005H\u0002J\b\u00103\u001a\u00020\u0005H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0015R\u000e\u00103\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lorg/gnit/lucenekmp/search/BooleanQuery;", "Lorg/gnit/lucenekmp/search/Query;", "", "Lorg/gnit/lucenekmp/search/BooleanClause;", "minimumNumberShouldMatch", "", "clauses", "", "<init>", "(I[Lorg/gnit/lucenekmp/search/BooleanClause;)V", "getMinimumNumberShouldMatch", "()I", "", "clauseSets", "", "Lorg/gnit/lucenekmp/search/BooleanClause$Occur;", "", "getClauses", "occur", "isPureDisjunction", "", "()Z", "isTwoClausePureDisjunctionWithTerms", "rewriteTwoClauseDisjunctionWithTermsForCount", "indexSearcher", "Lorg/gnit/lucenekmp/search/IndexSearcher;", "(Lorg/gnit/lucenekmp/search/IndexSearcher;)[Lorg/gnit/lucenekmp/search/Query;", "iterator", "", "rewriteNoScoring", "createWeight", "Lorg/gnit/lucenekmp/search/Weight;", "searcher", "scoreMode", "Lorg/gnit/lucenekmp/search/ScoreMode;", "boost", "", "rewrite", "visit", "", "visitor", "Lorg/gnit/lucenekmp/search/QueryVisitor;", "toString", "", "field", "equals", "o", "", "equalsTo", "other", "computeHashCode", "hashCode", "Builder", "core"})
@SourceDebugExtension(value={"SMAP\nBooleanQuery.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BooleanQuery.kt\norg/gnit/lucenekmp/search/BooleanQuery\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,709:1\n1761#2,3:710\n1#3:713\n*S KotlinDebug\n*F\n+ 1 BooleanQuery.kt\norg/gnit/lucenekmp/search/BooleanQuery\n*L\n313#1:710,3\n*E\n"})
public final class BooleanQuery
extends Query
implements Iterable<BooleanClause>,
KMappedMarker {
    private final int minimumNumberShouldMatch;
    @NotNull
    private final List<BooleanClause> clauses;
    @NotNull
    private final Map<BooleanClause.Occur, Collection<Query>> clauseSets;
    private int hashCode;

    private BooleanQuery(int minimumNumberShouldMatch, BooleanClause[] clauses) {
        this.minimumNumberShouldMatch = minimumNumberShouldMatch;
        this.clauses = ArraysKt.toMutableList((Object[])clauses);
        this.clauseSets = new LinkedHashMap();
        this.clauseSets.put(BooleanClause.Occur.SHOULD, (Collection<Query>)((Object)new Multiset()));
        this.clauseSets.put(BooleanClause.Occur.MUST, (Collection<Query>)((Object)new Multiset()));
        this.clauseSets.put(BooleanClause.Occur.FILTER, new HashSet());
        this.clauseSets.put(BooleanClause.Occur.MUST_NOT, new HashSet());
        for (BooleanClause clause : clauses) {
            Collection<Query> collection = this.clauseSets.get((Object)clause.getOccur());
            Intrinsics.checkNotNull(collection);
            collection.add(clause.getQuery());
        }
    }

    public final int getMinimumNumberShouldMatch() {
        return this.minimumNumberShouldMatch;
    }

    @NotNull
    public final List<BooleanClause> clauses() {
        return this.clauses;
    }

    @NotNull
    public final Collection<Query> getClauses(@NotNull BooleanClause.Occur occur) {
        Intrinsics.checkNotNullParameter((Object)((Object)occur), (String)"occur");
        Collection<Query> collection = this.clauseSets.get((Object)occur);
        Intrinsics.checkNotNull(collection);
        return CollectionsKt.toMutableSet((Iterable)collection);
    }

    public final boolean isPureDisjunction() {
        return this.clauses.size() == this.getClauses(BooleanClause.Occur.SHOULD).size() && this.minimumNumberShouldMatch <= 1;
    }

    public final boolean isTwoClausePureDisjunctionWithTerms() {
        return this.clauses.size() == 2 && this.isPureDisjunction() && this.clauses.get(0).getQuery() instanceof TermQuery && this.clauses.get(1).getQuery() instanceof TermQuery;
    }

    @NotNull
    public final Query[] rewriteTwoClauseDisjunctionWithTermsForCount(@NotNull IndexSearcher indexSearcher) throws IOException {
        Intrinsics.checkNotNullParameter((Object)indexSearcher, (String)"indexSearcher");
        Builder newQuery = new Builder();
        Query[] queries2 = new Query[3];
        int n = ((Collection)this.clauses).size();
        for (int i = 0; i < n; ++i) {
            Query query = this.clauses.get(i).getQuery();
            Intrinsics.checkNotNull((Object)query, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.search.TermQuery");
            TermQuery termQuery = (TermQuery)query;
            if (termQuery.getTermStates() == null) {
                termQuery = new TermQuery(termQuery.getTerm(), TermStates.Companion.build(indexSearcher, termQuery.getTerm(), false));
            }
            newQuery.add(termQuery, BooleanClause.Occur.MUST);
            queries2[i] = termQuery;
        }
        queries2[2] = newQuery.build();
        return queries2;
    }

    @Override
    @NotNull
    public Iterator<BooleanClause> iterator() {
        return this.clauses.iterator();
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final BooleanQuery rewriteNoScoring() {
        actuallyRewritten = false;
        newQuery = new Builder().setMinimumNumberShouldMatch(this.minimumNumberShouldMatch);
        if (this.minimumNumberShouldMatch > 0) ** GOTO lbl-1000
        v0 = this.clauseSets.get((Object)BooleanClause.Occur.MUST);
        Intrinsics.checkNotNull(v0);
        v1 = v0.size();
        v2 = this.clauseSets.get((Object)BooleanClause.Occur.FILTER);
        Intrinsics.checkNotNull(v2);
        if (v1 + v2.size() == 0) lbl-1000:
        // 2 sources

        {
            v3 = true;
        } else {
            v3 = false;
        }
        keepShould = v3;
        for (BooleanClause clause : this.clauses) {
            query = clause.getQuery();
            rewritten = query;
            if (rewritten instanceof BoostQuery) {
                rewritten = ((BoostQuery)rewritten).getQuery();
            }
            if (rewritten instanceof ConstantScoreQuery) {
                rewritten = ((ConstantScoreQuery)rewritten).getQuery();
            }
            if (rewritten instanceof BooleanQuery) {
                rewritten = ((BooleanQuery)rewritten).rewriteNoScoring();
            }
            if ((occur = clause.getOccur()) == BooleanClause.Occur.SHOULD && !keepShould) {
                actuallyRewritten = true;
                continue;
            }
            if (occur == BooleanClause.Occur.MUST) {
                newQuery.add(rewritten, BooleanClause.Occur.FILTER);
                actuallyRewritten = true;
                continue;
            }
            if (query != rewritten) {
                newQuery.add(rewritten, occur);
                actuallyRewritten = true;
                continue;
            }
            newQuery.add(clause);
        }
        if (!actuallyRewritten) {
            return this;
        }
        return newQuery.build();
    }

    @Override
    @NotNull
    public Weight createWeight(@NotNull IndexSearcher searcher, @NotNull ScoreMode scoreMode, float boost) {
        Intrinsics.checkNotNullParameter((Object)searcher, (String)"searcher");
        Intrinsics.checkNotNullParameter((Object)((Object)scoreMode), (String)"scoreMode");
        return new BooleanWeight(this, searcher, scoreMode, boost);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Query rewrite(@NotNull IndexSearcher indexSearcher) {
        Query query;
        boolean bl;
        Double d;
        Map map2;
        Query query2;
        Builder builder;
        Collection<Object> filters;
        Object rewritten;
        block93: {
            block95: {
                boolean modified;
                block94: {
                    Intrinsics.checkNotNullParameter((Object)indexSearcher, (String)"indexSearcher");
                    if (this.clauses.isEmpty()) {
                        return new MatchNoDocsQuery("empty BooleanQuery");
                    }
                    int n = this.clauses.size();
                    Collection<Query> collection = this.clauseSets.get((Object)BooleanClause.Occur.MUST_NOT);
                    Intrinsics.checkNotNull(collection);
                    if (n == collection.size()) {
                        return new MatchNoDocsQuery("pure negative BooleanQuery");
                    }
                    if (this.clauses.size() == 1) {
                        BooleanClause c = this.clauses.get(0);
                        Query query4 = c.getQuery();
                        if (this.minimumNumberShouldMatch == 1 && c.getOccur() == BooleanClause.Occur.SHOULD) {
                            return query4;
                        }
                        if (this.minimumNumberShouldMatch == 0) {
                            switch (WhenMappings.$EnumSwitchMapping$0[c.getOccur().ordinal()]) {
                                case 1: 
                                case 2: {
                                    return query4;
                                }
                                case 3: {
                                    return new BoostQuery(new ConstantScoreQuery(query4), 0.0f);
                                }
                                case 4: {
                                    throw new AssertionError();
                                }
                            }
                            throw new AssertionError();
                        }
                    }
                    BooleanQuery $this$rewrite_u24lambda_u240 = this;
                    boolean bl2 = false;
                    Builder builder2 = new Builder();
                    builder2.setMinimumNumberShouldMatch($this$rewrite_u24lambda_u240.minimumNumberShouldMatch);
                    boolean actuallyRewritten = false;
                    block13: for (BooleanClause booleanClause : $this$rewrite_u24lambda_u240) {
                        Builder builder3;
                        Query query5 = booleanClause.getQuery();
                        BooleanClause.Occur occur = booleanClause.getOccur();
                        rewritten = null;
                        if (occur == BooleanClause.Occur.FILTER || occur == BooleanClause.Occur.MUST_NOT) {
                            rewritten = new ConstantScoreQuery(query5).rewrite(indexSearcher);
                            if (rewritten instanceof ConstantScoreQuery) {
                                rewritten = ((ConstantScoreQuery)rewritten).getQuery();
                            }
                        } else {
                            rewritten = query5.rewrite(indexSearcher);
                        }
                        if (rewritten != query5 || query5 instanceof MatchNoDocsQuery) {
                            actuallyRewritten = true;
                            if (rewritten instanceof MatchNoDocsQuery) {
                                switch (WhenMappings.$EnumSwitchMapping$0[occur.ordinal()]) {
                                    case 1: 
                                    case 4: {
                                        builder3 = Unit.INSTANCE;
                                        continue block13;
                                    }
                                    case 2: 
                                    case 3: {
                                        return rewritten;
                                    }
                                    default: {
                                        throw new NoWhenBranchMatchedException();
                                    }
                                }
                            }
                            builder3 = builder2.add((Query)rewritten, occur);
                            continue;
                        }
                        builder3 = builder2.add(booleanClause);
                    }
                    if (actuallyRewritten) {
                        return builder2.build();
                    }
                    BooleanQuery $this$rewrite_u24lambda_u241 = this;
                    boolean bl22 = false;
                    int clauseCount = 0;
                    for (Collection<Query> collection2 : $this$rewrite_u24lambda_u241.clauseSets.values()) {
                        clauseCount += collection2.size();
                    }
                    if (clauseCount != $this$rewrite_u24lambda_u241.clauses.size()) {
                        Iterator<BooleanClause> rewritten2 = new Builder();
                        ((Builder)((Object)rewritten2)).setMinimumNumberShouldMatch($this$rewrite_u24lambda_u241.minimumNumberShouldMatch);
                        for (Map.Entry<BooleanClause.Occur, Collection<Query>> entry : $this$rewrite_u24lambda_u241.clauseSets.entrySet()) {
                            BooleanClause.Occur occur = entry.getKey();
                            for (Object query6 : entry.getValue()) {
                                ((Builder)((Object)rewritten2)).add((Query)query6, occur);
                            }
                        }
                        return ((Builder)((Object)rewritten2)).build();
                    }
                    Collection<Query> collection3 = this.clauseSets.get((Object)BooleanClause.Occur.MUST_NOT);
                    Intrinsics.checkNotNull(collection3);
                    Collection<Query> mustNotClauses = collection3;
                    if (!mustNotClauses.isEmpty()) {
                        boolean bl3;
                        block92: {
                            Collection<Query> collection4 = this.clauseSets.get((Object)BooleanClause.Occur.MUST);
                            Intrinsics.checkNotNull(collection4);
                            Collection<Query> collection5 = this.clauseSets.get((Object)BooleanClause.Occur.FILTER);
                            Intrinsics.checkNotNull(collection5);
                            List mustOrFilter = CollectionsKt.plus(collection4, (Iterable)collection5);
                            Iterable $this$any$iv = mustNotClauses;
                            boolean $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl3 = false;
                            } else {
                                for (Object e : $this$any$iv) {
                                    Query query3 = (Query)e;
                                    boolean bl4 = false;
                                    if (!mustOrFilter.contains(query3)) continue;
                                    bl3 = true;
                                    break block92;
                                }
                                bl3 = false;
                            }
                        }
                        if (bl3) {
                            return new MatchNoDocsQuery("FILTER or MUST clause also in MUST_NOT");
                        }
                        if (mustNotClauses.contains(new MatchAllDocsQuery())) {
                            return new MatchNoDocsQuery("MUST_NOT clause is MatchAllDocsQuery");
                        }
                    }
                    Collection<Query> collection6 = this.clauseSets.get((Object)BooleanClause.Occur.FILTER);
                    Intrinsics.checkNotNull(collection6);
                    if (!(!collection6.isEmpty())) break block93;
                    Collection<Query> collection7 = this.clauseSets.get((Object)BooleanClause.Occur.FILTER);
                    Intrinsics.checkNotNull(collection7);
                    filters = CollectionsKt.toMutableSet((Iterable)collection7);
                    modified = false;
                    if (filters.size() > 1) break block94;
                    Collection<Query> collection8 = this.clauseSets.get((Object)BooleanClause.Occur.MUST);
                    Intrinsics.checkNotNull(collection8);
                    if (collection8.isEmpty()) break block95;
                }
                modified = filters.remove(new MatchAllDocsQuery());
            }
            Collection<Query> collection = this.clauseSets.get((Object)BooleanClause.Occur.MUST);
            Intrinsics.checkNotNull(collection);
            if (modified |= filters.removeAll(collection)) {
                Builder builder4 = new Builder();
                builder4.setMinimumNumberShouldMatch(this.minimumNumberShouldMatch);
                for (BooleanClause booleanClause : this.clauses) {
                    if (booleanClause.getOccur() == BooleanClause.Occur.FILTER) continue;
                    builder4.add(booleanClause);
                }
                for (Query query4 : filters) {
                    builder4.add(query4, BooleanClause.Occur.FILTER);
                }
                return builder4.build();
            }
        }
        Collection<Query> collection = this.clauseSets.get((Object)BooleanClause.Occur.SHOULD);
        Intrinsics.checkNotNull(collection);
        if (!collection.isEmpty()) {
            Collection<Query> collection9 = this.clauseSets.get((Object)BooleanClause.Occur.FILTER);
            Intrinsics.checkNotNull(collection9);
            if (!collection9.isEmpty()) {
                Collection<Query> collection10 = this.clauseSets.get((Object)BooleanClause.Occur.FILTER);
                Intrinsics.checkNotNull(collection10);
                filters = collection10;
                Collection<Query> collection11 = this.clauseSets.get((Object)BooleanClause.Occur.SHOULD);
                Intrinsics.checkNotNull(collection11);
                Collection<Query> shoulds = collection11;
                Set intersection = CollectionsKt.toMutableSet((Iterable)filters);
                intersection.retainAll(shoulds);
                if (!intersection.isEmpty()) {
                    void var7_37;
                    builder = new Builder();
                    int n = this.minimumNumberShouldMatch;
                    for (BooleanClause clause : this.clauses) {
                        Builder builder4;
                        if (intersection.contains(clause.getQuery())) {
                            if (clause.getOccur() == BooleanClause.Occur.SHOULD) {
                                builder.add(new BooleanClause(clause.getQuery(), BooleanClause.Occur.MUST));
                                --var7_37;
                            }
                            builder4 = Unit.INSTANCE;
                            continue;
                        }
                        builder4 = builder.add(clause);
                    }
                    builder.setMinimumNumberShouldMatch(Math.max(0, (int)var7_37));
                    return builder.build();
                }
            }
        }
        Collection<Query> collection12 = this.clauseSets.get((Object)BooleanClause.Occur.SHOULD);
        Intrinsics.checkNotNull(collection12);
        if (!collection12.isEmpty() && this.minimumNumberShouldMatch <= 1) {
            Map shouldClauses = new LinkedHashMap();
            Collection<Query> collection13 = this.clauseSets.get((Object)BooleanClause.Occur.SHOULD);
            Intrinsics.checkNotNull(collection13);
            Iterator<Query> shoulds = collection13.iterator();
            while (shoulds.hasNext()) {
                Query query7;
                Query query3 = query7 = shoulds.next();
                double d2 = 1.0;
                while (query3 instanceof BoostQuery) {
                    Query bq = query3;
                    d2 *= (double)((BoostQuery)bq).getBoost();
                    query3 = ((BoostQuery)bq).getQuery();
                }
                Map map3 = shouldClauses;
                Query query5 = query3;
                Object object = shouldClauses.get(query3);
                if (object == null) {
                    query2 = query5;
                    map2 = map3;
                    boolean bl4 = false;
                    d = 0.0;
                    map3 = map2;
                    query5 = query2;
                    object = d;
                }
                map3.put(query5, ((Number)object).doubleValue() + d2);
            }
            int n = shouldClauses.size();
            Collection<Query> collection14 = this.clauseSets.get((Object)BooleanClause.Occur.SHOULD);
            Intrinsics.checkNotNull(collection14);
            if (n != collection14.size()) {
                Builder builder6 = new Builder().setMinimumNumberShouldMatch(this.minimumNumberShouldMatch);
                for (Map.Entry entry : shouldClauses.entrySet()) {
                    void var7_41;
                    Query query6 = (Query)entry.getKey();
                    float f = (float)((Number)entry.getValue()).doubleValue();
                    if (!(f == 1.0f)) {
                        Query query7 = new BoostQuery(query6, f);
                    }
                    builder6.add((Query)var7_41, BooleanClause.Occur.SHOULD);
                }
                for (BooleanClause clause : this.clauses) {
                    if (clause.getOccur() == BooleanClause.Occur.SHOULD) continue;
                    builder6.add(clause);
                }
                return builder6.build();
            }
        }
        Collection<Query> collection15 = this.clauseSets.get((Object)BooleanClause.Occur.MUST);
        Intrinsics.checkNotNull(collection15);
        if (!collection15.isEmpty()) {
            Map mustClauses = new LinkedHashMap();
            Collection<Query> collection16 = this.clauseSets.get((Object)BooleanClause.Occur.MUST);
            Intrinsics.checkNotNull(collection16);
            Iterator<Query> builder6 = collection16.iterator();
            while (builder6.hasNext()) {
                Query query9;
                Query query8 = query9 = builder6.next();
                double d3 = 1.0;
                while (query8 instanceof BoostQuery) {
                    Query bq = query8;
                    d3 *= (double)((BoostQuery)bq).getBoost();
                    query8 = ((BoostQuery)bq).getQuery();
                }
                Map map4 = mustClauses;
                Query query10 = query8;
                Object object = mustClauses.get(query8);
                if (object == null) {
                    query2 = query10;
                    map2 = map4;
                    boolean bl5 = false;
                    d = 0.0;
                    map4 = map2;
                    query10 = query2;
                    object = d;
                }
                map4.put(query10, ((Number)object).doubleValue() + d3);
            }
            int n = mustClauses.size();
            Collection<Query> collection17 = this.clauseSets.get((Object)BooleanClause.Occur.MUST);
            Intrinsics.checkNotNull(collection17);
            if (n != collection17.size()) {
                Builder builder5 = new Builder().setMinimumNumberShouldMatch(this.minimumNumberShouldMatch);
                for (Map.Entry entry : mustClauses.entrySet()) {
                    void var7_45;
                    Query query11 = (Query)entry.getKey();
                    float f = (float)((Number)entry.getValue()).doubleValue();
                    if (!(f == 1.0f)) {
                        Query query12 = new BoostQuery(query11, f);
                    }
                    builder5.add((Query)var7_45, BooleanClause.Occur.MUST);
                }
                for (BooleanClause clause : this.clauses) {
                    if (clause.getOccur() == BooleanClause.Occur.MUST) continue;
                    builder5.add(clause);
                }
                return builder5.build();
            }
        }
        BooleanQuery $this$rewrite_u24lambda_u245 = this;
        boolean bl6 = false;
        Collection<Query> collection18 = $this$rewrite_u24lambda_u245.clauseSets.get((Object)BooleanClause.Occur.MUST);
        Intrinsics.checkNotNull(collection18);
        Collection<Query> musts = collection18;
        Collection<Query> collection19 = $this$rewrite_u24lambda_u245.clauseSets.get((Object)BooleanClause.Occur.FILTER);
        Intrinsics.checkNotNull(collection19);
        Collection<Query> collection20 = collection19;
        if (musts.size() == 1 && !collection20.isEmpty()) {
            void var8_63;
            Query query13 = musts.iterator().next();
            float boost = 1.0f;
            if (query13 instanceof BoostQuery) {
                Query query14;
                Query query15 = query14 = ((BoostQuery)query13).getQuery();
                Intrinsics.checkNotNull((Object)query15, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.search.BoostQuery");
                boost = ((BoostQuery)query15).getBoost();
            }
            if (var8_63 instanceof MatchAllDocsQuery) {
                Builder builder7 = new Builder();
                for (BooleanClause clause : $this$rewrite_u24lambda_u245.clauses) {
                    switch (WhenMappings.$EnumSwitchMapping$0[clause.getOccur().ordinal()]) {
                        case 3: 
                        case 4: {
                            Object object = builder7.add(clause);
                            break;
                        }
                        case 1: 
                        case 2: {
                            Object object = Unit.INSTANCE;
                            break;
                        }
                        default: {
                            Object object = Unit.INSTANCE;
                        }
                    }
                }
                rewritten = builder7.build();
                rewritten = new ConstantScoreQuery((Query)rewritten);
                if (!(boost == 1.0f)) {
                    rewritten = new BoostQuery((Query)rewritten, boost);
                }
                builder7 = new Builder().setMinimumNumberShouldMatch($this$rewrite_u24lambda_u245.minimumNumberShouldMatch).add((Query)rewritten, BooleanClause.Occur.MUST);
                Collection<Query> collection21 = $this$rewrite_u24lambda_u245.clauseSets.get((Object)BooleanClause.Occur.SHOULD);
                Intrinsics.checkNotNull(collection21);
                for (Query query12 : collection21) {
                    builder7.add(query12, BooleanClause.Occur.SHOULD);
                }
                rewritten = builder7.build();
                return rewritten;
            }
        }
        if (this.minimumNumberShouldMatch <= 1) {
            Builder builder8 = new Builder();
            builder8.setMinimumNumberShouldMatch(this.minimumNumberShouldMatch);
            boolean actuallyRewritten = false;
            for (BooleanClause clause : this.clauses) {
                Builder builder6;
                if (clause.getOccur() == BooleanClause.Occur.SHOULD && clause.getQuery() instanceof BooleanQuery) {
                    BooleanQuery booleanQuery = (BooleanQuery)clause.getQuery();
                    if (booleanQuery.isPureDisjunction()) {
                        actuallyRewritten = true;
                        for (BooleanClause innerClause : booleanQuery.clauses()) {
                            builder8.add(innerClause);
                        }
                        builder6 = Unit.INSTANCE;
                        continue;
                    }
                    builder6 = builder8.add(clause);
                    continue;
                }
                builder6 = builder8.add(clause);
            }
            if (actuallyRewritten) {
                return builder8.build();
            }
        }
        BooleanQuery $this$rewrite_u24lambda_u246 = this;
        boolean bl5 = false;
        builder = new Builder();
        builder.setMinimumNumberShouldMatch($this$rewrite_u24lambda_u246.minimumNumberShouldMatch);
        boolean bl7 = false;
        for (BooleanClause outerClause : $this$rewrite_u24lambda_u246.clauses) {
            Builder builder7;
            if (outerClause.isRequired() && outerClause.getQuery() instanceof BooleanQuery) {
                BooleanQuery innerQuery = (BooleanQuery)outerClause.getQuery();
                if (!(innerQuery.getClauses(BooleanClause.Occur.MUST_NOT).size() != innerQuery.clauses().size())) {
                    rewritten = "Failed requirement.";
                    throw new IllegalArgumentException(rewritten.toString());
                }
                if (innerQuery.minimumNumberShouldMatch == 0 && innerQuery.getClauses(BooleanClause.Occur.SHOULD).isEmpty()) {
                    bl = true;
                    for (BooleanClause innerClause : innerQuery) {
                        Builder builder8;
                        BooleanClause.Occur innerOccur = innerClause.getOccur();
                        if (innerOccur == BooleanClause.Occur.FILTER || innerOccur == BooleanClause.Occur.MUST_NOT || outerClause.getOccur() == BooleanClause.Occur.MUST) {
                            builder8 = builder.add(innerClause);
                            continue;
                        }
                        if (!(outerClause.getOccur() == BooleanClause.Occur.FILTER && innerOccur == BooleanClause.Occur.MUST)) {
                            String string = "Failed requirement.";
                            throw new IllegalArgumentException(string.toString());
                        }
                        builder8 = builder.add(innerClause.getQuery(), BooleanClause.Occur.FILTER);
                    }
                    builder7 = Unit.INSTANCE;
                    continue;
                }
                builder7 = builder.add(outerClause);
                continue;
            }
            builder7 = builder.add(outerClause);
        }
        if (bl) {
            return builder.build();
        }
        BooleanQuery $this$rewrite_u24lambda_u247 = this;
        boolean bl62 = false;
        Collection<Query> collection22 = $this$rewrite_u24lambda_u247.clauseSets.get((Object)BooleanClause.Occur.SHOULD);
        Intrinsics.checkNotNull(collection22);
        Collection<Query> shoulds = collection22;
        if (shoulds.size() < $this$rewrite_u24lambda_u247.minimumNumberShouldMatch) {
            return new MatchNoDocsQuery("SHOULD clause count less than minimumNumberShouldMatch");
        }
        if (!shoulds.isEmpty() && shoulds.size() == $this$rewrite_u24lambda_u247.minimumNumberShouldMatch) {
            Builder builder9 = new Builder();
            for (BooleanClause clause : $this$rewrite_u24lambda_u247.clauses) {
                Builder builder10 = clause.getOccur() == BooleanClause.Occur.SHOULD ? builder9.add(clause.getQuery(), BooleanClause.Occur.MUST) : builder9.add(clause);
            }
            return builder9.build();
        }
        BooleanQuery $this$rewrite_u24lambda_u248 = this;
        boolean bl72 = false;
        Collection<Query> collection23 = $this$rewrite_u24lambda_u248.clauseSets.get((Object)BooleanClause.Occur.SHOULD);
        Intrinsics.checkNotNull(collection23);
        shoulds = collection23;
        Collection<Query> collection24 = $this$rewrite_u24lambda_u248.clauseSets.get((Object)BooleanClause.Occur.MUST);
        Intrinsics.checkNotNull(collection24);
        Collection<Query> collection25 = collection24;
        if (shoulds.isEmpty() && collection25.size() == 1 && (query = collection25.iterator().next()) instanceof BooleanQuery) {
            int n = ((BooleanQuery)query).clauses.size();
            Collection<Query> collection26 = ((BooleanQuery)query).clauseSets.get((Object)BooleanClause.Occur.SHOULD);
            Intrinsics.checkNotNull(collection26);
            if (n == collection26.size()) {
                Builder rewritten3 = new Builder();
                for (BooleanClause clause : $this$rewrite_u24lambda_u248.clauses) {
                    if (clause.getOccur() == BooleanClause.Occur.MUST) continue;
                    rewritten3.add(clause);
                }
                for (BooleanClause innerClause : ((BooleanQuery)query).clauses()) {
                    rewritten3.add(innerClause);
                }
                rewritten3.setMinimumNumberShouldMatch(Math.max(1, ((BooleanQuery)query).minimumNumberShouldMatch));
                return rewritten3.build();
            }
        }
        return super.rewrite(indexSearcher);
    }

    @Override
    public void visit(@NotNull QueryVisitor visitor2) {
        Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
        QueryVisitor sub = visitor2.getSubVisitor(BooleanClause.Occur.MUST, this);
        for (BooleanClause.Occur occur : this.clauseSets.keySet()) {
            Collection<Query> collection = this.clauseSets.get((Object)occur);
            Intrinsics.checkNotNull(collection);
            if (!(!collection.isEmpty())) continue;
            if (occur == BooleanClause.Occur.MUST) {
                Collection<Query> collection2 = this.clauseSets.get((Object)occur);
                Intrinsics.checkNotNull(collection2);
                for (Query q : collection2) {
                    q.visit(sub);
                }
                continue;
            }
            QueryVisitor v = sub.getSubVisitor(occur, this);
            Collection<Query> collection3 = this.clauseSets.get((Object)occur);
            Intrinsics.checkNotNull(collection3);
            for (Query q : collection3) {
                q.visit(v);
            }
        }
    }

    @Override
    @NotNull
    public String toString(@Nullable String field) {
        boolean needParens;
        StringBuilder buffer = new StringBuilder();
        boolean bl = needParens = this.minimumNumberShouldMatch > 0;
        if (needParens) {
            buffer.append("(");
        }
        int i = 0;
        for (BooleanClause c : this) {
            buffer.append(c.getOccur().toString());
            Query subQuery = c.getQuery();
            if (subQuery instanceof BooleanQuery) {
                buffer.append("(");
                buffer.append(((BooleanQuery)subQuery).toString(field));
                v1 = buffer.append(")");
            } else {
                v1 = buffer.append(subQuery.toString(field));
            }
            if (i != this.clauses.size() - 1) {
                buffer.append(" ");
            }
            ++i;
        }
        if (needParens) {
            buffer.append(")");
        }
        if (this.minimumNumberShouldMatch > 0) {
            buffer.append('~');
            buffer.append(this.minimumNumberShouldMatch);
        }
        String string = buffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        return this.sameClassAs(o) && this.equalsTo((BooleanQuery)KClasses.cast((KClass)Reflection.getOrCreateKotlinClass(this.getClass()), (Object)o));
    }

    private final boolean equalsTo(BooleanQuery other) {
        return this.minimumNumberShouldMatch == other.minimumNumberShouldMatch && Intrinsics.areEqual(this.clauseSets, other.clauseSets);
    }

    private final int computeHashCode() {
        Object[] objectArray = new Object[]{this.minimumNumberShouldMatch, this.clauseSets};
        int hashCode = Objects.INSTANCE.hash(objectArray);
        if (hashCode == 0) {
            hashCode = 1;
        }
        return hashCode;
    }

    @Override
    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.computeHashCode();
            if (!(this.hashCode != 0)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
        }
        if (!(this.hashCode == this.computeHashCode())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return this.hashCode;
    }

    public /* synthetic */ BooleanQuery(int minimumNumberShouldMatch, BooleanClause[] clauses, DefaultConstructorMarker $constructor_marker) {
        this(minimumNumberShouldMatch, clauses);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u0005J\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\bJ\u0014\u0010\u000b\u001a\u00020\u00002\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u000eJ\u0016\u0010\u000b\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/gnit/lucenekmp/search/BooleanQuery$Builder;", "", "<init>", "()V", "minimumNumberShouldMatch", "", "clauses", "", "Lorg/gnit/lucenekmp/search/BooleanClause;", "setMinimumNumberShouldMatch", "min", "add", "clause", "collection", "", "query", "Lorg/gnit/lucenekmp/search/Query;", "occur", "Lorg/gnit/lucenekmp/search/BooleanClause$Occur;", "build", "Lorg/gnit/lucenekmp/search/BooleanQuery;", "core"})
    @SourceDebugExtension(value={"SMAP\nBooleanQuery.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BooleanQuery.kt\norg/gnit/lucenekmp/search/BooleanQuery$Builder\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,709:1\n37#2:710\n36#2,3:711\n*S KotlinDebug\n*F\n+ 1 BooleanQuery.kt\norg/gnit/lucenekmp/search/BooleanQuery$Builder\n*L\n99#1:710\n99#1:711,3\n*E\n"})
    public static final class Builder {
        private int minimumNumberShouldMatch;
        @NotNull
        private final List<BooleanClause> clauses = new ArrayList();

        @NotNull
        public final Builder setMinimumNumberShouldMatch(int min) {
            this.minimumNumberShouldMatch = min;
            return this;
        }

        @NotNull
        public final Builder add(@NotNull BooleanClause clause) {
            Intrinsics.checkNotNullParameter((Object)clause, (String)"clause");
            if (this.clauses.size() >= IndexSearcher.Companion.getMaxClauseCount()) {
                throw new IndexSearcher.TooManyClauses(null, 1, null);
            }
            this.clauses.add(clause);
            return this;
        }

        @NotNull
        public final Builder add(@NotNull Collection<BooleanClause> collection) {
            Intrinsics.checkNotNullParameter(collection, (String)"collection");
            if (this.clauses.size() + collection.size() > IndexSearcher.Companion.getMaxClauseCount()) {
                throw new IndexSearcher.TooManyClauses(null, 1, null);
            }
            this.clauses.addAll(collection);
            return this;
        }

        @NotNull
        public final Builder add(@NotNull Query query, @NotNull BooleanClause.Occur occur) {
            Intrinsics.checkNotNullParameter((Object)query, (String)"query");
            Intrinsics.checkNotNullParameter((Object)((Object)occur), (String)"occur");
            return this.add(new BooleanClause(query, occur));
        }

        @NotNull
        public final BooleanQuery build() {
            Collection $this$toTypedArray$iv = this.clauses;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return new BooleanQuery(this.minimumNumberShouldMatch, thisCollection$iv.toArray(new BooleanClause[0]), null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BooleanClause.Occur.values().length];
            try {
                nArray[BooleanClause.Occur.SHOULD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BooleanClause.Occur.MUST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BooleanClause.Occur.FILTER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BooleanClause.Occur.MUST_NOT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

