/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.index.LeafReaderContext;
import org.gnit.lucenekmp.search.BooleanClause;
import org.gnit.lucenekmp.search.BooleanQuery;
import org.gnit.lucenekmp.search.BooleanScorerSupplier;
import org.gnit.lucenekmp.search.Explanation;
import org.gnit.lucenekmp.search.IndexSearcher;
import org.gnit.lucenekmp.search.Matches;
import org.gnit.lucenekmp.search.MatchesUtils;
import org.gnit.lucenekmp.search.ScoreMode;
import org.gnit.lucenekmp.search.Scorer;
import org.gnit.lucenekmp.search.ScorerSupplier;
import org.gnit.lucenekmp.search.Weight;
import org.gnit.lucenekmp.search.similarities.Similarity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001,B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u001a\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010\"\u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010#\u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010$\u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u001dH\u0016J\u0012\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R!\u0010\u0014\u001a\u0012\u0012\u0004\u0012\u00020\u00160\u0015j\b\u0012\u0004\u0012\u00020\u0016`\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006-"}, d2={"Lorg/gnit/lucenekmp/search/BooleanWeight;", "Lorg/gnit/lucenekmp/search/Weight;", "query", "Lorg/gnit/lucenekmp/search/BooleanQuery;", "searcher", "Lorg/gnit/lucenekmp/search/IndexSearcher;", "scoreMode", "Lorg/gnit/lucenekmp/search/ScoreMode;", "boost", "", "<init>", "(Lorg/gnit/lucenekmp/search/BooleanQuery;Lorg/gnit/lucenekmp/search/IndexSearcher;Lorg/gnit/lucenekmp/search/ScoreMode;F)V", "getQuery", "()Lorg/gnit/lucenekmp/search/BooleanQuery;", "getScoreMode", "()Lorg/gnit/lucenekmp/search/ScoreMode;", "similarity", "Lorg/gnit/lucenekmp/search/similarities/Similarity;", "getSimilarity", "()Lorg/gnit/lucenekmp/search/similarities/Similarity;", "weightedClauses", "Ljava/util/ArrayList;", "Lorg/gnit/lucenekmp/search/BooleanWeight$WeightedBooleanClause;", "Lkotlin/collections/ArrayList;", "getWeightedClauses", "()Ljava/util/ArrayList;", "explain", "Lorg/gnit/lucenekmp/search/Explanation;", "context", "Lorg/gnit/lucenekmp/index/LeafReaderContext;", "doc", "", "matches", "Lorg/gnit/lucenekmp/search/Matches;", "count", "reqCount", "optCount", "occur", "Lorg/gnit/lucenekmp/search/BooleanClause$Occur;", "isCacheable", "", "ctx", "scorerSupplier", "Lorg/gnit/lucenekmp/search/ScorerSupplier;", "WeightedBooleanClause", "core"})
@SourceDebugExtension(value={"SMAP\nBooleanWeight.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BooleanWeight.kt\norg/gnit/lucenekmp/search/BooleanWeight\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,309:1\n1869#2,2:310\n*S KotlinDebug\n*F\n+ 1 BooleanWeight.kt\norg/gnit/lucenekmp/search/BooleanWeight\n*L\n256#1:310,2\n*E\n"})
public final class BooleanWeight
extends Weight {
    @NotNull
    private final BooleanQuery query;
    @NotNull
    private final ScoreMode scoreMode;
    @NotNull
    private final Similarity similarity;
    @NotNull
    private final ArrayList<WeightedBooleanClause> weightedClauses;

    public BooleanWeight(@NotNull BooleanQuery query, @NotNull IndexSearcher searcher, @NotNull ScoreMode scoreMode, float boost) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)searcher, (String)"searcher");
        Intrinsics.checkNotNullParameter((Object)((Object)scoreMode), (String)"scoreMode");
        super(query);
        this.query = query;
        this.scoreMode = scoreMode;
        this.similarity = searcher.getSimilarity();
        this.weightedClauses = new ArrayList();
        for (BooleanClause c : this.getQuery()) {
            Weight w = searcher.createWeight(c.getQuery(), c.isScoring() ? this.scoreMode : ScoreMode.COMPLETE_NO_SCORES, boost);
            this.weightedClauses.add(new WeightedBooleanClause(c, w));
        }
    }

    @Override
    @NotNull
    public BooleanQuery getQuery() {
        return this.query;
    }

    @NotNull
    public final ScoreMode getScoreMode() {
        return this.scoreMode;
    }

    @NotNull
    public final Similarity getSimilarity() {
        return this.similarity;
    }

    @NotNull
    public final ArrayList<WeightedBooleanClause> getWeightedClauses() {
        return this.weightedClauses;
    }

    @Override
    @NotNull
    public Explanation explain(@NotNull LeafReaderContext context, int doc) throws IOException {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        int minShouldMatch = this.getQuery().getMinimumNumberShouldMatch();
        List subs = new ArrayList();
        boolean fail = false;
        int matchCount = 0;
        int shouldMatchCount = 0;
        Iterator<WeightedBooleanClause> iterator2 = this.weightedClauses.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
        Iterator<WeightedBooleanClause> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Explanation[] explanationArray;
            WeightedBooleanClause wc;
            Intrinsics.checkNotNullExpressionValue((Object)iterator3.next(), (String)"next(...)");
            Weight w = wc.getWeight();
            BooleanClause c = wc.getClause();
            Explanation e = w.explain(context, doc);
            if (e.isMatch()) {
                if (c.isScoring()) {
                    subs.add(e);
                } else if (c.isRequired()) {
                    explanationArray = new Explanation[]{Explanation.Companion.match((Number)Float.valueOf(0.0f), BooleanClause.Occur.FILTER + " clause", new Explanation[0]), e};
                    subs.add(Explanation.Companion.match((Number)Float.valueOf(0.0f), "match on required clause, product of:", explanationArray));
                } else if (c.isProhibited()) {
                    explanationArray = new Explanation[]{e};
                    subs.add(Explanation.Companion.noMatch("match on prohibited clause (" + c.getQuery() + ")", explanationArray));
                    fail = true;
                }
                if (!c.isProhibited()) {
                    ++matchCount;
                }
                if (c.getOccur() != BooleanClause.Occur.SHOULD) continue;
                ++shouldMatchCount;
                continue;
            }
            if (!c.isRequired()) continue;
            explanationArray = new Explanation[]{e};
            subs.add(Explanation.Companion.noMatch("no match on required clause (" + c.getQuery() + ")", explanationArray));
            fail = true;
        }
        if (fail) {
            return Explanation.Companion.noMatch("Failure to meet condition(s) of required/prohibited clause(s)", subs);
        }
        if (matchCount == 0) {
            return Explanation.Companion.noMatch("No matching clauses", subs);
        }
        if (shouldMatchCount < minShouldMatch) {
            return Explanation.Companion.noMatch("Failure to match minimum number of optional clauses: " + minShouldMatch, subs);
        }
        Scorer scorer2 = this.scorer(context);
        Intrinsics.checkNotNull((Object)scorer2);
        Scorer scorer3 = scorer2;
        int advanced = scorer3.iterator().advance(doc);
        if (!(advanced == doc)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return Explanation.Companion.match((Number)Float.valueOf(scorer3.score()), "sum of:", subs);
    }

    @Override
    @Nullable
    public Matches matches(@NotNull LeafReaderContext context, int doc) throws IOException {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        int minShouldMatch = this.getQuery().getMinimumNumberShouldMatch();
        List matches2 = new ArrayList();
        int shouldMatchCount = 0;
        Iterator<WeightedBooleanClause> iterator2 = this.weightedClauses.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
        Iterator<WeightedBooleanClause> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            WeightedBooleanClause wc;
            Intrinsics.checkNotNullExpressionValue((Object)iterator3.next(), (String)"next(...)");
            Weight w = wc.getWeight();
            BooleanClause bc = wc.getClause();
            Matches m = w.matches(context, doc);
            if (bc.isProhibited() && m != null) {
                return null;
            }
            if (bc.isRequired()) {
                if (m == null) {
                    return null;
                }
                matches2.add(m);
            }
            if (bc.getOccur() != BooleanClause.Occur.SHOULD || m == null) continue;
            matches2.add(m);
            ++shouldMatchCount;
        }
        if (shouldMatchCount < minShouldMatch) {
            return null;
        }
        return MatchesUtils.INSTANCE.fromSubMatches(matches2);
    }

    @Override
    public int count(@NotNull LeafReaderContext context) throws IOException {
        int positiveCount;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        int numDocs = context.reader().numDocs();
        if (this.getQuery().isPureDisjunction()) {
            return this.optCount(context, BooleanClause.Occur.SHOULD);
        }
        int n = positiveCount = (!this.getQuery().getClauses(BooleanClause.Occur.FILTER).isEmpty() || !this.getQuery().getClauses(BooleanClause.Occur.MUST).isEmpty()) && this.getQuery().getMinimumNumberShouldMatch() == 0 ? this.reqCount(context) : -1;
        if (positiveCount == 0) {
            return 0;
        }
        int prohibitedCount = this.optCount(context, BooleanClause.Occur.MUST_NOT);
        return prohibitedCount == -1 ? -1 : (prohibitedCount == 0 ? positiveCount : (prohibitedCount == numDocs ? 0 : (positiveCount == numDocs ? numDocs - prohibitedCount : -1)));
    }

    private final int reqCount(LeafReaderContext context) throws IOException {
        int numDocs;
        int reqCount = numDocs = context.reader().numDocs();
        Iterator<WeightedBooleanClause> iterator2 = this.weightedClauses.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
        Iterator<WeightedBooleanClause> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            WeightedBooleanClause weightedClause;
            Intrinsics.checkNotNullExpressionValue((Object)iterator3.next(), (String)"next(...)");
            if (!weightedClause.getClause().isRequired()) continue;
            int count = weightedClause.getWeight().count(context);
            if (count == -1 || count == 0) {
                return count;
            }
            if (count == numDocs) continue;
            if (reqCount == numDocs) {
                reqCount = count;
                continue;
            }
            return -1;
        }
        return reqCount;
    }

    private final int optCount(LeafReaderContext context, BooleanClause.Occur occur) throws IOException {
        int numDocs = context.reader().numDocs();
        int optCount = 0;
        boolean unknownCount = false;
        Iterator<WeightedBooleanClause> iterator2 = this.weightedClauses.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
        Iterator<WeightedBooleanClause> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            WeightedBooleanClause weightedClause;
            Intrinsics.checkNotNullExpressionValue((Object)iterator3.next(), (String)"next(...)");
            if (weightedClause.getClause().getOccur() != occur) continue;
            int count = weightedClause.getWeight().count(context);
            if (count == -1) {
                unknownCount = true;
                continue;
            }
            if (count == numDocs) {
                return count;
            }
            if (count == 0) continue;
            if (optCount == 0) {
                optCount = count;
                continue;
            }
            unknownCount = true;
        }
        return unknownCount ? -1 : optCount;
    }

    @Override
    public boolean isCacheable(@NotNull LeafReaderContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        if (this.getQuery().clauses().size() > 16) {
            return false;
        }
        Iterator<WeightedBooleanClause> iterator2 = this.weightedClauses.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
        Iterator<WeightedBooleanClause> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            WeightedBooleanClause wc;
            Intrinsics.checkNotNullExpressionValue((Object)iterator3.next(), (String)"next(...)");
            Weight w = wc.getWeight();
            if (w.isCacheable(ctx)) continue;
            return false;
        }
        return true;
    }

    @Override
    @Nullable
    public ScorerSupplier scorerSupplier(@NotNull LeafReaderContext context) throws IOException {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        int minShouldMatch = this.getQuery().getMinimumNumberShouldMatch();
        Iterator<WeightedBooleanClause> iterator2 = new LinkedHashMap();
        Map $this$scorerSupplier_u24lambda_u241 = iterator2;
        boolean bl = false;
        Iterable $this$forEach$iv = (Iterable)BooleanClause.Occur.getEntries();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BooleanClause.Occur occur = (BooleanClause.Occur)((Object)element$iv);
            boolean bl2 = false;
            $this$scorerSupplier_u24lambda_u241.put(occur, (List)new ArrayList());
        }
        Map scorers = iterator2;
        for (BooleanClause.Occur occur : BooleanClause.Occur.getEntries()) {
            scorers.put(occur, new ArrayList());
        }
        Iterator<WeightedBooleanClause> iterator3 = this.weightedClauses.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator3, (String)"iterator(...)");
        iterator2 = iterator3;
        while (iterator2.hasNext()) {
            WeightedBooleanClause wc;
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            Weight w = wc.getWeight();
            BooleanClause c = wc.getClause();
            ScorerSupplier subScorer = w.scorerSupplier(context);
            if (subScorer == null) {
                if (!c.isRequired()) continue;
                return null;
            }
            Object v = scorers.get((Object)c.getOccur());
            Intrinsics.checkNotNull(v);
            ((Collection)v).add(subScorer);
        }
        Object v = scorers.get((Object)BooleanClause.Occur.SHOULD);
        Intrinsics.checkNotNull(v);
        if (((Collection)v).size() == minShouldMatch) {
            Object v2 = scorers.get((Object)BooleanClause.Occur.MUST);
            Intrinsics.checkNotNull(v2);
            Collection collection = (Collection)v2;
            Object v3 = scorers.get((Object)BooleanClause.Occur.SHOULD);
            Intrinsics.checkNotNull(v3);
            collection.addAll((Collection)v3);
            Object v4 = scorers.get((Object)BooleanClause.Occur.SHOULD);
            Intrinsics.checkNotNull(v4);
            ((Collection)v4).clear();
            minShouldMatch = 0;
        }
        Object v5 = scorers.get((Object)BooleanClause.Occur.FILTER);
        Intrinsics.checkNotNull(v5);
        if (((Collection)v5).isEmpty()) {
            Object v6 = scorers.get((Object)BooleanClause.Occur.MUST);
            Intrinsics.checkNotNull(v6);
            if (((Collection)v6).isEmpty()) {
                Object v7 = scorers.get((Object)BooleanClause.Occur.SHOULD);
                Intrinsics.checkNotNull(v7);
                if (((Collection)v7).isEmpty()) {
                    return null;
                }
            }
        }
        Object v8 = scorers.get((Object)BooleanClause.Occur.SHOULD);
        Intrinsics.checkNotNull(v8);
        if (((Collection)v8).size() < minShouldMatch) {
            return null;
        }
        if (!this.scoreMode.needsScores() && minShouldMatch == 0) {
            Object v9 = scorers.get((Object)BooleanClause.Occur.MUST);
            Intrinsics.checkNotNull(v9);
            int n = ((Collection)v9).size();
            Object v10 = scorers.get((Object)BooleanClause.Occur.FILTER);
            Intrinsics.checkNotNull(v10);
            if (n + ((Collection)v10).size() > 0) {
                Object v11 = scorers.get((Object)BooleanClause.Occur.SHOULD);
                Intrinsics.checkNotNull(v11);
                ((Collection)v11).clear();
            }
        }
        return new BooleanScorerSupplier(this, scorers, this.scoreMode, minShouldMatch, context.reader().maxDoc());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B\u0019\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/gnit/lucenekmp/search/BooleanWeight$WeightedBooleanClause;", "", "clause", "Lorg/gnit/lucenekmp/search/BooleanClause;", "weight", "Lorg/gnit/lucenekmp/search/Weight;", "<init>", "(Lorg/gnit/lucenekmp/search/BooleanClause;Lorg/gnit/lucenekmp/search/Weight;)V", "getClause", "()Lorg/gnit/lucenekmp/search/BooleanClause;", "getWeight", "()Lorg/gnit/lucenekmp/search/Weight;", "core"})
    public static final class WeightedBooleanClause {
        @NotNull
        private final BooleanClause clause;
        @NotNull
        private final Weight weight;

        public WeightedBooleanClause(@NotNull BooleanClause clause, @NotNull Weight weight) {
            Intrinsics.checkNotNullParameter((Object)clause, (String)"clause");
            Intrinsics.checkNotNullParameter((Object)weight, (String)"weight");
            this.clause = clause;
            this.weight = weight;
        }

        @NotNull
        public final BooleanClause getClause() {
            return this.clause;
        }

        @NotNull
        public final Weight getWeight() {
            return this.weight;
        }
    }
}

