/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.LongCompanionObject;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.jdkport.LongExtKt;
import org.gnit.lucenekmp.search.DocIdSetIterator;
import org.gnit.lucenekmp.search.Scorer;
import org.gnit.lucenekmp.search.TwoPhaseIterator;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.gnit.lucenekmp.util.BitSet;
import org.gnit.lucenekmp.util.BitSetIterator;
import org.gnit.lucenekmp.util.CollectionUtil;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u0000 \u001d2\u00020\u0001:\u0003\u001b\u001c\u001dB\u0019\b\u0002\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002J\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0011H\u0016J\b\u0010\u0015\u001a\u00020\u0011H\u0016J\b\u0010\u0016\u001a\u00020\u0011H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0002R\u0011\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0019\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00010\f\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001e"}, d2={"Lorg/gnit/lucenekmp/search/ConjunctionDISI;", "Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "iterators", "", "<init>", "(Ljava/util/List;)V", "lead1", "getLead1", "()Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "lead2", "getLead2", "others", "", "getOthers", "()[Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "[Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "doNext", "", "doc", "advance", "target", "docID", "nextDoc", "cost", "", "assertItersOnSameDoc", "", "BitSetConjunctionDISI", "ConjunctionTwoPhaseIterator", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nConjunctionDISI.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConjunctionDISI.kt\norg/gnit/lucenekmp/search/ConjunctionDISI\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,358:1\n37#2:359\n36#2,3:360\n*S KotlinDebug\n*F\n+ 1 ConjunctionDISI.kt\norg/gnit/lucenekmp/search/ConjunctionDISI\n*L\n32#1:359\n32#1:360,3\n*E\n"})
public final class ConjunctionDISI
extends DocIdSetIterator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DocIdSetIterator lead1;
    @NotNull
    private final DocIdSetIterator lead2;
    @NotNull
    private final DocIdSetIterator[] others;

    private ConjunctionDISI(List<? extends DocIdSetIterator> iterators) {
        if (!(iterators.size() >= 2)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        CollectionUtil.INSTANCE.timSort(iterators, 1.INSTANCE);
        this.lead1 = iterators.get(0);
        this.lead2 = iterators.get(1);
        Collection $this$toTypedArray$iv = iterators.subList(2, iterators.size());
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        this.others = thisCollection$iv.toArray(new DocIdSetIterator[0]);
    }

    @NotNull
    public final DocIdSetIterator getLead1() {
        return this.lead1;
    }

    @NotNull
    public final DocIdSetIterator getLead2() {
        return this.lead2;
    }

    @NotNull
    public final DocIdSetIterator[] getOthers() {
        return this.others;
    }

    private final int doNext(int doc) throws IOException {
        int doc2 = doc;
        block0: while (true) {
            if (!(doc2 == this.lead1.docID())) {
                DocIdSetIterator[] docIdSetIteratorArray = "Failed requirement.";
                throw new IllegalArgumentException(docIdSetIteratorArray.toString());
            }
            int next2 = this.lead2.advance(doc2);
            if (next2 != doc2 && next2 != (doc2 = this.lead1.advance(next2))) continue;
            for (DocIdSetIterator other : this.others) {
                int next;
                if (other.docID() >= doc2 || (next = other.advance(doc2)) <= doc2) continue;
                doc2 = this.lead1.advance(next);
                continue block0;
            }
            break;
        }
        return doc2;
    }

    @Override
    public int advance(int target) throws IOException {
        if (!this.assertItersOnSameDoc()) {
            boolean bl = false;
            String string = "Sub-iterators of ConjunctionDISI are not one the same document!";
            throw new IllegalArgumentException(string.toString());
        }
        return this.doNext(this.lead1.advance(target));
    }

    @Override
    public int docID() {
        return this.lead1.docID();
    }

    @Override
    public int nextDoc() throws IOException {
        if (!this.assertItersOnSameDoc()) {
            boolean bl = false;
            String string = "Sub-iterators of ConjunctionDISI are not on the same document!";
            throw new IllegalArgumentException(string.toString());
        }
        return this.doNext(this.lead1.nextDoc());
    }

    @Override
    public long cost() {
        return this.lead1.cost();
    }

    private final boolean assertItersOnSameDoc() {
        int curDoc = this.lead1.docID();
        boolean iteratorsOnTheSameDoc = this.lead2.docID() == curDoc;
        for (int i = 0; i < this.others.length && iteratorsOnTheSameDoc; ++i) {
            iteratorsOnTheSameDoc = iteratorsOnTheSameDoc && this.others[i].docID() == curDoc;
        }
        return iteratorsOnTheSameDoc;
    }

    public /* synthetic */ ConjunctionDISI(List iterators, DefaultConstructorMarker $constructor_marker) {
        this(iterators);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0014\u001a\u00020\u0012H\u0016J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0012H\u0016J\u000e\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0012J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0006\u0010\u001b\u001a\u00020\u001cR\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0019\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\n\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\fR\u0018\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/gnit/lucenekmp/search/ConjunctionDISI$BitSetConjunctionDISI;", "Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "lead", "bitSetIterators", "", "Lorg/gnit/lucenekmp/util/BitSetIterator;", "<init>", "(Lorg/gnit/lucenekmp/search/DocIdSetIterator;Ljava/util/Collection;)V", "getLead", "()Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "", "getBitSetIterators", "()[Lorg/gnit/lucenekmp/util/BitSetIterator;", "[Lorg/gnit/lucenekmp/util/BitSetIterator;", "bitSets", "Lorg/gnit/lucenekmp/util/BitSet;", "[Lorg/gnit/lucenekmp/util/BitSet;", "minLength", "", "docID", "nextDoc", "advance", "target", "doNext", "doc", "cost", "", "assertItersOnSameDoc", "", "core"})
    @SourceDebugExtension(value={"SMAP\nConjunctionDISI.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConjunctionDISI.kt\norg/gnit/lucenekmp/search/ConjunctionDISI$BitSetConjunctionDISI\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,358:1\n37#2:359\n36#2,3:360\n*S KotlinDebug\n*F\n+ 1 ConjunctionDISI.kt\norg/gnit/lucenekmp/search/ConjunctionDISI$BitSetConjunctionDISI\n*L\n120#1:359\n120#1:360,3\n*E\n"})
    private static final class BitSetConjunctionDISI
    extends DocIdSetIterator {
        @NotNull
        private final DocIdSetIterator lead;
        @NotNull
        private final BitSetIterator[] bitSetIterators;
        @NotNull
        private final BitSet[] bitSets;
        private final int minLength;

        public BitSetConjunctionDISI(@NotNull DocIdSetIterator lead, @NotNull Collection<BitSetIterator> bitSetIterators) {
            Intrinsics.checkNotNullParameter((Object)lead, (String)"lead");
            Intrinsics.checkNotNullParameter(bitSetIterators, (String)"bitSetIterators");
            this.lead = lead;
            if (!(!bitSetIterators.isEmpty())) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            Collection<BitSetIterator> $this$toTypedArray$iv = bitSetIterators;
            boolean $i$f$toTypedArray = false;
            Collection<BitSetIterator> thisCollection$iv = $this$toTypedArray$iv;
            this.bitSetIterators = thisCollection$iv.toArray(new BitSetIterator[0]);
            ArrayUtil.Companion.timSort(this.bitSetIterators, (arg_0, arg_1) -> BitSetConjunctionDISI._init_$lambda$1(BitSetConjunctionDISI::_init_$lambda$0, arg_0, arg_1));
            this.bitSets = new BitSet[this.bitSetIterators.length];
            int minLen = Integer.MAX_VALUE;
            int n = this.bitSetIterators.length;
            for (int i = 0; i < n; ++i) {
                BitSet bitSet;
                this.bitSets[i] = bitSet = this.bitSetIterators[i].getBitSet();
                minLen = Math.min(minLen, bitSet.length());
            }
            this.minLength = minLen;
        }

        @NotNull
        public final DocIdSetIterator getLead() {
            return this.lead;
        }

        @NotNull
        public final BitSetIterator[] getBitSetIterators() {
            return this.bitSetIterators;
        }

        @Override
        public int docID() {
            return this.lead.docID();
        }

        @Override
        public int nextDoc() throws IOException {
            if (!this.assertItersOnSameDoc()) {
                boolean bl = false;
                String string = "Sub-iterators of ConjunctionDISI are not on the same document!";
                throw new IllegalArgumentException(string.toString());
            }
            return this.doNext(this.lead.nextDoc());
        }

        @Override
        public int advance(int target) throws IOException {
            if (!this.assertItersOnSameDoc()) {
                boolean bl = false;
                String string = "Sub-iterators of ConjunctionDISI are not on the same document!";
                throw new IllegalArgumentException(string.toString());
            }
            return this.doNext(this.lead.advance(target));
        }

        public final int doNext(int doc) throws IOException {
            int doc2 = doc;
            block0: while (true) {
                if (doc2 >= this.minLength) {
                    if (doc2 != Integer.MAX_VALUE) {
                        this.lead.advance(Integer.MAX_VALUE);
                    }
                    return Integer.MAX_VALUE;
                }
                Object[] objectArray = this.bitSets;
                int n = objectArray.length;
                for (int i = 0; i < n; ++i) {
                    BitSet bitSet;
                    BitSet bitSet2 = bitSet = objectArray[i];
                    Intrinsics.checkNotNull((Object)bitSet2);
                    if (bitSet2.get(doc2)) continue;
                    doc2 = this.lead.nextDoc();
                    continue block0;
                }
                break;
            }
            for (BitSetIterator iterator2 : this.bitSetIterators) {
                iterator2.setDocId(doc2);
            }
            return doc2;
        }

        @Override
        public long cost() {
            return this.lead.cost();
        }

        public final boolean assertItersOnSameDoc() {
            int curDoc = this.lead.docID();
            boolean iteratorsOnTheSameDoc = true;
            for (int i = 0; i < this.bitSetIterators.length && iteratorsOnTheSameDoc; ++i) {
                iteratorsOnTheSameDoc = iteratorsOnTheSameDoc && this.bitSetIterators[i].docID() == curDoc;
            }
            return iteratorsOnTheSameDoc;
        }

        private static final int _init_$lambda$0(BitSetIterator a, BitSetIterator b) {
            return LongExtKt.compare(LongCompanionObject.INSTANCE, a.cost(), b.cost());
        }

        private static final int _init_$lambda$1(Function2 $tmp0, Object p0, Object p1) {
            return ((Number)$tmp0.invoke(p0, p1)).intValue();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\tJ*\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\n2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\tJ*\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\f2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\tJ\"\u0010\u0011\u001a\u00020\n2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\tJ\b\u0010\u0012\u001a\u00020\u0005H\u0002\u00a8\u0006\u0013"}, d2={"Lorg/gnit/lucenekmp/search/ConjunctionDISI$Companion;", "", "<init>", "()V", "addScorer", "", "scorer", "Lorg/gnit/lucenekmp/search/Scorer;", "allIterators", "", "Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "twoPhaseIterators", "Lorg/gnit/lucenekmp/search/TwoPhaseIterator;", "addIterator", "disi", "addTwoPhaseIterator", "twoPhaseIter", "createConjunction", "throwSubIteratorsNotOnSameDocument", "core"})
    public static final class Companion {
        private Companion() {
        }

        public final void addScorer(@NotNull Scorer scorer2, @NotNull List<DocIdSetIterator> allIterators, @NotNull List<TwoPhaseIterator> twoPhaseIterators) {
            Intrinsics.checkNotNullParameter((Object)scorer2, (String)"scorer");
            Intrinsics.checkNotNullParameter(allIterators, (String)"allIterators");
            Intrinsics.checkNotNullParameter(twoPhaseIterators, (String)"twoPhaseIterators");
            TwoPhaseIterator twoPhaseIter = scorer2.twoPhaseIterator();
            if (twoPhaseIter != null) {
                this.addTwoPhaseIterator(twoPhaseIter, allIterators, twoPhaseIterators);
            } else {
                this.addIterator(scorer2.iterator(), allIterators, twoPhaseIterators);
            }
        }

        public final void addIterator(@NotNull DocIdSetIterator disi, @NotNull List<DocIdSetIterator> allIterators, @NotNull List<TwoPhaseIterator> twoPhaseIterators) {
            Intrinsics.checkNotNullParameter((Object)disi, (String)"disi");
            Intrinsics.checkNotNullParameter(allIterators, (String)"allIterators");
            Intrinsics.checkNotNullParameter(twoPhaseIterators, (String)"twoPhaseIterators");
            TwoPhaseIterator twoPhase = TwoPhaseIterator.Companion.unwrap(disi);
            if (twoPhase != null) {
                this.addTwoPhaseIterator(twoPhase, allIterators, twoPhaseIterators);
            } else if (disi instanceof ConjunctionDISI) {
                DocIdSetIterator conjunction = disi;
                allIterators.add(((ConjunctionDISI)conjunction).getLead1());
                allIterators.add(((ConjunctionDISI)conjunction).getLead2());
                CollectionsKt.addAll((Collection)allIterators, (Object[])((ConjunctionDISI)conjunction).getOthers());
            } else if (disi instanceof BitSetConjunctionDISI) {
                DocIdSetIterator conjunction = disi;
                allIterators.add(((BitSetConjunctionDISI)conjunction).getLead());
                CollectionsKt.addAll((Collection)allIterators, (Object[])((BitSetConjunctionDISI)conjunction).getBitSetIterators());
            } else {
                allIterators.add(disi);
            }
        }

        public final void addTwoPhaseIterator(@NotNull TwoPhaseIterator twoPhaseIter, @NotNull List<DocIdSetIterator> allIterators, @NotNull List<TwoPhaseIterator> twoPhaseIterators) {
            Intrinsics.checkNotNullParameter((Object)twoPhaseIter, (String)"twoPhaseIter");
            Intrinsics.checkNotNullParameter(allIterators, (String)"allIterators");
            Intrinsics.checkNotNullParameter(twoPhaseIterators, (String)"twoPhaseIterators");
            this.addIterator(twoPhaseIter.approximation(), allIterators, twoPhaseIterators);
            boolean bl = twoPhaseIter instanceof ConjunctionTwoPhaseIterator ? CollectionsKt.addAll((Collection)twoPhaseIterators, (Object[])((ConjunctionTwoPhaseIterator)twoPhaseIter).getTwoPhaseIterators()) : twoPhaseIterators.add(twoPhaseIter);
        }

        @NotNull
        public final DocIdSetIterator createConjunction(@NotNull List<DocIdSetIterator> allIterators, @NotNull List<TwoPhaseIterator> twoPhaseIterators) {
            Intrinsics.checkNotNullParameter(allIterators, (String)"allIterators");
            Intrinsics.checkNotNullParameter(twoPhaseIterators, (String)"twoPhaseIterators");
            int curDoc = !((Collection)allIterators).isEmpty() ? allIterators.get(0).docID() : twoPhaseIterators.get(0).getApproximation().docID();
            long minCost = Long.MAX_VALUE;
            for (DocIdSetIterator allIterator : allIterators) {
                if (allIterator.docID() != curDoc) {
                    this.throwSubIteratorsNotOnSameDocument();
                }
                minCost = Math.min(allIterator.cost(), minCost);
            }
            for (TwoPhaseIterator it : twoPhaseIterators) {
                if (it.approximation().docID() == curDoc) continue;
                this.throwSubIteratorsNotOnSameDocument();
            }
            List bitSetIterators = new ArrayList();
            List iterators = new ArrayList();
            for (DocIdSetIterator iterator2 : allIterators) {
                boolean bl = iterator2 instanceof BitSetIterator && ((BitSetIterator)iterator2).cost() > minCost ? bitSetIterators.add(iterator2) : iterators.add(iterator2);
            }
            DocIdSetIterator disi = null;
            disi = iterators.size() == 1 ? (DocIdSetIterator)iterators.get(0) : (DocIdSetIterator)new ConjunctionDISI(iterators, null);
            if (!((Collection)bitSetIterators).isEmpty()) {
                disi = new BitSetConjunctionDISI(disi, bitSetIterators);
            }
            if (!twoPhaseIterators.isEmpty()) {
                disi = TwoPhaseIterator.Companion.asDocIdSetIterator(new ConjunctionTwoPhaseIterator(disi, twoPhaseIterators));
            }
            return disi;
        }

        private final void throwSubIteratorsNotOnSameDocument() {
            throw new IllegalArgumentException("Sub-iterators of ConjunctionDISI are not on the same document!");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u0019\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\b\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/gnit/lucenekmp/search/ConjunctionDISI$ConjunctionTwoPhaseIterator;", "Lorg/gnit/lucenekmp/search/TwoPhaseIterator;", "approximation", "Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "twoPhaseIterators", "", "<init>", "(Lorg/gnit/lucenekmp/search/DocIdSetIterator;Ljava/util/List;)V", "", "getTwoPhaseIterators", "()[Lorg/gnit/lucenekmp/search/TwoPhaseIterator;", "[Lorg/gnit/lucenekmp/search/TwoPhaseIterator;", "matchCost", "", "matches", "", "core"})
    @SourceDebugExtension(value={"SMAP\nConjunctionDISI.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConjunctionDISI.kt\norg/gnit/lucenekmp/search/ConjunctionDISI$ConjunctionTwoPhaseIterator\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,358:1\n37#2:359\n36#2,3:360\n*S KotlinDebug\n*F\n+ 1 ConjunctionDISI.kt\norg/gnit/lucenekmp/search/ConjunctionDISI$ConjunctionTwoPhaseIterator\n*L\n212#1:359\n212#1:360,3\n*E\n"})
    private static final class ConjunctionTwoPhaseIterator
    extends TwoPhaseIterator {
        @NotNull
        private final TwoPhaseIterator[] twoPhaseIterators;
        private final float matchCost;

        public ConjunctionTwoPhaseIterator(@NotNull DocIdSetIterator approximation2, @NotNull List<? extends TwoPhaseIterator> twoPhaseIterators) {
            Intrinsics.checkNotNullParameter((Object)approximation2, (String)"approximation");
            Intrinsics.checkNotNullParameter(twoPhaseIterators, (String)"twoPhaseIterators");
            super(approximation2);
            if (!(!((Collection)twoPhaseIterators).isEmpty())) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            CollectionUtil.INSTANCE.timSort(twoPhaseIterators, 1.INSTANCE);
            Collection $this$toTypedArray$iv = twoPhaseIterators;
            boolean $i$f$toTypedArray = false;
            Collection collection = $this$toTypedArray$iv;
            this.twoPhaseIterators = collection.toArray(new TwoPhaseIterator[0]);
            float totalMatchCost = 0.0f;
            for (TwoPhaseIterator twoPhaseIterator2 : twoPhaseIterators) {
                totalMatchCost += twoPhaseIterator2.matchCost();
            }
            this.matchCost = totalMatchCost;
        }

        @NotNull
        public final TwoPhaseIterator[] getTwoPhaseIterators() {
            return this.twoPhaseIterators;
        }

        @Override
        public boolean matches() throws IOException {
            for (TwoPhaseIterator twoPhaseIterator2 : this.twoPhaseIterators) {
                if (twoPhaseIterator2.matches()) continue;
                return false;
            }
            return true;
        }

        @Override
        public float matchCost() {
            return this.matchCost;
        }
    }
}

