/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.search.ConjunctionUtils;
import org.gnit.lucenekmp.search.DocIdSetIterator;
import org.gnit.lucenekmp.search.Scorable;
import org.gnit.lucenekmp.search.Scorer;
import org.gnit.lucenekmp.search.TwoPhaseIterator;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001%B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\bH\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u0015H\u0016J\u0010\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u0015H\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0019\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u000b\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R$\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u00178V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u0010\u00a8\u0006&"}, d2={"Lorg/gnit/lucenekmp/search/ConjunctionScorer;", "Lorg/gnit/lucenekmp/search/Scorer;", "required", "", "scorers", "<init>", "(Ljava/util/Collection;Ljava/util/Collection;)V", "disi", "Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "getDisi", "()Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "", "getScorers", "()[Lorg/gnit/lucenekmp/search/Scorer;", "[Lorg/gnit/lucenekmp/search/Scorer;", "getRequired", "()Ljava/util/Collection;", "twoPhaseIterator", "Lorg/gnit/lucenekmp/search/TwoPhaseIterator;", "iterator", "docID", "", "score", "", "getMaxScore", "upTo", "advanceShallow", "target", "minScore", "minCompetitiveScore", "getMinCompetitiveScore", "()F", "setMinCompetitiveScore", "(F)V", "children", "Lorg/gnit/lucenekmp/search/Scorable$ChildScorable;", "getChildren", "DocsAndFreqs", "core"})
@SourceDebugExtension(value={"SMAP\nConjunctionScorer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConjunctionScorer.kt\norg/gnit/lucenekmp/search/ConjunctionScorer\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,95:1\n37#2:96\n36#2,3:97\n*S KotlinDebug\n*F\n+ 1 ConjunctionScorer.kt\norg/gnit/lucenekmp/search/ConjunctionScorer\n*L\n18#1:96\n18#1:97,3\n*E\n"})
public final class ConjunctionScorer
extends Scorer {
    @NotNull
    private final DocIdSetIterator disi;
    @NotNull
    private final Scorer[] scorers;
    @NotNull
    private final Collection<Scorer> required;

    public ConjunctionScorer(@NotNull Collection<Scorer> required, @NotNull Collection<Scorer> scorers) {
        Intrinsics.checkNotNullParameter(required, (String)"required");
        Intrinsics.checkNotNullParameter(scorers, (String)"scorers");
        if (!required.containsAll(scorers)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.disi = ConjunctionUtils.INSTANCE.intersectScorers(required);
        Collection<Scorer> $this$toTypedArray$iv = scorers;
        boolean $i$f$toTypedArray = false;
        Collection<Scorer> thisCollection$iv = $this$toTypedArray$iv;
        this.scorers = thisCollection$iv.toArray(new Scorer[0]);
        this.required = required;
    }

    @NotNull
    public final DocIdSetIterator getDisi() {
        return this.disi;
    }

    @NotNull
    public final Scorer[] getScorers() {
        return this.scorers;
    }

    @NotNull
    public final Collection<Scorer> getRequired() {
        return this.required;
    }

    @Override
    @NotNull
    public TwoPhaseIterator twoPhaseIterator() {
        TwoPhaseIterator twoPhaseIterator2 = TwoPhaseIterator.Companion.unwrap(this.disi);
        Intrinsics.checkNotNull((Object)twoPhaseIterator2);
        return twoPhaseIterator2;
    }

    @Override
    @NotNull
    public DocIdSetIterator iterator() {
        return this.disi;
    }

    @Override
    public int docID() {
        return this.disi.docID();
    }

    @Override
    public float score() throws IOException {
        double sum = 0.0;
        for (Scorer scorer2 : this.scorers) {
            sum += (double)scorer2.score();
        }
        return (float)sum;
    }

    @Override
    public float getMaxScore(int upTo) throws IOException {
        double maxScore = 0.0;
        for (Scorer s : this.scorers) {
            if (s.docID() > upTo) continue;
            maxScore += (double)s.getMaxScore(upTo);
        }
        return (float)maxScore;
    }

    @Override
    public int advanceShallow(int target) throws IOException {
        if (this.scorers.length == 1) {
            return this.scorers[0].advanceShallow(target);
        }
        for (Scorer scorer2 : this.scorers) {
            scorer2.advanceShallow(target);
        }
        return super.advanceShallow(target);
    }

    @Override
    public float getMinCompetitiveScore() {
        return this.scorers.length == 1 ? this.scorers[0].getMinCompetitiveScore() : 0.0f;
    }

    @Override
    public void setMinCompetitiveScore(float minScore) {
        if (this.scorers.length == 1) {
            this.scorers[0].setMinCompetitiveScore(minScore);
        }
    }

    @Override
    @NotNull
    public Collection<Scorable.ChildScorable> getChildren() {
        ArrayList<Scorable.ChildScorable> children = new ArrayList<Scorable.ChildScorable>();
        for (Scorer scorer2 : this.required) {
            children.add(new Scorable.ChildScorable(scorer2, "MUST"));
        }
        return children;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lorg/gnit/lucenekmp/search/ConjunctionScorer$DocsAndFreqs;", "", "iterator", "Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "<init>", "(Lorg/gnit/lucenekmp/search/DocIdSetIterator;)V", "getIterator", "()Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "cost", "", "getCost", "()J", "doc", "", "getDoc", "()I", "setDoc", "(I)V", "core"})
    public static final class DocsAndFreqs {
        @NotNull
        private final DocIdSetIterator iterator;
        private final long cost;
        private int doc;

        public DocsAndFreqs(@NotNull DocIdSetIterator iterator2) {
            Intrinsics.checkNotNullParameter((Object)iterator2, (String)"iterator");
            this.iterator = iterator2;
            this.cost = this.iterator.cost();
            this.doc = -1;
        }

        @NotNull
        public final DocIdSetIterator getIterator() {
            return this.iterator;
        }

        public final long getCost() {
            return this.cost;
        }

        public final int getDoc() {
            return this.doc;
        }

        public final void setDoc(int n) {
            this.doc = n;
        }
    }
}

