/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.search;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.index.LeafReaderContext;
import org.gnit.lucenekmp.search.BooleanClause;
import org.gnit.lucenekmp.search.BooleanQuery;
import org.gnit.lucenekmp.search.BoostQuery;
import org.gnit.lucenekmp.search.BulkScorer;
import org.gnit.lucenekmp.search.ConstantScoreQuery;
import org.gnit.lucenekmp.search.ConstantScoreScorer;
import org.gnit.lucenekmp.search.ConstantScoreWeight;
import org.gnit.lucenekmp.search.FilterLeafCollector;
import org.gnit.lucenekmp.search.FilterScorable;
import org.gnit.lucenekmp.search.IndexSearcher;
import org.gnit.lucenekmp.search.LeafCollector;
import org.gnit.lucenekmp.search.MatchNoDocsQuery;
import org.gnit.lucenekmp.search.Matches;
import org.gnit.lucenekmp.search.Query;
import org.gnit.lucenekmp.search.QueryVisitor;
import org.gnit.lucenekmp.search.Scorable;
import org.gnit.lucenekmp.search.ScoreMode;
import org.gnit.lucenekmp.search.Scorer;
import org.gnit.lucenekmp.search.ScorerSupplier;
import org.gnit.lucenekmp.search.TwoPhaseIterator;
import org.gnit.lucenekmp.search.Weight;
import org.gnit.lucenekmp.util.Bits;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001:\u0001\u001eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0012\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0016H\u0016J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0096\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0016R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001f"}, d2={"Lorg/gnit/lucenekmp/search/ConstantScoreQuery;", "Lorg/gnit/lucenekmp/search/Query;", "query", "<init>", "(Lorg/gnit/lucenekmp/search/Query;)V", "getQuery", "()Lorg/gnit/lucenekmp/search/Query;", "rewrite", "indexSearcher", "Lorg/gnit/lucenekmp/search/IndexSearcher;", "visit", "", "visitor", "Lorg/gnit/lucenekmp/search/QueryVisitor;", "createWeight", "Lorg/gnit/lucenekmp/search/Weight;", "searcher", "scoreMode", "Lorg/gnit/lucenekmp/search/ScoreMode;", "boost", "", "toString", "", "field", "equals", "", "other", "", "hashCode", "", "ConstantBulkScorer", "core"})
public class ConstantScoreQuery
extends Query {
    @NotNull
    private final Query query;

    public ConstantScoreQuery(@NotNull Query query) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        this.query = query;
    }

    @NotNull
    public final Query getQuery() {
        return this.query;
    }

    @Override
    @NotNull
    public Query rewrite(@NotNull IndexSearcher indexSearcher) {
        Intrinsics.checkNotNullParameter((Object)indexSearcher, (String)"indexSearcher");
        Query rewritten = this.query.rewrite(indexSearcher);
        if (rewritten instanceof BoostQuery) {
            rewritten = ((BoostQuery)rewritten).getQuery();
        } else if (rewritten instanceof ConstantScoreQuery) {
            rewritten = ((ConstantScoreQuery)rewritten).query;
        } else if (rewritten instanceof BooleanQuery) {
            rewritten = ((BooleanQuery)rewritten).rewriteNoScoring();
        }
        if (rewritten.getClass() == MatchNoDocsQuery.class) {
            return rewritten;
        }
        if (rewritten != this.query) {
            return new ConstantScoreQuery(rewritten);
        }
        if (rewritten.getClass() == ConstantScoreQuery.class) {
            return rewritten;
        }
        if (rewritten.getClass() == BoostQuery.class) {
            Query query = rewritten;
            Intrinsics.checkNotNull((Object)query, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.search.BoostQuery");
            return new ConstantScoreQuery(((BoostQuery)query).getQuery());
        }
        return super.rewrite(indexSearcher);
    }

    @Override
    public void visit(@NotNull QueryVisitor visitor2) {
        Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
        this.query.visit(visitor2.getSubVisitor(BooleanClause.Occur.FILTER, this));
    }

    @Override
    @NotNull
    public Weight createWeight(@NotNull IndexSearcher searcher, @NotNull ScoreMode scoreMode, float boost) {
        Intrinsics.checkNotNullParameter((Object)searcher, (String)"searcher");
        Intrinsics.checkNotNullParameter((Object)((Object)scoreMode), (String)"scoreMode");
        ScoreMode innerScoreMode = null;
        innerScoreMode = scoreMode.isExhaustive() ? ScoreMode.COMPLETE_NO_SCORES : ScoreMode.TOP_DOCS;
        Weight innerWeight = searcher.createWeight(this.query, innerScoreMode, 1.0f);
        if (scoreMode.needsScores()) {
            return new ConstantScoreWeight(this, boost, innerWeight, scoreMode){
                final /* synthetic */ Weight $innerWeight;
                final /* synthetic */ ScoreMode $scoreMode;
                {
                    this.$innerWeight = $innerWeight;
                    this.$scoreMode = $scoreMode;
                    super($receiver, $boost);
                }

                public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
                    Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                    ScorerSupplier innerScorerSupplier = this.$innerWeight.scorerSupplier(context);
                    if (innerScorerSupplier == null) {
                        return null;
                    }
                    return new ScorerSupplier(innerScorerSupplier, this, this.$scoreMode, this.$innerWeight){
                        final /* synthetic */ ScorerSupplier $innerScorerSupplier;
                        final /* synthetic */ createWeight.1 this$0;
                        final /* synthetic */ ScoreMode $scoreMode;
                        final /* synthetic */ Weight $innerWeight;
                        {
                            this.$innerScorerSupplier = $innerScorerSupplier;
                            this.this$0 = $receiver;
                            this.$scoreMode = $scoreMode;
                            this.$innerWeight = $innerWeight;
                        }

                        public Scorer get(long leadCost) throws IOException {
                            Scorer innerScorer = this.$innerScorerSupplier.get(leadCost);
                            TwoPhaseIterator twoPhaseIterator2 = innerScorer.twoPhaseIterator();
                            if (twoPhaseIterator2 == null) {
                                return new ConstantScoreScorer(this.this$0.score(), this.$scoreMode, innerScorer.iterator());
                            }
                            return new ConstantScoreScorer(this.this$0.score(), this.$scoreMode, twoPhaseIterator2);
                        }

                        public BulkScorer bulkScorer() throws IOException {
                            if (!this.$scoreMode.isExhaustive()) {
                                return super.bulkScorer();
                            }
                            BulkScorer innerScorer = this.$innerScorerSupplier.bulkScorer();
                            if (innerScorer == null) {
                                return null;
                            }
                            return new ConstantBulkScorer(innerScorer, this.$innerWeight, this.this$0.score());
                        }

                        public long cost() {
                            return this.$innerScorerSupplier.cost();
                        }
                    };
                }

                public Matches matches(LeafReaderContext context, int doc) throws IOException {
                    Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                    return this.$innerWeight.matches(context, doc);
                }

                public boolean isCacheable(LeafReaderContext ctx) {
                    Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                    return this.$innerWeight.isCacheable(ctx);
                }

                public int count(LeafReaderContext context) throws IOException {
                    Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                    return this.$innerWeight.count(context);
                }
            };
        }
        return innerWeight;
    }

    @Override
    @NotNull
    public String toString(@Nullable String field) {
        return "ConstantScore(" + this.query.toString(field) + ")";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(@Nullable Object other) {
        if (!this.sameClassAs(other)) return false;
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.search.ConstantScoreQuery");
        if (!Intrinsics.areEqual((Object)this.query, (Object)((ConstantScoreQuery)other).query)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return 31 * this.classHash() + this.query.hashCode();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\b\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ*\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0010H\u0016J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0016R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lorg/gnit/lucenekmp/search/ConstantScoreQuery$ConstantBulkScorer;", "Lorg/gnit/lucenekmp/search/BulkScorer;", "bulkScorer", "weight", "Lorg/gnit/lucenekmp/search/Weight;", "theScore", "", "<init>", "(Lorg/gnit/lucenekmp/search/BulkScorer;Lorg/gnit/lucenekmp/search/Weight;F)V", "getBulkScorer", "()Lorg/gnit/lucenekmp/search/BulkScorer;", "getWeight", "()Lorg/gnit/lucenekmp/search/Weight;", "getTheScore", "()F", "score", "", "collector", "Lorg/gnit/lucenekmp/search/LeafCollector;", "acceptDocs", "Lorg/gnit/lucenekmp/util/Bits;", "min", "max", "wrapCollector", "cost", "", "core"})
    protected static final class ConstantBulkScorer
    extends BulkScorer {
        @NotNull
        private final BulkScorer bulkScorer;
        @NotNull
        private final Weight weight;
        private final float theScore;

        public ConstantBulkScorer(@NotNull BulkScorer bulkScorer, @NotNull Weight weight, float theScore) {
            Intrinsics.checkNotNullParameter((Object)bulkScorer, (String)"bulkScorer");
            Intrinsics.checkNotNullParameter((Object)weight, (String)"weight");
            this.bulkScorer = bulkScorer;
            this.weight = weight;
            this.theScore = theScore;
        }

        @NotNull
        public final BulkScorer getBulkScorer() {
            return this.bulkScorer;
        }

        @NotNull
        public final Weight getWeight() {
            return this.weight;
        }

        public final float getTheScore() {
            return this.theScore;
        }

        @Override
        public int score(@NotNull LeafCollector collector2, @Nullable Bits acceptDocs, int min, int max) throws IOException {
            Intrinsics.checkNotNullParameter((Object)collector2, (String)"collector");
            return this.bulkScorer.score(this.wrapCollector(collector2), acceptDocs, min, max);
        }

        private final LeafCollector wrapCollector(LeafCollector collector2) {
            return new FilterLeafCollector(collector2, this){
                final /* synthetic */ ConstantBulkScorer this$0;
                {
                    this.this$0 = $receiver;
                    super($collector);
                }

                public Scorable getScorer() {
                    throw new UnsupportedOperationException("Scorer should not be accessed in ConstantScoreQuery");
                }

                public void setScorer(Scorable scorer2) {
                    LeafCollector leafCollector = this.getIn();
                    Scorable scorable = scorer2;
                    Intrinsics.checkNotNull((Object)scorable);
                    Scorable scorable2 = scorable;
                    leafCollector.setScorer(new FilterScorable(this.this$0, scorable2){
                        final /* synthetic */ ConstantBulkScorer this$0;
                        {
                            this.this$0 = $receiver;
                            super($super_call_param$1);
                        }

                        public float score() {
                            return this.this$0.getTheScore();
                        }
                    });
                }
            };
        }

        @Override
        public long cost() {
            return this.bulkScorer.cost();
        }
    }
}

