/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.search;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.index.LeafReaderContext;
import org.gnit.lucenekmp.search.Explanation;
import org.gnit.lucenekmp.search.Query;
import org.gnit.lucenekmp.search.Scorer;
import org.gnit.lucenekmp.search.TwoPhaseIterator;
import org.gnit.lucenekmp.search.Weight;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b&\u0018\u00002\u00020\u0001B\u0019\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0004\u001a\u00020\u0005H\u0004J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/gnit/lucenekmp/search/ConstantScoreWeight;", "Lorg/gnit/lucenekmp/search/Weight;", "query", "Lorg/gnit/lucenekmp/search/Query;", "score", "", "<init>", "(Lorg/gnit/lucenekmp/search/Query;F)V", "explain", "Lorg/gnit/lucenekmp/search/Explanation;", "context", "Lorg/gnit/lucenekmp/index/LeafReaderContext;", "doc", "", "core"})
public abstract class ConstantScoreWeight
extends Weight {
    private final float score;

    protected ConstantScoreWeight(@NotNull Query query, float score2) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        super(query);
        this.score = score2;
    }

    protected final float score() {
        return this.score;
    }

    @Override
    @NotNull
    public Explanation explain(@NotNull LeafReaderContext context, int doc) throws IOException {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Scorer s = this.scorer(context);
        boolean exists = false;
        if (s == null) {
            exists = false;
        } else {
            TwoPhaseIterator twoPhase = s.twoPhaseIterator();
            if (twoPhase == null) {
                exists = s.iterator().advance(doc) == doc;
            } else {
                boolean bl = exists = twoPhase.approximation().advance(doc) == doc && twoPhase.matches();
            }
        }
        if (exists) {
            return Explanation.Companion.match((Number)Float.valueOf(this.score), this.getQuery() + (String)(this.score == 1.0f ? "" : "^" + this.score), new Explanation[0]);
        }
        return Explanation.Companion.noMatch(this.getQuery() + " doesn't match id " + doc, new Explanation[0]);
    }
}

