/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.LongCompanionObject;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.jdkport.LongExtKt;
import org.gnit.lucenekmp.search.BulkScorer;
import org.gnit.lucenekmp.search.CheckedIntConsumer;
import org.gnit.lucenekmp.search.DocIdSetIterator;
import org.gnit.lucenekmp.search.DocIdStream;
import org.gnit.lucenekmp.search.LeafCollector;
import org.gnit.lucenekmp.search.SimpleScorable;
import org.gnit.lucenekmp.util.Bits;
import org.gnit.lucenekmp.util.FixedBitSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\b\u0000\u0018\u0000 &2\u00020\u0001:\u0004#$%&B%\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ*\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u0006H\u0016J8\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u001f\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\u0006H\u0002J\b\u0010!\u001a\u00020\"H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0010\u001a\u00060\u0011R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0012\u001a\u00060\u0013R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0014\u001a\u00060\u0015R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/gnit/lucenekmp/search/DenseConjunctionBulkScorer;", "Lorg/gnit/lucenekmp/search/BulkScorer;", "iterators", "", "Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "maxDoc", "", "constantScore", "", "<init>", "(Ljava/util/List;IF)V", "scorable", "Lorg/gnit/lucenekmp/search/SimpleScorable;", "windowMatches", "Lorg/gnit/lucenekmp/util/FixedBitSet;", "clauseWindowMatches", "docIdStreamView", "Lorg/gnit/lucenekmp/search/DenseConjunctionBulkScorer$DocIdStreamView;", "rangeDocIdStream", "Lorg/gnit/lucenekmp/search/DenseConjunctionBulkScorer$RangeDocIdStream;", "singleIteratorDocIdStream", "Lorg/gnit/lucenekmp/search/DenseConjunctionBulkScorer$SingleIteratorDocIdStream;", "score", "collector", "Lorg/gnit/lucenekmp/search/LeafCollector;", "acceptDocs", "Lorg/gnit/lucenekmp/util/Bits;", "min", "max", "scoreWindowUsingBitSet", "", "windowBase", "windowMax", "cost", "", "DocIdStreamView", "RangeDocIdStream", "SingleIteratorDocIdStream", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nDenseConjunctionBulkScorer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DenseConjunctionBulkScorer.kt\norg/gnit/lucenekmp/search/DenseConjunctionBulkScorer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,285:1\n1011#2,2:286\n*S KotlinDebug\n*F\n+ 1 DenseConjunctionBulkScorer.kt\norg/gnit/lucenekmp/search/DenseConjunctionBulkScorer\n*L\n35#1:286,2\n*E\n"})
public final class DenseConjunctionBulkScorer
extends BulkScorer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int maxDoc;
    @NotNull
    private final List<DocIdSetIterator> iterators;
    @NotNull
    private final SimpleScorable scorable;
    @NotNull
    private final FixedBitSet windowMatches;
    @NotNull
    private final FixedBitSet clauseWindowMatches;
    @NotNull
    private final DocIdStreamView docIdStreamView;
    @NotNull
    private final RangeDocIdStream rangeDocIdStream;
    @NotNull
    private final SingleIteratorDocIdStream singleIteratorDocIdStream;
    public static final int WINDOW_SIZE = 4096;
    public static final int DENSITY_THRESHOLD_INVERSE = 32;

    public DenseConjunctionBulkScorer(@NotNull List<DocIdSetIterator> iterators, int maxDoc, float constantScore) {
        Intrinsics.checkNotNullParameter(iterators, (String)"iterators");
        this.windowMatches = new FixedBitSet(4096);
        this.clauseWindowMatches = new FixedBitSet(4096);
        this.docIdStreamView = new DocIdStreamView();
        this.rangeDocIdStream = new RangeDocIdStream();
        this.singleIteratorDocIdStream = new SingleIteratorDocIdStream();
        List iterators2 = iterators;
        this.maxDoc = maxDoc;
        List $this$sortBy$iv = iterators2 = (List)new ArrayList(iterators2);
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    DocIdSetIterator it = (DocIdSetIterator)a;
                    boolean bl = false;
                    Comparable comparable = Long.valueOf(it.cost());
                    it = (DocIdSetIterator)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.cost()));
                }
            });
        }
        this.iterators = iterators2;
        this.scorable = new SimpleScorable();
        this.scorable.setScore(constantScore);
    }

    @Override
    public int score(@NotNull LeafCollector collector2, @Nullable Bits acceptDocs, int min, int max) throws IOException {
        Intrinsics.checkNotNullParameter((Object)collector2, (String)"collector");
        int min2 = min;
        int max2 = max;
        collector2.setScorer(this.scorable);
        List iterators = this.iterators;
        if (collector2.competitiveIterator() != null) {
            iterators = new ArrayList(iterators);
            ArrayList arrayList = (ArrayList)iterators;
            DocIdSetIterator docIdSetIterator = collector2.competitiveIterator();
            Intrinsics.checkNotNull((Object)docIdSetIterator);
            arrayList.add(docIdSetIterator);
        }
        for (DocIdSetIterator it : iterators) {
            min2 = Math.max(min2, it.docID());
        }
        max2 = Math.min(max2, this.maxDoc);
        DocIdSetIterator lead = null;
        if (!iterators.isEmpty() && (lead = (DocIdSetIterator)iterators.get(0)).docID() < min2) {
            min2 = lead.advance(min2);
        }
        if (min2 >= max2) {
            return min2 >= this.maxDoc ? Integer.MAX_VALUE : min2;
        }
        int windowMax = min2;
        do {
            if (this.scorable.getMinCompetitiveScore() > this.scorable.getScore()) {
                return Integer.MAX_VALUE;
            }
            DocIdSetIterator docIdSetIterator = lead;
            int windowBase = docIdSetIterator != null ? docIdSetIterator.docID() : windowMax;
            windowMax = Math.min(max2, windowBase + 4096);
            if (windowMax <= windowBase) continue;
            this.scoreWindowUsingBitSet(collector2, acceptDocs, iterators, windowBase, windowMax);
        } while (windowMax < max2);
        DocIdSetIterator docIdSetIterator = lead;
        return docIdSetIterator != null ? docIdSetIterator.docID() : (windowMax >= this.maxDoc ? Integer.MAX_VALUE : windowMax);
    }

    private final void scoreWindowUsingBitSet(LeafCollector collector2, Bits acceptDocs, List<DocIdSetIterator> iterators, int windowBase, int windowMax) throws IOException {
        int i;
        int n;
        int upTo;
        if (!(windowMax > windowBase)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!this.windowMatches.scanIsEmpty()) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!this.clauseWindowMatches.scanIsEmpty()) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (acceptDocs == null) {
            if (iterators.isEmpty()) {
                this.rangeDocIdStream.setFrom(windowBase);
                this.rangeDocIdStream.setTo(windowMax);
                collector2.collect(this.rangeDocIdStream);
                return;
            }
            if (iterators.size() == 1) {
                this.singleIteratorDocIdStream.setIterator(iterators.get(0));
                this.singleIteratorDocIdStream.setFrom(windowBase);
                this.singleIteratorDocIdStream.setTo(windowMax);
                collector2.collect(this.singleIteratorDocIdStream);
                return;
            }
        }
        if (iterators.isEmpty()) {
            this.windowMatches.set(0, windowMax - windowBase);
        } else {
            DocIdSetIterator lead = iterators.get(0);
            lead.intoBitSet(windowMax, this.windowMatches, windowBase);
        }
        Bits bits = acceptDocs;
        if (bits != null) {
            bits.applyMask(this.windowMatches, windowBase);
        }
        int windowSize = windowMax - windowBase;
        int threshold = windowSize / 32;
        for (upTo = 1; upTo < iterators.size() && this.windowMatches.cardinality() >= threshold; ++upTo) {
            DocIdSetIterator other = iterators.get(upTo);
            if (other.docID() < windowBase) {
                other.advance(windowBase);
            }
            other.intoBitSet(windowMax, this.clauseWindowMatches, windowBase);
            this.windowMatches.and(this.clauseWindowMatches);
            this.clauseWindowMatches.clear();
        }
        if (upTo < iterators.size()) {
            int windowMatch = this.windowMatches.nextSetBit(0);
            block1: while (windowMatch != Integer.MAX_VALUE) {
                int doc = windowBase + windowMatch;
                n = iterators.size();
                for (i = upTo; i < n; ++i) {
                    DocIdSetIterator other = iterators.get(i);
                    int otherDoc = other.docID();
                    if (otherDoc < doc) {
                        otherDoc = other.advance(doc);
                    }
                    if (doc == otherDoc) continue;
                    int clearUpTo = Math.min(4096, otherDoc - windowBase);
                    this.windowMatches.clear(windowMatch, clearUpTo);
                    windowMatch = DenseConjunctionBulkScorer.Companion.advance(this.windowMatches, clearUpTo);
                    continue block1;
                }
                windowMatch = DenseConjunctionBulkScorer.Companion.advance(this.windowMatches, windowMatch + 1);
            }
        }
        this.docIdStreamView.setWindowBase(windowBase);
        collector2.collect(this.docIdStreamView);
        this.windowMatches.clear();
        if (iterators.size() >= 2) {
            DocIdSetIterator lead = iterators.get(0);
            int maxOtherDocID = -1;
            n = iterators.size();
            for (i = 1; i < n; ++i) {
                maxOtherDocID = Math.max(maxOtherDocID, iterators.get(i).docID());
            }
            if (lead.docID() < maxOtherDocID) {
                lead.advance(maxOtherDocID);
            }
        }
    }

    @Override
    public long cost() {
        return this.iterators.isEmpty() ? (long)this.maxDoc : this.iterators.get(0).cost();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/gnit/lucenekmp/search/DenseConjunctionBulkScorer$Companion;", "", "<init>", "()V", "WINDOW_SIZE", "", "DENSITY_THRESHOLD_INVERSE", "advance", "set", "Lorg/gnit/lucenekmp/util/FixedBitSet;", "i", "core"})
    public static final class Companion {
        private Companion() {
        }

        private final int advance(FixedBitSet set, int i) {
            return i >= 4096 ? Integer.MAX_VALUE : set.nextSetBit(i);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\n\u001a\u00020\u000b2\u0010\u0010\f\u001a\f\u0012\b\u0012\u00060\u000ej\u0002`\u000f0\rH\u0016J\b\u0010\u0010\u001a\u00020\u0005H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u0011"}, d2={"Lorg/gnit/lucenekmp/search/DenseConjunctionBulkScorer$DocIdStreamView;", "Lorg/gnit/lucenekmp/search/DocIdStream;", "<init>", "(Lorg/gnit/lucenekmp/search/DenseConjunctionBulkScorer;)V", "windowBase", "", "getWindowBase", "()I", "setWindowBase", "(I)V", "forEach", "", "consumer", "Lorg/gnit/lucenekmp/search/CheckedIntConsumer;", "Ljava/io/IOException;", "Lokio/IOException;", "count", "core"})
    public final class DocIdStreamView
    extends DocIdStream {
        private int windowBase;

        public final int getWindowBase() {
            return this.windowBase;
        }

        public final void setWindowBase(int n) {
            this.windowBase = n;
        }

        @Override
        public void forEach(@NotNull CheckedIntConsumer<IOException> consumer) throws IOException {
            Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
            int windowBase = this.windowBase;
            long[] bitArray = DenseConjunctionBulkScorer.this.windowMatches.getBits();
            int n = bitArray.length;
            for (int idx = 0; idx < n; ++idx) {
                int ntz;
                for (long bits = bitArray[idx]; bits != 0L; bits ^= 1L << ntz) {
                    ntz = LongExtKt.numberOfTrailingZeros(LongCompanionObject.INSTANCE, bits);
                    consumer.accept(windowBase + (idx << 6 | ntz));
                }
            }
        }

        @Override
        public int count() throws IOException {
            return DenseConjunctionBulkScorer.this.windowMatches.cardinality();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\r\u001a\u00020\u000e2\u0010\u0010\u000f\u001a\f\u0012\b\u0012\u00060\u0011j\u0002`\u00120\u0010H\u0016J\b\u0010\u0013\u001a\u00020\u0005H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\t\u00a8\u0006\u0014"}, d2={"Lorg/gnit/lucenekmp/search/DenseConjunctionBulkScorer$RangeDocIdStream;", "Lorg/gnit/lucenekmp/search/DocIdStream;", "<init>", "(Lorg/gnit/lucenekmp/search/DenseConjunctionBulkScorer;)V", "from", "", "getFrom", "()I", "setFrom", "(I)V", "to", "getTo", "setTo", "forEach", "", "consumer", "Lorg/gnit/lucenekmp/search/CheckedIntConsumer;", "Ljava/io/IOException;", "Lokio/IOException;", "count", "core"})
    public final class RangeDocIdStream
    extends DocIdStream {
        private int from;
        private int to;

        public final int getFrom() {
            return this.from;
        }

        public final void setFrom(int n) {
            this.from = n;
        }

        public final int getTo() {
            return this.to;
        }

        public final void setTo(int n) {
            this.to = n;
        }

        @Override
        public void forEach(@NotNull CheckedIntConsumer<IOException> consumer) throws IOException {
            Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
            int n = this.to;
            for (int i = this.from; i < n; ++i) {
                consumer.accept(i);
            }
        }

        @Override
        public int count() throws IOException {
            return this.to - this.from;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0013\u001a\u00020\u00142\u0010\u0010\u0015\u001a\f\u0012\b\u0012\u00060\u0017j\u0002`\u00180\u0016H\u0016J\b\u0010\u0019\u001a\u00020\u0005H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001a"}, d2={"Lorg/gnit/lucenekmp/search/DenseConjunctionBulkScorer$SingleIteratorDocIdStream;", "Lorg/gnit/lucenekmp/search/DocIdStream;", "<init>", "(Lorg/gnit/lucenekmp/search/DenseConjunctionBulkScorer;)V", "from", "", "getFrom", "()I", "setFrom", "(I)V", "to", "getTo", "setTo", "iterator", "Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "getIterator", "()Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "setIterator", "(Lorg/gnit/lucenekmp/search/DocIdSetIterator;)V", "forEach", "", "consumer", "Lorg/gnit/lucenekmp/search/CheckedIntConsumer;", "Ljava/io/IOException;", "Lokio/IOException;", "count", "core"})
    public final class SingleIteratorDocIdStream
    extends DocIdStream {
        private int from;
        private int to;
        @Nullable
        private DocIdSetIterator iterator;

        public final int getFrom() {
            return this.from;
        }

        public final void setFrom(int n) {
            this.from = n;
        }

        public final int getTo() {
            return this.to;
        }

        public final void setTo(int n) {
            this.to = n;
        }

        @Nullable
        public final DocIdSetIterator getIterator() {
            return this.iterator;
        }

        public final void setIterator(@Nullable DocIdSetIterator docIdSetIterator) {
            this.iterator = docIdSetIterator;
        }

        @Override
        public void forEach(@NotNull CheckedIntConsumer<IOException> consumer) throws IOException {
            Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
            DocIdSetIterator docIdSetIterator = this.iterator;
            Intrinsics.checkNotNull((Object)docIdSetIterator);
            if (docIdSetIterator.docID() < this.from) {
                DocIdSetIterator docIdSetIterator2 = this.iterator;
                Intrinsics.checkNotNull((Object)docIdSetIterator2);
                docIdSetIterator2.advance(this.from);
            }
            DocIdSetIterator docIdSetIterator3 = this.iterator;
            Intrinsics.checkNotNull((Object)docIdSetIterator3);
            int doc = docIdSetIterator3.docID();
            while (doc < this.to) {
                consumer.accept(doc);
                DocIdSetIterator docIdSetIterator4 = this.iterator;
                Intrinsics.checkNotNull((Object)docIdSetIterator4);
                doc = docIdSetIterator4.nextDoc();
            }
        }

        @Override
        public int count() throws IOException {
            if (!DenseConjunctionBulkScorer.this.windowMatches.scanIsEmpty()) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            DocIdSetIterator docIdSetIterator = this.iterator;
            Intrinsics.checkNotNull((Object)docIdSetIterator);
            docIdSetIterator.intoBitSet(this.to, DenseConjunctionBulkScorer.this.clauseWindowMatches, this.from);
            int count = DenseConjunctionBulkScorer.this.clauseWindowMatches.cardinality();
            DenseConjunctionBulkScorer.this.clauseWindowMatches.clear();
            return count;
        }
    }
}

