/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.search;

import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.jdkport.Arrays;
import org.gnit.lucenekmp.search.DisiPriorityQueue;
import org.gnit.lucenekmp.search.DisiWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010)\n\u0002\b\u0002\b\u0000\u0018\u0000 $2\u00020\u0001:\u0001$B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u0003H\u0016J\n\u0010\u000b\u001a\u0004\u0018\u00010\bH\u0016J\n\u0010\f\u001a\u0004\u0018\u00010\bH\u0016J\b\u0010\r\u001a\u00020\bH\u0016J\u001c\u0010\u000e\u001a\u00020\b2\b\u0010\u000f\u001a\u0004\u0018\u00010\b2\b\u0010\u0010\u001a\u0004\u0018\u00010\bH\u0002J5\u0010\r\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\b2\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00072\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0003H\u0002\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\bH\u0016J+\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u001bJ\n\u0010\u001c\u001a\u0004\u0018\u00010\bH\u0016J\b\u0010\u001d\u001a\u00020\bH\u0016J\u0010\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\bH\u0016J\b\u0010\u001f\u001a\u00020\u0017H\u0016J\u000e\u0010 \u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u0003J\u000e\u0010!\u001a\u00020\u00172\u0006\u0010\n\u001a\u00020\u0003J\u0011\u0010\"\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0#H\u0096\u0002R\u0018\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u000e\u0010\n\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/gnit/lucenekmp/search/DisiPriorityQueueN;", "Lorg/gnit/lucenekmp/search/DisiPriorityQueue;", "maxSize", "", "<init>", "(I)V", "heap", "", "Lorg/gnit/lucenekmp/search/DisiWrapper;", "[Lorg/gnit/lucenekmp/search/DisiWrapper;", "size", "top", "top2", "topList", "prepend", "w1", "w2", "list", "i", "(Lorg/gnit/lucenekmp/search/DisiWrapper;[Lorg/gnit/lucenekmp/search/DisiWrapper;II)Lorg/gnit/lucenekmp/search/DisiWrapper;", "add", "entry", "addAll", "", "entries", "offset", "len", "([Lorg/gnit/lucenekmp/search/DisiWrapper;II)V", "pop", "updateTop", "topReplacement", "clear", "upHeap", "downHeap", "iterator", "", "Companion", "core"})
public final class DisiPriorityQueueN
extends DisiPriorityQueue {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DisiWrapper[] heap;
    private int size;

    public DisiPriorityQueueN(int maxSize) {
        this.heap = new DisiWrapper[maxSize];
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    @Nullable
    public DisiWrapper top() {
        return this.heap[0];
    }

    @Override
    @Nullable
    public DisiWrapper top2() {
        switch (this.size()) {
            case 0: 
            case 1: {
                return null;
            }
            case 2: {
                return this.heap[1];
            }
        }
        DisiWrapper disiWrapper = this.heap[1];
        Intrinsics.checkNotNull((Object)disiWrapper);
        int n = disiWrapper.getDoc();
        DisiWrapper disiWrapper2 = this.heap[2];
        Intrinsics.checkNotNull((Object)disiWrapper2);
        if (n <= disiWrapper2.getDoc()) {
            return this.heap[1];
        }
        return this.heap[2];
    }

    @Override
    @NotNull
    public DisiWrapper topList() {
        DisiWrapper list;
        DisiWrapper[] heap = this.heap;
        int size2 = this.size;
        DisiWrapper disiWrapper = list = heap[0];
        Intrinsics.checkNotNull((Object)disiWrapper);
        disiWrapper.setNext(null);
        if (size2 >= 3) {
            list = this.topList(list, heap, size2, 1);
            list = this.topList(list, heap, size2, 2);
        } else if (size2 == 2) {
            DisiWrapper disiWrapper2 = heap[1];
            Intrinsics.checkNotNull((Object)disiWrapper2);
            if (disiWrapper2.getDoc() == list.getDoc()) {
                list = this.prepend(heap[1], list);
            }
        }
        return list;
    }

    private final DisiWrapper prepend(DisiWrapper w1, DisiWrapper w2) {
        DisiWrapper disiWrapper = w1;
        Intrinsics.checkNotNull((Object)disiWrapper);
        disiWrapper.setNext(w2);
        return w1;
    }

    private final DisiWrapper topList(DisiWrapper list, DisiWrapper[] heap, int size2, int i) {
        DisiWrapper w;
        DisiWrapper list2 = list;
        DisiWrapper disiWrapper = w = heap[i];
        Intrinsics.checkNotNull((Object)disiWrapper);
        if (disiWrapper.getDoc() == list2.getDoc()) {
            list2 = this.prepend(w, list2);
            int left = Companion.leftNode(i);
            int right = Companion.rightNode(left);
            if (right < size2) {
                list2 = this.topList(list2, heap, size2, left);
                list2 = this.topList(list2, heap, size2, right);
            } else if (left < size2) {
                DisiWrapper disiWrapper2 = heap[left];
                Intrinsics.checkNotNull((Object)disiWrapper2);
                if (disiWrapper2.getDoc() == list2.getDoc()) {
                    list2 = this.prepend(heap[left], list2);
                }
            }
        }
        return list2;
    }

    @Override
    @NotNull
    public DisiWrapper add(@NotNull DisiWrapper entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        DisiWrapper[] heap = this.heap;
        int size2 = this.size;
        heap[size2] = entry;
        this.upHeap(size2);
        this.size = size2 + 1;
        DisiWrapper disiWrapper = heap[0];
        Intrinsics.checkNotNull((Object)disiWrapper);
        return disiWrapper;
    }

    @Override
    public void addAll(@NotNull DisiWrapper[] entries2, int offset, int len) {
        Intrinsics.checkNotNullParameter((Object)entries2, (String)"entries");
        if (len == 0) {
            return;
        }
        if (this.size + len > this.heap.length) {
            throw new IndexOutOfBoundsException("Cannot add " + len + " elements to a queue with remaining capacity " + (this.heap.length - this.size));
        }
        ArraysKt.copyInto((Object[])entries2, (Object[])this.heap, (int)this.size, (int)offset, (int)(offset + len));
        this.size += len;
        int firstLeafIndex = this.size >>> 1;
        for (int rootIndex = firstLeafIndex - 1; -1 < rootIndex; --rootIndex) {
            DisiWrapper parent;
            int parentIndex = rootIndex;
            Intrinsics.checkNotNull((Object)this.heap[parentIndex]);
            while (parentIndex < firstLeafIndex) {
                DisiWrapper child;
                int childIndex = Companion.leftNode(parentIndex);
                int rightChildIndex = Companion.rightNode(childIndex);
                Intrinsics.checkNotNull((Object)this.heap[childIndex]);
                if (rightChildIndex < this.size) {
                    DisiWrapper disiWrapper = this.heap[rightChildIndex];
                    Intrinsics.checkNotNull((Object)disiWrapper);
                    if (disiWrapper.getDoc() < child.getDoc()) {
                        DisiWrapper disiWrapper2 = this.heap[rightChildIndex];
                        Intrinsics.checkNotNull((Object)disiWrapper2);
                        child = disiWrapper2;
                        childIndex = rightChildIndex;
                    }
                }
                if (child.getDoc() >= parent.getDoc()) break;
                this.heap[parentIndex] = child;
                parentIndex = childIndex;
            }
            this.heap[parentIndex] = parent;
        }
    }

    @Override
    @Nullable
    public DisiWrapper pop() {
        DisiWrapper[] heap = this.heap;
        DisiWrapper result = heap[0];
        this.size += -1;
        int i = this.size;
        heap[0] = heap[i];
        heap[i] = null;
        if (i > 0) {
            this.downHeap(i);
        }
        return result;
    }

    @Override
    @NotNull
    public DisiWrapper updateTop() {
        this.downHeap(this.size);
        DisiWrapper disiWrapper = this.heap[0];
        Intrinsics.checkNotNull((Object)disiWrapper);
        return disiWrapper;
    }

    @Override
    @NotNull
    public DisiWrapper updateTop(@NotNull DisiWrapper topReplacement) {
        Intrinsics.checkNotNullParameter((Object)topReplacement, (String)"topReplacement");
        this.heap[0] = topReplacement;
        return this.updateTop();
    }

    @Override
    public void clear() {
        Arrays.INSTANCE.fill(this.heap, null);
        this.size = 0;
    }

    public final void upHeap(int i) {
        int i2 = i;
        DisiWrapper disiWrapper = this.heap[i2];
        Intrinsics.checkNotNull((Object)disiWrapper);
        DisiWrapper node = disiWrapper;
        int nodeDoc = node.getDoc();
        int j = Companion.parentNode(i2);
        while (j >= 0) {
            DisiWrapper disiWrapper2 = this.heap[j];
            Intrinsics.checkNotNull((Object)disiWrapper2);
            if (nodeDoc >= disiWrapper2.getDoc()) break;
            this.heap[i2] = this.heap[j];
            i2 = j;
            j = Companion.parentNode(j);
        }
        this.heap[i2] = node;
    }

    public final void downHeap(int size2) {
        int i = 0;
        DisiWrapper disiWrapper = this.heap[0];
        Intrinsics.checkNotNull((Object)disiWrapper);
        DisiWrapper node = disiWrapper;
        int j = Companion.leftNode(i);
        if (j < size2) {
            int k = Companion.rightNode(j);
            if (k < size2) {
                DisiWrapper disiWrapper2 = this.heap[k];
                Intrinsics.checkNotNull((Object)disiWrapper2);
                int n = disiWrapper2.getDoc();
                DisiWrapper disiWrapper3 = this.heap[j];
                Intrinsics.checkNotNull((Object)disiWrapper3);
                if (n < disiWrapper3.getDoc()) {
                    j = k;
                }
            }
            DisiWrapper disiWrapper4 = this.heap[j];
            Intrinsics.checkNotNull((Object)disiWrapper4);
            if (disiWrapper4.getDoc() < node.getDoc()) {
                DisiWrapper disiWrapper5;
                do {
                    this.heap[i] = this.heap[j];
                    i = j;
                    k = Companion.rightNode(j = Companion.leftNode(i));
                    if (k < size2) {
                        DisiWrapper disiWrapper6 = this.heap[k];
                        Intrinsics.checkNotNull((Object)disiWrapper6);
                        int n = disiWrapper6.getDoc();
                        DisiWrapper disiWrapper7 = this.heap[j];
                        Intrinsics.checkNotNull((Object)disiWrapper7);
                        if (n < disiWrapper7.getDoc()) {
                            j = k;
                        }
                    }
                    if (j >= size2) break;
                    disiWrapper5 = this.heap[j];
                    Intrinsics.checkNotNull((Object)disiWrapper5);
                } while (disiWrapper5.getDoc() < node.getDoc());
                this.heap[i] = node;
            }
        }
    }

    @Override
    @NotNull
    public Iterator<DisiWrapper> iterator() {
        return ArraysKt.toMutableList((Object[])this.heap).subList(0, this.size).iterator();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005J\u000e\u0010\u0007\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005\u00a8\u0006\t"}, d2={"Lorg/gnit/lucenekmp/search/DisiPriorityQueueN$Companion;", "", "<init>", "()V", "leftNode", "", "node", "rightNode", "parentNode", "core"})
    public static final class Companion {
        private Companion() {
        }

        public final int leftNode(int node) {
            return (node + 1 << 1) - 1;
        }

        public final int rightNode(int leftNode) {
            return leftNode + 1;
        }

        public final int parentNode(int node) {
            return (node + 1 >>> 1) - 1;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

