/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.search;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.search.DocIdSetIterator;
import org.gnit.lucenekmp.search.Scorable;
import org.gnit.lucenekmp.search.Scorer;
import org.gnit.lucenekmp.search.ScorerUtil;
import org.gnit.lucenekmp.search.TwoPhaseIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\n\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001c\u0010$\u001a\u0004\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u001c\u0010)\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010\u000b\"\u0004\b+\u0010\rR\u0013\u0010,\u001a\u0004\u0018\u00010-\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u001a\u00100\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u0010\u0017\"\u0004\b2\u00103R\u001a\u00104\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u0010\u001b\"\u0004\b6\u0010\u001d\u00a8\u00067"}, d2={"Lorg/gnit/lucenekmp/search/DisiWrapper;", "", "scorer", "Lorg/gnit/lucenekmp/search/Scorer;", "impacts", "", "<init>", "(Lorg/gnit/lucenekmp/search/Scorer;Z)V", "iterator", "Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "getIterator", "()Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "setIterator", "(Lorg/gnit/lucenekmp/search/DocIdSetIterator;)V", "getScorer", "()Lorg/gnit/lucenekmp/search/Scorer;", "scorable", "Lorg/gnit/lucenekmp/search/Scorable;", "getScorable", "()Lorg/gnit/lucenekmp/search/Scorable;", "cost", "", "getCost", "()J", "matchCost", "", "getMatchCost", "()F", "setMatchCost", "(F)V", "doc", "", "getDoc", "()I", "setDoc", "(I)V", "next", "getNext", "()Lorg/gnit/lucenekmp/search/DisiWrapper;", "setNext", "(Lorg/gnit/lucenekmp/search/DisiWrapper;)V", "approximation", "getApproximation", "setApproximation", "twoPhaseView", "Lorg/gnit/lucenekmp/search/TwoPhaseIterator;", "getTwoPhaseView", "()Lorg/gnit/lucenekmp/search/TwoPhaseIterator;", "scaledMaxScore", "getScaledMaxScore", "setScaledMaxScore", "(J)V", "maxWindowScore", "getMaxWindowScore", "setMaxWindowScore", "core"})
public class DisiWrapper {
    @Nullable
    private DocIdSetIterator iterator;
    @NotNull
    private final Scorer scorer;
    @Nullable
    private final Scorable scorable;
    private final long cost;
    private float matchCost;
    private int doc;
    @Nullable
    private DisiWrapper next;
    @Nullable
    private DocIdSetIterator approximation;
    @Nullable
    private final TwoPhaseIterator twoPhaseView;
    private long scaledMaxScore;
    private float maxWindowScore;

    public DisiWrapper(@NotNull Scorer scorer2, boolean impacts2) {
        Intrinsics.checkNotNullParameter((Object)scorer2, (String)"scorer");
        this.scorer = scorer2;
        this.scorable = ScorerUtil.INSTANCE.likelyTermScorer(scorer2);
        this.iterator = impacts2 ? ScorerUtil.INSTANCE.likelyImpactsEnum(scorer2.iterator()) : scorer2.iterator();
        DocIdSetIterator docIdSetIterator = this.iterator;
        Intrinsics.checkNotNull((Object)docIdSetIterator);
        this.cost = docIdSetIterator.cost();
        this.doc = -1;
        this.twoPhaseView = scorer2.twoPhaseIterator();
        if (this.twoPhaseView != null) {
            this.approximation = this.twoPhaseView.approximation();
            this.matchCost = this.twoPhaseView.matchCost();
        } else {
            this.approximation = this.iterator;
            this.matchCost = 0.0f;
        }
    }

    @Nullable
    public final DocIdSetIterator getIterator() {
        return this.iterator;
    }

    public final void setIterator(@Nullable DocIdSetIterator docIdSetIterator) {
        this.iterator = docIdSetIterator;
    }

    @NotNull
    public final Scorer getScorer() {
        return this.scorer;
    }

    @Nullable
    public final Scorable getScorable() {
        return this.scorable;
    }

    public final long getCost() {
        return this.cost;
    }

    public final float getMatchCost() {
        return this.matchCost;
    }

    public final void setMatchCost(float f) {
        this.matchCost = f;
    }

    public final int getDoc() {
        return this.doc;
    }

    public final void setDoc(int n) {
        this.doc = n;
    }

    @Nullable
    public final DisiWrapper getNext() {
        return this.next;
    }

    public final void setNext(@Nullable DisiWrapper disiWrapper) {
        this.next = disiWrapper;
    }

    @Nullable
    public final DocIdSetIterator getApproximation() {
        return this.approximation;
    }

    public final void setApproximation(@Nullable DocIdSetIterator docIdSetIterator) {
        this.approximation = docIdSetIterator;
    }

    @Nullable
    public final TwoPhaseIterator getTwoPhaseView() {
        return this.twoPhaseView;
    }

    public final long getScaledMaxScore() {
        return this.scaledMaxScore;
    }

    public final void setScaledMaxScore(long l) {
        this.scaledMaxScore = l;
    }

    public final float getMaxWindowScore() {
        return this.maxWindowScore;
    }

    public final void setMaxWindowScore(float f) {
        this.maxWindowScore = f;
    }
}

