/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.search;

import java.io.IOException;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.jdkport.Arrays;
import org.gnit.lucenekmp.search.BulkScorer;
import org.gnit.lucenekmp.search.DocIdSetIterator;
import org.gnit.lucenekmp.search.DocIdStream;
import org.gnit.lucenekmp.search.LeafCollector;
import org.gnit.lucenekmp.search.Scorable;
import org.gnit.lucenekmp.search.SimpleScorable;
import org.gnit.lucenekmp.util.Bits;
import org.gnit.lucenekmp.util.FixedBitSet;
import org.gnit.lucenekmp.util.PriorityQueue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00192\u00020\u0001:\u0002\u0018\u0019B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J*\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u000fH\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/gnit/lucenekmp/search/DisjunctionMaxBulkScorer;", "Lorg/gnit/lucenekmp/search/BulkScorer;", "scorers", "", "<init>", "(Ljava/util/List;)V", "windowMatches", "Lorg/gnit/lucenekmp/util/FixedBitSet;", "windowScores", "", "Lorg/gnit/lucenekmp/util/PriorityQueue;", "Lorg/gnit/lucenekmp/search/DisjunctionMaxBulkScorer$BulkScorerAndNext;", "topLevelScorable", "Lorg/gnit/lucenekmp/search/SimpleScorable;", "score", "", "collector", "Lorg/gnit/lucenekmp/search/LeafCollector;", "acceptDocs", "Lorg/gnit/lucenekmp/util/Bits;", "min", "max", "cost", "", "BulkScorerAndNext", "Companion", "core"})
public final class DisjunctionMaxBulkScorer
extends BulkScorer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FixedBitSet windowMatches;
    @NotNull
    private final float[] windowScores;
    @NotNull
    private final PriorityQueue<BulkScorerAndNext> scorers;
    @NotNull
    private final SimpleScorable topLevelScorable;
    private static final int WINDOW_SIZE = 4096;

    public DisjunctionMaxBulkScorer(@NotNull List<BulkScorer> scorers) {
        Intrinsics.checkNotNullParameter(scorers, (String)"scorers");
        this.windowMatches = new FixedBitSet(4097);
        this.windowScores = new float[4096];
        this.topLevelScorable = new SimpleScorable();
        if (!(scorers.size() >= 2)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int n = scorers.size();
        this.scorers = new PriorityQueue<BulkScorerAndNext>(n){

            @Override
            public boolean lessThan(BulkScorerAndNext a, BulkScorerAndNext b) {
                Intrinsics.checkNotNullParameter((Object)a, (String)"a");
                Intrinsics.checkNotNullParameter((Object)b, (String)"b");
                return a.getNext() < b.getNext();
            }
        };
        for (BulkScorer scorer2 : scorers) {
            (this.scorers).add(new BulkScorerAndNext(scorer2));
        }
    }

    @Override
    public int score(@NotNull LeafCollector collector2, @Nullable Bits acceptDocs, int min, int max) throws IOException {
        Intrinsics.checkNotNullParameter((Object)collector2, (String)"collector");
        BulkScorerAndNext top = this.scorers.top();
        while (top.getNext() < max) {
            int windowMin = Math.max(top.getNext(), min);
            int windowMax = Math.min(max, windowMin + 4096);
            do {
                top.setNext(top.getScorer().score(new LeafCollector(this, windowMin){
                    private Scorable scorer;
                    final /* synthetic */ DisjunctionMaxBulkScorer this$0;
                    final /* synthetic */ int $windowMin;
                    {
                        this.this$0 = $receiver;
                        this.$windowMin = $windowMin;
                    }

                    public Scorable getScorer() {
                        return this.scorer;
                    }

                    public void setScorer(Scorable scorer2) {
                        this.scorer = scorer2;
                        if (!(DisjunctionMaxBulkScorer.access$getTopLevelScorable$p(this.this$0).getMinCompetitiveScore() == 0.0f)) {
                            Scorable scorable = scorer2;
                            Intrinsics.checkNotNull((Object)scorable);
                            scorable.setMinCompetitiveScore(DisjunctionMaxBulkScorer.access$getTopLevelScorable$p(this.this$0).getMinCompetitiveScore());
                        }
                    }

                    public void collect(int doc) throws IOException {
                        int delta = doc - this.$windowMin;
                        DisjunctionMaxBulkScorer.access$getWindowMatches$p(this.this$0).set(doc - this.$windowMin);
                        float[] fArray = DisjunctionMaxBulkScorer.access$getWindowScores$p(this.this$0);
                        float f = DisjunctionMaxBulkScorer.access$getWindowScores$p(this.this$0)[delta];
                        Scorable scorable = this.getScorer();
                        Intrinsics.checkNotNull((Object)scorable);
                        fArray[delta] = Math.max(f, scorable.score());
                    }

                    public void collect(DocIdStream stream) throws IOException {
                        LeafCollector.super.collect(stream);
                    }

                    public DocIdSetIterator competitiveIterator() throws IOException {
                        return LeafCollector.super.competitiveIterator();
                    }

                    public void finish() throws IOException {
                        LeafCollector.super.finish();
                    }
                }, acceptDocs, windowMin, windowMax));
            } while ((top = this.scorers.updateTop()).getNext() < windowMax);
            collector2.setScorer(this.topLevelScorable);
            int windowDoc = this.windowMatches.nextSetBit(0);
            while (windowDoc != Integer.MAX_VALUE) {
                int doc = windowMin + windowDoc;
                this.topLevelScorable.setScore(this.windowScores[windowDoc]);
                collector2.collect(doc);
                windowDoc = this.windowMatches.nextSetBit(windowDoc + 1);
            }
            this.windowMatches.clear();
            Arrays.INSTANCE.fill(this.windowScores, 0.0f);
        }
        return top.getNext();
    }

    @Override
    public long cost() {
        long cost = 0L;
        for (BulkScorerAndNext scorer2 : this.scorers) {
            cost += scorer2.getScorer().cost();
        }
        return cost;
    }

    public static final /* synthetic */ SimpleScorable access$getTopLevelScorable$p(DisjunctionMaxBulkScorer $this) {
        return $this.topLevelScorable;
    }

    public static final /* synthetic */ FixedBitSet access$getWindowMatches$p(DisjunctionMaxBulkScorer $this) {
        return $this.windowMatches;
    }

    public static final /* synthetic */ float[] access$getWindowScores$p(DisjunctionMaxBulkScorer $this) {
        return $this.windowScores;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/gnit/lucenekmp/search/DisjunctionMaxBulkScorer$BulkScorerAndNext;", "", "scorer", "Lorg/gnit/lucenekmp/search/BulkScorer;", "<init>", "(Lorg/gnit/lucenekmp/search/BulkScorer;)V", "getScorer", "()Lorg/gnit/lucenekmp/search/BulkScorer;", "next", "", "getNext", "()I", "setNext", "(I)V", "core"})
    private static final class BulkScorerAndNext {
        @NotNull
        private final BulkScorer scorer;
        private int next;

        public BulkScorerAndNext(@NotNull BulkScorer scorer2) {
            Intrinsics.checkNotNullParameter((Object)scorer2, (String)"scorer");
            this.scorer = scorer2;
        }

        @NotNull
        public final BulkScorer getScorer() {
            return this.scorer;
        }

        public final int getNext() {
            return this.next;
        }

        public final void setNext(int n) {
            this.next = n;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/gnit/lucenekmp/search/DisjunctionMaxBulkScorer$Companion;", "", "<init>", "()V", "WINDOW_SIZE", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

