/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.search;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.search.DisiWrapper;
import org.gnit.lucenekmp.search.DisjunctionScoreBlockBoundaryPropagator;
import org.gnit.lucenekmp.search.DisjunctionScorer;
import org.gnit.lucenekmp.search.Scorable;
import org.gnit.lucenekmp.search.ScoreMode;
import org.gnit.lucenekmp.search.Scorer;
import org.gnit.lucenekmp.util.MathUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0012\u0010\u000f\u001a\u00020\u00032\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0014J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0016J\u0010\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0013H\u0016J\u0015\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0003H\u0007\u00a2\u0006\u0002\b\u001aR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/gnit/lucenekmp/search/DisjunctionMaxScorer;", "Lorg/gnit/lucenekmp/search/DisjunctionScorer;", "tieBreakerMultiplier", "", "subScorers", "", "Lorg/gnit/lucenekmp/search/Scorer;", "scoreMode", "Lorg/gnit/lucenekmp/search/ScoreMode;", "leadCost", "", "<init>", "(FLjava/util/List;Lorg/gnit/lucenekmp/search/ScoreMode;J)V", "disjunctionBlockPropagator", "Lorg/gnit/lucenekmp/search/DisjunctionScoreBlockBoundaryPropagator;", "score", "topList", "Lorg/gnit/lucenekmp/search/DisiWrapper;", "advanceShallow", "", "target", "getMaxScore", "upTo", "setMinCompetitiveScore", "", "minScore", "setMinCompetitiveScoreKt", "core"})
@SourceDebugExtension(value={"SMAP\nDisjunctionMaxScorer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DisjunctionMaxScorer.kt\norg/gnit/lucenekmp/search/DisjunctionMaxScorer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,108:1\n1#2:109\n*E\n"})
public final class DisjunctionMaxScorer
extends DisjunctionScorer {
    private final float tieBreakerMultiplier;
    @NotNull
    private final List<Scorer> subScorers;
    @Nullable
    private DisjunctionScoreBlockBoundaryPropagator disjunctionBlockPropagator;

    public DisjunctionMaxScorer(float tieBreakerMultiplier, @NotNull List<Scorer> subScorers, @Nullable ScoreMode scoreMode, long leadCost) {
        Intrinsics.checkNotNullParameter(subScorers, (String)"subScorers");
        super(subScorers, scoreMode, leadCost);
        this.tieBreakerMultiplier = tieBreakerMultiplier;
        this.subScorers = subScorers;
        if (!(!(this.tieBreakerMultiplier < 0.0f) && !(this.tieBreakerMultiplier > 1.0f))) {
            boolean bl = false;
            String string = "tieBreakerMultiplier must be in [0, 1]";
            throw new IllegalArgumentException(string.toString());
        }
        this.disjunctionBlockPropagator = scoreMode == ScoreMode.TOP_SCORES ? new DisjunctionScoreBlockBoundaryPropagator((Collection<Scorer>)this.subScorers) : null;
    }

    @Override
    protected float score(@Nullable DisiWrapper topList) throws IOException {
        float scoreMax = 0.0f;
        double otherScoreSum = 0.0;
        for (DisiWrapper w = topList; w != null; w = w.getNext()) {
            Scorable scorable = w.getScorable();
            Intrinsics.checkNotNull((Object)scorable);
            float subScore = scorable.score();
            if (subScore >= scoreMax) {
                otherScoreSum += (double)scoreMax;
                scoreMax = subScore;
                continue;
            }
            otherScoreSum += (double)subScore;
        }
        return (float)((double)scoreMax + otherScoreSum * (double)this.tieBreakerMultiplier);
    }

    @Override
    public int advanceShallow(int target) throws IOException {
        if (this.disjunctionBlockPropagator != null) {
            DisjunctionScoreBlockBoundaryPropagator disjunctionScoreBlockBoundaryPropagator = this.disjunctionBlockPropagator;
            Intrinsics.checkNotNull((Object)disjunctionScoreBlockBoundaryPropagator);
            return disjunctionScoreBlockBoundaryPropagator.advanceShallow(target);
        }
        return super.advanceShallow(target);
    }

    @Override
    public float getMaxScore(int upTo) throws IOException {
        float scoreMax = 0.0f;
        double otherScoreSum = 0.0;
        for (Scorer scorer2 : this.subScorers) {
            if (scorer2.docID() > upTo) continue;
            float subScore = scorer2.getMaxScore(upTo);
            if (subScore >= scoreMax) {
                otherScoreSum += (double)scoreMax;
                scoreMax = subScore;
                continue;
            }
            otherScoreSum += (double)subScore;
        }
        if (this.tieBreakerMultiplier == 0.0f) {
            return scoreMax;
        }
        return (float)((double)scoreMax + (otherScoreSum *= 1.0 + (double)2 * MathUtil.INSTANCE.sumRelativeErrorBound(this.subScorers.size() - 1)) * (double)this.tieBreakerMultiplier);
    }

    @JvmName(name="setMinCompetitiveScoreKt")
    public final void setMinCompetitiveScoreKt(float minScore) throws IOException {
        if (this.disjunctionBlockPropagator != null) {
            DisjunctionScoreBlockBoundaryPropagator disjunctionScoreBlockBoundaryPropagator = this.disjunctionBlockPropagator;
            Intrinsics.checkNotNull((Object)disjunctionScoreBlockBoundaryPropagator);
            disjunctionScoreBlockBoundaryPropagator.setMinCompetitiveScore(minScore);
        }
        if (this.tieBreakerMultiplier == 0.0f) {
            for (Scorer scorer2 : this.subScorers) {
                scorer2.setMinCompetitiveScore(minScore);
            }
        }
    }
}

