/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.search.DisiWrapper;
import org.gnit.lucenekmp.search.DisjunctionDISIApproximation;
import org.gnit.lucenekmp.search.DocIdSetIterator;
import org.gnit.lucenekmp.search.Scorable;
import org.gnit.lucenekmp.search.ScoreMode;
import org.gnit.lucenekmp.search.Scorer;
import org.gnit.lucenekmp.search.TwoPhaseIterator;
import org.gnit.lucenekmp.util.PriorityQueue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0004\b \u0018\u00002\u00020\u0001:\u0001#B)\b\u0004\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u000bH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u0012\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0018H$R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0018\u00010\u0011R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0017\u001a\u0004\u0018\u00010\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006$"}, d2={"Lorg/gnit/lucenekmp/search/DisjunctionScorer;", "Lorg/gnit/lucenekmp/search/Scorer;", "subScorers", "", "scoreMode", "Lorg/gnit/lucenekmp/search/ScoreMode;", "leadCost", "", "<init>", "(Ljava/util/List;Lorg/gnit/lucenekmp/search/ScoreMode;J)V", "numClauses", "", "needsScores", "", "approximation", "Lorg/gnit/lucenekmp/search/DisjunctionDISIApproximation;", "twoPhase", "Lorg/gnit/lucenekmp/search/DisjunctionScorer$TwoPhase;", "iterator", "Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "twoPhaseIterator", "Lorg/gnit/lucenekmp/search/TwoPhaseIterator;", "docID", "subMatches", "Lorg/gnit/lucenekmp/search/DisiWrapper;", "getSubMatches", "()Lorg/gnit/lucenekmp/search/DisiWrapper;", "score", "", "topList", "children", "", "Lorg/gnit/lucenekmp/search/Scorable$ChildScorable;", "getChildren", "()Ljava/util/Collection;", "TwoPhase", "core"})
@SourceDebugExtension(value={"SMAP\nDisjunctionScorer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DisjunctionScorer.kt\norg/gnit/lucenekmp/search/DisjunctionScorer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,165:1\n1#2:166\n*E\n"})
public abstract class DisjunctionScorer
extends Scorer {
    private final int numClauses;
    private final boolean needsScores;
    @NotNull
    private final DisjunctionDISIApproximation approximation;
    @Nullable
    private TwoPhase twoPhase;

    protected DisjunctionScorer(@NotNull List<Scorer> subScorers, @Nullable ScoreMode scoreMode, long leadCost) {
        Intrinsics.checkNotNullParameter(subScorers, (String)"subScorers");
        if (!(subScorers.size() > 1)) {
            boolean $i$a$-require-DisjunctionScorer$22 = false;
            String $i$a$-require-DisjunctionScorer$22 = "There must be at least 2 subScorers";
            throw new IllegalArgumentException($i$a$-require-DisjunctionScorer$22.toString());
        }
        this.numClauses = subScorers.size();
        this.needsScores = scoreMode != ScoreMode.COMPLETE_NO_SCORES;
        boolean hasApproximation = false;
        float sumMatchCost = 0.0f;
        long sumApproxCost = 0L;
        List wrappers = new ArrayList();
        for (Scorer scorer2 : subScorers) {
            DisiWrapper w = new DisiWrapper(scorer2, false);
            long costWeight = w.getCost() <= 1L ? 1L : w.getCost();
            sumApproxCost += costWeight;
            if (w.getTwoPhaseView() != null) {
                hasApproximation = true;
                sumMatchCost += w.getMatchCost() * (float)costWeight;
            }
            wrappers.add(w);
        }
        this.approximation = new DisjunctionDISIApproximation(wrappers, leadCost);
        if (!hasApproximation) {
            this.twoPhase = null;
        } else {
            float matchCost = sumMatchCost / (float)sumApproxCost;
            this.twoPhase = new TwoPhase(this.approximation, matchCost);
        }
    }

    @Override
    @NotNull
    public DocIdSetIterator iterator() {
        if (this.twoPhase != null) {
            TwoPhase twoPhase = this.twoPhase;
            Intrinsics.checkNotNull((Object)twoPhase);
            return TwoPhaseIterator.Companion.asDocIdSetIterator(twoPhase);
        }
        return this.approximation;
    }

    @Override
    @Nullable
    public TwoPhaseIterator twoPhaseIterator() {
        return this.twoPhase;
    }

    @Override
    public int docID() {
        return this.approximation.docID();
    }

    @Nullable
    public final DisiWrapper getSubMatches() {
        if (this.twoPhase == null) {
            return this.approximation.topList();
        }
        TwoPhase twoPhase = this.twoPhase;
        Intrinsics.checkNotNull((Object)twoPhase);
        return twoPhase.getSubMatches();
    }

    @Override
    public float score() throws IOException {
        return this.score(this.getSubMatches());
    }

    protected abstract float score(@Nullable DisiWrapper var1) throws IOException;

    @Override
    @NotNull
    public Collection<Scorable.ChildScorable> getChildren() {
        ArrayList<Scorable.ChildScorable> children = new ArrayList<Scorable.ChildScorable>();
        for (DisiWrapper scorer2 = this.getSubMatches(); scorer2 != null; scorer2 = scorer2.getNext()) {
            children.add(new Scorable.ChildScorable(scorer2.getScorer(), "SHOULD"));
        }
        return children;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0004\u001a\u00020\u0005H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0012\u001a\u0004\u0018\u00010\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/gnit/lucenekmp/search/DisjunctionScorer$TwoPhase;", "Lorg/gnit/lucenekmp/search/TwoPhaseIterator;", "approximation", "Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "matchCost", "", "<init>", "(Lorg/gnit/lucenekmp/search/DisjunctionScorer;Lorg/gnit/lucenekmp/search/DocIdSetIterator;F)V", "verifiedMatches", "Lorg/gnit/lucenekmp/search/DisiWrapper;", "getVerifiedMatches", "()Lorg/gnit/lucenekmp/search/DisiWrapper;", "setVerifiedMatches", "(Lorg/gnit/lucenekmp/search/DisiWrapper;)V", "unverifiedMatches", "Lorg/gnit/lucenekmp/util/PriorityQueue;", "getUnverifiedMatches", "()Lorg/gnit/lucenekmp/util/PriorityQueue;", "subMatches", "getSubMatches", "matches", "", "core"})
    private final class TwoPhase
    extends TwoPhaseIterator {
        private final float matchCost;
        @Nullable
        private DisiWrapper verifiedMatches;
        @NotNull
        private final PriorityQueue<DisiWrapper> unverifiedMatches;

        public TwoPhase(DocIdSetIterator approximation2, float matchCost) {
            DocIdSetIterator docIdSetIterator = approximation2;
            Intrinsics.checkNotNull((Object)docIdSetIterator);
            super(docIdSetIterator);
            this.matchCost = matchCost;
            int n = DisjunctionScorer.this.numClauses;
            this.unverifiedMatches = new PriorityQueue<DisiWrapper>(n){

                public boolean lessThan(DisiWrapper a, DisiWrapper b) {
                    Intrinsics.checkNotNullParameter((Object)a, (String)"a");
                    Intrinsics.checkNotNullParameter((Object)b, (String)"b");
                    return a.getMatchCost() < b.getMatchCost();
                }
            };
        }

        @Nullable
        public final DisiWrapper getVerifiedMatches() {
            return this.verifiedMatches;
        }

        public final void setVerifiedMatches(@Nullable DisiWrapper disiWrapper) {
            this.verifiedMatches = disiWrapper;
        }

        @NotNull
        public final PriorityQueue<DisiWrapper> getUnverifiedMatches() {
            return this.unverifiedMatches;
        }

        @Nullable
        public final DisiWrapper getSubMatches() {
            for (DisiWrapper w : this.unverifiedMatches) {
                TwoPhaseIterator twoPhaseIterator2 = w.getTwoPhaseView();
                Intrinsics.checkNotNull((Object)twoPhaseIterator2);
                if (!twoPhaseIterator2.matches()) continue;
                w.setNext(this.verifiedMatches);
                this.verifiedMatches = w;
            }
            this.unverifiedMatches.clear();
            return this.verifiedMatches;
        }

        @Override
        public boolean matches() throws IOException {
            this.verifiedMatches = null;
            this.unverifiedMatches.clear();
            DisiWrapper w = DisjunctionScorer.this.approximation.topList();
            while (w != null) {
                DisiWrapper next = w.getNext();
                if (w.getTwoPhaseView() == null) {
                    w.setNext(this.verifiedMatches);
                    this.verifiedMatches = w;
                    if (!DisjunctionScorer.this.needsScores) {
                        return true;
                    }
                } else {
                    this.unverifiedMatches.add(w);
                }
                w = next;
            }
            if (this.verifiedMatches != null) {
                return true;
            }
            while (this.unverifiedMatches.size() > 0) {
                DisiWrapper w2;
                Intrinsics.checkNotNull((Object)this.unverifiedMatches.pop());
                TwoPhaseIterator twoPhaseIterator2 = w2.getTwoPhaseView();
                Intrinsics.checkNotNull((Object)twoPhaseIterator2);
                if (!twoPhaseIterator2.matches()) continue;
                w2.setNext(null);
                this.verifiedMatches = w2;
                return true;
            }
            return false;
        }

        @Override
        public float matchCost() {
            return this.matchCost;
        }
    }
}

