/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.search;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.util.FixedBitSet;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H&J\b\u0010\u0006\u001a\u00020\u0005H&J\u0010\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005H&J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005H\u0004J\b\u0010\n\u001a\u00020\u000bH&J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0005H\u0016\u00a8\u0006\u0013"}, d2={"Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "", "<init>", "()V", "docID", "", "nextDoc", "advance", "target", "slowAdvance", "cost", "", "intoBitSet", "", "upTo", "bitSet", "Lorg/gnit/lucenekmp/util/FixedBitSet;", "offset", "Companion", "core"})
public abstract class DocIdSetIterator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int NO_MORE_DOCS = Integer.MAX_VALUE;

    public abstract int docID();

    public abstract int nextDoc() throws IOException;

    public abstract int advance(int var1) throws IOException;

    protected final int slowAdvance(int target) throws IOException {
        if (!(this.docID() < target)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int doc = 0;
        while ((doc = this.nextDoc()) < target) {
        }
        return doc;
    }

    public abstract long cost();

    public void intoBitSet(int upTo, @NotNull FixedBitSet bitSet, int offset) throws IOException {
        Intrinsics.checkNotNullParameter((Object)bitSet, (String)"bitSet");
        if (!(offset <= this.docID())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int doc = this.docID();
        while (doc < upTo) {
            bitSet.set(doc - offset);
            doc = this.nextDoc();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u000e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u000b\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/gnit/lucenekmp/search/DocIdSetIterator$Companion;", "", "<init>", "()V", "empty", "Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "all", "maxDoc", "", "range", "minDoc", "NO_MORE_DOCS", "core"})
    @SourceDebugExtension(value={"SMAP\nDocIdSetIterator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocIdSetIterator.kt\norg/gnit/lucenekmp/search/DocIdSetIterator$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,241:1\n1#2:242\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DocIdSetIterator empty() {
            return new DocIdSetIterator(){
                private boolean exhausted;

                public final boolean getExhausted() {
                    return this.exhausted;
                }

                public final void setExhausted(boolean bl) {
                    this.exhausted = bl;
                }

                public int advance(int target) {
                    if (!(!this.exhausted)) {
                        String string = "Failed requirement.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    if (!(target >= 0)) {
                        String string = "Failed requirement.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.exhausted = true;
                    return Integer.MAX_VALUE;
                }

                public int docID() {
                    return this.exhausted ? Integer.MAX_VALUE : -1;
                }

                public int nextDoc() {
                    if (!(!this.exhausted)) {
                        String string = "Failed requirement.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.exhausted = true;
                    return Integer.MAX_VALUE;
                }

                public long cost() {
                    return 0L;
                }
            };
        }

        @NotNull
        public final DocIdSetIterator all(int maxDoc) {
            return new DocIdSetIterator(maxDoc){
                private int doc;
                final /* synthetic */ int $maxDoc;
                {
                    this.$maxDoc = $maxDoc;
                    this.doc = -1;
                }

                public final int getDoc() {
                    return this.doc;
                }

                public final void setDoc(int n) {
                    this.doc = n;
                }

                public int docID() {
                    return this.doc;
                }

                public int nextDoc() {
                    return this.advance(this.doc + 1);
                }

                public int advance(int target) {
                    this.doc = target;
                    if (this.doc >= this.$maxDoc) {
                        this.doc = Integer.MAX_VALUE;
                    }
                    return this.doc;
                }

                public long cost() {
                    return this.$maxDoc;
                }

                public void intoBitSet(int upTo, FixedBitSet bitSet, int offset) {
                    Intrinsics.checkNotNullParameter((Object)bitSet, (String)"bitSet");
                    int upTo2 = upTo;
                    if (!(offset <= this.doc)) {
                        String string = "Failed requirement.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    if ((upTo2 = Math.min(upTo2, this.$maxDoc)) > this.doc) {
                        bitSet.set(this.doc - offset, upTo2 - offset);
                        this.advance(upTo2);
                    }
                }
            };
        }

        @NotNull
        public final DocIdSetIterator range(int minDoc, int maxDoc) {
            if (!(minDoc < maxDoc)) {
                boolean $i$a$-require-DocIdSetIterator$Companion$range$32 = false;
                String $i$a$-require-DocIdSetIterator$Companion$range$32 = "minDoc must be < maxDoc but got minDoc=" + minDoc + " maxDoc=" + maxDoc;
                throw new IllegalArgumentException($i$a$-require-DocIdSetIterator$Companion$range$32.toString());
            }
            if (!(minDoc >= 0)) {
                boolean bl = false;
                String string = "minDoc must be >= 0 but got minDoc=" + minDoc;
                throw new IllegalArgumentException(string.toString());
            }
            return new DocIdSetIterator(minDoc, maxDoc){
                private int doc;
                final /* synthetic */ int $minDoc;
                final /* synthetic */ int $maxDoc;
                {
                    this.$minDoc = $minDoc;
                    this.$maxDoc = $maxDoc;
                    this.doc = -1;
                }

                public int docID() {
                    return this.doc;
                }

                public int nextDoc() {
                    return this.advance(this.doc + 1);
                }

                public int advance(int target) {
                    this.doc = target < this.$minDoc ? this.$minDoc : (target >= this.$maxDoc ? Integer.MAX_VALUE : target);
                    return this.doc;
                }

                public long cost() {
                    return this.$maxDoc - this.$minDoc;
                }

                public void intoBitSet(int upTo, FixedBitSet bitSet, int offset) {
                    Intrinsics.checkNotNullParameter((Object)bitSet, (String)"bitSet");
                    int upTo2 = upTo;
                    if (!(offset <= this.doc)) {
                        String string = "Failed requirement.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    if ((upTo2 = Math.min(upTo2, this.$maxDoc)) > this.doc) {
                        bitSet.set(this.doc - offset, upTo2 - offset);
                        this.advance(upTo2);
                    }
                }
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

