/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.search;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.index.DocValuesSkipper;
import org.gnit.lucenekmp.search.DocIdSetIterator;
import org.gnit.lucenekmp.search.TwoPhaseIterator;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0004\u0013\u0014\u0015\u0016B/\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0010\u001a\u00020\tH\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0017"}, d2={"Lorg/gnit/lucenekmp/search/DocValuesRangeIterator;", "Lorg/gnit/lucenekmp/search/TwoPhaseIterator;", "innerTwoPhase", "skipper", "Lorg/gnit/lucenekmp/index/DocValuesSkipper;", "lowerValue", "", "upperValue", "queryRangeHasGaps", "", "<init>", "(Lorg/gnit/lucenekmp/search/TwoPhaseIterator;Lorg/gnit/lucenekmp/index/DocValuesSkipper;JJZ)V", "approximation", "Lorg/gnit/lucenekmp/search/DocValuesRangeIterator$Approximation;", "getApproximation", "()Lorg/gnit/lucenekmp/search/DocValuesRangeIterator$Approximation;", "matches", "matchCost", "", "Match", "Approximation", "RangeNoGapsApproximation", "RangeWithGapsApproximation", "core"})
public final class DocValuesRangeIterator
extends TwoPhaseIterator {
    @NotNull
    private final TwoPhaseIterator innerTwoPhase;
    @NotNull
    private final Approximation approximation;

    public DocValuesRangeIterator(@NotNull TwoPhaseIterator innerTwoPhase, @NotNull DocValuesSkipper skipper, long lowerValue, long upperValue, boolean queryRangeHasGaps) {
        Intrinsics.checkNotNullParameter((Object)innerTwoPhase, (String)"innerTwoPhase");
        Intrinsics.checkNotNullParameter((Object)skipper, (String)"skipper");
        super(queryRangeHasGaps ? (Approximation)new RangeWithGapsApproximation(innerTwoPhase.approximation(), skipper, lowerValue, upperValue) : (Approximation)new RangeNoGapsApproximation(innerTwoPhase.approximation(), skipper, lowerValue, upperValue));
        this.innerTwoPhase = innerTwoPhase;
        DocIdSetIterator docIdSetIterator = this.approximation();
        Intrinsics.checkNotNull((Object)docIdSetIterator, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.search.DocValuesRangeIterator.Approximation");
        this.approximation = (Approximation)docIdSetIterator;
    }

    @Override
    @NotNull
    public Approximation getApproximation() {
        return this.approximation;
    }

    @Override
    public boolean matches() throws IOException {
        return switch (WhenMappings.$EnumSwitchMapping$0[this.getApproximation().getMatch().ordinal()]) {
            case 1 -> true;
            case 2 -> true;
            case 3 -> this.innerTwoPhase.matches();
            case 4 -> throw new IllegalStateException("Unpositioned approximation");
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Override
    public float matchCost() {
        return this.innerTwoPhase.matchCost();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\b&\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u001c\u001a\u00020\u0010H\u0016J\b\u0010\u001d\u001a\u00020\u0010H\u0016J\u0010\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u0010H\u0016J\b\u0010 \u001a\u00020\u0006H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010!\u001a\u00020\u0010H$R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0007\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006\""}, d2={"Lorg/gnit/lucenekmp/search/DocValuesRangeIterator$Approximation;", "Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "innerApproximation", "skipper", "Lorg/gnit/lucenekmp/index/DocValuesSkipper;", "lowerValue", "", "upperValue", "<init>", "(Lorg/gnit/lucenekmp/search/DocIdSetIterator;Lorg/gnit/lucenekmp/index/DocValuesSkipper;JJ)V", "getSkipper", "()Lorg/gnit/lucenekmp/index/DocValuesSkipper;", "getLowerValue", "()J", "getUpperValue", "doc", "", "match", "Lorg/gnit/lucenekmp/search/DocValuesRangeIterator$Match;", "getMatch", "()Lorg/gnit/lucenekmp/search/DocValuesRangeIterator$Match;", "setMatch", "(Lorg/gnit/lucenekmp/search/DocValuesRangeIterator$Match;)V", "upTo", "getUpTo", "()I", "setUpTo", "(I)V", "docID", "nextDoc", "advance", "target", "cost", "level", "core"})
    @SourceDebugExtension(value={"SMAP\nDocValuesRangeIterator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocValuesRangeIterator.kt\norg/gnit/lucenekmp/search/DocValuesRangeIterator$Approximation\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,187:1\n1#2:188\n*E\n"})
    public static abstract class Approximation
    extends DocIdSetIterator {
        @NotNull
        private final DocIdSetIterator innerApproximation;
        @NotNull
        private final DocValuesSkipper skipper;
        private final long lowerValue;
        private final long upperValue;
        private int doc;
        @NotNull
        private Match match;
        private int upTo;

        public Approximation(@NotNull DocIdSetIterator innerApproximation, @NotNull DocValuesSkipper skipper, long lowerValue, long upperValue) {
            Intrinsics.checkNotNullParameter((Object)innerApproximation, (String)"innerApproximation");
            Intrinsics.checkNotNullParameter((Object)skipper, (String)"skipper");
            this.innerApproximation = innerApproximation;
            this.doc = -1;
            this.match = Match.MAYBE;
            this.upTo = -1;
            this.skipper = skipper;
            this.lowerValue = lowerValue;
            this.upperValue = upperValue;
        }

        @NotNull
        protected final DocValuesSkipper getSkipper() {
            return this.skipper;
        }

        protected final long getLowerValue() {
            return this.lowerValue;
        }

        protected final long getUpperValue() {
            return this.upperValue;
        }

        @NotNull
        public final Match getMatch() {
            return this.match;
        }

        public final void setMatch(@NotNull Match match) {
            Intrinsics.checkNotNullParameter((Object)((Object)match), (String)"<set-?>");
            this.match = match;
        }

        public final int getUpTo() {
            return this.upTo;
        }

        public final void setUpTo(int n) {
            this.upTo = n;
        }

        @Override
        public int docID() {
            return this.doc;
        }

        @Override
        public int nextDoc() throws IOException {
            return this.advance(this.docID() + 1);
        }

        @Override
        public int advance(int target) throws IOException {
            int target2 = target;
            block5: while (true) {
                if (target2 > this.upTo) {
                    this.skipper.advance(target2);
                    target2 = Math.max(target2, this.skipper.minDocID(0));
                    if (target2 == Integer.MAX_VALUE) {
                        int n;
                        int it = n = Integer.MAX_VALUE;
                        boolean bl = false;
                        this.doc = it;
                        return n;
                    }
                    this.upTo = this.skipper.maxDocID(0);
                    this.match = this.match(0);
                    for (int nextLevel = 1; this.match != Match.MAYBE && nextLevel < this.skipper.numLevels() && this.match == this.match(nextLevel); ++nextLevel) {
                        this.upTo = this.skipper.maxDocID(nextLevel);
                    }
                }
                switch (WhenMappings.$EnumSwitchMapping$0[this.match.ordinal()]) {
                    case 1: {
                        int n;
                        int it = n = target2;
                        boolean bl = false;
                        this.doc = it;
                        return n;
                    }
                    case 2: 
                    case 3: {
                        int n;
                        if (target2 > this.innerApproximation.docID()) {
                            target2 = this.innerApproximation.advance(target2);
                        }
                        if (target2 > this.upTo) continue block5;
                        int it = n = target2;
                        boolean bl = false;
                        this.doc = it;
                        return n;
                    }
                    case 4: {
                        if (this.upTo == Integer.MAX_VALUE) {
                            int n;
                            int it = n = Integer.MAX_VALUE;
                            boolean bl = false;
                            this.doc = it;
                            return n;
                        }
                        target2 = this.upTo + 1;
                        continue block5;
                    }
                }
                break;
            }
            throw new NoWhenBranchMatchedException();
        }

        @Override
        public long cost() {
            return this.innerApproximation.cost();
        }

        @NotNull
        protected abstract Match match(int var1);

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Match.values().length];
                try {
                    nArray[Match.YES.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Match.MAYBE.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Match.IF_DOC_HAS_VALUE.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Match.NO.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lorg/gnit/lucenekmp/search/DocValuesRangeIterator$Match;", "", "<init>", "(Ljava/lang/String;I)V", "NO", "MAYBE", "IF_DOC_HAS_VALUE", "YES", "core"})
    public static final class Match
    extends Enum<Match> {
        public static final /* enum */ Match NO = new Match();
        public static final /* enum */ Match MAYBE = new Match();
        public static final /* enum */ Match IF_DOC_HAS_VALUE = new Match();
        public static final /* enum */ Match YES = new Match();
        private static final /* synthetic */ Match[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Match[] values() {
            return (Match[])$VALUES.clone();
        }

        public static Match valueOf(String value) {
            return Enum.valueOf(Match.class, value);
        }

        @NotNull
        public static EnumEntries<Match> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = matchArray = new Match[]{Match.NO, Match.MAYBE, Match.IF_DOC_HAS_VALUE, Match.YES};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014\u00a8\u0006\u000f"}, d2={"Lorg/gnit/lucenekmp/search/DocValuesRangeIterator$RangeNoGapsApproximation;", "Lorg/gnit/lucenekmp/search/DocValuesRangeIterator$Approximation;", "innerApproximation", "Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "skipper", "Lorg/gnit/lucenekmp/index/DocValuesSkipper;", "lowerValue", "", "upperValue", "<init>", "(Lorg/gnit/lucenekmp/search/DocIdSetIterator;Lorg/gnit/lucenekmp/index/DocValuesSkipper;JJ)V", "match", "Lorg/gnit/lucenekmp/search/DocValuesRangeIterator$Match;", "level", "", "core"})
    private static final class RangeNoGapsApproximation
    extends Approximation {
        public RangeNoGapsApproximation(@NotNull DocIdSetIterator innerApproximation, @NotNull DocValuesSkipper skipper, long lowerValue, long upperValue) {
            Intrinsics.checkNotNullParameter((Object)innerApproximation, (String)"innerApproximation");
            Intrinsics.checkNotNullParameter((Object)skipper, (String)"skipper");
            super(innerApproximation, skipper, lowerValue, upperValue);
        }

        @Override
        @NotNull
        protected Match match(int level) {
            long minValue = this.getSkipper().minValue(level);
            long maxValue = this.getSkipper().maxValue(level);
            if (minValue > this.getUpperValue() || maxValue < this.getLowerValue()) {
                return Match.NO;
            }
            if (minValue >= this.getLowerValue() && maxValue <= this.getUpperValue()) {
                if (this.getSkipper().docCount(level) == this.getSkipper().maxDocID(level) - this.getSkipper().minDocID(level) + 1) {
                    return Match.YES;
                }
                return Match.IF_DOC_HAS_VALUE;
            }
            return Match.MAYBE;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014\u00a8\u0006\u000f"}, d2={"Lorg/gnit/lucenekmp/search/DocValuesRangeIterator$RangeWithGapsApproximation;", "Lorg/gnit/lucenekmp/search/DocValuesRangeIterator$Approximation;", "innerApproximation", "Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "skipper", "Lorg/gnit/lucenekmp/index/DocValuesSkipper;", "lowerValue", "", "upperValue", "<init>", "(Lorg/gnit/lucenekmp/search/DocIdSetIterator;Lorg/gnit/lucenekmp/index/DocValuesSkipper;JJ)V", "match", "Lorg/gnit/lucenekmp/search/DocValuesRangeIterator$Match;", "level", "", "core"})
    private static final class RangeWithGapsApproximation
    extends Approximation {
        public RangeWithGapsApproximation(@NotNull DocIdSetIterator innerApproximation, @NotNull DocValuesSkipper skipper, long lowerValue, long upperValue) {
            Intrinsics.checkNotNullParameter((Object)innerApproximation, (String)"innerApproximation");
            Intrinsics.checkNotNullParameter((Object)skipper, (String)"skipper");
            super(innerApproximation, skipper, lowerValue, upperValue);
        }

        @Override
        @NotNull
        protected Match match(int level) {
            long minValue = this.getSkipper().minValue(level);
            long maxValue = this.getSkipper().maxValue(level);
            if (minValue > this.getUpperValue() || maxValue < this.getLowerValue()) {
                return Match.NO;
            }
            return Match.MAYBE;
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Match.values().length];
            try {
                nArray[Match.YES.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Match.IF_DOC_HAS_VALUE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Match.MAYBE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Match.NO.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

