/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.jdkport.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001f\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB/\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00000\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0011\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00000\u0015\u00a2\u0006\u0002\u0010\u0016J\b\u0010\u0017\u001a\u00020\u0007H\u0016J\u0010\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0013\u0010\u001a\u001a\u00020\u00032\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u001c\u001a\u00020\u0019H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00000\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0010\u00a8\u0006\u001e"}, d2={"Lorg/gnit/lucenekmp/search/Explanation;", "", "isMatch", "", "value", "", "description", "", "details", "", "<init>", "(ZLjava/lang/Number;Ljava/lang/String;Ljava/util/Collection;)V", "()Z", "getValue", "()Ljava/lang/Number;", "getDescription", "()Ljava/lang/String;", "", "summary", "getSummary", "getDetails", "", "()[Lorg/gnit/lucenekmp/search/Explanation;", "toString", "depth", "", "equals", "o", "hashCode", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nExplanation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Explanation.kt\norg/gnit/lucenekmp/search/Explanation\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,107:1\n37#2:108\n36#2,3:109\n*S KotlinDebug\n*F\n+ 1 Explanation.kt\norg/gnit/lucenekmp/search/Explanation\n*L\n34#1:108\n34#1:109,3\n*E\n"})
public final class Explanation {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean isMatch;
    @NotNull
    private final Number value;
    @NotNull
    private final String description;
    @NotNull
    private final List<Explanation> details;

    private Explanation(boolean isMatch, Number value, String description, Collection<Explanation> details) {
        this.isMatch = isMatch;
        Number number = value;
        if (number == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        this.value = number;
        String string = description;
        if (string == null) {
            String string2 = "Required value was null.";
            throw new IllegalArgumentException(string2.toString());
        }
        this.description = string;
        this.details = new ArrayList<Explanation>(details);
        for (Explanation detail : details) {
            if (detail != null) continue;
            String string3 = "Required value was null.";
            throw new IllegalArgumentException(string3.toString());
        }
    }

    public final boolean isMatch() {
        return this.isMatch;
    }

    @NotNull
    public final Number getValue() {
        return this.value;
    }

    @NotNull
    public final String getDescription() {
        return this.description;
    }

    private final String getSummary() {
        return this.value + " = " + this.description;
    }

    @NotNull
    public final Explanation[] getDetails() {
        Collection $this$toTypedArray$iv = this.details;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new Explanation[0]);
    }

    @NotNull
    public String toString() {
        return this.toString(0);
    }

    private final String toString(int depth) {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < depth; ++i) {
            buffer.append("  ");
        }
        buffer.append(this.getSummary());
        buffer.append("\n");
        for (Explanation explanation : this.getDetails()) {
            Intrinsics.checkNotNull((Object)explanation);
            buffer.append(explanation.toString(depth + 1));
        }
        String string = buffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Explanation that = (Explanation)o;
        return this.isMatch == that.isMatch && Intrinsics.areEqual((Object)this.value, (Object)that.value) && Intrinsics.areEqual((Object)this.description, (Object)that.description) && Intrinsics.areEqual(this.details, that.details);
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.isMatch, this.value, this.description, this.details};
        return Objects.INSTANCE.hash(objectArray);
    }

    public /* synthetic */ Explanation(boolean isMatch, Number value, String description, Collection details, DefaultConstructorMarker $constructor_marker) {
        this(isMatch, value, description, details);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001f\n\u0002\u0010\u0011\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bJ/\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\f\"\u00020\u0005\u00a2\u0006\u0002\u0010\rJ\u001c\u0010\u000e\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bJ'\u0010\u000e\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\f\"\u00020\u0005\u00a2\u0006\u0002\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/gnit/lucenekmp/search/Explanation$Companion;", "", "<init>", "()V", "match", "Lorg/gnit/lucenekmp/search/Explanation;", "value", "", "description", "", "details", "", "", "(Ljava/lang/Number;Ljava/lang/String;[Lorg/gnit/lucenekmp/search/Explanation;)Lorg/gnit/lucenekmp/search/Explanation;", "noMatch", "(Ljava/lang/String;[Lorg/gnit/lucenekmp/search/Explanation;)Lorg/gnit/lucenekmp/search/Explanation;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Explanation match(@NotNull Number value, @NotNull String description, @NotNull Collection<Explanation> details) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            Intrinsics.checkNotNullParameter(details, (String)"details");
            return new Explanation(true, value, description, details, null);
        }

        @NotNull
        public final Explanation match(@NotNull Number value, @NotNull String description, Explanation ... details) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            Intrinsics.checkNotNullParameter((Object)details, (String)"details");
            return new Explanation(true, value, description, CollectionsKt.mutableListOf((Object[])Arrays.copyOf(details, details.length)), null);
        }

        @NotNull
        public final Explanation noMatch(@NotNull String description, @NotNull Collection<Explanation> details) {
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            Intrinsics.checkNotNullParameter(details, (String)"details");
            return new Explanation(false, Float.valueOf(0.0f), description, details, null);
        }

        @NotNull
        public final Explanation noMatch(@NotNull String description, Explanation ... details) {
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            Intrinsics.checkNotNullParameter((Object)details, (String)"details");
            return new Explanation(false, Float.valueOf(0.0f), description, CollectionsKt.mutableListOf((Object[])Arrays.copyOf(details, details.length)), null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

