/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.search;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.index.BinaryDocValues;
import org.gnit.lucenekmp.index.DocValues;
import org.gnit.lucenekmp.index.LeafReaderContext;
import org.gnit.lucenekmp.jdkport.FloatExtKt;
import org.gnit.lucenekmp.search.DocIdSetIterator;
import org.gnit.lucenekmp.search.LeafFieldComparator;
import org.gnit.lucenekmp.search.Scorable;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.BytesRefBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0002\u0019\u001aB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H&J\u0015\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\fJ\u0015\u0010\u000b\u001a\u00028\u00002\u0006\u0010\r\u001a\u00020\u0006H&\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H&J\u001d\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00028\u00002\u0006\u0010\u0015\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0016J\b\u0010\u0017\u001a\u00020\nH\u0016J\b\u0010\u0018\u001a\u00020\nH\u0016\u00a8\u0006\u001b"}, d2={"Lorg/gnit/lucenekmp/search/FieldComparator;", "T", "", "<init>", "()V", "compare", "", "slot1", "slot2", "setTopValue", "", "value", "(Ljava/lang/Object;)V", "slot", "(I)Ljava/lang/Object;", "getLeafComparator", "Lorg/gnit/lucenekmp/search/LeafFieldComparator;", "context", "Lorg/gnit/lucenekmp/index/LeafReaderContext;", "compareValues", "first", "second", "(Ljava/lang/Object;Ljava/lang/Object;)I", "setSingleSort", "disableSkipping", "RelevanceComparator", "TermValComparator", "core"})
public abstract class FieldComparator<T> {
    public abstract int compare(int var1, int var2);

    public abstract void setTopValue(T var1);

    public abstract T value(int var1);

    @NotNull
    public abstract LeafFieldComparator getLeafComparator(@NotNull LeafReaderContext var1) throws IOException;

    public int compareValues(T first, T second) {
        if (first == null) {
            if (second == null) {
                return 0;
            }
            return -1;
        }
        if (second == null) {
            return 1;
        }
        return ((Comparable)first).compareTo(second);
    }

    public void setSingleSort() {
    }

    public void disableSkipping() {
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005H\u0016J\u0010\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0005H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0005H\u0016J\u0010\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u0005H\u0016J\u0010\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u0002H\u0016J\u0010\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0015\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010\u001dJ\u0018\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u00022\u0006\u0010 \u001a\u00020\u0002H\u0016J\u0010\u0010!\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0005H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/gnit/lucenekmp/search/FieldComparator$RelevanceComparator;", "Lorg/gnit/lucenekmp/search/FieldComparator;", "", "Lorg/gnit/lucenekmp/search/LeafFieldComparator;", "numHits", "", "<init>", "(I)V", "scores", "", "bottom", "scorer", "Lorg/gnit/lucenekmp/search/Scorable;", "topValue", "compare", "slot1", "slot2", "compareBottom", "doc", "copy", "", "slot", "getLeafComparator", "context", "Lorg/gnit/lucenekmp/index/LeafReaderContext;", "setBottom", "setTopValue", "value", "setScorer", "(I)Ljava/lang/Float;", "compareValues", "first", "second", "compareTop", "core"})
    public static final class RelevanceComparator
    extends FieldComparator<Float>
    implements LeafFieldComparator {
        @NotNull
        private final float[] scores;
        private float bottom;
        private Scorable scorer;
        private float topValue;

        public RelevanceComparator(int numHits) {
            this.scores = new float[numHits];
        }

        @Override
        public int compare(int slot1, int slot2) {
            return FloatExtKt.compare(FloatCompanionObject.INSTANCE, this.scores[slot2], this.scores[slot1]);
        }

        @Override
        public int compareBottom(int doc) throws IOException {
            float score2;
            Scorable scorable = this.scorer;
            if (scorable == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"scorer");
                scorable = null;
            }
            if (!(!FloatExtKt.isNaN(FloatCompanionObject.INSTANCE, score2 = scorable.score()))) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            return FloatExtKt.compare(FloatCompanionObject.INSTANCE, score2, this.bottom);
        }

        @Override
        public void copy(int slot, int doc) throws IOException {
            Scorable scorable = this.scorer;
            if (scorable == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"scorer");
                scorable = null;
            }
            this.scores[slot] = scorable.score();
            if (!(!FloatExtKt.isNaN(FloatCompanionObject.INSTANCE, this.scores[slot]))) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
        }

        @Override
        @NotNull
        public LeafFieldComparator getLeafComparator(@NotNull LeafReaderContext context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return this;
        }

        @Override
        public void setBottom(int bottom) {
            this.bottom = this.scores[bottom];
        }

        @Override
        public void setTopValue(float value) {
            this.topValue = value;
        }

        @Override
        public void setScorer(@NotNull Scorable scorer2) {
            Intrinsics.checkNotNullParameter((Object)scorer2, (String)"scorer");
            this.scorer = scorer2;
        }

        @Override
        @NotNull
        public Float value(int slot) {
            return Float.valueOf(this.scores[slot]);
        }

        @Override
        public int compareValues(float first, float second) {
            return Float.compare(second, first);
        }

        @Override
        public int compareTop(int doc) throws IOException {
            float docValue;
            Scorable scorable = this.scorer;
            if (scorable == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"scorer");
                scorable = null;
            }
            if (!(!FloatExtKt.isNaN(FloatCompanionObject.INSTANCE, docValue = scorable.score()))) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            return FloatExtKt.compare(FloatCompanionObject.INSTANCE, docValue, this.topValue);
        }

        @Override
        @Nullable
        public DocIdSetIterator competitiveIterator() throws IOException {
            return LeafFieldComparator.super.competitiveIterator();
        }

        @Override
        public void setHitsThresholdReached() throws IOException {
            LeafFieldComparator.super.setHitsThresholdReached();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0018\u001a\u00020\u0005H\u0002J\u0018\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0005H\u0016J\u0010\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0005H\u0016J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0005H\u0016J\u0018\u0010 \u001a\u00020\u00132\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0006\u001a\u00020\u0007H\u0004J\u0010\u0010#\u001a\u00020\u00032\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010$\u001a\u00020\u001e2\u0006\u0010\u0014\u001a\u00020\u0005H\u0016J\u0010\u0010%\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020\u0002H\u0016J\u0010\u0010&\u001a\u00020\u00022\u0006\u0010\u001f\u001a\u00020\u0005H\u0016J\u0018\u0010'\u001a\u00020\u00052\u0006\u0010(\u001a\u00020\u00022\u0006\u0010)\u001a\u00020\u0002H\u0016J\u0010\u0010*\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0005H\u0016J\u0010\u0010+\u001a\u00020\u001e2\u0006\u0010,\u001a\u00020-H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u0018\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lorg/gnit/lucenekmp/search/FieldComparator$TermValComparator;", "Lorg/gnit/lucenekmp/search/FieldComparator;", "Lorg/gnit/lucenekmp/util/BytesRef;", "Lorg/gnit/lucenekmp/search/LeafFieldComparator;", "numHits", "", "field", "", "sortMissingLast", "", "<init>", "(ILjava/lang/String;Z)V", "values", "", "[Lorg/gnit/lucenekmp/util/BytesRef;", "tempBRs", "Lorg/gnit/lucenekmp/util/BytesRefBuilder;", "[Lorg/gnit/lucenekmp/util/BytesRefBuilder;", "docTerms", "Lorg/gnit/lucenekmp/index/BinaryDocValues;", "bottom", "topValue", "missingSortCmp", "getValueForDoc", "doc", "compare", "slot1", "slot2", "compareBottom", "copy", "", "slot", "getBinaryDocValues", "context", "Lorg/gnit/lucenekmp/index/LeafReaderContext;", "getLeafComparator", "setBottom", "setTopValue", "value", "compareValues", "val1", "val2", "compareTop", "setScorer", "scorer", "Lorg/gnit/lucenekmp/search/Scorable;", "core"})
    public static final class TermValComparator
    extends FieldComparator<BytesRef>
    implements LeafFieldComparator {
        @NotNull
        private final String field;
        @NotNull
        private final BytesRef[] values;
        @NotNull
        private final BytesRefBuilder[] tempBRs;
        @Nullable
        private BinaryDocValues docTerms;
        @Nullable
        private BytesRef bottom;
        @Nullable
        private BytesRef topValue;
        private final int missingSortCmp;

        public TermValComparator(int numHits, @NotNull String field, boolean sortMissingLast) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            this.field = field;
            this.values = new BytesRef[numHits];
            this.tempBRs = new BytesRefBuilder[numHits];
            this.missingSortCmp = sortMissingLast ? 1 : -1;
        }

        private final BytesRef getValueForDoc(int doc) throws IOException {
            BinaryDocValues binaryDocValues = this.docTerms;
            Intrinsics.checkNotNull((Object)binaryDocValues);
            if (binaryDocValues.advanceExact(doc)) {
                BinaryDocValues binaryDocValues2 = this.docTerms;
                Intrinsics.checkNotNull((Object)binaryDocValues2);
                return binaryDocValues2.binaryValue();
            }
            return null;
        }

        @Override
        public int compare(int slot1, int slot2) {
            BytesRef bytesRef = this.values[slot1];
            Intrinsics.checkNotNull((Object)bytesRef);
            BytesRef val1 = bytesRef;
            BytesRef bytesRef2 = this.values[slot2];
            Intrinsics.checkNotNull((Object)bytesRef2);
            BytesRef val2 = bytesRef2;
            return this.compareValues(val1, val2);
        }

        @Override
        public int compareBottom(int doc) throws IOException {
            BytesRef comparableBytes = this.getValueForDoc(doc);
            return ComparisonsKt.compareValues((Comparable)this.bottom, (Comparable)comparableBytes);
        }

        @Override
        public void copy(int slot, int doc) throws IOException {
            BytesRef comparableBytes = this.getValueForDoc(doc);
            if (comparableBytes == null) {
                this.values[slot] = null;
            } else {
                if (this.tempBRs[slot] == null) {
                    this.tempBRs[slot] = new BytesRefBuilder();
                }
                BytesRefBuilder bytesRefBuilder = this.tempBRs[slot];
                Intrinsics.checkNotNull((Object)bytesRefBuilder);
                bytesRefBuilder.copyBytes(comparableBytes);
                BytesRefBuilder bytesRefBuilder2 = this.tempBRs[slot];
                Intrinsics.checkNotNull((Object)bytesRefBuilder2);
                this.values[slot] = bytesRefBuilder2.get();
            }
        }

        @NotNull
        protected final BinaryDocValues getBinaryDocValues(@NotNull LeafReaderContext context, @NotNull String field) throws IOException {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            return DocValues.INSTANCE.getBinary(context.reader(), field);
        }

        @Override
        @NotNull
        public LeafFieldComparator getLeafComparator(@NotNull LeafReaderContext context) throws IOException {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            this.docTerms = this.getBinaryDocValues(context, this.field);
            return this;
        }

        @Override
        public void setBottom(int bottom) {
            BytesRef bytesRef = this.values[bottom];
            Intrinsics.checkNotNull((Object)bytesRef);
            this.bottom = bytesRef;
        }

        @Override
        public void setTopValue(@NotNull BytesRef value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.topValue = value;
        }

        @Override
        @NotNull
        public BytesRef value(int slot) {
            BytesRef bytesRef = this.values[slot];
            Intrinsics.checkNotNull((Object)bytesRef);
            return bytesRef;
        }

        @Override
        public int compareValues(@NotNull BytesRef val1, @NotNull BytesRef val2) {
            Intrinsics.checkNotNullParameter((Object)val1, (String)"val1");
            Intrinsics.checkNotNullParameter((Object)val2, (String)"val2");
            return val1.compareTo(val2);
        }

        @Override
        public int compareTop(int doc) throws IOException {
            return ComparisonsKt.compareValues((Comparable)this.topValue, (Comparable)this.getValueForDoc(doc));
        }

        @Override
        public void setScorer(@NotNull Scorable scorer2) {
            Intrinsics.checkNotNullParameter((Object)scorer2, (String)"scorer");
        }

        @Override
        @Nullable
        public DocIdSetIterator competitiveIterator() throws IOException {
            return LeafFieldComparator.super.competitiveIterator();
        }

        @Override
        public void setHitsThresholdReached() throws IOException {
            LeafFieldComparator.super.setHitsThresholdReached();
        }
    }
}

