/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.search;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.index.ByteVectorValues;
import org.gnit.lucenekmp.index.DocValues;
import org.gnit.lucenekmp.index.DocValuesType;
import org.gnit.lucenekmp.index.FieldInfo;
import org.gnit.lucenekmp.index.FieldInfos;
import org.gnit.lucenekmp.index.FloatVectorValues;
import org.gnit.lucenekmp.index.IndexOptions;
import org.gnit.lucenekmp.index.IndexReader;
import org.gnit.lucenekmp.index.LeafReader;
import org.gnit.lucenekmp.index.LeafReaderContext;
import org.gnit.lucenekmp.index.PointValues;
import org.gnit.lucenekmp.index.Terms;
import org.gnit.lucenekmp.index.VectorEncoding;
import org.gnit.lucenekmp.search.ConstantScoreScorer;
import org.gnit.lucenekmp.search.ConstantScoreWeight;
import org.gnit.lucenekmp.search.DocIdSetIterator;
import org.gnit.lucenekmp.search.FieldExistsQuery;
import org.gnit.lucenekmp.search.IndexSearcher;
import org.gnit.lucenekmp.search.MatchAllDocsQuery;
import org.gnit.lucenekmp.search.Query;
import org.gnit.lucenekmp.search.QueryVisitor;
import org.gnit.lucenekmp.search.ScoreMode;
import org.gnit.lucenekmp.search.ScorerSupplier;
import org.gnit.lucenekmp.search.Weight;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 $2\u00020\u0001:\u0001$B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\b\u001a\u00020\u00032\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0096\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0018\u0010 \u001a\u00020\u00122\u0006\u0010!\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020#H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006%"}, d2={"Lorg/gnit/lucenekmp/search/FieldExistsQuery;", "Lorg/gnit/lucenekmp/search/Query;", "field", "", "<init>", "(Ljava/lang/String;)V", "getField", "()Ljava/lang/String;", "toString", "visit", "", "visitor", "Lorg/gnit/lucenekmp/search/QueryVisitor;", "equals", "", "other", "", "hashCode", "", "rewrite", "indexSearcher", "Lorg/gnit/lucenekmp/search/IndexSearcher;", "createWeight", "Lorg/gnit/lucenekmp/search/Weight;", "searcher", "scoreMode", "Lorg/gnit/lucenekmp/search/ScoreMode;", "boost", "", "buildErrorMsg", "fieldInfo", "Lorg/gnit/lucenekmp/index/FieldInfo;", "getVectorValuesSize", "fi", "reader", "Lorg/gnit/lucenekmp/index/LeafReader;", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nFieldExistsQuery.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FieldExistsQuery.kt\norg/gnit/lucenekmp/search/FieldExistsQuery\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,249:1\n1#2:250\n*E\n"})
public final class FieldExistsQuery
extends Query {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String field;

    public FieldExistsQuery(@NotNull String field) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        this.field = field;
    }

    @NotNull
    public final String getField() {
        return this.field;
    }

    @Override
    @NotNull
    public String toString(@Nullable String field) {
        return "FieldExistsQuery [field=" + this.field + "]";
    }

    @Override
    public void visit(@NotNull QueryVisitor visitor2) {
        Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
        if (visitor2.acceptField(this.field)) {
            visitor2.visitLeaf(this);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(@Nullable Object other) {
        if (!this.sameClassAs(other)) return false;
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.search.FieldExistsQuery");
        if (!Intrinsics.areEqual((Object)this.field, (Object)((FieldExistsQuery)other).field)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int hash = this.classHash();
        hash = prime * hash + this.field.hashCode();
        return hash;
    }

    @Override
    @NotNull
    public Query rewrite(@NotNull IndexSearcher indexSearcher) {
        Intrinsics.checkNotNullParameter((Object)indexSearcher, (String)"indexSearcher");
        IndexReader reader2 = indexSearcher.getIndexReader();
        boolean allReadersRewritable = true;
        for (LeafReaderContext context : reader2.leaves()) {
            LeafReader leaf = context.reader();
            FieldInfos fieldInfos = leaf.getFieldInfos();
            FieldInfo fieldInfo = fieldInfos.fieldInfo(this.field);
            if (fieldInfo == null) {
                allReadersRewritable = false;
                break;
            }
            if (fieldInfo.hasNorms()) {
                if (reader2.getDocCount(this.field) == reader2.maxDoc()) continue;
                allReadersRewritable = false;
                break;
            }
            if (fieldInfo.getVectorDimension() != 0) {
                if (this.getVectorValuesSize(fieldInfo, leaf) == leaf.maxDoc()) continue;
                allReadersRewritable = false;
                break;
            }
            if (fieldInfo.getDocValuesType() != DocValuesType.NONE) {
                Terms terms = leaf.terms(this.field);
                PointValues pointValues = leaf.getPointValues(this.field);
                if (terms != null && terms.getDocCount() == leaf.maxDoc() || pointValues != null && pointValues.getDocCount() == leaf.maxDoc()) continue;
                allReadersRewritable = false;
                break;
            }
            throw new IllegalStateException(this.buildErrorMsg(fieldInfo));
        }
        if (allReadersRewritable) {
            return new MatchAllDocsQuery();
        }
        return super.rewrite(indexSearcher);
    }

    @Override
    @NotNull
    public Weight createWeight(@NotNull IndexSearcher searcher, @NotNull ScoreMode scoreMode, float boost) {
        Intrinsics.checkNotNullParameter((Object)searcher, (String)"searcher");
        Intrinsics.checkNotNullParameter((Object)((Object)scoreMode), (String)"scoreMode");
        return new ConstantScoreWeight(this, boost, scoreMode){
            final /* synthetic */ FieldExistsQuery this$0;
            final /* synthetic */ ScoreMode $scoreMode;
            {
                this.this$0 = $receiver;
                this.$scoreMode = $scoreMode;
                super($receiver, $boost);
            }

            public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                FieldInfos fieldInfos = context.reader().getFieldInfos();
                FieldInfo fieldInfo = fieldInfos.fieldInfo(this.this$0.getField());
                DocIdSetIterator iterator2 = null;
                if (fieldInfo == null) {
                    return null;
                }
                if (fieldInfo.hasNorms()) {
                    iterator2 = context.reader().getNormValues(this.this$0.getField());
                } else if (fieldInfo.getVectorDimension() != 0) {
                    iterator2 = switch (createWeight.WhenMappings.$EnumSwitchMapping$0[fieldInfo.getVectorEncoding().ordinal()]) {
                        case 1 -> {
                            FloatVectorValues v0 = context.reader().getFloatVectorValues(this.this$0.getField());
                            Intrinsics.checkNotNull((Object)v0);
                            yield v0.iterator();
                        }
                        case 2 -> {
                            ByteVectorValues v2 = context.reader().getByteVectorValues(this.this$0.getField());
                            Intrinsics.checkNotNull((Object)v2);
                            yield v2.iterator();
                        }
                        default -> throw new NoWhenBranchMatchedException();
                    };
                } else if (fieldInfo.getDocValuesType() != DocValuesType.NONE) {
                    iterator2 = switch (createWeight.WhenMappings.$EnumSwitchMapping$1[fieldInfo.getDocValuesType().ordinal()]) {
                        case 1 -> context.reader().getNumericDocValues(this.this$0.getField());
                        case 2 -> context.reader().getBinaryDocValues(this.this$0.getField());
                        case 3 -> context.reader().getSortedDocValues(this.this$0.getField());
                        case 4 -> context.reader().getSortedNumericDocValues(this.this$0.getField());
                        case 5 -> context.reader().getSortedSetDocValues(this.this$0.getField());
                        case 6 -> throw new AssertionError();
                        default -> throw new NoWhenBranchMatchedException();
                    };
                } else {
                    throw new IllegalStateException(FieldExistsQuery.access$buildErrorMsg(this.this$0, fieldInfo));
                }
                if (iterator2 == null) {
                    return null;
                }
                ConstantScoreScorer scorer2 = new ConstantScoreScorer(this.score(), this.$scoreMode, iterator2);
                return new Weight.DefaultScorerSupplier(scorer2);
            }

            public int count(LeafReaderContext context) throws IOException {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                LeafReader reader2 = context.reader();
                FieldInfos fieldInfos = reader2.getFieldInfos();
                FieldInfo fieldInfo = fieldInfos.fieldInfo(this.this$0.getField());
                if (fieldInfo == null) {
                    return 0;
                }
                if (fieldInfo.hasNorms()) {
                    if (reader2.getDocCount(this.this$0.getField()) == reader2.maxDoc()) {
                        return reader2.numDocs();
                    }
                    return super.count(context);
                }
                if (fieldInfo.hasVectorValues()) {
                    if (!reader2.hasDeletions()) {
                        return FieldExistsQuery.access$getVectorValuesSize(this.this$0, fieldInfo, reader2);
                    }
                    return super.count(context);
                }
                if (fieldInfo.getDocValuesType() != DocValuesType.NONE) {
                    if (!reader2.hasDeletions()) {
                        if (fieldInfo.getPointDimensionCount() > 0) {
                            PointValues pointValues;
                            PointValues pointValues2 = pointValues = reader2.getPointValues(this.this$0.getField());
                            return pointValues2 != null ? pointValues2.getDocCount() : 0;
                        }
                        if (fieldInfo.getIndexOptions() != IndexOptions.NONE) {
                            Terms terms;
                            Terms terms2 = terms = reader2.terms(this.this$0.getField());
                            return terms2 != null ? terms2.getDocCount() : 0;
                        }
                    }
                    return super.count(context);
                }
                throw new IllegalStateException(FieldExistsQuery.access$buildErrorMsg(this.this$0, fieldInfo));
            }

            public boolean isCacheable(LeafReaderContext context) {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                FieldInfos fieldInfos = context.reader().getFieldInfos();
                FieldInfo fieldInfo = fieldInfos.fieldInfo(this.this$0.getField());
                if (fieldInfo != null && fieldInfo.getDocValuesType() != DocValuesType.NONE) {
                    String[] stringArray = new String[]{this.this$0.getField()};
                    return DocValues.INSTANCE.isCacheable(context, stringArray);
                }
                return true;
            }
        };
    }

    private final String buildErrorMsg(FieldInfo fieldInfo) {
        return "FieldExistsQuery requires that the field indexes doc values, norms or vectors, but field '" + fieldInfo.getName() + "' exists and indexes neither of these data structures";
    }

    private final int getVectorValuesSize(FieldInfo fi, LeafReader reader2) throws IOException {
        if (!Intrinsics.areEqual((Object)fi.getName(), (Object)this.field)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return switch (WhenMappings.$EnumSwitchMapping$0[fi.getVectorEncoding().ordinal()]) {
            case 1 -> {
                FloatVectorValues v0 = reader2.getFloatVectorValues(this.field);
                if (v0 == null) {
                    boolean $i$a$-checkNotNull-FieldExistsQuery$getVectorValuesSize$floatVectorValues$2 = false;
                    String $i$a$-checkNotNull-FieldExistsQuery$getVectorValuesSize$floatVectorValues$2 = "unexpected null float vector values";
                    throw new IllegalStateException($i$a$-checkNotNull-FieldExistsQuery$getVectorValuesSize$floatVectorValues$2.toString());
                }
                FloatVectorValues floatVectorValues = v0;
                yield floatVectorValues.size();
            }
            case 2 -> {
                ByteVectorValues v2 = reader2.getByteVectorValues(this.field);
                if (v2 == null) {
                    boolean $i$a$-checkNotNull-FieldExistsQuery$getVectorValuesSize$byteVectorValues$1 = false;
                    String var5_7 = "unexpected null byte vector values";
                    throw new IllegalStateException(var5_7.toString());
                }
                ByteVectorValues byteVectorValues = v2;
                yield byteVectorValues.size();
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public static final /* synthetic */ String access$buildErrorMsg(FieldExistsQuery $this, FieldInfo fieldInfo) {
        return $this.buildErrorMsg(fieldInfo);
    }

    public static final /* synthetic */ int access$getVectorValuesSize(FieldExistsQuery $this, FieldInfo fi, LeafReader reader2) {
        return $this.getVectorValuesSize(fi, reader2);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lorg/gnit/lucenekmp/search/FieldExistsQuery$Companion;", "", "<init>", "()V", "getDocValuesDocIdSetIterator", "Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "field", "", "reader", "Lorg/gnit/lucenekmp/index/LeafReader;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final DocIdSetIterator getDocValuesDocIdSetIterator(@NotNull String field, @NotNull LeafReader reader2) throws IOException {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
            FieldInfo fieldInfo = reader2.getFieldInfos().fieldInfo(field);
            DocIdSetIterator iterator2 = null;
            if (fieldInfo != null) {
                iterator2 = switch (WhenMappings.$EnumSwitchMapping$0[fieldInfo.getDocValuesType().ordinal()]) {
                    case 1 -> null;
                    case 2 -> reader2.getNumericDocValues(field);
                    case 3 -> reader2.getBinaryDocValues(field);
                    case 4 -> reader2.getSortedDocValues(field);
                    case 5 -> reader2.getSortedNumericDocValues(field);
                    case 6 -> reader2.getSortedSetDocValues(field);
                    default -> throw new NoWhenBranchMatchedException();
                };
                return iterator2;
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[DocValuesType.values().length];
                try {
                    nArray[DocValuesType.NONE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DocValuesType.NUMERIC.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DocValuesType.BINARY.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DocValuesType.SORTED.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DocValuesType.SORTED_NUMERIC.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DocValuesType.SORTED_SET.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[VectorEncoding.values().length];
            try {
                nArray[VectorEncoding.FLOAT32.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VectorEncoding.BYTE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

