/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.search;

import java.io.IOException;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.index.LeafReaderContext;
import org.gnit.lucenekmp.search.FieldComparator;
import org.gnit.lucenekmp.search.FieldDoc;
import org.gnit.lucenekmp.search.LeafFieldComparator;
import org.gnit.lucenekmp.search.Pruning;
import org.gnit.lucenekmp.search.ScoreDoc;
import org.gnit.lucenekmp.search.SortField;
import org.gnit.lucenekmp.util.PriorityQueue;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u0000 &*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0004#$%&B\u001f\b\u0002\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0019\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00052\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\u001d\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00028\u00002\u0006\u0010\u001e\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u001fJ\u000e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0002R\u0019\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\fR\u001d\u0010\u0013\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00140\u0005\u00a2\u0006\n\n\u0002\u0010\u0016\u001a\u0004\b\u000e\u0010\u0015R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006'"}, d2={"Lorg/gnit/lucenekmp/search/FieldValueHitQueue;", "T", "Lorg/gnit/lucenekmp/search/FieldValueHitQueue$Entry;", "Lorg/gnit/lucenekmp/util/PriorityQueue;", "fields", "", "Lorg/gnit/lucenekmp/search/SortField;", "size", "", "<init>", "([Lorg/gnit/lucenekmp/search/SortField;I)V", "getFields", "()[Lorg/gnit/lucenekmp/search/SortField;", "[Lorg/gnit/lucenekmp/search/SortField;", "getComparators", "Lorg/gnit/lucenekmp/search/LeafFieldComparator;", "context", "Lorg/gnit/lucenekmp/index/LeafReaderContext;", "(Lorg/gnit/lucenekmp/index/LeafReaderContext;)[Lorg/gnit/lucenekmp/search/LeafFieldComparator;", "comparators", "Lorg/gnit/lucenekmp/search/FieldComparator;", "()[Lorg/gnit/lucenekmp/search/FieldComparator;", "[Lorg/gnit/lucenekmp/search/FieldComparator;", "reverseMul", "", "getReverseMul", "()[I", "lessThan", "", "a", "b", "(Lorg/gnit/lucenekmp/search/FieldValueHitQueue$Entry;Lorg/gnit/lucenekmp/search/FieldValueHitQueue$Entry;)Z", "fillFields", "Lorg/gnit/lucenekmp/search/FieldDoc;", "entry", "Entry", "OneComparatorFieldValueHitQueue", "MultiComparatorsFieldValueHitQueue", "Companion", "core"})
public abstract class FieldValueHitQueue<T extends Entry>
extends PriorityQueue<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SortField[] fields;
    @NotNull
    private final FieldComparator<?>[] comparators;
    @NotNull
    private final int[] reverseMul;

    private FieldValueHitQueue(SortField[] fields, int size2) {
        super(size2, null, 2, null);
        this.fields = fields;
        int numComparators = this.fields.length;
        this.comparators = new FieldComparator[numComparators];
        this.reverseMul = new int[numComparators];
        for (int i = 0; i < numComparators; ++i) {
            SortField field = this.fields[i];
            int n = this.reverseMul[i] = field.getReverse() ? -1 : 1;
            this.comparators[i] = field.getComparator(size2, i == 0 ? (numComparators > 1 ? Pruning.GREATER_THAN : Pruning.GREATER_THAN_OR_EQUAL_TO) : Pruning.NONE);
        }
    }

    @NotNull
    public final SortField[] getFields() {
        return this.fields;
    }

    @NotNull
    public final LeafFieldComparator[] getComparators(@NotNull LeafReaderContext context) throws IOException {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        LeafFieldComparator[] comparators = new LeafFieldComparator[this.comparators.length];
        int n = comparators.length;
        for (int i = 0; i < n; ++i) {
            comparators[i] = this.comparators[i].getLeafComparator(context);
        }
        return comparators;
    }

    @NotNull
    public final FieldComparator<?>[] getComparators() {
        return this.comparators;
    }

    @NotNull
    public final int[] getReverseMul() {
        return this.reverseMul;
    }

    @Override
    public abstract boolean lessThan(@NotNull T var1, @NotNull T var2);

    @NotNull
    public final FieldDoc fillFields(@NotNull Entry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        int n = this.comparators.length;
        Object[] fields = new Object[n];
        for (int i = 0; i < n; ++i) {
            fields[i] = this.comparators[i].value(entry.getSlot());
        }
        return new FieldDoc(entry.getDoc(), entry.getScore(), fields);
    }

    public /* synthetic */ FieldValueHitQueue(SortField[] fields, int size2, DefaultConstructorMarker $constructor_marker) {
        this(fields, size2);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J1\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\b\b\u0001\u0010\u0006*\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/gnit/lucenekmp/search/FieldValueHitQueue$Companion;", "", "<init>", "()V", "create", "Lorg/gnit/lucenekmp/search/FieldValueHitQueue;", "T", "Lorg/gnit/lucenekmp/search/FieldValueHitQueue$Entry;", "fields", "", "Lorg/gnit/lucenekmp/search/SortField;", "size", "", "([Lorg/gnit/lucenekmp/search/SortField;I)Lorg/gnit/lucenekmp/search/FieldValueHitQueue;", "core"})
    @SourceDebugExtension(value={"SMAP\nFieldValueHitQueue.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FieldValueHitQueue.kt\norg/gnit/lucenekmp/search/FieldValueHitQueue$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,180:1\n1#2:181\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final <T extends Entry> FieldValueHitQueue<T> create(@NotNull SortField[] fields, int size2) {
            Intrinsics.checkNotNullParameter((Object)fields, (String)"fields");
            if (!(!(fields.length == 0))) {
                boolean bl = false;
                String string = "Sort must contain at least one field";
                throw new IllegalArgumentException(string.toString());
            }
            return fields.length == 1 ? (FieldValueHitQueue)new OneComparatorFieldValueHitQueue(fields, size2) : (FieldValueHitQueue)new MultiComparatorsFieldValueHitQueue(fields, size2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Lorg/gnit/lucenekmp/search/FieldValueHitQueue$Entry;", "Lorg/gnit/lucenekmp/search/ScoreDoc;", "slot", "", "doc", "<init>", "(II)V", "getSlot", "()I", "setSlot", "(I)V", "toString", "", "core"})
    public static class Entry
    extends ScoreDoc {
        private int slot;

        public Entry(int slot, int doc) {
            super(doc, Float.NaN, 0, 4, null);
            this.slot = slot;
        }

        public final int getSlot() {
            return this.slot;
        }

        public final void setSlot(int n) {
            this.slot = n;
        }

        @Override
        @NotNull
        public String toString() {
            return "slot:" + this.slot + " " + super.toString();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0002\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001d\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u001d\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00028\u00012\u0006\u0010\u000e\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/gnit/lucenekmp/search/FieldValueHitQueue$MultiComparatorsFieldValueHitQueue;", "T", "Lorg/gnit/lucenekmp/search/FieldValueHitQueue$Entry;", "Lorg/gnit/lucenekmp/search/FieldValueHitQueue;", "fields", "", "Lorg/gnit/lucenekmp/search/SortField;", "size", "", "<init>", "([Lorg/gnit/lucenekmp/search/SortField;I)V", "lessThan", "", "hitA", "hitB", "(Lorg/gnit/lucenekmp/search/FieldValueHitQueue$Entry;Lorg/gnit/lucenekmp/search/FieldValueHitQueue$Entry;)Z", "core"})
    @SourceDebugExtension(value={"SMAP\nFieldValueHitQueue.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FieldValueHitQueue.kt\norg/gnit/lucenekmp/search/FieldValueHitQueue$MultiComparatorsFieldValueHitQueue\n+ 2 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 3 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n*L\n1#1,180:1\n3#2,8:181\n3#2,8:190\n10#3:189\n10#3:198\n*S KotlinDebug\n*F\n+ 1 FieldValueHitQueue.kt\norg/gnit/lucenekmp/search/FieldValueHitQueue$MultiComparatorsFieldValueHitQueue\n*L\n75#1:181,8\n76#1:190,8\n75#1:189\n76#1:198\n*E\n"})
    private static final class MultiComparatorsFieldValueHitQueue<T extends Entry>
    extends FieldValueHitQueue<T> {
        public MultiComparatorsFieldValueHitQueue(@NotNull SortField[] fields, int size2) {
            Intrinsics.checkNotNullParameter((Object)fields, (String)"fields");
            super(fields, size2, null);
        }

        @Override
        public boolean lessThan(@NotNull T hitA, @NotNull T hitB) {
            Intrinsics.checkNotNullParameter(hitA, (String)"hitA");
            Intrinsics.checkNotNullParameter(hitB, (String)"hitB");
            boolean condition$iv = hitA != hitB;
            boolean $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv) {
                boolean $i$a$-assert-AssertKt$assert$22 = false;
                String $i$a$-assert-AssertKt$assert$22 = "assertion failed";
                throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$22);
            }
            condition$iv = ((Entry)hitA).getSlot() != ((Entry)hitB).getSlot();
            $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv) {
                boolean bl = false;
                String string = "assertion failed";
                throw new AssertionError((Object)string);
            }
            int numComparators = this.getComparators().length;
            for (int i = 0; i < numComparators; ++i) {
                int c = this.getReverseMul()[i] * this.getComparators()[i].compare(((Entry)hitA).getSlot(), ((Entry)hitB).getSlot());
                if (c == 0) continue;
                return c > 0;
            }
            return ((ScoreDoc)hitA).getDoc() > ((ScoreDoc)hitB).getDoc();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0002\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001d\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u001d\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00028\u00012\u0006\u0010\u0011\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u0012R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/gnit/lucenekmp/search/FieldValueHitQueue$OneComparatorFieldValueHitQueue;", "T", "Lorg/gnit/lucenekmp/search/FieldValueHitQueue$Entry;", "Lorg/gnit/lucenekmp/search/FieldValueHitQueue;", "fields", "", "Lorg/gnit/lucenekmp/search/SortField;", "size", "", "<init>", "([Lorg/gnit/lucenekmp/search/SortField;I)V", "oneReverseMul", "oneComparator", "Lorg/gnit/lucenekmp/search/FieldComparator;", "lessThan", "", "hitA", "hitB", "(Lorg/gnit/lucenekmp/search/FieldValueHitQueue$Entry;Lorg/gnit/lucenekmp/search/FieldValueHitQueue$Entry;)Z", "core"})
    @SourceDebugExtension(value={"SMAP\nFieldValueHitQueue.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FieldValueHitQueue.kt\norg/gnit/lucenekmp/search/FieldValueHitQueue$OneComparatorFieldValueHitQueue\n+ 2 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 3 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n*L\n1#1,180:1\n3#2,8:181\n3#2,8:190\n3#2,8:199\n10#3:189\n10#3:198\n10#3:207\n*S KotlinDebug\n*F\n+ 1 FieldValueHitQueue.kt\norg/gnit/lucenekmp/search/FieldValueHitQueue$OneComparatorFieldValueHitQueue\n*L\n42#1:181,8\n56#1:190,8\n57#1:199,8\n42#1:189\n56#1:198\n57#1:207\n*E\n"})
    private static final class OneComparatorFieldValueHitQueue<T extends Entry>
    extends FieldValueHitQueue<T> {
        private final int oneReverseMul;
        @NotNull
        private final FieldComparator<?> oneComparator;

        public OneComparatorFieldValueHitQueue(@NotNull SortField[] fields, int size2) {
            Intrinsics.checkNotNullParameter((Object)fields, (String)"fields");
            super(fields, size2, null);
            boolean condition$iv = fields.length == 1;
            boolean $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv) {
                boolean bl = false;
                String string = "assertion failed";
                throw new AssertionError((Object)string);
            }
            this.oneComparator = this.getComparators()[0];
            this.oneReverseMul = this.getReverseMul()[0];
        }

        @Override
        public boolean lessThan(@NotNull T hitA, @NotNull T hitB) {
            Intrinsics.checkNotNullParameter(hitA, (String)"hitA");
            Intrinsics.checkNotNullParameter(hitB, (String)"hitB");
            boolean condition$iv = hitA != hitB;
            boolean $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv) {
                boolean $i$a$-assert-AssertKt$assert$22 = false;
                String $i$a$-assert-AssertKt$assert$22 = "assertion failed";
                throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$22);
            }
            condition$iv = ((Entry)hitA).getSlot() != ((Entry)hitB).getSlot();
            $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv) {
                boolean bl = false;
                String string = "assertion failed";
                throw new AssertionError((Object)string);
            }
            int c = this.oneReverseMul * this.oneComparator.compare(((Entry)hitA).getSlot(), ((Entry)hitB).getSlot());
            if (c != 0) {
                return c > 0;
            }
            return ((ScoreDoc)hitA).getDoc() > ((ScoreDoc)hitB).getDoc();
        }
    }
}

