/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.search;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.jdkport.Character;
import org.gnit.lucenekmp.jdkport.ObjectsKt;
import org.gnit.lucenekmp.jdkport.System;
import org.gnit.lucenekmp.search.FuzzyTermsEnum;
import org.gnit.lucenekmp.util.UnicodeUtil;
import org.gnit.lucenekmp.util.UnicodeUtilKt;
import org.gnit.lucenekmp.util.automaton.Automaton;
import org.gnit.lucenekmp.util.automaton.CompiledAutomaton;
import org.gnit.lucenekmp.util.automaton.LevenshteinAutomata;
import org.gnit.lucenekmp.util.automaton.TooComplexToDeterminizeException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0011\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\u0002\u0010\u0014J\u0006\u0010\u0015\u001a\u00020\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0017"}, d2={"Lorg/gnit/lucenekmp/search/FuzzyAutomatonBuilder;", "", "term", "", "maxEdits", "", "prefixLength", "transpositions", "", "<init>", "(Ljava/lang/String;IIZ)V", "levBuilder", "Lorg/gnit/lucenekmp/util/automaton/LevenshteinAutomata;", "prefix", "termLength", "getTermLength", "()I", "buildAutomatonSet", "", "Lorg/gnit/lucenekmp/util/automaton/CompiledAutomaton;", "()[Lorg/gnit/lucenekmp/util/automaton/CompiledAutomaton;", "buildMaxEditAutomaton", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nFuzzyAutomatonBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FuzzyAutomatonBuilder.kt\norg/gnit/lucenekmp/search/FuzzyAutomatonBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,90:1\n1#2:91\n*E\n"})
public final class FuzzyAutomatonBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String term;
    private final int maxEdits;
    @NotNull
    private final LevenshteinAutomata levBuilder;
    @NotNull
    private final String prefix;
    private final int termLength;

    public FuzzyAutomatonBuilder(@NotNull String term, int maxEdits, int prefixLength, boolean transpositions) {
        Intrinsics.checkNotNullParameter((Object)term, (String)"term");
        int prefixLength2 = prefixLength;
        if (!(maxEdits >= 0 && maxEdits <= 2)) {
            boolean $i$a$-require-FuzzyAutomatonBuilder$32 = false;
            String $i$a$-require-FuzzyAutomatonBuilder$32 = "max edits must be 0..2, inclusive; got: " + maxEdits;
            throw new IllegalArgumentException($i$a$-require-FuzzyAutomatonBuilder$32.toString());
        }
        if (!(prefixLength2 >= 0)) {
            boolean $i$a$-require-FuzzyAutomatonBuilder$42 = false;
            String $i$a$-require-FuzzyAutomatonBuilder$42 = "prefixLength cannot be less than 0";
            throw new IllegalArgumentException($i$a$-require-FuzzyAutomatonBuilder$42.toString());
        }
        this.term = term;
        this.maxEdits = maxEdits;
        int[] codePoints = FuzzyAutomatonBuilder.Companion.stringToUTF32(term);
        this.termLength = codePoints.length;
        prefixLength2 = Math.min(prefixLength2, codePoints.length);
        int[] suffix = new int[codePoints.length - prefixLength2];
        System.INSTANCE.arraycopy(codePoints, prefixLength2, suffix, 0, suffix.length);
        this.levBuilder = new LevenshteinAutomata(suffix, 0x10FFFF, transpositions);
        this.prefix = UnicodeUtil.INSTANCE.newString(codePoints, 0, prefixLength2);
    }

    public final int getTermLength() {
        return this.termLength;
    }

    @NotNull
    public final CompiledAutomaton[] buildAutomatonSet() {
        CompiledAutomaton[] compiled = new CompiledAutomaton[this.maxEdits + 1];
        int i = 0;
        int n = this.maxEdits;
        if (i <= n) {
            while (true) {
                try {
                    Automaton automaton = this.levBuilder.toAutomaton(i, this.prefix);
                    Intrinsics.checkNotNull((Object)automaton);
                    compiled[i] = new CompiledAutomaton(automaton, true, false);
                }
                catch (TooComplexToDeterminizeException e) {
                    throw new FuzzyTermsEnum.FuzzyTermsException(this.term, e);
                }
                if (i == n) break;
                ++i;
            }
        }
        return compiled;
    }

    @NotNull
    public final CompiledAutomaton buildMaxEditAutomaton() {
        try {
            Automaton automaton = this.levBuilder.toAutomaton(this.maxEdits, this.prefix);
            Intrinsics.checkNotNull((Object)automaton);
            return new CompiledAutomaton(automaton, true, false);
        }
        catch (TooComplexToDeterminizeException e) {
            throw new FuzzyTermsEnum.FuzzyTermsException(this.term, e);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\b"}, d2={"Lorg/gnit/lucenekmp/search/FuzzyAutomatonBuilder$Companion;", "", "<init>", "()V", "stringToUTF32", "", "text", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        private final int[] stringToUTF32(String text) {
            int[] termText = new int[UnicodeUtilKt.codePointCount(text, 0, text.length())];
            int cp = 0;
            int j = 0;
            for (int i = 0; i < text.length(); i += Character.Companion.charCount(cp)) {
                cp = ObjectsKt.codePointAt(text, i);
                termText[j++] = cp;
            }
            return termText;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

