/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.search;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.index.SingleTermsEnum;
import org.gnit.lucenekmp.index.Term;
import org.gnit.lucenekmp.index.Terms;
import org.gnit.lucenekmp.index.TermsEnum;
import org.gnit.lucenekmp.search.FuzzyAutomatonBuilder;
import org.gnit.lucenekmp.search.FuzzyTermsEnum;
import org.gnit.lucenekmp.search.MultiTermQuery;
import org.gnit.lucenekmp.search.QueryVisitor;
import org.gnit.lucenekmp.util.AttributeSource;
import org.gnit.lucenekmp.util.automaton.ByteRunAutomaton;
import org.gnit.lucenekmp.util.automaton.CompiledAutomaton;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u0000 )2\u00020\u0001:\u0001)BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0014J\u0006\u0010!\u001a\u00020\u0003J\u0012\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010#H\u0016J\b\u0010%\u001a\u00020\u0005H\u0016J\u0013\u0010&\u001a\u00020\t2\b\u0010'\u001a\u0004\u0018\u00010(H\u0096\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006*"}, d2={"Lorg/gnit/lucenekmp/search/FuzzyQuery;", "Lorg/gnit/lucenekmp/search/MultiTermQuery;", "term", "Lorg/gnit/lucenekmp/index/Term;", "maxEdits", "", "prefixLength", "maxExpansions", "transpositions", "", "rewriteMethod", "Lorg/gnit/lucenekmp/search/MultiTermQuery$RewriteMethod;", "<init>", "(Lorg/gnit/lucenekmp/index/Term;IIIZLorg/gnit/lucenekmp/search/MultiTermQuery$RewriteMethod;)V", "getMaxEdits", "()I", "getTranspositions", "()Z", "getPrefixLength", "automata", "Lorg/gnit/lucenekmp/util/automaton/CompiledAutomaton;", "getAutomata", "()Lorg/gnit/lucenekmp/util/automaton/CompiledAutomaton;", "visit", "", "visitor", "Lorg/gnit/lucenekmp/search/QueryVisitor;", "getTermsEnum", "Lorg/gnit/lucenekmp/index/TermsEnum;", "terms", "Lorg/gnit/lucenekmp/index/Terms;", "atts", "Lorg/gnit/lucenekmp/util/AttributeSource;", "getTerm", "toString", "", "field", "hashCode", "equals", "obj", "", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nFuzzyQuery.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FuzzyQuery.kt\norg/gnit/lucenekmp/search/FuzzyQuery\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,213:1\n1#2:214\n*E\n"})
public final class FuzzyQuery
extends MultiTermQuery {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int maxEdits;
    private final int maxExpansions;
    private final boolean transpositions;
    private final int prefixLength;
    @NotNull
    private final Term term;
    public static final int defaultMaxEdits = 2;
    public static final int defaultPrefixLength = 0;
    public static final int defaultMaxExpansions = 50;
    public static final boolean defaultTranspositions = true;

    public FuzzyQuery(@NotNull Term term, int maxEdits, int prefixLength, int maxExpansions, boolean transpositions, @NotNull MultiTermQuery.RewriteMethod rewriteMethod) {
        Intrinsics.checkNotNullParameter((Object)term, (String)"term");
        Intrinsics.checkNotNullParameter((Object)rewriteMethod, (String)"rewriteMethod");
        super(term.field(), rewriteMethod);
        if (!(maxEdits >= 0 && maxEdits <= 2)) {
            boolean $i$a$-require-FuzzyQuery$42 = false;
            String $i$a$-require-FuzzyQuery$42 = "maxEdits must be between 0 and 2";
            throw new IllegalArgumentException($i$a$-require-FuzzyQuery$42.toString());
        }
        if (!(prefixLength >= 0)) {
            boolean $i$a$-require-FuzzyQuery$52 = false;
            String $i$a$-require-FuzzyQuery$52 = "prefixLength cannot be negative.";
            throw new IllegalArgumentException($i$a$-require-FuzzyQuery$52.toString());
        }
        if (!(maxExpansions > 0)) {
            boolean bl = false;
            String string = "maxExpansions must be positive.";
            throw new IllegalArgumentException(string.toString());
        }
        this.term = term;
        this.maxEdits = maxEdits;
        this.prefixLength = prefixLength;
        this.transpositions = transpositions;
        this.maxExpansions = maxExpansions;
    }

    public /* synthetic */ FuzzyQuery(Term term, int n, int n2, int n3, boolean bl, MultiTermQuery.RewriteMethod rewriteMethod, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 2) != 0) {
            n = 2;
        }
        if ((n4 & 4) != 0) {
            n2 = 0;
        }
        if ((n4 & 8) != 0) {
            n3 = 50;
        }
        if ((n4 & 0x10) != 0) {
            bl = true;
        }
        if ((n4 & 0x20) != 0) {
            rewriteMethod = Companion.defaultRewriteMethod(n3);
        }
        this(term, n, n2, n3, bl, rewriteMethod);
    }

    public final int getMaxEdits() {
        return this.maxEdits;
    }

    public final boolean getTranspositions() {
        return this.transpositions;
    }

    public final int getPrefixLength() {
        return this.prefixLength;
    }

    @NotNull
    public final CompiledAutomaton getAutomata() {
        return Companion.getFuzzyAutomaton(this.term.text(), this.maxEdits, this.prefixLength, this.transpositions);
    }

    @Override
    public void visit(@NotNull QueryVisitor visitor2) {
        Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
        if (visitor2.acceptField(this.getField())) {
            visitor2.consumeTermsMatching(this, this.term.field(), (Function0<ByteRunAutomaton>)((Function0)() -> FuzzyQuery.visit$lambda$3(this)));
        }
    }

    @Override
    @NotNull
    protected TermsEnum getTermsEnum(@NotNull Terms terms, @NotNull AttributeSource atts) throws IOException {
        Intrinsics.checkNotNullParameter((Object)terms, (String)"terms");
        Intrinsics.checkNotNullParameter((Object)atts, (String)"atts");
        if (this.maxEdits == 0) {
            return new SingleTermsEnum(terms.iterator(), this.term.bytes());
        }
        return new FuzzyTermsEnum(terms, atts, this.getTerm(), this.maxEdits, this.prefixLength, this.transpositions);
    }

    @NotNull
    public final Term getTerm() {
        return this.term;
    }

    @Override
    @NotNull
    public String toString(@Nullable String field) {
        StringBuilder buffer = new StringBuilder();
        if (!Intrinsics.areEqual((Object)this.term.field(), (Object)field)) {
            buffer.append(this.term.field());
            buffer.append(":");
        }
        buffer.append(this.term.text());
        buffer.append('~');
        buffer.append(this.maxEdits);
        String string = buffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = prime * result + this.maxEdits;
        result = prime * result + this.prefixLength;
        result = prime * result + this.maxExpansions;
        result = prime * result + (this.transpositions ? 0 : 1);
        result = prime * result + (this.term == null ? 0 : this.term.hashCode());
        return result;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        Class<?> clazz = this.getClass();
        Object object = obj;
        Intrinsics.checkNotNull((Object)object);
        if (clazz != object.getClass()) {
            return false;
        }
        FuzzyQuery other = (FuzzyQuery)obj;
        return this.maxEdits == other.maxEdits && this.prefixLength == other.prefixLength && this.maxExpansions == other.maxExpansions && this.transpositions == other.transpositions && Intrinsics.areEqual((Object)this.term, (Object)other.term);
    }

    private static final ByteRunAutomaton visit$lambda$3(FuzzyQuery this$0) {
        ByteRunAutomaton byteRunAutomaton = this$0.getAutomata().getRunAutomaton();
        Intrinsics.checkNotNull((Object)byteRunAutomaton);
        return byteRunAutomaton;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005J&\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\tJ\u0016\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/gnit/lucenekmp/search/FuzzyQuery$Companion;", "", "<init>", "()V", "defaultMaxEdits", "", "defaultPrefixLength", "defaultMaxExpansions", "defaultTranspositions", "", "defaultRewriteMethod", "Lorg/gnit/lucenekmp/search/MultiTermQuery$RewriteMethod;", "maxExpansions", "getFuzzyAutomaton", "Lorg/gnit/lucenekmp/util/automaton/CompiledAutomaton;", "term", "", "maxEdits", "prefixLength", "transpositions", "floatToEdits", "minimumSimilarity", "", "termLen", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MultiTermQuery.RewriteMethod defaultRewriteMethod(int maxExpansions) {
            return new MultiTermQuery.TopTermsBlendedFreqScoringRewrite(maxExpansions);
        }

        @NotNull
        public final CompiledAutomaton getFuzzyAutomaton(@NotNull String term, int maxEdits, int prefixLength, boolean transpositions) {
            Intrinsics.checkNotNullParameter((Object)term, (String)"term");
            FuzzyAutomatonBuilder builder = new FuzzyAutomatonBuilder(term, maxEdits, prefixLength, transpositions);
            return builder.buildMaxEditAutomaton();
        }

        public final int floatToEdits(float minimumSimilarity, int termLen) {
            return minimumSimilarity >= 1.0f ? (int)Math.min(minimumSimilarity, 2.0f) : (minimumSimilarity == 0.0f ? 0 : Math.min((int)((1.0 - (double)minimumSimilarity) * (double)termLen), 2));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

