/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.search;

import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.concurrent.atomics.AtomicsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import org.gnit.lucenekmp.index.IndexReader;
import org.gnit.lucenekmp.index.LeafReaderContext;
import org.gnit.lucenekmp.index.ReaderUtil;
import org.gnit.lucenekmp.search.BoostQuery;
import org.gnit.lucenekmp.search.BulkScorer;
import org.gnit.lucenekmp.search.ConstantScoreQuery;
import org.gnit.lucenekmp.search.ConstantScoreScorerSupplier;
import org.gnit.lucenekmp.search.ConstantScoreWeight;
import org.gnit.lucenekmp.search.DocIdSet;
import org.gnit.lucenekmp.search.DocIdSetIterator;
import org.gnit.lucenekmp.search.DocIdStream;
import org.gnit.lucenekmp.search.LRUQueryCache;
import org.gnit.lucenekmp.search.LRUQueryCacheKt;
import org.gnit.lucenekmp.search.LeafCollector;
import org.gnit.lucenekmp.search.Matches;
import org.gnit.lucenekmp.search.Query;
import org.gnit.lucenekmp.search.QueryCache;
import org.gnit.lucenekmp.search.QueryCachingPolicy;
import org.gnit.lucenekmp.search.Scorable;
import org.gnit.lucenekmp.search.ScoreMode;
import org.gnit.lucenekmp.search.ScorerSupplier;
import org.gnit.lucenekmp.search.Weight;
import org.gnit.lucenekmp.util.Accountable;
import org.gnit.lucenekmp.util.Accountables;
import org.gnit.lucenekmp.util.BitDocIdSet;
import org.gnit.lucenekmp.util.FixedBitSet;
import org.gnit.lucenekmp.util.RamUsageEstimator;
import org.gnit.lucenekmp.util.RoaringDocIdSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\b\u0016\u0018\u0000 `2\u00020\u00012\u00020\u0002:\u0004]^_`B7\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0018\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u0011H\u0004J\u0018\u0010,\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u0011H\u0004J\u0018\u0010-\u001a\u00020(2\u0006\u0010+\u001a\u00020\u00112\u0006\u0010 \u001a\u00020\u0006H\u0004J\u0018\u0010.\u001a\u00020(2\u0006\u0010+\u001a\u00020\u00112\u0006\u0010 \u001a\u00020\u0006H\u0004J\u0018\u0010/\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010 \u001a\u00020\u0006H\u0004J \u00100\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u00101\u001a\u00020\u00042\u0006\u00102\u001a\u00020\u0006H\u0004J\b\u00103\u001a\u00020(H\u0004J\u0006\u00104\u001a\u00020\nJ\u0018\u00105\u001a\u0004\u0018\u0001062\u0006\u00107\u001a\u00020\u00112\u0006\u00108\u001a\u000209J&\u0010:\u001a\u00020(2\u0006\u0010+\u001a\u00020\u00112\u0006\u0010;\u001a\u0002062\u0006\u00108\u001a\u000209H\u0082@\u00a2\u0006\u0002\u0010<J\b\u0010=\u001a\u00020(H\u0002J\u0016\u0010>\u001a\u00020(2\u0006\u0010?\u001a\u00020*H\u0086@\u00a2\u0006\u0002\u0010@J\u0016\u0010A\u001a\u00020(2\u0006\u0010+\u001a\u00020\u0011H\u0086@\u00a2\u0006\u0002\u0010BJ\u0010\u0010C\u001a\u00020(2\u0006\u0010D\u001a\u00020\u0011H\u0002J\u000e\u0010E\u001a\u00020(H\u0086@\u00a2\u0006\u0002\u0010FJ\u000e\u0010G\u001a\u00020(H\u0086@\u00a2\u0006\u0002\u0010FJ\u0014\u0010H\u001a\b\u0012\u0004\u0012\u00020\u00110IH\u0086@\u00a2\u0006\u0002\u0010FJ\u0018\u0010J\u001a\u00020K2\u0006\u0010L\u001a\u00020K2\u0006\u0010M\u001a\u00020NH\u0016J\b\u0010 \u001a\u00020\u0006H\u0016J\u0018\u0010S\u001a\u0002062\u0006\u0010T\u001a\u00020U2\u0006\u0010V\u001a\u00020\u0004H\u0004J\u0006\u0010Y\u001a\u00020\u0006J\u0006\u0010Z\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0014\u001a\u0012\u0012\u0004\u0012\u00020\u0015\u0012\b\u0012\u00060\u0016R\u00020\u00000\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\n\n\u0002\u0010\u001d\u0012\u0004\b\u001b\u0010\u001cR\u0016\u0010\u001e\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\n\n\u0002\u0010\u001d\u0012\u0004\b\u001f\u0010\u001cR\u000e\u0010 \u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\"\u001a\u00020\u00062\u0006\u0010!\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u001e\u0010%\u001a\u00020\u00062\u0006\u0010!\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010$R\u001a\u0010O\u001a\b\u0012\u0004\u0012\u00020\u00020P8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bQ\u0010RR\u0011\u0010W\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\bX\u0010$R\u0011\u0010[\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\\\u0010$\u00a8\u0006a"}, d2={"Lorg/gnit/lucenekmp/search/LRUQueryCache;", "Lorg/gnit/lucenekmp/search/QueryCache;", "Lorg/gnit/lucenekmp/util/Accountable;", "maxSize", "", "maxRamBytesUsed", "", "leavesToCache", "Lkotlin/Function1;", "Lorg/gnit/lucenekmp/index/LeafReaderContext;", "", "skipCacheFactor", "", "<init>", "(IJLkotlin/jvm/functions/Function1;F)V", "uniqueQueries", "", "Lorg/gnit/lucenekmp/search/Query;", "mostRecentlyUsedQueries", "", "cache", "Lorg/gnit/lucenekmp/index/IndexReader$CacheKey;", "Lorg/gnit/lucenekmp/search/LRUQueryCache$LeafCache;", "cacheMutex", "Lkotlinx/coroutines/sync/Mutex;", "hitCount", "Lkotlin/concurrent/atomics/AtomicLong;", "getHitCount$annotations", "()V", "Ljava/util/concurrent/atomic/AtomicLong;", "missCount", "getMissCount$annotations", "ramBytesUsed", "value", "cacheCount", "getCacheCount", "()J", "cacheSize", "getCacheSize", "onHit", "", "readerCoreKey", "", "query", "onMiss", "onQueryCache", "onQueryEviction", "onDocIdSetCache", "onDocIdSetEviction", "numEntries", "sumRamBytesUsed", "onClear", "requiresEviction", "get", "Lorg/gnit/lucenekmp/search/LRUQueryCache$CacheAndCount;", "key", "cacheHelper", "Lorg/gnit/lucenekmp/index/IndexReader$CacheHelper;", "putIfAbsent", "cached", "(Lorg/gnit/lucenekmp/search/Query;Lorg/gnit/lucenekmp/search/LRUQueryCache$CacheAndCount;Lorg/gnit/lucenekmp/index/IndexReader$CacheHelper;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "evictIfNecessary", "clearCoreCacheKey", "coreKey", "(Ljava/lang/Object;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "clearQuery", "(Lorg/gnit/lucenekmp/search/Query;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "onEviction", "singleton", "clear", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "assertConsistent", "cachedQueries", "", "doCache", "Lorg/gnit/lucenekmp/search/Weight;", "weight", "policy", "Lorg/gnit/lucenekmp/search/QueryCachingPolicy;", "childResources", "", "getChildResources", "()Ljava/util/Collection;", "cacheImpl", "scorer", "Lorg/gnit/lucenekmp/search/BulkScorer;", "maxDoc", "totalCount", "getTotalCount", "getHitCount", "getMissCount", "evictionCount", "getEvictionCount", "LeafCache", "CachingWrapperWeight", "CacheAndCount", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nLRUQueryCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LRUQueryCache.kt\norg/gnit/lucenekmp/search/LRUQueryCache\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 4 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n+ 5 Mutex.kt\nkotlinx/coroutines/sync/MutexKt\n*L\n1#1,912:1\n1#2:913\n3#3,8:914\n3#3,8:923\n3#3,8:932\n3#3,8:941\n3#3,8:958\n3#3,8:977\n3#3,8:986\n10#4:922\n10#4:931\n10#4:940\n10#4:949\n10#4:966\n10#4:985\n10#4:994\n116#5,8:950\n125#5,2:967\n116#5,8:969\n125#5,2:995\n116#5,11:997\n116#5,11:1008\n116#5,11:1019\n116#5,10:1030\n*S KotlinDebug\n*F\n+ 1 LRUQueryCache.kt\norg/gnit/lucenekmp/search/LRUQueryCache\n*L\n285#1:914,8\n286#1:923,8\n314#1:932,8\n315#1:941,8\n331#1:958,8\n386#1:977,8\n387#1:986,8\n285#1:922\n286#1:931\n314#1:940\n315#1:949\n331#1:966\n386#1:985\n387#1:994\n318#1:950,8\n318#1:967,2\n378#1:969,8\n378#1:995,2\n398#1:997,11\n419#1:1008,11\n433#1:1019,11\n492#1:1030,10\n*E\n"})
public class LRUQueryCache
implements QueryCache,
Accountable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int maxSize;
    private final long maxRamBytesUsed;
    @NotNull
    private final Function1<LeafReaderContext, Boolean> leavesToCache;
    @NotNull
    private final Map<Query, Query> uniqueQueries;
    @NotNull
    private final Set<Query> mostRecentlyUsedQueries;
    @NotNull
    private final Map<IndexReader.CacheKey, LeafCache> cache;
    @NotNull
    private final Mutex cacheMutex;
    private final float skipCacheFactor;
    @NotNull
    private final AtomicLong hitCount;
    @NotNull
    private final AtomicLong missCount;
    private volatile long ramBytesUsed;
    private volatile long cacheCount;
    private volatile long cacheSize;

    public LRUQueryCache(int maxSize, long maxRamBytesUsed, @NotNull Function1<? super LeafReaderContext, Boolean> leavesToCache, float skipCacheFactor) {
        Intrinsics.checkNotNullParameter(leavesToCache, (String)"leavesToCache");
        this.maxSize = maxSize;
        this.maxRamBytesUsed = maxRamBytesUsed;
        this.leavesToCache = leavesToCache;
        if (!(skipCacheFactor >= 1.0f)) {
            boolean bl = false;
            String string = "skipCacheFactor must be no less than 1, get " + skipCacheFactor;
            throw new IllegalArgumentException(string.toString());
        }
        this.skipCacheFactor = skipCacheFactor;
        this.uniqueQueries = new LinkedHashMap();
        this.mostRecentlyUsedQueries = this.uniqueQueries.keySet();
        this.cache = new LinkedHashMap();
        this.cacheMutex = MutexKt.Mutex$default((boolean)false, (int)1, null);
        this.ramBytesUsed = 0L;
        this.hitCount = new AtomicLong(0L);
        this.missCount = new AtomicLong(0L);
    }

    public /* synthetic */ LRUQueryCache(int n, long l, Function1 function1, float f, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            function1 = LRUQueryCacheKt.minSegmentSizePredicate(10000);
        }
        if ((n2 & 8) != 0) {
            f = 10.0f;
        }
        this(n, l, function1, f);
    }

    private static /* synthetic */ void getHitCount$annotations() {
    }

    private static /* synthetic */ void getMissCount$annotations() {
    }

    public final long getCacheCount() {
        return this.cacheCount;
    }

    public final long getCacheSize() {
        return this.cacheSize;
    }

    protected final void onHit(@NotNull Object readerCoreKey, @NotNull Query query) {
        Intrinsics.checkNotNullParameter((Object)readerCoreKey, (String)"readerCoreKey");
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        AtomicsKt.incrementAndFetch((AtomicLong)this.hitCount);
    }

    protected final void onMiss(@NotNull Object readerCoreKey, @NotNull Query query) {
        Intrinsics.checkNotNullParameter((Object)readerCoreKey, (String)"readerCoreKey");
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        AtomicsKt.incrementAndFetch((AtomicLong)this.missCount);
    }

    protected final void onQueryCache(@NotNull Query query, long ramBytesUsed) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        this.ramBytesUsed += ramBytesUsed;
    }

    protected final void onQueryEviction(@NotNull Query query, long ramBytesUsed) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        this.ramBytesUsed -= ramBytesUsed;
    }

    protected final void onDocIdSetCache(@NotNull Object readerCoreKey, long ramBytesUsed) {
        Intrinsics.checkNotNullParameter((Object)readerCoreKey, (String)"readerCoreKey");
        ++this.cacheSize;
        ++this.cacheCount;
        this.ramBytesUsed += ramBytesUsed;
    }

    protected final void onDocIdSetEviction(@NotNull Object readerCoreKey, int numEntries, long sumRamBytesUsed) {
        Intrinsics.checkNotNullParameter((Object)readerCoreKey, (String)"readerCoreKey");
        this.ramBytesUsed -= sumRamBytesUsed;
        this.cacheSize -= (long)numEntries;
    }

    protected final void onClear() {
        this.ramBytesUsed = 0L;
        this.cacheSize = 0L;
    }

    public final boolean requiresEviction() {
        int size2 = this.mostRecentlyUsedQueries.size();
        return size2 == 0 ? false : size2 > this.maxSize || this.ramBytesUsed() > this.maxRamBytesUsed;
    }

    @Nullable
    public final CacheAndCount get(@NotNull Query key, @NotNull IndexReader.CacheHelper cacheHelper2) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)cacheHelper2, (String)"cacheHelper");
        boolean condition$iv = !(key instanceof BoostQuery);
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean $i$a$-assert-AssertKt$assert$22 = false;
            String $i$a$-assert-AssertKt$assert$22 = "assertion failed";
            throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$22);
        }
        condition$iv = !(key instanceof ConstantScoreQuery);
        $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean $i$a$-assert-AssertKt$assert$32 = false;
            String $i$a$-assert-AssertKt$assert$32 = "assertion failed";
            throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$32);
        }
        IndexReader.CacheKey readerKey = cacheHelper2.getKey();
        LeafCache leafCache = this.cache.get(readerKey);
        if (leafCache == null) {
            this.onMiss(readerKey, key);
            return null;
        }
        Query singleton = this.uniqueQueries.get(key);
        if (singleton == null) {
            this.onMiss(readerKey, key);
            return null;
        }
        CacheAndCount cached = leafCache.get(singleton);
        if (cached == null) {
            this.onMiss(readerKey, singleton);
        } else {
            this.onHit(readerKey, singleton);
        }
        return cached;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final Object putIfAbsent(Query query, CacheAndCount cached, IndexReader.CacheHelper cacheHelper, Continuation<? super Unit> $completion) {
        if (!($completion instanceof putIfAbsent.1)) ** GOTO lbl-1000
        var20_5 = $completion;
        if ((var20_5.label & -2147483648) != 0) {
            var20_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                Object L$7;
                Object L$8;
                int I$0;
                int I$1;
                /* synthetic */ Object result;
                final /* synthetic */ LRUQueryCache this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return LRUQueryCache.access$putIfAbsent(this.this$0, null, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var21_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                query = new Ref.ObjectRef();
                query.element = query;
                condition$iv = query.element instanceof BoostQuery == false;
                $i$f$assert = false;
                if (_Assertions.ENABLED && !condition$iv) {
                    $i$a$-assert-AssertKt$assert$1 = false;
                    $i$a$-assert-AssertKt$assert$1 = "assertion failed";
                    throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$1);
                }
                condition$iv = query.element instanceof ConstantScoreQuery == false;
                $i$f$assert = false;
                if (_Assertions.ENABLED && !condition$iv) {
                    $i$a$-assert-AssertKt$assert$1 = false;
                    $i$a$-assert-AssertKt$assert$1 = "assertion failed";
                    throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$1);
                }
                $this$withLock_u24default$iv = this.cacheMutex;
                owner$iv = null;
                $i$f$withLock = 0;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)query);
                $continuation.L$1 = cached;
                $continuation.L$2 = cacheHelper;
                $continuation.L$3 = query;
                $continuation.L$4 = $this$withLock_u24default$iv;
                $continuation.I$0 = $i$f$withLock;
                $continuation.label = 1;
                v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$continuation);
                if (v0 == var21_7) {
                    return var21_7;
                }
                ** GOTO lbl51
            }
            case 1: {
                $i$f$withLock = $continuation.I$0;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$4;
                query = (Ref.ObjectRef)$continuation.L$3;
                cacheHelper = (IndexReader.CacheHelper)$continuation.L$2;
                cached = (CacheAndCount)$continuation.L$1;
                query = (Query)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl51:
                // 3 sources

                $i$a$-withLock$default-LRUQueryCache$putIfAbsent$2 = 0;
                singleton = this.uniqueQueries.putIfAbsent((Query)query.element, (Query)query.element);
                if (singleton == null) {
                    this.onQueryCache((Query)query.element, org.gnit.lucenekmp.search.LRUQueryCache$Companion.access$getRamBytesUsed(LRUQueryCache.Companion, (Query)query.element));
                } else {
                    query.element = singleton;
                }
                key = cacheHelper.getKey();
                leafCache = this.cache.get(key);
                if (leafCache != null) ** GOTO lbl103
                leafCache = new LeafCache(key);
                previous = this.cache.put(key, leafCache);
                this.ramBytesUsed += 16L;
                condition$iv = previous == null;
                $i$f$assert = false;
                if (_Assertions.ENABLED && !condition$iv) {
                    $i$a$-assert-AssertKt$assert$1 = false;
                    var16_30 = "assertion failed";
                    throw new AssertionError((Object)var16_30);
                }
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)query);
                $continuation.L$1 = cached;
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)cacheHelper);
                $continuation.L$3 = query;
                $continuation.L$4 = $this$withLock_u24default$iv;
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)singleton);
                $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)key);
                $continuation.L$7 = leafCache;
                $continuation.L$8 = SpillingKt.nullOutSpilledVariable((Object)previous);
                $continuation.I$0 = $i$f$withLock;
                $continuation.I$1 = $i$a$-withLock$default-LRUQueryCache$putIfAbsent$2;
                $continuation.label = 2;
                v1 = cacheHelper.addClosedListener((IndexReader.ClosedListener)LambdaMetafactory.metafactory(null, null, null, (Lorg/gnit/lucenekmp/index/IndexReader$CacheKey;)V, putIfAbsent$lambda$2$lambda$1(org.gnit.lucenekmp.search.LRUQueryCache java.lang.Object ), (Lorg/gnit/lucenekmp/index/IndexReader$CacheKey;)V)((LRUQueryCache)this), (Continuation<? super Unit>)$continuation);
                ** if (v1 != var21_7) goto lbl85
lbl84:
                // 1 sources

                return var21_7;
lbl85:
                // 1 sources

                ** GOTO lbl103
            }
            case 2: {
                $i$a$-withLock$default-LRUQueryCache$putIfAbsent$2 = $continuation.I$1;
                $i$f$withLock = $continuation.I$0;
                previous = (LeafCache)$continuation.L$8;
                leafCache = (LeafCache)$continuation.L$7;
                key = (IndexReader.CacheKey)$continuation.L$6;
                singleton = (Query)$continuation.L$5;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$4;
                query = (Ref.ObjectRef)$continuation.L$3;
                cacheHelper = (IndexReader.CacheHelper)$continuation.L$2;
                cached = (CacheAndCount)$continuation.L$1;
                query = (Query)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl103:
                    // 3 sources

                    leafCache.putIfAbsent((Query)query.element, cached);
                    this.evictIfNecessary();
                    var17_31 = Unit.INSTANCE;
                }
                catch (Throwable var18_32) {
                    throw var18_32;
                }
                finally {
                    $this$withLock_u24default$iv.unlock(owner$iv);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void evictIfNecessary() {
        if (this.requiresEviction()) {
            Iterator<Query> iterator2 = this.mostRecentlyUsedQueries.iterator();
            do {
                Query query = iterator2.next();
                int size2 = this.mostRecentlyUsedQueries.size();
                iterator2.remove();
                if (size2 == this.mostRecentlyUsedQueries.size()) {
                    throw new ConcurrentModificationException("Removal from the cache failed! This is probably due to a query which has been modified after having been put into  the cache or a badly implemented clone(). Query class: [" + Reflection.getOrCreateKotlinClass(query.getClass()) + "], query: [" + query + "]");
                }
                this.onEviction(query);
            } while (iterator2.hasNext() && this.requiresEviction());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Nullable
    public final Object clearCoreCacheKey(@NotNull Object coreKey, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof clearCoreCacheKey.1)) ** GOTO lbl-1000
        var15_3 = $completion;
        if ((var15_3.label & -2147483648) != 0) {
            var15_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ LRUQueryCache this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.clearCoreCacheKey(null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var16_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$withLock_u24default$iv = this.cacheMutex;
                owner$iv = null;
                $i$f$withLock = 0;
                $continuation.L$0 = coreKey;
                $continuation.L$1 = $this$withLock_u24default$iv;
                $continuation.I$0 = $i$f$withLock;
                $continuation.label = 1;
                v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$continuation);
                if (v0 == var16_5) {
                    return var16_5;
                }
                ** GOTO lbl30
            }
            case 1: {
                $i$f$withLock = $continuation.I$0;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$1;
                coreKey = $continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl30:
                // 2 sources

                try {
                    $i$a$-withLock$default-LRUQueryCache$clearCoreCacheKey$2 = false;
                    leafCache = (LeafCache)TypeIntrinsics.asMutableMap(this.cache).remove(coreKey);
                    if (leafCache != null) {
                        this.ramBytesUsed -= 16L;
                        numEntries = leafCache.getCache().size();
                        if (numEntries > 0) {
                            this.onDocIdSetEviction(coreKey, numEntries, leafCache.getRamBytesUsed());
                        } else {
                            condition$iv = numEntries == 0;
                            $i$f$assert = false;
                            if (_Assertions.ENABLED && !condition$iv) {
                                $i$a$-assert-AssertKt$assert$1 = false;
                                $i$a$-assert-AssertKt$assert$1 = "assertion failed";
                                throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$1);
                            }
                            condition$iv = leafCache.getRamBytesUsed() == 0L;
                            $i$f$assert = false;
                            if (_Assertions.ENABLED && !condition$iv) {
                                $i$a$-assert-AssertKt$assert$1 = false;
                                var11_18 = "assertion failed";
                                throw new AssertionError((Object)var11_18);
                            }
                        }
                    }
                    var12_19 = Unit.INSTANCE;
                }
                finally {
                    $this$withLock_u24default$iv.unlock(owner$iv);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Nullable
    public final Object clearQuery(@NotNull Query query, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof clearQuery.1)) ** GOTO lbl-1000
        var11_3 = $completion;
        if ((var11_3.label & -2147483648) != 0) {
            var11_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ LRUQueryCache this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.clearQuery(null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var12_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$withLock_u24default$iv = this.cacheMutex;
                owner$iv = null;
                $i$f$withLock = 0;
                $continuation.L$0 = query;
                $continuation.L$1 = $this$withLock_u24default$iv;
                $continuation.I$0 = $i$f$withLock;
                $continuation.label = 1;
                v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$continuation);
                if (v0 == var12_5) {
                    return var12_5;
                }
                ** GOTO lbl30
            }
            case 1: {
                $i$f$withLock = $continuation.I$0;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$1;
                query = (Query)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl30:
                // 2 sources

                try {
                    $i$a$-withLock$default-LRUQueryCache$clearQuery$2 = false;
                    singleton = this.uniqueQueries.remove(query);
                    if (singleton != null) {
                        this.onEviction(singleton);
                    }
                    var8_12 = Unit.INSTANCE;
                }
                finally {
                    $this$withLock_u24default$iv.unlock(owner$iv);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void onEviction(Query singleton) {
        this.onQueryEviction(singleton, LRUQueryCache.Companion.getRamBytesUsed(singleton));
        for (LeafCache leafCache : this.cache.values()) {
            leafCache.remove(singleton);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Nullable
    public final Object clear(@NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof clear.1)) ** GOTO lbl-1000
        var8_2 = $completion;
        if ((var8_2.label & -2147483648) != 0) {
            var8_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ LRUQueryCache this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.clear((Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var9_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$withLock_u24default$iv = this.cacheMutex;
                owner$iv = null;
                $i$f$withLock = 0;
                $continuation.L$0 = $this$withLock_u24default$iv;
                $continuation.I$0 = $i$f$withLock;
                $continuation.label = 1;
                v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$continuation);
                if (v0 == var9_4) {
                    return var9_4;
                }
                ** GOTO lbl28
            }
            case 1: {
                $i$f$withLock = $continuation.I$0;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl28:
                // 2 sources

                try {
                    $i$a$-withLock$default-LRUQueryCache$clear$2 = false;
                    this.cache.clear();
                    this.mostRecentlyUsedQueries.clear();
                    this.onClear();
                    var6_11 = Unit.INSTANCE;
                }
                finally {
                    $this$withLock_u24default$iv.unlock(owner$iv);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Nullable
    public final Object assertConsistent(@NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof assertConsistent.1)) ** GOTO lbl-1000
        var18_2 = $completion;
        if ((var18_2.label & -2147483648) != 0) {
            var18_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ LRUQueryCache this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.assertConsistent((Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var19_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$withLock_u24default$iv = this.cacheMutex;
                owner$iv = null;
                $i$f$withLock = 0;
                $continuation.L$0 = $this$withLock_u24default$iv;
                $continuation.I$0 = $i$f$withLock;
                $continuation.label = 1;
                v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$continuation);
                if (v0 == var19_4) {
                    return var19_4;
                }
                ** GOTO lbl28
            }
            case 1: {
                $i$f$withLock = $continuation.I$0;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl28:
                // 2 sources

                try {
                    $i$a$-withLock$default-LRUQueryCache$assertConsistent$2 = false;
                    if (this.requiresEviction()) {
                        throw new AssertionError((Object)("requires evictions: size=" + this.mostRecentlyUsedQueries.size() + ", maxSize=" + this.maxSize + ", ramBytesUsed=" + this.ramBytesUsed() + ", maxRamBytesUsed=" + this.maxRamBytesUsed));
                    }
                    for (LeafCache leafCache : this.cache.values()) {
                        keys = new LinkedHashSet<E>();
                        keys.addAll((Collection)leafCache.getCache().keySet());
                        keys.removeAll((Collection)this.mostRecentlyUsedQueries);
                        if (!keys.isEmpty()) {
                            throw new AssertionError((Object)("One leaf cache contains more keys than the top-level cache: " + keys));
                        }
                    }
                    recomputedRamBytesUsed = 16L * (long)this.cache.size();
                    for (Query query : this.mostRecentlyUsedQueries) {
                        recomputedRamBytesUsed += org.gnit.lucenekmp.search.LRUQueryCache$Companion.access$getRamBytesUsed(LRUQueryCache.Companion, query);
                    }
                    for (LeafCache leafCache : this.cache.values()) {
                        recomputedRamBytesUsed += 16L * (long)leafCache.getCache().size();
                        for (CacheAndCount cached : leafCache.getCache().values()) {
                            recomputedRamBytesUsed += cached.ramBytesUsed();
                        }
                    }
                    if (recomputedRamBytesUsed != this.ramBytesUsed) {
                        throw new AssertionError((Object)("ramBytesUsed mismatch : " + this.ramBytesUsed + " != " + recomputedRamBytesUsed));
                    }
                    recomputedCacheSize = 0L;
                    for (LeafCache leafCache : this.cache.values()) {
                        recomputedCacheSize += (long)leafCache.getCache().size();
                    }
                    if (recomputedCacheSize != this.cacheSize) {
                        throw new AssertionError((Object)("cacheSize mismatch : " + this.cacheSize + " != " + recomputedCacheSize));
                    }
                    var16_18 = Unit.INSTANCE;
                }
                finally {
                    $this$withLock_u24default$iv.unlock(owner$iv);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Nullable
    public final Object cachedQueries(@NotNull Continuation<? super List<Query>> $completion) {
        if (!($completion instanceof cachedQueries.1)) ** GOTO lbl-1000
        var8_2 = $completion;
        if ((var8_2.label & -2147483648) != 0) {
            var8_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ LRUQueryCache this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.cachedQueries((Continuation<? super List<Query>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var9_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$withLock_u24default$iv = this.cacheMutex;
                owner$iv = null;
                $i$f$withLock = 0;
                $continuation.L$0 = $this$withLock_u24default$iv;
                $continuation.I$0 = $i$f$withLock;
                $continuation.label = 1;
                v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$continuation);
                if (v0 == var9_4) {
                    return var9_4;
                }
                ** GOTO lbl28
            }
            case 1: {
                $i$f$withLock = $continuation.I$0;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl28:
                // 2 sources

                try {
                    $i$a$-withLock$default-LRUQueryCache$cachedQueries$2 = false;
                    var6_11 = CollectionsKt.toMutableList((Collection)this.mostRecentlyUsedQueries);
                    return var6_11;
                }
                finally {
                    $this$withLock_u24default$iv.unlock(owner$iv);
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    @NotNull
    public Weight doCache(@NotNull Weight weight, @NotNull QueryCachingPolicy policy) {
        Intrinsics.checkNotNullParameter((Object)weight, (String)"weight");
        Intrinsics.checkNotNullParameter((Object)policy, (String)"policy");
        Weight weight2 = weight;
        while (weight2 instanceof CachingWrapperWeight) {
            weight2 = ((CachingWrapperWeight)weight2).getIn();
        }
        return new CachingWrapperWeight(weight2, policy);
    }

    @Override
    public long ramBytesUsed() {
        return this.ramBytesUsed;
    }

    @Override
    @NotNull
    public Collection<Accountable> getChildResources() {
        return (Collection)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Collection<Accountable>>, Object>(this, null){
            Object L$0;
            Object L$1;
            int I$0;
            int label;
            final /* synthetic */ LRUQueryCache this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var8_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        var2_3 = LRUQueryCache.access$getCacheMutex$p(this.this$0);
                        var4_4 = this.this$0;
                        owner$iv = null;
                        $i$f$withLock = 0;
                        this.L$0 = $this$withLock_u24default$iv;
                        this.L$1 = var4_4;
                        this.I$0 = $i$f$withLock;
                        this.label = 1;
                        v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)this);
                        if (v0 == var8_2) {
                            return var8_2;
                        }
                        ** GOTO lbl24
                    }
                    case 1: {
                        $i$f$withLock = this.I$0;
                        var4_4 = (LRUQueryCache)this.L$1;
                        owner$iv = null;
                        $this$withLock_u24default$iv = (Mutex)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl24:
                        // 2 sources

                        try {
                            $i$a$-withLock$default-LRUQueryCache$childResources$1$1 = false;
                            var7_10 = Accountables.INSTANCE.namedAccountables("segment", LRUQueryCache.access$getCache$p(var4_4));
                        }
                        finally {
                            $this$withLock_u24default$iv.unlock(owner$iv);
                        }
                        return var7_10;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Collection<Accountable>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    @NotNull
    protected final CacheAndCount cacheImpl(@NotNull BulkScorer scorer2, int maxDoc) throws IOException {
        Intrinsics.checkNotNullParameter((Object)scorer2, (String)"scorer");
        return scorer2.cost() * (long)100 >= (long)maxDoc ? LRUQueryCache.Companion.cacheIntoBitSet(scorer2, maxDoc) : LRUQueryCache.Companion.cacheIntoRoaringDocIdSet(scorer2, maxDoc);
    }

    public final long getTotalCount() {
        return this.getHitCount() + this.getMissCount();
    }

    public final long getHitCount() {
        return this.hitCount.get();
    }

    public final long getMissCount() {
        return this.missCount.get();
    }

    public final long getEvictionCount() {
        return this.cacheCount - this.cacheSize;
    }

    private static final void putIfAbsent$lambda$2$lambda$1(LRUQueryCache this$0, Object coreKey) {
        Intrinsics.checkNotNullParameter((Object)coreKey, (String)"coreKey");
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, coreKey, null){
            int label;
            final /* synthetic */ LRUQueryCache this$0;
            final /* synthetic */ Object $coreKey;
            {
                this.this$0 = $receiver;
                this.$coreKey = $coreKey;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = this.this$0.clearCoreCacheKey(this.$coreKey, (Continuation<? super Unit>)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    public static final /* synthetic */ Object access$putIfAbsent(LRUQueryCache $this, Query query, CacheAndCount cached, IndexReader.CacheHelper cacheHelper2, Continuation $completion) {
        return $this.putIfAbsent(query, cached, cacheHelper2, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Map access$getCache$p(LRUQueryCache $this) {
        return $this.cache;
    }

    public static final /* synthetic */ float access$getSkipCacheFactor$p(LRUQueryCache $this) {
        return $this.skipCacheFactor;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\u0004\u001a\u00020\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/gnit/lucenekmp/search/LRUQueryCache$CacheAndCount;", "Lorg/gnit/lucenekmp/util/Accountable;", "cache", "Lorg/gnit/lucenekmp/search/DocIdSet;", "count", "", "<init>", "(Lorg/gnit/lucenekmp/search/DocIdSet;I)V", "iterator", "Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "ramBytesUsed", "", "Companion", "core"})
    public static final class CacheAndCount
    implements Accountable {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final DocIdSet cache;
        private final int count;
        @NotNull
        private static final CacheAndCount EMPTY = new CacheAndCount(DocIdSet.Companion.getEMPTY(), 0);
        private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.Companion.shallowSizeOfInstance(Reflection.getOrCreateKotlinClass(CacheAndCount.class));

        public CacheAndCount(@NotNull DocIdSet cache, int count) {
            Intrinsics.checkNotNullParameter((Object)cache, (String)"cache");
            this.cache = cache;
            this.count = count;
        }

        @NotNull
        public final DocIdSetIterator iterator() throws IOException {
            return this.cache.iterator();
        }

        public final int count() {
            return this.count;
        }

        @Override
        public long ramBytesUsed() {
            return BASE_RAM_BYTES_USED + this.cache.ramBytesUsed();
        }

        @Override
        @NotNull
        public Collection<Accountable> getChildResources() {
            return Accountable.super.getChildResources();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/gnit/lucenekmp/search/LRUQueryCache$CacheAndCount$Companion;", "", "<init>", "()V", "EMPTY", "Lorg/gnit/lucenekmp/search/LRUQueryCache$CacheAndCount;", "getEMPTY", "()Lorg/gnit/lucenekmp/search/LRUQueryCache$CacheAndCount;", "BASE_RAM_BYTES_USED", "", "core"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final CacheAndCount getEMPTY() {
                return EMPTY;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0014J\u000e\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u0012J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u0012H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\n\n\u0002\u0010\u000e\u0012\u0004\b\f\u0010\r\u00a8\u0006\u001e"}, d2={"Lorg/gnit/lucenekmp/search/LRUQueryCache$CachingWrapperWeight;", "Lorg/gnit/lucenekmp/search/ConstantScoreWeight;", "in", "Lorg/gnit/lucenekmp/search/Weight;", "policy", "Lorg/gnit/lucenekmp/search/QueryCachingPolicy;", "<init>", "(Lorg/gnit/lucenekmp/search/LRUQueryCache;Lorg/gnit/lucenekmp/search/Weight;Lorg/gnit/lucenekmp/search/QueryCachingPolicy;)V", "getIn", "()Lorg/gnit/lucenekmp/search/Weight;", "used", "Lkotlin/concurrent/atomics/AtomicBoolean;", "getUsed$annotations", "()V", "Ljava/util/concurrent/atomic/AtomicBoolean;", "matches", "Lorg/gnit/lucenekmp/search/Matches;", "context", "Lorg/gnit/lucenekmp/index/LeafReaderContext;", "doc", "", "cacheEntryHasReasonableWorstCaseSize", "", "maxDoc", "shouldCache", "scorerSupplier", "Lorg/gnit/lucenekmp/search/ScorerSupplier;", "count", "isCacheable", "ctx", "core"})
    private final class CachingWrapperWeight
    extends ConstantScoreWeight {
        @NotNull
        private final Weight in;
        @NotNull
        private final QueryCachingPolicy policy;
        @NotNull
        private final AtomicBoolean used;

        public CachingWrapperWeight(@NotNull Weight in, QueryCachingPolicy policy) {
            Intrinsics.checkNotNullParameter((Object)in, (String)"in");
            Intrinsics.checkNotNullParameter((Object)policy, (String)"policy");
            super(in.getQuery(), 1.0f);
            this.in = in;
            this.policy = policy;
            this.used = new AtomicBoolean(false);
        }

        @NotNull
        public final Weight getIn() {
            return this.in;
        }

        private static /* synthetic */ void getUsed$annotations() {
        }

        @Override
        @Nullable
        public Matches matches(@NotNull LeafReaderContext context, int doc) throws IOException {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return this.in.matches(context, doc);
        }

        public final boolean cacheEntryHasReasonableWorstCaseSize(int maxDoc) {
            long worstCaseRamUsage = maxDoc / 8;
            long totalRamAvailable = LRUQueryCache.this.maxRamBytesUsed;
            return worstCaseRamUsage * (long)5 < totalRamAvailable;
        }

        public final boolean shouldCache(@NotNull LeafReaderContext context) throws IOException {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return this.cacheEntryHasReasonableWorstCaseSize(ReaderUtil.INSTANCE.getTopLevelContext(context).reader().maxDoc()) && (Boolean)LRUQueryCache.this.leavesToCache.invoke((Object)context) != false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public ScorerSupplier scorerSupplier(@NotNull LeafReaderContext context) throws IOException {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (this.used.compareAndSet(false, true)) {
                this.policy.onUse(this.getQuery());
            }
            if (!this.in.isCacheable(context)) {
                return this.in.scorerSupplier(context);
            }
            if (!this.shouldCache(context)) {
                return this.in.scorerSupplier(context);
            }
            IndexReader.CacheHelper cacheHelper2 = context.reader().getCoreCacheHelper();
            if (cacheHelper2 == null) {
                return this.in.scorerSupplier(context);
            }
            if (!Mutex.DefaultImpls.tryLock$default((Mutex)LRUQueryCache.this.cacheMutex, null, (int)1, null)) {
                return this.in.scorerSupplier(context);
            }
            CacheAndCount cached = null;
            try {
                cached = LRUQueryCache.this.get(this.in.getQuery(), cacheHelper2);
            }
            finally {
                Mutex.DefaultImpls.unlock$default((Mutex)LRUQueryCache.this.cacheMutex, null, (int)1, null);
            }
            int maxDoc = context.reader().maxDoc();
            if (cached == null) {
                if (this.policy.shouldCache(this.in.getQuery())) {
                    ScorerSupplier supplier = this.in.scorerSupplier(context);
                    if (supplier == null) {
                        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(LRUQueryCache.this, this, cacheHelper2, null){
                            int label;
                            final /* synthetic */ LRUQueryCache this$0;
                            final /* synthetic */ CachingWrapperWeight this$1;
                            final /* synthetic */ IndexReader.CacheHelper $cacheHelper;
                            {
                                this.this$0 = $receiver;
                                this.this$1 = $receiver2;
                                this.$cacheHelper = $cacheHelper;
                                super(2, $completion);
                            }

                            /*
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object $result) {
                                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.label = 1;
                                        Object object2 = LRUQueryCache.access$putIfAbsent(this.this$0, this.this$1.getIn().getQuery(), CacheAndCount.Companion.getEMPTY(), this.$cacheHelper, (Continuation)this);
                                        if (object2 != object) return Unit.INSTANCE;
                                        return object;
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object2 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)1, null);
                        return null;
                    }
                    long cost = supplier.cost();
                    ScoreMode scoreMode = ScoreMode.COMPLETE_NO_SCORES;
                    return new ConstantScoreScorerSupplier(maxDoc, cost, LRUQueryCache.this, supplier, this, cacheHelper2, scoreMode){
                        final /* synthetic */ int $maxDoc;
                        final /* synthetic */ long $cost;
                        final /* synthetic */ LRUQueryCache this$0;
                        final /* synthetic */ ScorerSupplier $supplier;
                        final /* synthetic */ CachingWrapperWeight this$1;
                        final /* synthetic */ IndexReader.CacheHelper $cacheHelper;
                        {
                            this.$maxDoc = $maxDoc;
                            this.$cost = $cost;
                            this.this$0 = $receiver;
                            this.$supplier = $supplier;
                            this.this$1 = $receiver2;
                            this.$cacheHelper = $cacheHelper;
                            super(0.0f, $super_call_param$1, $maxDoc);
                        }

                        public DocIdSetIterator iterator(long leadCost) throws IOException {
                            if ((float)this.$cost / LRUQueryCache.access$getSkipCacheFactor$p(this.this$0) > (float)leadCost) {
                                return this.$supplier.get(leadCost).iterator();
                            }
                            BulkScorer bulkScorer = this.$supplier.bulkScorer();
                            Intrinsics.checkNotNull((Object)bulkScorer);
                            CacheAndCount cached = this.this$0.cacheImpl(bulkScorer, this.$maxDoc);
                            BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.this$1, cached, this.$cacheHelper, null){
                                int label;
                                final /* synthetic */ LRUQueryCache this$0;
                                final /* synthetic */ CachingWrapperWeight this$1;
                                final /* synthetic */ CacheAndCount $cached;
                                final /* synthetic */ IndexReader.CacheHelper $cacheHelper;
                                {
                                    this.this$0 = $receiver;
                                    this.this$1 = $receiver2;
                                    this.$cached = $cached;
                                    this.$cacheHelper = $cacheHelper;
                                    super(2, $completion);
                                }

                                /*
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                public final Object invokeSuspend(Object $result) {
                                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            this.label = 1;
                                            Object object2 = LRUQueryCache.access$putIfAbsent(this.this$0, this.this$1.getIn().getQuery(), this.$cached, this.$cacheHelper, (Continuation)this);
                                            if (object2 != object) return Unit.INSTANCE;
                                            return object;
                                        }
                                        case 1: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            Object object2 = $result;
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (int)1, null);
                            DocIdSetIterator disi = cached.iterator();
                            if (disi == null) {
                                disi = DocIdSetIterator.Companion.empty();
                            }
                            return disi;
                        }

                        public long cost() {
                            return this.$cost;
                        }
                    };
                }
                return this.in.scorerSupplier(context);
            }
            if (cached == CacheAndCount.Companion.getEMPTY()) {
                return null;
            }
            DocIdSetIterator disi = cached.iterator();
            if (disi == null) {
                return null;
            }
            return ConstantScoreScorerSupplier.Companion.fromIterator(disi, 0.0f, ScoreMode.COMPLETE_NO_SCORES, maxDoc);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int count(@NotNull LeafReaderContext context) throws IOException {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (context.reader().hasDeletions()) {
                return this.in.count(context);
            }
            if (this.used.compareAndSet(false, true)) {
                this.policy.onUse(this.getQuery());
            }
            if (!this.in.isCacheable(context)) {
                return this.in.count(context);
            }
            if (!this.shouldCache(context)) {
                return this.in.count(context);
            }
            IndexReader.CacheHelper cacheHelper2 = context.reader().getCoreCacheHelper();
            if (cacheHelper2 == null) {
                return this.in.count(context);
            }
            if (!Mutex.DefaultImpls.tryLock$default((Mutex)LRUQueryCache.this.cacheMutex, null, (int)1, null)) {
                return this.in.count(context);
            }
            CacheAndCount cached = null;
            try {
                cached = LRUQueryCache.this.get(this.in.getQuery(), cacheHelper2);
            }
            finally {
                Mutex.DefaultImpls.unlock$default((Mutex)LRUQueryCache.this.cacheMutex, null, (int)1, null);
            }
            if (cached != null) {
                return cached.count();
            }
            return this.in.count(context);
        }

        @Override
        public boolean isCacheable(@NotNull LeafReaderContext ctx) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            return this.in.isCacheable(ctx);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/gnit/lucenekmp/search/LRUQueryCache$Companion;", "", "<init>", "()V", "getRamBytesUsed", "", "query", "Lorg/gnit/lucenekmp/search/Query;", "cacheIntoBitSet", "Lorg/gnit/lucenekmp/search/LRUQueryCache$CacheAndCount;", "scorer", "Lorg/gnit/lucenekmp/search/BulkScorer;", "maxDoc", "", "cacheIntoRoaringDocIdSet", "core"})
    public static final class Companion {
        private Companion() {
        }

        private final long getRamBytesUsed(Query query) {
            return 24L + (query instanceof Accountable ? ((Accountable)((Object)query)).ramBytesUsed() : 1024L);
        }

        private final CacheAndCount cacheIntoBitSet(BulkScorer scorer2, int maxDoc) throws IOException {
            FixedBitSet bitSet = new FixedBitSet(maxDoc);
            int[] count = new int[1];
            scorer2.score(new LeafCollector(count, bitSet){
                final /* synthetic */ int[] $count;
                final /* synthetic */ FixedBitSet $bitSet;
                {
                    this.$count = $count;
                    this.$bitSet = $bitSet;
                }

                public Scorable getScorer() {
                    throw new UnsupportedOperationException("Scorer should not be set in this collector");
                }

                public void setScorer(Scorable scorer2) {
                }

                public void collect(int doc) throws IOException {
                    int[] nArray = this.$count;
                    int n = nArray[0];
                    nArray[0] = n + 1;
                    this.$bitSet.set(doc);
                }

                public void collect(DocIdStream stream) throws IOException {
                    LeafCollector.super.collect(stream);
                }

                public DocIdSetIterator competitiveIterator() throws IOException {
                    return LeafCollector.super.competitiveIterator();
                }

                public void finish() throws IOException {
                    LeafCollector.super.finish();
                }
            }, null, 0, Integer.MAX_VALUE);
            return new CacheAndCount(new BitDocIdSet(bitSet, count[0]), count[0]);
        }

        private final CacheAndCount cacheIntoRoaringDocIdSet(BulkScorer scorer2, int maxDoc) throws IOException {
            RoaringDocIdSet.Builder builder = new RoaringDocIdSet.Builder(maxDoc);
            scorer2.score(new LeafCollector(builder){
                final /* synthetic */ RoaringDocIdSet.Builder $builder;
                {
                    this.$builder = $builder;
                }

                public Scorable getScorer() {
                    throw new UnsupportedOperationException("Scorer should not be set in this collector");
                }

                public void setScorer(Scorable scorer2) {
                }

                public void collect(int doc) throws IOException {
                    this.$builder.add(doc);
                }

                public void collect(DocIdStream stream) throws IOException {
                    LeafCollector.super.collect(stream);
                }

                public DocIdSetIterator competitiveIterator() throws IOException {
                    return LeafCollector.super.competitiveIterator();
                }

                public void finish() throws IOException {
                    LeafCollector.super.finish();
                }
            }, null, 0, Integer.MAX_VALUE);
            RoaringDocIdSet cache = builder.build();
            return new CacheAndCount(cache, cache.cardinality());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u0014\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u0015\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0016\u001a\u00020\bJ\u0016\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\tJ\u000e\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\bJ\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001a"}, d2={"Lorg/gnit/lucenekmp/search/LRUQueryCache$LeafCache;", "Lorg/gnit/lucenekmp/util/Accountable;", "key", "", "<init>", "(Lorg/gnit/lucenekmp/search/LRUQueryCache;Ljava/lang/Object;)V", "cache", "", "Lorg/gnit/lucenekmp/search/Query;", "Lorg/gnit/lucenekmp/search/LRUQueryCache$CacheAndCount;", "getCache", "()Ljava/util/Map;", "ramBytesUsed", "", "getRamBytesUsed", "()J", "setRamBytesUsed", "(J)V", "onDocIdSetCache", "", "onDocIdSetEviction", "get", "query", "putIfAbsent", "cached", "remove", "core"})
    @SourceDebugExtension(value={"SMAP\nLRUQueryCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LRUQueryCache.kt\norg/gnit/lucenekmp/search/LRUQueryCache$LeafCache\n+ 2 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 3 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n*L\n1#1,912:1\n3#2,8:913\n3#2,8:922\n3#2,8:931\n3#2,8:940\n3#2,8:949\n3#2,8:958\n10#3:921\n10#3:930\n10#3:939\n10#3:948\n10#3:957\n10#3:966\n*S KotlinDebug\n*F\n+ 1 LRUQueryCache.kt\norg/gnit/lucenekmp/search/LRUQueryCache$LeafCache\n*L\n607#1:913,8\n608#1:922,8\n614#1:931,8\n615#1:940,8\n624#1:949,8\n625#1:958,8\n607#1:921\n608#1:930\n614#1:939\n615#1:948\n624#1:957\n625#1:966\n*E\n"})
    private final class LeafCache
    implements Accountable {
        @NotNull
        private final Object key;
        @NotNull
        private final Map<Query, CacheAndCount> cache;
        private volatile long ramBytesUsed;

        public LeafCache(Object key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            this.key = key;
            this.cache = new LinkedHashMap();
        }

        @NotNull
        public final Map<Query, CacheAndCount> getCache() {
            return this.cache;
        }

        public final long getRamBytesUsed() {
            return this.ramBytesUsed;
        }

        public final void setRamBytesUsed(long l) {
            this.ramBytesUsed = l;
        }

        public final void onDocIdSetCache(long ramBytesUsed) {
            this.ramBytesUsed += ramBytesUsed;
            LRUQueryCache.this.onDocIdSetCache(this.key, ramBytesUsed);
        }

        public final void onDocIdSetEviction(long ramBytesUsed) {
            this.ramBytesUsed -= ramBytesUsed;
            LRUQueryCache.this.onDocIdSetEviction(this.key, 1, ramBytesUsed);
        }

        @Nullable
        public final CacheAndCount get(@NotNull Query query) {
            Intrinsics.checkNotNullParameter((Object)query, (String)"query");
            boolean condition$iv = !(query instanceof BoostQuery);
            boolean $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv) {
                boolean $i$a$-assert-AssertKt$assert$22 = false;
                String $i$a$-assert-AssertKt$assert$22 = "assertion failed";
                throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$22);
            }
            condition$iv = !(query instanceof ConstantScoreQuery);
            $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv) {
                boolean bl = false;
                String string = "assertion failed";
                throw new AssertionError((Object)string);
            }
            return this.cache.get(query);
        }

        public final void putIfAbsent(@NotNull Query query, @NotNull CacheAndCount cached) {
            Intrinsics.checkNotNullParameter((Object)query, (String)"query");
            Intrinsics.checkNotNullParameter((Object)cached, (String)"cached");
            boolean condition$iv = !(query instanceof BoostQuery);
            boolean $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv) {
                boolean $i$a$-assert-AssertKt$assert$22 = false;
                String $i$a$-assert-AssertKt$assert$22 = "assertion failed";
                throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$22);
            }
            condition$iv = !(query instanceof ConstantScoreQuery);
            $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv) {
                boolean bl = false;
                String string = "assertion failed";
                throw new AssertionError((Object)string);
            }
            if (this.cache.putIfAbsent(query, cached) == null) {
                this.onDocIdSetCache(16L + cached.ramBytesUsed());
            }
        }

        public final void remove(@NotNull Query query) {
            Intrinsics.checkNotNullParameter((Object)query, (String)"query");
            boolean condition$iv = !(query instanceof BoostQuery);
            boolean $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv) {
                boolean $i$a$-assert-AssertKt$assert$22 = false;
                String $i$a$-assert-AssertKt$assert$22 = "assertion failed";
                throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$22);
            }
            condition$iv = !(query instanceof ConstantScoreQuery);
            $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv) {
                boolean bl = false;
                String string = "assertion failed";
                throw new AssertionError((Object)string);
            }
            CacheAndCount removed = this.cache.remove(query);
            if (removed != null) {
                this.onDocIdSetEviction(16L + removed.ramBytesUsed());
            }
        }

        @Override
        public long ramBytesUsed() {
            return this.ramBytesUsed;
        }

        @Override
        @NotNull
        public Collection<Accountable> getChildResources() {
            return Accountable.super.getChildResources();
        }
    }
}

