/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.search;

import java.io.IOException;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.DoubleCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.LongCompanionObject;
import org.gnit.lucenekmp.jdkport.Arrays;
import org.gnit.lucenekmp.jdkport.DoubleExtKt;
import org.gnit.lucenekmp.jdkport.LongExtKt;
import org.gnit.lucenekmp.jdkport.System;
import org.gnit.lucenekmp.search.BulkScorer;
import org.gnit.lucenekmp.search.DisiPriorityQueue;
import org.gnit.lucenekmp.search.DisiWrapper;
import org.gnit.lucenekmp.search.DocIdSetIterator;
import org.gnit.lucenekmp.search.LeafCollector;
import org.gnit.lucenekmp.search.Scorable;
import org.gnit.lucenekmp.search.Scorer;
import org.gnit.lucenekmp.util.Bits;
import org.gnit.lucenekmp.util.FixedBitSet;
import org.gnit.lucenekmp.util.MathUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0013\n\u0002\b\u0003\n\u0002\u0010\u0016\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0000\u0018\u0000 N2\u00020\u0001:\u0002MNB'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\b\u0010\tJ*\u00102\u001a\u00020\u00032\u0006\u00103\u001a\u0002042\b\u00105\u001a\u0004\u0018\u0001062\u0006\u00107\u001a\u00020\u00032\u0006\u00108\u001a\u00020\u0003H\u0016J,\u00109\u001a\u00020:2\u0006\u00103\u001a\u0002042\b\u00105\u001a\u0004\u0018\u0001062\u0006\u00108\u001a\u00020\u00032\b\u0010\u0007\u001a\u0004\u0018\u00010\fH\u0002J*\u0010;\u001a\u00020:2\u0006\u00103\u001a\u0002042\b\u00105\u001a\u0004\u0018\u0001062\u0006\u00108\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\fH\u0002J\"\u0010<\u001a\u00020:2\u0006\u00103\u001a\u0002042\b\u00105\u001a\u0004\u0018\u0001062\u0006\u0010=\u001a\u00020\u0003H\u0002J\"\u0010>\u001a\u00020:2\u0006\u00103\u001a\u0002042\b\u00105\u001a\u0004\u0018\u0001062\u0006\u00108\u001a\u00020\u0003H\u0002J\"\u0010?\u001a\u00020:2\u0006\u00103\u001a\u0002042\b\u00105\u001a\u0004\u0018\u0001062\u0006\u00108\u001a\u00020\u0003H\u0002J\u0010\u0010@\u001a\u00020\u00032\u0006\u0010A\u001a\u00020\u0003H\u0002J\u0016\u0010B\u001a\u00020:2\u0006\u0010A\u001a\u00020\u00032\u0006\u0010C\u001a\u00020\u0003J(\u0010D\u001a\u00020:2\u0006\u00103\u001a\u0002042\u0006\u0010E\u001a\u00020\u00032\u0006\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020\u0003H\u0002J\u0006\u0010I\u001a\u00020JJ\u0010\u0010K\u001a\u00020\u00032\u0006\u0010L\u001a\u00020\u0003H\u0002J\b\u0010!\u001a\u00020\"H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000b\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000eR\u0018\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0015\"\u0004\b\u001a\u0010\u0017R\u001a\u0010\u001b\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010#\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u001e\"\u0004\b%\u0010 R\u0012\u0010&\u001a\u00060'R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010(\u001a\u00020)\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006O"}, d2={"Lorg/gnit/lucenekmp/search/MaxScoreBulkScorer;", "Lorg/gnit/lucenekmp/search/BulkScorer;", "maxDoc", "", "scorers", "", "Lorg/gnit/lucenekmp/search/Scorer;", "filter", "<init>", "(ILjava/util/List;Lorg/gnit/lucenekmp/search/Scorer;)V", "allScorers", "", "Lorg/gnit/lucenekmp/search/DisiWrapper;", "getAllScorers", "()[Lorg/gnit/lucenekmp/search/DisiWrapper;", "[Lorg/gnit/lucenekmp/search/DisiWrapper;", "scratch", "essentialQueue", "Lorg/gnit/lucenekmp/search/DisiPriorityQueue;", "firstEssentialScorer", "getFirstEssentialScorer", "()I", "setFirstEssentialScorer", "(I)V", "firstRequiredScorer", "getFirstRequiredScorer", "setFirstRequiredScorer", "nextMinCompetitiveScore", "", "getNextMinCompetitiveScore", "()F", "setNextMinCompetitiveScore", "(F)V", "cost", "", "minCompetitiveScore", "getMinCompetitiveScore", "setMinCompetitiveScore", "scorable", "Lorg/gnit/lucenekmp/search/MaxScoreBulkScorer$Score;", "maxScoreSums", "", "getMaxScoreSums", "()[D", "windowMatches", "", "windowScores", "numOuterWindows", "numCandidates", "minWindowSize", "score", "collector", "Lorg/gnit/lucenekmp/search/LeafCollector;", "acceptDocs", "Lorg/gnit/lucenekmp/util/Bits;", "min", "max", "scoreInnerWindow", "", "scoreInnerWindowWithFilter", "scoreInnerWindowSingleEssentialClause", "upTo", "scoreInnerWindowAsConjunction", "scoreInnerWindowMultipleEssentialClauses", "computeOuterWindowMax", "windowMin", "updateMaxWindowScores", "windowMax", "scoreNonEssentialClauses", "doc", "essentialScore", "", "numNonEssentialClauses", "partitionScorers", "", "nextCandidate", "rangeEnd", "Score", "Companion", "core"})
public final class MaxScoreBulkScorer
extends BulkScorer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int maxDoc;
    @NotNull
    private final DisiWrapper[] allScorers;
    @NotNull
    private final DisiWrapper[] scratch;
    @NotNull
    private final DisiPriorityQueue essentialQueue;
    private int firstEssentialScorer;
    private int firstRequiredScorer;
    private float nextMinCompetitiveScore;
    private final long cost;
    private float minCompetitiveScore;
    @NotNull
    private final Score scorable;
    @NotNull
    private final double[] maxScoreSums;
    @Nullable
    private final DisiWrapper filter;
    @NotNull
    private final long[] windowMatches;
    @NotNull
    private final double[] windowScores;
    private int numOuterWindows;
    private int numCandidates;
    private int minWindowSize;
    public static final int INNER_WINDOW_SIZE = 4096;

    public MaxScoreBulkScorer(int maxDoc, @NotNull List<Scorer> scorers, @Nullable Scorer filter) {
        Intrinsics.checkNotNullParameter(scorers, (String)"scorers");
        this.maxDoc = maxDoc;
        this.allScorers = new DisiWrapper[scorers.size()];
        this.scratch = new DisiWrapper[this.allScorers.length];
        this.scorable = new Score();
        this.filter = filter == null ? null : new DisiWrapper(filter, false);
        this.windowMatches = new long[FixedBitSet.Companion.bits2words(4096)];
        this.windowScores = new double[4096];
        this.minWindowSize = 1;
        int i = 0;
        long cost = 0L;
        for (Scorer scorer2 : scorers) {
            DisiWrapper w = new DisiWrapper(scorer2, true);
            cost += w.getCost();
            this.allScorers[i++] = w;
        }
        this.cost = cost;
        this.essentialQueue = DisiPriorityQueue.Companion.ofMaxSize(this.allScorers.length);
        this.maxScoreSums = new double[this.allScorers.length];
    }

    @NotNull
    public final DisiWrapper[] getAllScorers() {
        return this.allScorers;
    }

    public final int getFirstEssentialScorer() {
        return this.firstEssentialScorer;
    }

    public final void setFirstEssentialScorer(int n) {
        this.firstEssentialScorer = n;
    }

    public final int getFirstRequiredScorer() {
        return this.firstRequiredScorer;
    }

    public final void setFirstRequiredScorer(int n) {
        this.firstRequiredScorer = n;
    }

    public final float getNextMinCompetitiveScore() {
        return this.nextMinCompetitiveScore;
    }

    public final void setNextMinCompetitiveScore(float f) {
        this.nextMinCompetitiveScore = f;
    }

    public final float getMinCompetitiveScore() {
        return this.minCompetitiveScore;
    }

    public final void setMinCompetitiveScore(float f) {
        this.minCompetitiveScore = f;
    }

    @NotNull
    public final double[] getMaxScoreSums() {
        return this.maxScoreSums;
    }

    @Override
    public int score(@NotNull LeafCollector collector2, @Nullable Bits acceptDocs, int min, int max) throws IOException {
        Intrinsics.checkNotNullParameter((Object)collector2, (String)"collector");
        collector2.setScorer(this.scorable);
        int outerWindowMin = min;
        block0: while (outerWindowMin < max) {
            DisiWrapper top;
            int outerWindowMax = this.computeOuterWindowMax(outerWindowMin);
            outerWindowMax = Math.min(outerWindowMax, max);
            while (true) {
                this.updateMaxWindowScores(outerWindowMin, outerWindowMax);
                if (!this.partitionScorers()) {
                    outerWindowMin = outerWindowMax;
                    continue block0;
                }
                int newOuterWindowMax = this.computeOuterWindowMax(outerWindowMin);
                if (newOuterWindowMax >= outerWindowMax) break;
                outerWindowMax = newOuterWindowMax;
            }
            Intrinsics.checkNotNull((Object)this.essentialQueue.top());
            while (top.getDoc() < outerWindowMin) {
                DocIdSetIterator docIdSetIterator = top.getIterator();
                Intrinsics.checkNotNull((Object)docIdSetIterator);
                top.setDoc(docIdSetIterator.advance(outerWindowMin));
                top = this.essentialQueue.updateTop();
            }
            while (top.getDoc() < outerWindowMax) {
                this.scoreInnerWindow(collector2, acceptDocs, outerWindowMax, this.filter);
                Intrinsics.checkNotNull((Object)this.essentialQueue.top());
                if (!(this.minCompetitiveScore >= this.nextMinCompetitiveScore)) continue;
            }
            outerWindowMin = Math.min(top.getDoc(), outerWindowMax);
            ++this.numOuterWindows;
        }
        return this.nextCandidate(max);
    }

    private final void scoreInnerWindow(LeafCollector collector2, Bits acceptDocs, int max, DisiWrapper filter) throws IOException {
        if (filter != null) {
            this.scoreInnerWindowWithFilter(collector2, acceptDocs, max, filter);
        } else if (this.allScorers.length - this.firstRequiredScorer >= 2) {
            this.scoreInnerWindowAsConjunction(collector2, acceptDocs, max);
        } else {
            DisiWrapper disiWrapper = this.essentialQueue.top();
            Intrinsics.checkNotNull((Object)disiWrapper);
            DisiWrapper top = disiWrapper;
            DisiWrapper top2 = this.essentialQueue.top2();
            if (top2 == null) {
                this.scoreInnerWindowSingleEssentialClause(collector2, acceptDocs, max);
            } else if (top2.getDoc() - 2048 >= top.getDoc()) {
                this.scoreInnerWindowSingleEssentialClause(collector2, acceptDocs, Math.min(max, top2.getDoc()));
            } else {
                this.scoreInnerWindowMultipleEssentialClauses(collector2, acceptDocs, max);
            }
        }
    }

    private final void scoreInnerWindowWithFilter(LeafCollector collector2, Bits acceptDocs, int max, DisiWrapper filter) throws IOException {
        DisiWrapper disiWrapper = this.essentialQueue.top();
        Intrinsics.checkNotNull((Object)disiWrapper);
        DisiWrapper top = disiWrapper;
        if (!(top.getDoc() < max)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        while (top.getDoc() < filter.getDoc()) {
            DocIdSetIterator docIdSetIterator = top.getApproximation();
            Intrinsics.checkNotNull((Object)docIdSetIterator);
            top.setDoc(docIdSetIterator.advance(filter.getDoc()));
            top = this.essentialQueue.updateTop();
        }
        int innerWindowMin = top.getDoc();
        int innerWindowMax = (int)Math.min((long)max, (long)innerWindowMin + (long)4096);
        while (top.getDoc() < innerWindowMax) {
            if (!(filter.getDoc() <= top.getDoc())) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (filter.getDoc() < top.getDoc()) {
                DocIdSetIterator docIdSetIterator = filter.getApproximation();
                Intrinsics.checkNotNull((Object)docIdSetIterator);
                filter.setDoc(docIdSetIterator.advance(top.getDoc()));
            }
            if (filter.getDoc() != top.getDoc()) {
                do {
                    DocIdSetIterator docIdSetIterator = top.getIterator();
                    Intrinsics.checkNotNull((Object)docIdSetIterator);
                    top.setDoc(docIdSetIterator.advance(filter.getDoc()));
                } while ((top = this.essentialQueue.updateTop()).getDoc() < filter.getDoc());
                continue;
            }
            int doc = top.getDoc();
            boolean match = !(acceptDocs != null && !acceptDocs.get(doc) || filter.getTwoPhaseView() != null && !filter.getTwoPhaseView().matches());
            double score2 = 0.0;
            do {
                if (match) {
                    score2 += (double)top.getScorer().score();
                }
                DocIdSetIterator docIdSetIterator = top.getIterator();
                Intrinsics.checkNotNull((Object)docIdSetIterator);
                top.setDoc(docIdSetIterator.nextDoc());
            } while ((top = this.essentialQueue.updateTop()).getDoc() == doc);
            if (!match) continue;
            this.scoreNonEssentialClauses(collector2, doc, score2, this.firstEssentialScorer);
        }
    }

    private final void scoreInnerWindowSingleEssentialClause(LeafCollector collector2, Bits acceptDocs, int upTo) throws IOException {
        DisiWrapper disiWrapper = this.essentialQueue.top();
        Intrinsics.checkNotNull((Object)disiWrapper);
        DisiWrapper top = disiWrapper;
        int doc = top.getDoc();
        while (doc < upTo) {
            if (acceptDocs != null && !acceptDocs.get(doc)) {
                DocIdSetIterator docIdSetIterator = top.getIterator();
                Intrinsics.checkNotNull((Object)docIdSetIterator);
                doc = docIdSetIterator.nextDoc();
                continue;
            }
            Scorable scorable = top.getScorable();
            Intrinsics.checkNotNull((Object)scorable);
            this.scoreNonEssentialClauses(collector2, doc, scorable.score(), this.firstEssentialScorer);
            DocIdSetIterator docIdSetIterator = top.getIterator();
            Intrinsics.checkNotNull((Object)docIdSetIterator);
            doc = docIdSetIterator.nextDoc();
        }
        DocIdSetIterator docIdSetIterator = top.getIterator();
        Intrinsics.checkNotNull((Object)docIdSetIterator);
        top.setDoc(docIdSetIterator.docID());
        this.essentialQueue.updateTop();
    }

    private final void scoreInnerWindowAsConjunction(LeafCollector collector2, Bits acceptDocs, int max) throws IOException {
        if (!(this.firstEssentialScorer == this.allScorers.length - 1)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(this.firstRequiredScorer <= this.allScorers.length - 2)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        DisiWrapper disiWrapper = this.allScorers[this.allScorers.length - 1];
        Intrinsics.checkNotNull((Object)disiWrapper);
        DisiWrapper lead1 = disiWrapper;
        if (!(this.essentialQueue.size() == 1)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(lead1 == this.essentialQueue.top())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        DisiWrapper disiWrapper2 = this.allScorers[this.allScorers.length - 2];
        Intrinsics.checkNotNull((Object)disiWrapper2);
        DisiWrapper lead2 = disiWrapper2;
        if (lead1.getDoc() < lead2.getDoc()) {
            DocIdSetIterator docIdSetIterator = lead1.getIterator();
            Intrinsics.checkNotNull((Object)docIdSetIterator);
            lead1.setDoc(docIdSetIterator.advance(Math.min(lead2.getDoc(), max)));
        }
        double maxScoreSumAtLead2 = this.maxScoreSums[this.allScorers.length - 2];
        block0: while (lead1.getDoc() < max) {
            if (acceptDocs != null && !acceptDocs.get(lead1.getDoc())) {
                DocIdSetIterator docIdSetIterator = lead1.getIterator();
                Intrinsics.checkNotNull((Object)docIdSetIterator);
                lead1.setDoc(docIdSetIterator.nextDoc());
                continue;
            }
            Scorable scorable = lead1.getScorable();
            Intrinsics.checkNotNull((Object)scorable);
            double score2 = scorable.score();
            if ((float)MathUtil.INSTANCE.sumUpperBound(score2 + maxScoreSumAtLead2, this.allScorers.length) < this.minCompetitiveScore) {
                DocIdSetIterator docIdSetIterator = lead1.getIterator();
                Intrinsics.checkNotNull((Object)docIdSetIterator);
                lead1.setDoc(docIdSetIterator.nextDoc());
                continue;
            }
            if (lead2.getDoc() < lead1.getDoc()) {
                DocIdSetIterator docIdSetIterator = lead2.getIterator();
                Intrinsics.checkNotNull((Object)docIdSetIterator);
                lead2.setDoc(docIdSetIterator.advance(lead1.getDoc()));
            }
            if (lead2.getDoc() != lead1.getDoc()) {
                DocIdSetIterator docIdSetIterator = lead1.getIterator();
                Intrinsics.checkNotNull((Object)docIdSetIterator);
                lead1.setDoc(docIdSetIterator.advance(Math.min(lead2.getDoc(), max)));
                continue;
            }
            Scorable scorable2 = lead2.getScorable();
            Intrinsics.checkNotNull((Object)scorable2);
            score2 += (double)scorable2.score();
            int i = this.allScorers.length - 3;
            int n = this.firstRequiredScorer;
            if (n <= i) {
                while (true) {
                    DisiWrapper w;
                    if ((float)MathUtil.INSTANCE.sumUpperBound(score2 + this.maxScoreSums[i], this.allScorers.length) < this.minCompetitiveScore) {
                        DocIdSetIterator docIdSetIterator = lead1.getIterator();
                        Intrinsics.checkNotNull((Object)docIdSetIterator);
                        lead1.setDoc(docIdSetIterator.nextDoc());
                        continue block0;
                    }
                    Intrinsics.checkNotNull((Object)this.allScorers[i]);
                    if (w.getDoc() < lead1.getDoc()) {
                        DocIdSetIterator docIdSetIterator = w.getIterator();
                        Intrinsics.checkNotNull((Object)docIdSetIterator);
                        w.setDoc(docIdSetIterator.advance(lead1.getDoc()));
                    }
                    if (w.getDoc() != lead1.getDoc()) {
                        DocIdSetIterator docIdSetIterator = lead1.getIterator();
                        Intrinsics.checkNotNull((Object)docIdSetIterator);
                        lead1.setDoc(docIdSetIterator.advance(Math.min(w.getDoc(), max)));
                        continue block0;
                    }
                    Scorable scorable3 = w.getScorable();
                    Intrinsics.checkNotNull((Object)scorable3);
                    score2 += (double)scorable3.score();
                    if (i == n) break;
                    --i;
                }
            }
            this.scoreNonEssentialClauses(collector2, lead1.getDoc(), score2, this.firstRequiredScorer);
            DocIdSetIterator docIdSetIterator = lead1.getIterator();
            Intrinsics.checkNotNull((Object)docIdSetIterator);
            lead1.setDoc(docIdSetIterator.nextDoc());
        }
    }

    private final void scoreInnerWindowMultipleEssentialClauses(LeafCollector collector2, Bits acceptDocs, int max) throws IOException {
        DisiWrapper disiWrapper = this.essentialQueue.top();
        Intrinsics.checkNotNull((Object)disiWrapper);
        DisiWrapper top = disiWrapper;
        int innerWindowMin = top.getDoc();
        int innerWindowMax = (int)Math.min((long)max, (long)innerWindowMin + (long)4096);
        do {
            int doc = top.getDoc();
            while (doc < innerWindowMax) {
                if (acceptDocs == null || acceptDocs.get(doc)) {
                    int i = doc - innerWindowMin;
                    this.windowMatches[i >>> 6] = this.windowMatches[i >>> 6] | 1L << i;
                    double[] dArray = this.windowScores;
                    double d = dArray[i];
                    Scorable scorable = top.getScorable();
                    Intrinsics.checkNotNull((Object)scorable);
                    dArray[i] = d + (double)scorable.score();
                }
                DocIdSetIterator docIdSetIterator = top.getIterator();
                Intrinsics.checkNotNull((Object)docIdSetIterator);
                doc = docIdSetIterator.nextDoc();
            }
            DocIdSetIterator docIdSetIterator = top.getIterator();
            Intrinsics.checkNotNull((Object)docIdSetIterator);
            top.setDoc(docIdSetIterator.docID());
        } while ((top = this.essentialQueue.updateTop()).getDoc() < innerWindowMax);
        int n = this.windowMatches.length;
        for (int wordIndex = 0; wordIndex < n; ++wordIndex) {
            int ntz;
            this.windowMatches[wordIndex] = 0L;
            for (long bits = this.windowMatches[wordIndex]; bits != 0L; bits ^= 1L << ntz) {
                ntz = LongExtKt.numberOfTrailingZeros(LongCompanionObject.INSTANCE, bits);
                int index = wordIndex << 6 | ntz;
                int doc = innerWindowMin + index;
                double score2 = this.windowScores[index];
                this.windowScores[index] = 0.0;
                this.scoreNonEssentialClauses(collector2, doc, score2, this.firstEssentialScorer);
            }
        }
    }

    private final int computeOuterWindowMax(int windowMin) throws IOException {
        int firstWindowLead = Math.min(this.firstEssentialScorer, this.allScorers.length - 1);
        int windowMax = Integer.MAX_VALUE;
        int n = this.allScorers.length;
        for (int i = firstWindowLead; i < n; ++i) {
            DisiWrapper scorer2;
            Intrinsics.checkNotNull((Object)this.allScorers[i]);
            if (this.filter != null && scorer2.getCost() < this.filter.getCost()) continue;
            int upTo = scorer2.getScorer().advanceShallow(Math.max(scorer2.getDoc(), windowMin));
            windowMax = (int)Math.min((long)windowMax, (long)upTo + 1L);
        }
        if (this.allScorers.length - firstWindowLead > 1) {
            long threshold = (long)this.numOuterWindows * 32L * (long)this.allScorers.length;
            this.minWindowSize = (long)this.numCandidates < threshold ? Math.min(this.minWindowSize << 1, 4096) : 1;
            int minWindowMax = (int)Math.min(Integer.MAX_VALUE, (long)windowMin + (long)this.minWindowSize);
            windowMax = Math.max(windowMax, minWindowMax);
        }
        return windowMax;
    }

    public final void updateMaxWindowScores(int windowMin, int windowMax) throws IOException {
        DisiWrapper[] disiWrapperArray = this.allScorers;
        int n = disiWrapperArray.length;
        for (int i = 0; i < n; ++i) {
            DisiWrapper scorer2;
            DisiWrapper disiWrapper = scorer2 = disiWrapperArray[i];
            Intrinsics.checkNotNull((Object)disiWrapper);
            if (disiWrapper.getDoc() < windowMax) {
                if (scorer2.getDoc() < windowMin) {
                    scorer2.getScorer().advanceShallow(windowMin);
                }
                scorer2.setMaxWindowScore(scorer2.getScorer().getMaxScore(windowMax - 1));
                continue;
            }
            scorer2.setMaxWindowScore(0.0f);
        }
    }

    private final void scoreNonEssentialClauses(LeafCollector collector2, int doc, double essentialScore, int numNonEssentialClauses) throws IOException {
        ++this.numCandidates;
        double score2 = essentialScore;
        for (int i = numNonEssentialClauses - 1; -1 < i; --i) {
            DisiWrapper scorer2;
            float maxPossibleScore = (float)MathUtil.INSTANCE.sumUpperBound(score2 + this.maxScoreSums[i], this.allScorers.length);
            if (maxPossibleScore < this.minCompetitiveScore) {
                return;
            }
            DisiWrapper disiWrapper = scorer2 = this.allScorers[i];
            Intrinsics.checkNotNull((Object)disiWrapper);
            if (disiWrapper.getDoc() < doc) {
                DocIdSetIterator docIdSetIterator = scorer2.getIterator();
                Intrinsics.checkNotNull((Object)docIdSetIterator);
                scorer2.setDoc(docIdSetIterator.advance(doc));
            }
            if (scorer2.getDoc() != doc) continue;
            Scorable scorable = scorer2.getScorable();
            Intrinsics.checkNotNull((Object)scorable);
            score2 += (double)scorable.score();
        }
        this.scorable.setScore((float)score2);
        collector2.collect(doc);
    }

    public final boolean partitionScorers() {
        int i;
        System.INSTANCE.arraycopyKtNullable(this.allScorers, 0, this.scratch, 0, this.allScorers.length);
        Arrays.INSTANCE.sort(this.scratch, MaxScoreBulkScorer::partitionScorers$lambda$0);
        double maxScoreSum = 0.0;
        this.firstEssentialScorer = 0;
        this.nextMinCompetitiveScore = Float.POSITIVE_INFINITY;
        int n = this.allScorers.length;
        for (i = 0; i < n; ++i) {
            DisiWrapper w = this.scratch[i];
            double newMaxScoreSum = maxScoreSum + (double)w.getMaxWindowScore();
            float maxScoreSumFloat = (float)MathUtil.INSTANCE.sumUpperBound(newMaxScoreSum, this.firstEssentialScorer + 1);
            if (maxScoreSumFloat < this.minCompetitiveScore) {
                maxScoreSum = newMaxScoreSum;
                this.allScorers[this.firstEssentialScorer] = w;
                this.maxScoreSums[this.firstEssentialScorer] = maxScoreSum;
                int n2 = this.firstEssentialScorer;
                this.firstEssentialScorer = n2 + 1;
                continue;
            }
            this.allScorers[this.allScorers.length - 1 - (i - this.firstEssentialScorer)] = w;
            this.nextMinCompetitiveScore = Math.min(maxScoreSumFloat, this.nextMinCompetitiveScore);
        }
        this.firstRequiredScorer = this.allScorers.length;
        if (this.firstEssentialScorer == this.allScorers.length) {
            return false;
        }
        this.essentialQueue.clear();
        n = this.allScorers.length;
        for (i = this.firstEssentialScorer; i < n; ++i) {
            DisiWrapper disiWrapper = this.allScorers[i];
            Intrinsics.checkNotNull((Object)disiWrapper);
            this.essentialQueue.add(disiWrapper);
        }
        if (this.firstEssentialScorer == this.allScorers.length - 1) {
            this.firstRequiredScorer = this.allScorers.length - 1;
            DisiWrapper disiWrapper = this.allScorers[this.firstEssentialScorer];
            Intrinsics.checkNotNull((Object)disiWrapper);
            double maxRequiredScore = disiWrapper.getMaxWindowScore();
            while (this.firstRequiredScorer > 0) {
                double maxPossibleScoreWithoutPreviousClause = maxRequiredScore;
                if (this.firstRequiredScorer > 1) {
                    maxPossibleScoreWithoutPreviousClause += this.maxScoreSums[this.firstRequiredScorer - 2];
                }
                if ((float)maxPossibleScoreWithoutPreviousClause >= this.minCompetitiveScore) break;
                this.firstRequiredScorer += -1;
                DisiWrapper disiWrapper2 = this.allScorers[this.firstRequiredScorer];
                Intrinsics.checkNotNull((Object)disiWrapper2);
                maxRequiredScore += (double)disiWrapper2.getMaxWindowScore();
            }
        }
        return true;
    }

    private final int nextCandidate(int rangeEnd) {
        if (rangeEnd >= this.maxDoc) {
            return Integer.MAX_VALUE;
        }
        int next = Integer.MAX_VALUE;
        DisiWrapper[] disiWrapperArray = this.allScorers;
        int n = disiWrapperArray.length;
        for (int i = 0; i < n; ++i) {
            DisiWrapper scorer2;
            DisiWrapper disiWrapper = scorer2 = disiWrapperArray[i];
            Intrinsics.checkNotNull((Object)disiWrapper);
            if (disiWrapper.getDoc() < rangeEnd) {
                return rangeEnd;
            }
            next = Math.min(next, scorer2.getDoc());
        }
        return next;
    }

    @Override
    public long cost() {
        return this.cost;
    }

    private static final int partitionScorers$lambda$0(DisiWrapper scorer1, DisiWrapper scorer2) {
        Intrinsics.checkNotNullParameter((Object)scorer1, (String)"scorer1");
        Intrinsics.checkNotNullParameter((Object)scorer2, (String)"scorer2");
        return DoubleExtKt.compare(DoubleCompanionObject.INSTANCE, (double)scorer1.getMaxWindowScore() / (double)Math.max(1L, scorer1.getCost()), (double)scorer2.getMaxWindowScore() / (double)Math.max(1L, scorer2.getCost()));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/gnit/lucenekmp/search/MaxScoreBulkScorer$Companion;", "", "<init>", "()V", "INNER_WINDOW_SIZE", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0015\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0007\u00a2\u0006\u0002\b\rR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lorg/gnit/lucenekmp/search/MaxScoreBulkScorer$Score;", "Lorg/gnit/lucenekmp/search/Scorable;", "<init>", "(Lorg/gnit/lucenekmp/search/MaxScoreBulkScorer;)V", "score", "", "getScore", "()F", "setScore", "(F)V", "setMinCompetitiveScore", "", "minScore", "setMinCompetitiveScoreKt", "core"})
    private final class Score
    extends Scorable {
        private float score;

        public final float getScore() {
            return this.score;
        }

        public final void setScore(float f) {
            this.score = f;
        }

        @Override
        public float score() {
            return this.score;
        }

        @JvmName(name="setMinCompetitiveScoreKt")
        public final void setMinCompetitiveScoreKt(float minScore) throws IOException {
            MaxScoreBulkScorer.this.setMinCompetitiveScore(minScore);
        }
    }
}

