/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.search;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.search.DocIdSetIterator;
import org.gnit.lucenekmp.search.LeafFieldComparator;
import org.gnit.lucenekmp.search.Scorable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bH\u0016J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000bH\u0016J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000bH\u0016J\u0018\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000bH\u0016J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\rH\u0016J\n\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016R\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/gnit/lucenekmp/search/MultiLeafFieldComparator;", "Lorg/gnit/lucenekmp/search/LeafFieldComparator;", "comparators", "", "reverseMul", "", "<init>", "([Lorg/gnit/lucenekmp/search/LeafFieldComparator;[I)V", "[Lorg/gnit/lucenekmp/search/LeafFieldComparator;", "firstComparator", "firstReverseMul", "", "setBottom", "", "slot", "compareBottom", "doc", "compareTop", "copy", "setScorer", "scorer", "Lorg/gnit/lucenekmp/search/Scorable;", "setHitsThresholdReached", "competitiveIterator", "Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "core"})
public final class MultiLeafFieldComparator
implements LeafFieldComparator {
    @NotNull
    private final LeafFieldComparator[] comparators;
    @NotNull
    private final int[] reverseMul;
    @NotNull
    private final LeafFieldComparator firstComparator;
    private final int firstReverseMul;

    public MultiLeafFieldComparator(@NotNull LeafFieldComparator[] comparators, @NotNull int[] reverseMul) {
        Intrinsics.checkNotNullParameter((Object)comparators, (String)"comparators");
        Intrinsics.checkNotNullParameter((Object)reverseMul, (String)"reverseMul");
        if (!(comparators.length == reverseMul.length)) {
            boolean bl = false;
            String string = "Must have the same number of comparators and reverseMul, got " + comparators.length + " and " + reverseMul.length;
            throw new IllegalArgumentException(string.toString());
        }
        this.comparators = comparators;
        this.reverseMul = reverseMul;
        this.firstComparator = comparators[0];
        this.firstReverseMul = reverseMul[0];
    }

    @Override
    public void setBottom(int slot) throws IOException {
        for (LeafFieldComparator comparator2 : this.comparators) {
            comparator2.setBottom(slot);
        }
    }

    @Override
    public int compareBottom(int doc) throws IOException {
        int cmp = this.firstReverseMul * this.firstComparator.compareBottom(doc);
        if (cmp != 0) {
            return cmp;
        }
        int n = this.comparators.length;
        for (int i = 1; i < n; ++i) {
            cmp = this.reverseMul[i] * this.comparators[i].compareBottom(doc);
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    @Override
    public int compareTop(int doc) throws IOException {
        int cmp = this.firstReverseMul * this.firstComparator.compareTop(doc);
        if (cmp != 0) {
            return cmp;
        }
        int n = this.comparators.length;
        for (int i = 1; i < n; ++i) {
            cmp = this.reverseMul[i] * this.comparators[i].compareTop(doc);
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    @Override
    public void copy(int slot, int doc) throws IOException {
        for (LeafFieldComparator comparator2 : this.comparators) {
            comparator2.copy(slot, doc);
        }
    }

    @Override
    public void setScorer(@NotNull Scorable scorer2) throws IOException {
        Intrinsics.checkNotNullParameter((Object)scorer2, (String)"scorer");
        for (LeafFieldComparator comparator2 : this.comparators) {
            comparator2.setScorer(scorer2);
        }
    }

    @Override
    public void setHitsThresholdReached() throws IOException {
        this.firstComparator.setHitsThresholdReached();
    }

    @Override
    @Nullable
    public DocIdSetIterator competitiveIterator() throws IOException {
        return this.firstComparator.competitiveIterator();
    }
}

