/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.index.ImpactsEnum;
import org.gnit.lucenekmp.index.LeafReader;
import org.gnit.lucenekmp.index.LeafReaderContext;
import org.gnit.lucenekmp.index.PostingsEnum;
import org.gnit.lucenekmp.index.SlowImpactsEnum;
import org.gnit.lucenekmp.index.Term;
import org.gnit.lucenekmp.index.TermState;
import org.gnit.lucenekmp.index.TermStates;
import org.gnit.lucenekmp.index.Terms;
import org.gnit.lucenekmp.index.TermsEnum;
import org.gnit.lucenekmp.internal.hppc.IntArrayList;
import org.gnit.lucenekmp.jdkport.System;
import org.gnit.lucenekmp.search.BooleanClause;
import org.gnit.lucenekmp.search.BooleanQuery;
import org.gnit.lucenekmp.search.CollectionStatistics;
import org.gnit.lucenekmp.search.ExactPhraseMatcher;
import org.gnit.lucenekmp.search.IndexSearcher;
import org.gnit.lucenekmp.search.MatchNoDocsQuery;
import org.gnit.lucenekmp.search.PhraseMatcher;
import org.gnit.lucenekmp.search.PhraseQuery;
import org.gnit.lucenekmp.search.PhraseWeight;
import org.gnit.lucenekmp.search.Query;
import org.gnit.lucenekmp.search.QueryVisitor;
import org.gnit.lucenekmp.search.ScoreMode;
import org.gnit.lucenekmp.search.SloppyPhraseMatcher;
import org.gnit.lucenekmp.search.TermQuery;
import org.gnit.lucenekmp.search.TermStatistics;
import org.gnit.lucenekmp.search.Weight;
import org.gnit.lucenekmp.search.similarities.Similarity;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.IOSupplier;
import org.gnit.lucenekmp.util.PriorityQueue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\f\u0018\u00002\u00020\u0001:\u0004/012B5\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0005\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J \u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\u0012\u0010\"\u001a\u00020\u00032\b\u0010#\u001a\u0004\u0018\u00010\u0003H\u0016J\u0013\u0010$\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010'H\u0096\u0002J\u0010\u0010(\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0000H\u0002J\b\u0010)\u001a\u00020\nH\u0016J\b\u0010*\u001a\u00020\nH\u0002J5\u0010+\u001a\u00020%2\u0012\u0010,\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00052\u0012\u0010-\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0005H\u0002\u00a2\u0006\u0002\u0010.R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u00063"}, d2={"Lorg/gnit/lucenekmp/search/MultiPhraseQuery;", "Lorg/gnit/lucenekmp/search/Query;", "field", "", "termArrays", "", "Lorg/gnit/lucenekmp/index/Term;", "positions", "", "slop", "", "<init>", "(Ljava/lang/String;[[Lorg/gnit/lucenekmp/index/Term;[II)V", "[[Lorg/gnit/lucenekmp/index/Term;", "getPositions", "()[I", "getSlop", "()I", "getTermArrays", "()[[Lorg/gnit/lucenekmp/index/Term;", "rewrite", "indexSearcher", "Lorg/gnit/lucenekmp/search/IndexSearcher;", "visit", "", "visitor", "Lorg/gnit/lucenekmp/search/QueryVisitor;", "createWeight", "Lorg/gnit/lucenekmp/search/Weight;", "searcher", "scoreMode", "Lorg/gnit/lucenekmp/search/ScoreMode;", "boost", "", "toString", "f", "equals", "", "other", "", "equalsTo", "hashCode", "termArraysHashCode", "termArraysEquals", "termArrays1", "termArrays2", "([[Lorg/gnit/lucenekmp/index/Term;[[Lorg/gnit/lucenekmp/index/Term;)Z", "Builder", "UnionPostingsEnum", "PostingsAndPosition", "UnionFullPostingsEnum", "core"})
public final class MultiPhraseQuery
extends Query {
    @NotNull
    private final String field;
    @NotNull
    private final Term[][] termArrays;
    @NotNull
    private final int[] positions;
    private final int slop;

    private MultiPhraseQuery(String field, Term[][] termArrays, int[] positions, int slop) {
        this.field = field;
        this.termArrays = termArrays;
        this.positions = positions;
        this.slop = slop;
    }

    @NotNull
    public final int[] getPositions() {
        return this.positions;
    }

    public final int getSlop() {
        return this.slop;
    }

    @NotNull
    public final Term[][] getTermArrays() {
        return this.termArrays;
    }

    @Override
    @NotNull
    public Query rewrite(@NotNull IndexSearcher indexSearcher) {
        Intrinsics.checkNotNullParameter((Object)indexSearcher, (String)"indexSearcher");
        if (((Object[])this.termArrays).length == 0) {
            return new MatchNoDocsQuery("empty MultiPhraseQuery");
        }
        if (((Object[])this.termArrays).length == 1) {
            Term[] terms = this.termArrays[0];
            BooleanQuery.Builder builder = new BooleanQuery.Builder();
            for (Term term : terms) {
                builder.add(new TermQuery(term), BooleanClause.Occur.SHOULD);
            }
            return builder.build();
        }
        return super.rewrite(indexSearcher);
    }

    @Override
    public void visit(@NotNull QueryVisitor visitor2) {
        Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
        if (!visitor2.acceptField(this.field)) {
            return;
        }
        QueryVisitor v = visitor2.getSubVisitor(BooleanClause.Occur.MUST, this);
        Term[][] termArray = this.termArrays;
        int n = ((Object[])termArray).length;
        for (int i = 0; i < n; ++i) {
            Term[] terms = termArray[i];
            QueryVisitor sv = v.getSubVisitor(BooleanClause.Occur.SHOULD, this);
            sv.consumeTerms(this, Arrays.copyOf(terms, terms.length));
        }
    }

    @Override
    @NotNull
    public Weight createWeight(@NotNull IndexSearcher searcher, @NotNull ScoreMode scoreMode, float boost) {
        Intrinsics.checkNotNullParameter((Object)searcher, (String)"searcher");
        Intrinsics.checkNotNullParameter((Object)((Object)scoreMode), (String)"scoreMode");
        Map termStates = new LinkedHashMap();
        String string = this.field;
        return new PhraseWeight(this, searcher, scoreMode, termStates, boost, string){
            final /* synthetic */ MultiPhraseQuery this$0;
            final /* synthetic */ ScoreMode $scoreMode;
            final /* synthetic */ Map<Term, TermStates> $termStates;
            final /* synthetic */ float $boost;
            {
                this.this$0 = $receiver;
                this.$scoreMode = $scoreMode;
                this.$termStates = $termStates;
                this.$boost = $boost;
                super($receiver, $super_call_param$1, $searcher, $scoreMode);
            }

            protected Similarity.SimScorer getStats(IndexSearcher searcher) throws IOException {
                Similarity.SimScorer simScorer;
                Intrinsics.checkNotNullParameter((Object)searcher, (String)"searcher");
                ArrayList<TermStatistics> allTermStats = new ArrayList<TermStatistics>();
                Term[][] termArray = MultiPhraseQuery.access$getTermArrays$p(this.this$0);
                int n = ((Object[])termArray).length;
                for (int i = 0; i < n; ++i) {
                    Term[] terms = termArray[i];
                    Intrinsics.checkNotNull((Object)terms);
                    for (Term term : terms) {
                        TermStates ts = this.$termStates.get(term);
                        if (ts == null) {
                            ts = TermStates.Companion.build(searcher, term, this.$scoreMode.needsScores());
                            this.$termStates.put(term, ts);
                        }
                        if (!this.$scoreMode.needsScores() || ts.docFreq() <= 0) continue;
                        allTermStats.add(searcher.termStatistics(term, ts.docFreq(), ts.totalTermFreq()));
                    }
                }
                if (allTermStats.isEmpty()) {
                    simScorer = null;
                } else {
                    Similarity similarity = this.getSimilarity();
                    CollectionStatistics collectionStatistics = searcher.collectionStatistics(this.getField());
                    Intrinsics.checkNotNull((Object)collectionStatistics);
                    Collection $this$toTypedArray$iv = allTermStats;
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    termArray = thisCollection$iv.toArray(new TermStatistics[0]);
                    simScorer = similarity.scorer(this.$boost, collectionStatistics, (TermStatistics[])Arrays.copyOf(termArray, termArray.length));
                }
                return simScorer;
            }

            /*
             * WARNING - void declaration
             */
            protected PhraseMatcher getPhraseMatcher(LeafReaderContext context, Similarity.SimScorer scorer2, boolean exposeOffsets) throws IOException {
                void condition$iv;
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)scorer2, (String)"scorer");
                boolean bl = !(((Object[])MultiPhraseQuery.access$getTermArrays$p(this.this$0)).length == 0);
                boolean $i$f$assert = false;
                if (_Assertions.ENABLED && condition$iv == false) {
                    boolean $i$a$-assert-AssertKt$assert$22 = false;
                    String $i$a$-assert-AssertKt$assert$22 = "assertion failed";
                    throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$22);
                }
                LeafReader reader2 = context.reader();
                PhraseQuery.PostingsAndFreq[] postingsFreqs = new PhraseQuery.PostingsAndFreq[((Object[])MultiPhraseQuery.access$getTermArrays$p(this.this$0)).length];
                Terms fieldTerms = reader2.terms(this.getField());
                if (fieldTerms == null) {
                    return null;
                }
                if (!fieldTerms.hasPositions()) {
                    boolean $i$a$-check-MultiPhraseQuery$createWeight$1$getPhraseMatcher$22 = false;
                    String $i$a$-check-MultiPhraseQuery$createWeight$1$getPhraseMatcher$22 = "field \"" + this.getField() + "\" was indexed without position data; cannot run MultiPhraseQuery (phrase=" + this.getQuery() + ")";
                    throw new IllegalStateException($i$a$-check-MultiPhraseQuery$createWeight$1$getPhraseMatcher$22.toString());
                }
                TermsEnum termsEnum = fieldTerms.iterator();
                float totalMatchCost = 0.0f;
                int n = postingsFreqs.length;
                for (int pos = 0; pos < n; ++pos) {
                    Term[] terms = MultiPhraseQuery.access$getTermArrays$p(this.this$0)[pos];
                    List postings = new ArrayList<E>();
                    int n2 = terms.length;
                    for (int i = 0; i < n2; ++i) {
                        TermState termState2;
                        IOSupplier<TermState> supplier;
                        Term term = terms[i];
                        TermStates termStates = this.$termStates.get(term);
                        Intrinsics.checkNotNull((Object)termStates);
                        IOSupplier<TermState> iOSupplier = supplier = termStates.get(context);
                        TermState termState3 = termState2 = iOSupplier == null ? null : iOSupplier.get();
                        if (termState2 == null) continue;
                        termsEnum.seekExact(term.bytes(), termState2);
                        postings.add(termsEnum.postings(null, exposeOffsets ? PostingsEnum.Companion.getALL() : PostingsEnum.Companion.getPOSITIONS()));
                        totalMatchCost += PhraseQuery.Companion.termPositionsCost(termsEnum);
                    }
                    if (postings.isEmpty()) {
                        return null;
                    }
                    PostingsEnum postingsEnum = postings.size() == 1 ? (PostingsEnum)postings.get(0) : (PostingsEnum)(exposeOffsets ? (UnionPostingsEnum)new UnionFullPostingsEnum(postings) : new UnionPostingsEnum(postings));
                    postingsFreqs[pos] = new PhraseQuery.PostingsAndFreq(postingsEnum, (ImpactsEnum)new SlowImpactsEnum(postingsEnum), this.this$0.getPositions()[pos], Arrays.copyOf(terms, terms.length));
                }
                if (this.this$0.getSlop() == 0) {
                    ArrayUtil.Companion.timSort(postingsFreqs);
                    return new ExactPhraseMatcher(postingsFreqs, this.$scoreMode, scorer2, totalMatchCost);
                }
                return new SloppyPhraseMatcher(postingsFreqs, this.this$0.getSlop(), this.$scoreMode, scorer2, totalMatchCost, exposeOffsets);
            }
        };
    }

    @Override
    @NotNull
    public String toString(@Nullable String f) {
        StringBuilder buffer = new StringBuilder();
        if (this.field == null || !Intrinsics.areEqual((Object)this.field, (Object)f)) {
            buffer.append(this.field);
            buffer.append(":");
        }
        buffer.append("\"");
        int lastPos = -1;
        int n = ((Object[])this.termArrays).length;
        for (int i = 0; i < n; ++i) {
            int j;
            int n2;
            Term[] terms = this.termArrays[i];
            int position = this.positions[i];
            if (i != 0) {
                buffer.append(" ");
                n2 = position - lastPos;
                for (j = 1; j < n2; ++j) {
                    buffer.append(" ");
                }
            }
            if (terms.length > 1) {
                buffer.append("(");
                n2 = terms.length;
                for (j = 0; j < n2; ++j) {
                    buffer.append(terms[j].text());
                    if (j >= terms.length - 1) continue;
                    buffer.append(" ");
                }
                v0 = buffer.append(")");
            } else {
                v0 = buffer.append(terms[0].text());
            }
            lastPos = position;
        }
        buffer.append("\"");
        if (this.slop != 0) {
            buffer.append("~");
            buffer.append(this.slop);
        }
        String string = buffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return this.sameClassAs(other);
    }

    private final boolean equalsTo(MultiPhraseQuery other) {
        return this.slop == other.slop && this.termArraysEquals(this.termArrays, other.termArrays) && Arrays.equals(this.positions, other.positions);
    }

    @Override
    public int hashCode() {
        return this.classHash() ^ this.slop ^ this.termArraysHashCode() ^ Arrays.hashCode(this.positions);
    }

    private final int termArraysHashCode() {
        int hashCode = 1;
        Term[][] termArray = this.termArrays;
        int n = ((Object[])termArray).length;
        for (int i = 0; i < n; ++i) {
            Object[] termArray2 = termArray[i];
            hashCode = 31 * hashCode + (termArray2 == null ? 0 : Arrays.hashCode(termArray2));
        }
        return hashCode;
    }

    private final boolean termArraysEquals(Term[][] termArrays1, Term[][] termArrays2) {
        if (((Object[])termArrays1).length != ((Object[])termArrays2).length) {
            return false;
        }
        int n = ((Object[])termArrays1).length;
        for (int i = 0; i < n; ++i) {
            Object[] termArray1 = termArrays1[i];
            Object[] termArray2 = termArrays2[i];
            if (termArray1 == null ? termArray2 == null : Arrays.equals(termArray1, termArray2)) continue;
            return false;
        }
        return true;
    }

    public /* synthetic */ MultiPhraseQuery(String field, Term[][] termArrays, int[] positions, int slop, DefaultConstructorMarker $constructor_marker) {
        this(field, termArrays, positions, slop);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\u0018\u00002\u00020\u0001B\t\b\u0016\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0002\u0010\u0006J\u000e\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0011J\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\fJ\u0019\u0010\u0014\u001a\u00020\u00002\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\u0010\u0017J!\u0010\u0014\u001a\u00020\u00002\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0018\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0019J\u0006\u0010\u001a\u001a\u00020\u0005R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\t\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\nj\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/gnit/lucenekmp/search/MultiPhraseQuery$Builder;", "", "<init>", "()V", "multiPhraseQuery", "Lorg/gnit/lucenekmp/search/MultiPhraseQuery;", "(Lorg/gnit/lucenekmp/search/MultiPhraseQuery;)V", "field", "", "termArrays", "Ljava/util/ArrayList;", "", "Lorg/gnit/lucenekmp/index/Term;", "Lkotlin/collections/ArrayList;", "positions", "Lorg/gnit/lucenekmp/internal/hppc/IntArrayList;", "slop", "", "setSlop", "s", "add", "term", "terms", "([Lorg/gnit/lucenekmp/index/Term;)Lorg/gnit/lucenekmp/search/MultiPhraseQuery$Builder;", "position", "([Lorg/gnit/lucenekmp/index/Term;I)Lorg/gnit/lucenekmp/search/MultiPhraseQuery$Builder;", "build", "core"})
    @SourceDebugExtension(value={"SMAP\nMultiPhraseQuery.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultiPhraseQuery.kt\norg/gnit/lucenekmp/search/MultiPhraseQuery$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,646:1\n1#2:647\n37#3:648\n36#3,3:649\n*S KotlinDebug\n*F\n+ 1 MultiPhraseQuery.kt\norg/gnit/lucenekmp/search/MultiPhraseQuery$Builder\n*L\n125#1:648\n125#1:649,3\n*E\n"})
    public static final class Builder {
        @Nullable
        private String field;
        @NotNull
        private final ArrayList<Term[]> termArrays;
        @NotNull
        private final IntArrayList positions;
        private int slop;

        public Builder() {
            this.field = null;
            this.termArrays = new ArrayList();
            this.positions = new IntArrayList();
            this.slop = 0;
        }

        public Builder(@NotNull MultiPhraseQuery multiPhraseQuery) {
            Intrinsics.checkNotNullParameter((Object)multiPhraseQuery, (String)"multiPhraseQuery");
            this.field = multiPhraseQuery.field;
            int length = ((Object[])multiPhraseQuery.termArrays).length;
            this.termArrays = new ArrayList(length);
            this.positions = new IntArrayList(length);
            for (int i = 0; i < length; ++i) {
                this.termArrays.add(multiPhraseQuery.termArrays[i]);
                this.positions.add(multiPhraseQuery.getPositions()[i]);
            }
            this.slop = multiPhraseQuery.getSlop();
        }

        @NotNull
        public final Builder setSlop(int s) {
            if (!(s >= 0)) {
                boolean bl = false;
                String string = "slop value cannot be negative";
                throw new IllegalArgumentException(string.toString());
            }
            this.slop = s;
            return this;
        }

        @NotNull
        public final Builder add(@NotNull Term term) {
            Intrinsics.checkNotNullParameter((Object)term, (String)"term");
            Term[] termArray = new Term[]{term};
            return this.add(termArray);
        }

        @NotNull
        public final Builder add(@NotNull Term[] terms) {
            Intrinsics.checkNotNullParameter((Object)terms, (String)"terms");
            int position = 0;
            if (this.positions.size() > 0) {
                position = this.positions.get(this.positions.size() - 1) + 1;
            }
            return this.add(terms, position);
        }

        @NotNull
        public final Builder add(@NotNull Term[] terms, int position) {
            Intrinsics.checkNotNullParameter((Object)terms, (String)"terms");
            if (this.termArrays.isEmpty()) {
                this.field = terms[0].field();
            }
            int n = terms.length;
            for (int i = 0; i < n; ++i) {
                Term term = terms[i];
                if (Intrinsics.areEqual((Object)term.field(), (Object)this.field)) continue;
                boolean bl = false;
                String string = "All phrase terms must be in the same field (" + this.field + "): " + term;
                throw new IllegalArgumentException(string.toString());
            }
            this.termArrays.add(terms);
            this.positions.add(position);
            return this;
        }

        @NotNull
        public final MultiPhraseQuery build() {
            Collection $this$toTypedArray$iv = this.termArrays;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Term[][] termArraysArray = (Term[][])thisCollection$iv.toArray((T[])new Term[0][]);
            String string = this.field;
            Intrinsics.checkNotNull((Object)string);
            return new MultiPhraseQuery(string, termArraysArray, this.positions.toArray(), this.slop, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0010\u001a\u00020\bH\u0016J\b\u0010\u0011\u001a\u00020\bH\u0016J\b\u0010\u0012\u001a\u00020\bH\u0016J\b\u0010\u0013\u001a\u00020\bH\u0016J\b\u0010\u0018\u001a\u00020\bH\u0016J\b\u0010\u0019\u001a\u00020\bH\u0016J\u0010\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\n\"\u0004\b\u000f\u0010\fR\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001e"}, d2={"Lorg/gnit/lucenekmp/search/MultiPhraseQuery$PostingsAndPosition;", "Lorg/gnit/lucenekmp/index/PostingsEnum;", "pe", "<init>", "(Lorg/gnit/lucenekmp/index/PostingsEnum;)V", "getPe", "()Lorg/gnit/lucenekmp/index/PostingsEnum;", "pos", "", "getPos", "()I", "setPos", "(I)V", "upto", "getUpto", "setUpto", "freq", "nextPosition", "startOffset", "endOffset", "payload", "Lorg/gnit/lucenekmp/util/BytesRef;", "getPayload", "()Lorg/gnit/lucenekmp/util/BytesRef;", "docID", "nextDoc", "advance", "target", "cost", "", "core"})
    public static final class PostingsAndPosition
    extends PostingsEnum {
        @NotNull
        private final PostingsEnum pe;
        private int pos;
        private int upto;

        public PostingsAndPosition(@NotNull PostingsEnum pe) {
            Intrinsics.checkNotNullParameter((Object)pe, (String)"pe");
            this.pe = pe;
        }

        @NotNull
        public final PostingsEnum getPe() {
            return this.pe;
        }

        public final int getPos() {
            return this.pos;
        }

        public final void setPos(int n) {
            this.pos = n;
        }

        public final int getUpto() {
            return this.upto;
        }

        public final void setUpto(int n) {
            this.upto = n;
        }

        @Override
        public int freq() {
            return this.pe.freq();
        }

        @Override
        public int nextPosition() {
            return this.pe.nextPosition();
        }

        @Override
        public int startOffset() {
            return this.pe.startOffset();
        }

        @Override
        public int endOffset() {
            return this.pe.endOffset();
        }

        @Override
        @Nullable
        public BytesRef getPayload() {
            return this.pe.getPayload();
        }

        @Override
        public int docID() {
            return this.pe.docID();
        }

        @Override
        public int nextDoc() {
            return this.pe.nextDoc();
        }

        @Override
        public int advance(int target) {
            return this.pe.advance(target);
        }

        @Override
        public long cost() {
            return this.pe.cost();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\u001e\u001a\u00020\bH\u0016J\b\u0010\u001f\u001a\u00020\bH\u0016J\b\u0010 \u001a\u00020\bH\u0016R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R$\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0018X\u0096\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001d\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0016\u0010!\u001a\u0004\u0018\u00010\"8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$\u00a8\u0006%"}, d2={"Lorg/gnit/lucenekmp/search/MultiPhraseQuery$UnionFullPostingsEnum;", "Lorg/gnit/lucenekmp/search/MultiPhraseQuery$UnionPostingsEnum;", "subs", "", "Lorg/gnit/lucenekmp/index/PostingsEnum;", "<init>", "(Ljava/util/List;)V", "freq", "", "getFreq", "()I", "setFreq", "(I)V", "started", "", "getStarted", "()Z", "setStarted", "(Z)V", "prQueue", "Lorg/gnit/lucenekmp/util/PriorityQueue;", "Lorg/gnit/lucenekmp/search/MultiPhraseQuery$PostingsAndPosition;", "getPrQueue", "()Lorg/gnit/lucenekmp/util/PriorityQueue;", "", "getSubs", "()[Lorg/gnit/lucenekmp/index/PostingsEnum;", "setSubs", "([Lorg/gnit/lucenekmp/index/PostingsEnum;)V", "[Lorg/gnit/lucenekmp/index/PostingsEnum;", "nextPosition", "startOffset", "endOffset", "payload", "Lorg/gnit/lucenekmp/util/BytesRef;", "getPayload", "()Lorg/gnit/lucenekmp/util/BytesRef;", "core"})
    @SourceDebugExtension(value={"SMAP\nMultiPhraseQuery.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultiPhraseQuery.kt\norg/gnit/lucenekmp/search/MultiPhraseQuery$UnionFullPostingsEnum\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,646:1\n37#2:647\n36#2,3:648\n*S KotlinDebug\n*F\n+ 1 MultiPhraseQuery.kt\norg/gnit/lucenekmp/search/MultiPhraseQuery$UnionFullPostingsEnum\n*L\n588#1:647\n588#1:648,3\n*E\n"})
    public static final class UnionFullPostingsEnum
    extends UnionPostingsEnum {
        private int freq;
        private boolean started;
        @NotNull
        private final PriorityQueue<PostingsAndPosition> prQueue;
        @NotNull
        private PostingsEnum[] subs;

        public UnionFullPostingsEnum(@NotNull List<PostingsEnum> subs) {
            Intrinsics.checkNotNullParameter(subs, (String)"subs");
            super((Collection<PostingsEnum>)subs);
            this.freq = -1;
            int n = subs.size();
            this.prQueue = new PriorityQueue<PostingsAndPosition>(n){

                public boolean lessThan(PostingsAndPosition a, PostingsAndPosition b) {
                    Intrinsics.checkNotNullParameter((Object)a, (String)"a");
                    Intrinsics.checkNotNullParameter((Object)b, (String)"b");
                    return a.getPos() < b.getPos();
                }
            };
            ArrayList<PostingsAndPosition> al = new ArrayList<PostingsAndPosition>();
            for (PostingsEnum pe : subs) {
                al.add(new PostingsAndPosition(pe));
            }
            Collection $this$toTypedArray$iv = al;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            this.setSubs(thisCollection$iv.toArray(new PostingsAndPosition[0]));
        }

        public final int getFreq() {
            return this.freq;
        }

        public final void setFreq(int n) {
            this.freq = n;
        }

        public final boolean getStarted() {
            return this.started;
        }

        public final void setStarted(boolean bl) {
            this.started = bl;
        }

        @NotNull
        public final PriorityQueue<PostingsAndPosition> getPrQueue() {
            return this.prQueue;
        }

        @Override
        @NotNull
        public PostingsEnum[] getSubs() {
            return this.subs;
        }

        @Override
        public void setSubs(@NotNull PostingsEnum[] postingsEnumArray) {
            Intrinsics.checkNotNullParameter((Object)postingsEnumArray, (String)"<set-?>");
            this.subs = postingsEnumArray;
        }

        @Override
        public int freq() throws IOException {
            int doc = this.docID();
            if (doc == this.getPosQueueDoc()) {
                return this.freq;
            }
            this.freq = 0;
            this.started = false;
            this.prQueue.clear();
            for (PostingsEnum ppBeforeCast : this.getSubs()) {
                Intrinsics.checkNotNull((Object)ppBeforeCast, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.search.MultiPhraseQuery.PostingsAndPosition");
                PostingsAndPosition pp = (PostingsAndPosition)ppBeforeCast;
                if (pp.getPe().docID() != doc) continue;
                pp.setPos(pp.getPe().nextPosition());
                pp.setUpto(pp.getPe().freq());
                this.prQueue.add(pp);
                this.freq += pp.getUpto();
            }
            return this.freq;
        }

        @Override
        public int nextPosition() throws IOException {
            if (!this.started) {
                this.started = true;
                return this.prQueue.top().getPos();
            }
            if (this.prQueue.top().getUpto() == 1) {
                this.prQueue.pop();
                return this.prQueue.top().getPos();
            }
            this.prQueue.top().setPos(this.prQueue.top().getPe().nextPosition());
            PostingsAndPosition postingsAndPosition = this.prQueue.top();
            int n = postingsAndPosition.getUpto();
            postingsAndPosition.setUpto(n + -1);
            this.prQueue.updateTop();
            return this.prQueue.top().getPos();
        }

        @Override
        public int startOffset() throws IOException {
            return this.prQueue.top().getPe().startOffset();
        }

        @Override
        public int endOffset() throws IOException {
            return this.prQueue.top().getPe().endOffset();
        }

        @Override
        @Nullable
        public BytesRef getPayload() {
            return this.prQueue.top().getPe().getPayload();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001:\u0002*+B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u001e\u001a\u00020\u0013H\u0016J\b\u0010\u001f\u001a\u00020\u0013H\u0016J\b\u0010 \u001a\u00020\u0013H\u0016J\b\u0010!\u001a\u00020\u0013H\u0016J\u0010\u0010\"\u001a\u00020\u00132\u0006\u0010#\u001a\u00020\u0013H\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010$\u001a\u00020\u0013H\u0016J\b\u0010%\u001a\u00020\u0013H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R$\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0018X\u0096.\u00a2\u0006\u0010\n\u0002\u0010\u001d\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0016\u0010&\u001a\u0004\u0018\u00010'8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)\u00a8\u0006,"}, d2={"Lorg/gnit/lucenekmp/search/MultiPhraseQuery$UnionPostingsEnum;", "Lorg/gnit/lucenekmp/index/PostingsEnum;", "subs", "", "<init>", "(Ljava/util/Collection;)V", "docsQueue", "Lorg/gnit/lucenekmp/search/MultiPhraseQuery$UnionPostingsEnum$DocsQueue;", "getDocsQueue", "()Lorg/gnit/lucenekmp/search/MultiPhraseQuery$UnionPostingsEnum$DocsQueue;", "cost", "", "getCost", "()J", "posQueue", "Lorg/gnit/lucenekmp/search/MultiPhraseQuery$UnionPostingsEnum$PositionsQueue;", "getPosQueue", "()Lorg/gnit/lucenekmp/search/MultiPhraseQuery$UnionPostingsEnum$PositionsQueue;", "posQueueDoc", "", "getPosQueueDoc", "()I", "setPosQueueDoc", "(I)V", "", "getSubs", "()[Lorg/gnit/lucenekmp/index/PostingsEnum;", "setSubs", "([Lorg/gnit/lucenekmp/index/PostingsEnum;)V", "[Lorg/gnit/lucenekmp/index/PostingsEnum;", "freq", "nextPosition", "docID", "nextDoc", "advance", "target", "startOffset", "endOffset", "payload", "Lorg/gnit/lucenekmp/util/BytesRef;", "getPayload", "()Lorg/gnit/lucenekmp/util/BytesRef;", "DocsQueue", "PositionsQueue", "core"})
    @SourceDebugExtension(value={"SMAP\nMultiPhraseQuery.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultiPhraseQuery.kt\norg/gnit/lucenekmp/search/MultiPhraseQuery$UnionPostingsEnum\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,646:1\n37#2:647\n36#2,3:648\n*S KotlinDebug\n*F\n+ 1 MultiPhraseQuery.kt\norg/gnit/lucenekmp/search/MultiPhraseQuery$UnionPostingsEnum\n*L\n422#1:647\n422#1:648,3\n*E\n"})
    public static class UnionPostingsEnum
    extends PostingsEnum {
        @NotNull
        private final DocsQueue docsQueue;
        private final long cost;
        @NotNull
        private final PositionsQueue posQueue;
        private int posQueueDoc;
        public PostingsEnum[] subs;

        public UnionPostingsEnum(@NotNull Collection<PostingsEnum> subs) {
            Intrinsics.checkNotNullParameter(subs, (String)"subs");
            this.docsQueue = new DocsQueue(subs.size());
            this.posQueue = new PositionsQueue();
            this.posQueueDoc = -2;
            long cost = 0L;
            for (PostingsEnum sub : subs) {
                this.docsQueue.add(sub);
                cost += sub.cost();
            }
            this.cost = cost;
            Collection<PostingsEnum> $this$toTypedArray$iv = subs;
            boolean $i$f$toTypedArray = false;
            Collection<PostingsEnum> thisCollection$iv = $this$toTypedArray$iv;
            this.setSubs(thisCollection$iv.toArray(new PostingsEnum[0]));
        }

        @NotNull
        public final DocsQueue getDocsQueue() {
            return this.docsQueue;
        }

        public final long getCost() {
            return this.cost;
        }

        @NotNull
        public PositionsQueue getPosQueue() {
            return this.posQueue;
        }

        public final int getPosQueueDoc() {
            return this.posQueueDoc;
        }

        public final void setPosQueueDoc(int n) {
            this.posQueueDoc = n;
        }

        @NotNull
        public PostingsEnum[] getSubs() {
            if (this.subs != null) {
                return this.subs;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"subs");
            return null;
        }

        public void setSubs(@NotNull PostingsEnum[] postingsEnumArray) {
            Intrinsics.checkNotNullParameter((Object)postingsEnumArray, (String)"<set-?>");
            this.subs = postingsEnumArray;
        }

        @Override
        public int freq() throws IOException {
            int doc = this.docID();
            if (doc != this.posQueueDoc) {
                this.getPosQueue().clear();
                for (PostingsEnum sub : this.getSubs()) {
                    if (sub.docID() != doc) continue;
                    int freq = sub.freq();
                    for (int i = 0; i < freq; ++i) {
                        this.getPosQueue().add(sub.nextPosition());
                    }
                }
                this.getPosQueue().sort();
                this.posQueueDoc = doc;
            }
            return this.getPosQueue().size();
        }

        @Override
        public int nextPosition() throws IOException {
            return this.getPosQueue().next();
        }

        @Override
        public int docID() {
            return ((PostingsEnum)this.docsQueue.top()).docID();
        }

        @Override
        public int nextDoc() throws IOException {
            PostingsEnum top = (PostingsEnum)this.docsQueue.top();
            int doc = top.docID();
            do {
                top.nextDoc();
            } while ((top = (PostingsEnum)this.docsQueue.updateTop()).docID() == doc);
            return top.docID();
        }

        @Override
        public int advance(int target) throws IOException {
            PostingsEnum top = (PostingsEnum)this.docsQueue.top();
            do {
                top.advance(target);
            } while ((top = (PostingsEnum)this.docsQueue.updateTop()).docID() < target);
            return top.docID();
        }

        @Override
        public long cost() {
            return this.cost;
        }

        @Override
        public int startOffset() throws IOException {
            return -1;
        }

        @Override
        public int endOffset() throws IOException {
            return -1;
        }

        @Override
        @Nullable
        public BytesRef getPayload() {
            return null;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0002H\u0016\u00a8\u0006\u000b"}, d2={"Lorg/gnit/lucenekmp/search/MultiPhraseQuery$UnionPostingsEnum$DocsQueue;", "Lorg/gnit/lucenekmp/util/PriorityQueue;", "Lorg/gnit/lucenekmp/index/PostingsEnum;", "size", "", "<init>", "(I)V", "lessThan", "", "a", "b", "core"})
        public static final class DocsQueue
        extends PriorityQueue<PostingsEnum> {
            public DocsQueue(int size2) {
                super(size2, null, 2, null);
            }

            @Override
            public boolean lessThan(@NotNull PostingsEnum a, @NotNull PostingsEnum b) {
                Intrinsics.checkNotNullParameter((Object)a, (String)"a");
                Intrinsics.checkNotNullParameter((Object)b, (String)"b");
                return a.docID() < b.docID();
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005J\u0006\u0010\r\u001a\u00020\u0005J\u0006\u0010\u000e\u001a\u00020\u000bJ\u0006\u0010\u000f\u001a\u00020\u000bJ\u0006\u0010\u0007\u001a\u00020\u0005J\b\u0010\u0010\u001a\u00020\u000bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/gnit/lucenekmp/search/MultiPhraseQuery$UnionPostingsEnum$PositionsQueue;", "", "<init>", "()V", "arraySize", "", "index", "size", "array", "", "add", "", "i", "next", "sort", "clear", "growArray", "core"})
        public static final class PositionsQueue {
            private int arraySize = 16;
            private int index;
            private int size;
            @NotNull
            private int[] array = new int[this.arraySize];

            public final void add(int i) {
                if (this.size == this.arraySize) {
                    this.growArray();
                }
                int n = this.size;
                this.size = n + 1;
                this.array[n] = i;
            }

            public final int next() {
                int n = this.index;
                this.index = n + 1;
                return this.array[n];
            }

            public final void sort() {
                org.gnit.lucenekmp.jdkport.Arrays.INSTANCE.sort(this.array, this.index, this.size);
            }

            public final void clear() {
                this.index = 0;
                this.size = 0;
            }

            public final int size() {
                return this.size;
            }

            private final void growArray() {
                int[] newArray = new int[this.arraySize * 2];
                System.INSTANCE.arraycopy(this.array, 0, newArray, 0, this.arraySize);
                this.array = newArray;
                this.arraySize *= 2;
            }
        }
    }
}

