/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.index.LeafReaderContext;
import org.gnit.lucenekmp.index.PostingsEnum;
import org.gnit.lucenekmp.index.Term;
import org.gnit.lucenekmp.index.TermStates;
import org.gnit.lucenekmp.index.Terms;
import org.gnit.lucenekmp.index.TermsEnum;
import org.gnit.lucenekmp.search.AbstractMultiTermQueryConstantScoreWrapper;
import org.gnit.lucenekmp.search.ConstantScoreQuery;
import org.gnit.lucenekmp.search.ConstantScoreScorer;
import org.gnit.lucenekmp.search.DisiWrapper;
import org.gnit.lucenekmp.search.DisjunctionDISIApproximation;
import org.gnit.lucenekmp.search.DocIdSetIterator;
import org.gnit.lucenekmp.search.IndexSearcher;
import org.gnit.lucenekmp.search.MultiTermQuery;
import org.gnit.lucenekmp.search.Query;
import org.gnit.lucenekmp.search.ScoreMode;
import org.gnit.lucenekmp.search.Scorer;
import org.gnit.lucenekmp.search.TermQuery;
import org.gnit.lucenekmp.search.Weight;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.DocIdSetBuilder;
import org.gnit.lucenekmp.util.PriorityQueue;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\b\u0000\u0018\u0000 \u000f*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001\u000fB\u000f\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0006J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/gnit/lucenekmp/search/MultiTermQueryConstantScoreBlendedWrapper;", "Q", "Lorg/gnit/lucenekmp/search/MultiTermQuery;", "Lorg/gnit/lucenekmp/search/AbstractMultiTermQueryConstantScoreWrapper;", "query", "<init>", "(Lorg/gnit/lucenekmp/search/MultiTermQuery;)V", "createWeight", "Lorg/gnit/lucenekmp/search/Weight;", "searcher", "Lorg/gnit/lucenekmp/search/IndexSearcher;", "scoreMode", "Lorg/gnit/lucenekmp/search/ScoreMode;", "boost", "", "Companion", "core"})
public final class MultiTermQueryConstantScoreBlendedWrapper<Q extends MultiTermQuery>
extends AbstractMultiTermQueryConstantScoreWrapper<Q> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int POSTINGS_PRE_PROCESS_THRESHOLD = 512;

    public MultiTermQueryConstantScoreBlendedWrapper(@NotNull Q query) {
        Intrinsics.checkNotNullParameter(query, (String)"query");
        super(query);
    }

    @Override
    @NotNull
    public Weight createWeight(@NotNull IndexSearcher searcher, @NotNull ScoreMode scoreMode, float boost) {
        Intrinsics.checkNotNullParameter((Object)searcher, (String)"searcher");
        Intrinsics.checkNotNullParameter((Object)((Object)scoreMode), (String)"scoreMode");
        Object q = this.getQuery();
        return new AbstractMultiTermQueryConstantScoreWrapper.RewritingWeight(boost, scoreMode, searcher, q){
            final /* synthetic */ ScoreMode $scoreMode;
            final /* synthetic */ IndexSearcher $searcher;
            {
                this.$scoreMode = $scoreMode;
                this.$searcher = $searcher;
                super((MultiTermQuery)$super_call_param$1, $boost, $scoreMode, $searcher);
            }

            public AbstractMultiTermQueryConstantScoreWrapper.WeightOrDocIdSetIterator rewriteInner(LeafReaderContext context, int fieldDocCount, Terms terms, TermsEnum termsEnum, List<AbstractMultiTermQueryConstantScoreWrapper.TermAndState> collectedTerms, long leadCost) throws IOException {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)terms, (String)"terms");
                Intrinsics.checkNotNullParameter((Object)termsEnum, (String)"termsEnum");
                Intrinsics.checkNotNullParameter(collectedTerms, (String)"collectedTerms");
                DocIdSetBuilder otherTerms = new DocIdSetBuilder(context.reader().maxDoc(), terms);
                int n = collectedTerms.size();
                PriorityQueue highFrequencyTerms2 = new PriorityQueue<PostingsEnum>(n){

                    public boolean lessThan(PostingsEnum a, PostingsEnum b) {
                        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
                        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
                        return a.cost() < b.cost();
                    }
                };
                PostingsEnum reuse = null;
                if (!collectedTerms.isEmpty()) {
                    TermsEnum termsEnum2 = terms.iterator();
                    for (AbstractMultiTermQueryConstantScoreWrapper.TermAndState t : collectedTerms) {
                        termsEnum2.seekExact(t.getTerm(), t.getState());
                        reuse = termsEnum2.postings(reuse, 0);
                        if (t.getDocFreq() <= 512) {
                            otherTerms.add(reuse);
                            continue;
                        }
                        highFrequencyTerms2.add(reuse);
                        reuse = null;
                    }
                }
                do {
                    reuse = termsEnum.postings(reuse, 0);
                    int docFreq = termsEnum.docFreq();
                    if (fieldDocCount == docFreq) {
                        Weight weight;
                        TermStates termStates = new TermStates(this.$searcher.getTopReaderContext());
                        termStates.register(termsEnum.termState(), context.getOrd(), docFreq, termsEnum.totalTermFreq());
                        Query query = this.getQuery();
                        Intrinsics.checkNotNull((Object)query, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.search.MultiTermQuery");
                        String string = ((MultiTermQuery)query).getField();
                        BytesRef bytesRef = termsEnum.term();
                        Intrinsics.checkNotNull((Object)bytesRef);
                        Query q = new ConstantScoreQuery(new TermQuery(new Term(string, bytesRef), termStates));
                        Weight weight2 = weight = this.$searcher.rewrite(q).createWeight(this.$searcher, this.$scoreMode, this.score());
                        Intrinsics.checkNotNull((Object)weight2);
                        return new AbstractMultiTermQueryConstantScoreWrapper.WeightOrDocIdSetIterator(weight2);
                    }
                    if (docFreq <= 512) {
                        otherTerms.add(reuse);
                        continue;
                    }
                    PostingsEnum dropped = highFrequencyTerms2.insertWithOverflow(reuse);
                    if (dropped != null) {
                        otherTerms.add(dropped);
                    }
                    reuse = dropped;
                } while (termsEnum.next() != null);
                List subs = new ArrayList<E>(highFrequencyTerms2.size() + 1);
                for (PostingsEnum disi : highFrequencyTerms2) {
                    Scorer s = org.gnit.lucenekmp.search.MultiTermQueryConstantScoreBlendedWrapper$Companion.access$wrapWithDummyScorer(MultiTermQueryConstantScoreBlendedWrapper.Companion, this, disi);
                    subs.add(new DisiWrapper(s, false));
                }
                Scorer s = org.gnit.lucenekmp.search.MultiTermQueryConstantScoreBlendedWrapper$Companion.access$wrapWithDummyScorer(MultiTermQueryConstantScoreBlendedWrapper.Companion, this, otherTerms.build().iterator());
                subs.add(new DisiWrapper(s, false));
                return new AbstractMultiTermQueryConstantScoreWrapper.WeightOrDocIdSetIterator(new DisjunctionDISIApproximation(subs, leadCost));
            }
        };
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/gnit/lucenekmp/search/MultiTermQueryConstantScoreBlendedWrapper$Companion;", "", "<init>", "()V", "POSTINGS_PRE_PROCESS_THRESHOLD", "", "wrapWithDummyScorer", "Lorg/gnit/lucenekmp/search/Scorer;", "weight", "Lorg/gnit/lucenekmp/search/Weight;", "disi", "Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "core"})
    public static final class Companion {
        private Companion() {
        }

        private final Scorer wrapWithDummyScorer(Weight weight, DocIdSetIterator disi) {
            return new ConstantScoreScorer(1.0f, ScoreMode.COMPLETE_NO_SCORES, disi);
        }

        public static final /* synthetic */ Scorer access$wrapWithDummyScorer(Companion $this, Weight weight, DocIdSetIterator disi) {
            return $this.wrapWithDummyScorer(weight, disi);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

