/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KClasses;
import org.gnit.lucenekmp.index.ImpactsEnum;
import org.gnit.lucenekmp.index.LeafReader;
import org.gnit.lucenekmp.index.LeafReaderContext;
import org.gnit.lucenekmp.index.PostingsEnum;
import org.gnit.lucenekmp.index.SlowImpactsEnum;
import org.gnit.lucenekmp.index.Term;
import org.gnit.lucenekmp.index.TermState;
import org.gnit.lucenekmp.index.TermStates;
import org.gnit.lucenekmp.index.Terms;
import org.gnit.lucenekmp.index.TermsEnum;
import org.gnit.lucenekmp.internal.hppc.IntArrayList;
import org.gnit.lucenekmp.jdkport.System;
import org.gnit.lucenekmp.search.BooleanClause;
import org.gnit.lucenekmp.search.CollectionStatistics;
import org.gnit.lucenekmp.search.ExactPhraseMatcher;
import org.gnit.lucenekmp.search.IndexSearcher;
import org.gnit.lucenekmp.search.MatchNoDocsQuery;
import org.gnit.lucenekmp.search.PhraseMatcher;
import org.gnit.lucenekmp.search.PhraseWeight;
import org.gnit.lucenekmp.search.Query;
import org.gnit.lucenekmp.search.QueryVisitor;
import org.gnit.lucenekmp.search.ScoreMode;
import org.gnit.lucenekmp.search.SloppyPhraseMatcher;
import org.gnit.lucenekmp.search.TermQuery;
import org.gnit.lucenekmp.search.TermStatistics;
import org.gnit.lucenekmp.search.Weight;
import org.gnit.lucenekmp.search.similarities.Similarity;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.IOSupplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0006\u0018\u0000 32\u00020\u0001:\u0003123B'\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nB-\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u0005\"\u00020\f\u00a2\u0006\u0004\b\t\u0010\rB%\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u0005\"\u00020\f\u00a2\u0006\u0004\b\t\u0010\u000eB-\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u0005\"\u00020\u000f\u00a2\u0006\u0004\b\t\u0010\u0010B%\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u0005\"\u00020\u000f\u00a2\u0006\u0004\b\t\u0010\u0011J\u0010\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J \u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0016J\u0012\u0010)\u001a\u00020\f2\b\u0010*\u001a\u0004\u0018\u00010\fH\u0016J\u0013\u0010+\u001a\u00020,2\b\u0010-\u001a\u0004\u0018\u00010.H\u0096\u0002J\u0010\u0010/\u001a\u00020,2\u0006\u0010-\u001a\u00020\u0000H\u0002J\b\u00100\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0019\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\n\n\u0002\u0010\u0018\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u00064"}, d2={"Lorg/gnit/lucenekmp/search/PhraseQuery;", "Lorg/gnit/lucenekmp/search/Query;", "slop", "", "terms", "", "Lorg/gnit/lucenekmp/index/Term;", "positions", "", "<init>", "(I[Lorg/gnit/lucenekmp/index/Term;[I)V", "field", "", "(ILjava/lang/String;[Ljava/lang/String;)V", "(Ljava/lang/String;[Ljava/lang/String;)V", "Lorg/gnit/lucenekmp/util/BytesRef;", "(ILjava/lang/String;[Lorg/gnit/lucenekmp/util/BytesRef;)V", "(Ljava/lang/String;[Lorg/gnit/lucenekmp/util/BytesRef;)V", "getSlop", "()I", "getField", "()Ljava/lang/String;", "getTerms", "()[Lorg/gnit/lucenekmp/index/Term;", "[Lorg/gnit/lucenekmp/index/Term;", "getPositions", "()[I", "rewrite", "indexSearcher", "Lorg/gnit/lucenekmp/search/IndexSearcher;", "visit", "", "visitor", "Lorg/gnit/lucenekmp/search/QueryVisitor;", "createWeight", "Lorg/gnit/lucenekmp/search/Weight;", "searcher", "scoreMode", "Lorg/gnit/lucenekmp/search/ScoreMode;", "boost", "", "toString", "f", "equals", "", "other", "", "equalsTo", "hashCode", "Builder", "PostingsAndFreq", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nPhraseQuery.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PhraseQuery.kt\norg/gnit/lucenekmp/search/PhraseQuery\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,594:1\n1#2:595\n*E\n"})
public final class PhraseQuery
extends Query {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int slop;
    @Nullable
    private final String field;
    @NotNull
    private final Term[] terms;
    @NotNull
    private final int[] positions;
    private static final int TERM_POSNS_SEEK_OPS_PER_DOC = 128;
    private static final int TERM_OPS_PER_POS = 7;

    private PhraseQuery(int slop, Term[] terms, int[] positions) {
        int i;
        if (!(terms.length == positions.length)) {
            boolean $i$a$-require-PhraseQuery$32 = false;
            String $i$a$-require-PhraseQuery$32 = "Must have as many terms as positions";
            throw new IllegalArgumentException($i$a$-require-PhraseQuery$32.toString());
        }
        if (!(slop >= 0)) {
            boolean bl = false;
            String string = "Slop must be >= 0, got " + slop;
            throw new IllegalArgumentException(string.toString());
        }
        for (Term term : terms) {
            if (term != null) continue;
            boolean $i$a$-requireNotNull-PhraseQuery$42 = false;
            String $i$a$-requireNotNull-PhraseQuery$42 = "Cannot add a null term to PhraseQuery";
            throw new IllegalArgumentException($i$a$-requireNotNull-PhraseQuery$42.toString());
        }
        int n = terms.length;
        for (i = 1; i < n; ++i) {
            if (Intrinsics.areEqual((Object)terms[i - 1].field(), (Object)terms[i].field())) continue;
            boolean $i$a$-require-PhraseQuery$72 = false;
            String $i$a$-require-PhraseQuery$72 = "All terms should have the same field";
            throw new IllegalArgumentException($i$a$-require-PhraseQuery$72.toString());
        }
        for (int position : positions) {
            if (position >= 0) continue;
            boolean bl = false;
            String string = "Positions must be >= 0, got " + position;
            throw new IllegalArgumentException(string.toString());
        }
        n = positions.length;
        for (i = 1; i < n; ++i) {
            if (positions[i] >= positions[i - 1]) continue;
            boolean bl = false;
            String string = "Positions should not go backwards, got " + positions[i - 1] + " before " + positions[i];
            throw new IllegalArgumentException(string.toString());
        }
        this.slop = slop;
        this.terms = terms;
        this.positions = positions;
        this.field = terms.length == 0 ? null : terms[0].field();
    }

    public final int getSlop() {
        return this.slop;
    }

    @Nullable
    public final String getField() {
        return this.field;
    }

    @NotNull
    public final Term[] getTerms() {
        return this.terms;
    }

    @NotNull
    public final int[] getPositions() {
        return this.positions;
    }

    public PhraseQuery(int slop, @NotNull String field, String ... terms) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)terms, (String)"terms");
        this(slop, PhraseQuery.Companion.toTerms(field, Arrays.copyOf(terms, terms.length)), PhraseQuery.Companion.incrementalPositions(terms.length));
    }

    public PhraseQuery(@NotNull String field, String ... terms) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)terms, (String)"terms");
        this(0, field, Arrays.copyOf(terms, terms.length));
    }

    public PhraseQuery(int slop, @NotNull String field, BytesRef ... terms) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)terms, (String)"terms");
        this(slop, PhraseQuery.Companion.toTerms(field, Arrays.copyOf(terms, terms.length)), PhraseQuery.Companion.incrementalPositions(terms.length));
    }

    public PhraseQuery(@NotNull String field, BytesRef ... terms) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)terms, (String)"terms");
        this(0, field, Arrays.copyOf(terms, terms.length));
    }

    @Override
    @NotNull
    public Query rewrite(@NotNull IndexSearcher indexSearcher) {
        Intrinsics.checkNotNullParameter((Object)indexSearcher, (String)"indexSearcher");
        if (this.terms.length == 0) {
            return new MatchNoDocsQuery("empty PhraseQuery");
        }
        if (this.terms.length == 1) {
            return new TermQuery(this.terms[0]);
        }
        if (this.positions[0] != 0) {
            int[] newPositions = new int[this.positions.length];
            int n = this.positions.length;
            for (int i = 0; i < n; ++i) {
                newPositions[i] = this.positions[i] - this.positions[0];
            }
            return new PhraseQuery(this.slop, this.terms, newPositions);
        }
        return super.rewrite(indexSearcher);
    }

    @Override
    public void visit(@NotNull QueryVisitor visitor2) {
        Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
        if (!visitor2.acceptField(this.field)) {
            return;
        }
        QueryVisitor v = visitor2.getSubVisitor(BooleanClause.Occur.MUST, this);
        Term[] termArray = this.terms;
        v.consumeTerms(this, Arrays.copyOf(termArray, termArray.length));
    }

    @Override
    @NotNull
    public Weight createWeight(@NotNull IndexSearcher searcher, @NotNull ScoreMode scoreMode, float boost) {
        Intrinsics.checkNotNullParameter((Object)searcher, (String)"searcher");
        Intrinsics.checkNotNullParameter((Object)((Object)scoreMode), (String)"scoreMode");
        String string = this.field;
        Intrinsics.checkNotNull((Object)string);
        String string2 = string;
        return new PhraseWeight(this, searcher, scoreMode, boost, string2){
            private transient TermStates[] states;
            final /* synthetic */ PhraseQuery this$0;
            final /* synthetic */ ScoreMode $scoreMode;
            final /* synthetic */ float $boost;
            {
                this.this$0 = $receiver;
                this.$scoreMode = $scoreMode;
                this.$boost = $boost;
                super($receiver, $super_call_param$1, $searcher, $scoreMode);
            }

            /*
             * WARNING - void declaration
             */
            protected Similarity.SimScorer getStats(IndexSearcher searcher) throws IOException {
                TermStatistics[] term;
                Intrinsics.checkNotNullParameter((Object)searcher, (String)"searcher");
                int[] positions = this.this$0.getPositions();
                if (!(positions.length >= 2)) {
                    boolean $i$a$-check-PhraseQuery$createWeight$1$getStats$32 = false;
                    String $i$a$-check-PhraseQuery$createWeight$1$getStats$32 = "PhraseWeight does not support less than 2 terms, call rewrite first";
                    throw new IllegalStateException($i$a$-check-PhraseQuery$createWeight$1$getStats$32.toString());
                }
                if (!(positions[0] == 0)) {
                    boolean $i$a$-check-PhraseQuery$createWeight$1$getStats$42 = false;
                    String $i$a$-check-PhraseQuery$createWeight$1$getStats$42 = "PhraseWeight requires that the first position is 0, call rewrite first";
                    throw new IllegalStateException($i$a$-check-PhraseQuery$createWeight$1$getStats$42.toString());
                }
                this.states = new TermStates[this.this$0.getTerms().length];
                TermStatistics[] termStats = new TermStatistics[this.this$0.getTerms().length];
                int termUpTo = 0;
                int n = this.this$0.getTerms().length;
                for (int i = 0; i < n; ++i) {
                    TermStates ts;
                    term = this.this$0.getTerms()[i];
                    TermStates[] termStatesArray = this.states;
                    if (this.states == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"states");
                        termStatesArray = null;
                    }
                    termStatesArray[i] = TermStates.Companion.build(searcher, (Term)term, this.$scoreMode.needsScores());
                    if (!this.$scoreMode.needsScores()) continue;
                    TermStates[] termStatesArray2 = this.states;
                    if (this.states == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"states");
                        termStatesArray2 = null;
                    }
                    if ((ts = termStatesArray2[i]).docFreq() <= 0) continue;
                    int n2 = termUpTo++;
                    TermStatistics termStatistics = searcher.termStatistics((Term)term, ts.docFreq(), ts.totalTermFreq());
                    Intrinsics.checkNotNull((Object)termStatistics);
                    termStats[n2] = termStatistics;
                }
                if (termUpTo > 0) {
                    TermStatistics[] termStatisticsArray;
                    void from$iv;
                    void to$iv;
                    Similarity similarity = this.getSimilarity();
                    CollectionStatistics collectionStatistics = searcher.collectionStatistics(this.getField());
                    Intrinsics.checkNotNull((Object)collectionStatistics);
                    ArrayUtil.Companion companion = ArrayUtil.Companion;
                    term = termStats;
                    boolean ts = false;
                    int n3 = termUpTo;
                    CollectionStatistics collectionStatistics2 = collectionStatistics;
                    float f = this.$boost;
                    Similarity similarity2 = similarity;
                    boolean $i$f$copyOfSubArray = false;
                    void subLength$iv = to$iv - from$iv;
                    int n4 = 0;
                    TermStatistics[] termStatisticsArray2 = new TermStatistics[subLength$iv];
                    while (n4 < subLength$iv) {
                        void array$iv;
                        int n5 = n4++;
                        termStatisticsArray2[n5] = array$iv[from$iv + n5];
                    }
                    TermStatistics[] termStatisticsArray3 = termStatisticsArray = termStatisticsArray2;
                    return similarity2.scorer(f, collectionStatistics2, Arrays.copyOf(termStatisticsArray3, termStatisticsArray3.length));
                }
                return null;
            }

            protected PhraseMatcher getPhraseMatcher(LeafReaderContext context, Similarity.SimScorer scorer2, boolean exposeOffsets) throws IOException {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)scorer2, (String)"scorer");
                boolean condition$iv = this.this$0.getTerms().length > 0;
                boolean $i$f$assert = false;
                if (_Assertions.ENABLED && !condition$iv) {
                    boolean $i$a$-assert-AssertKt$assert$22 = false;
                    String $i$a$-assert-AssertKt$assert$22 = "assertion failed";
                    throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$22);
                }
                LeafReader reader2 = context.reader();
                PostingsAndFreq[] postingsFreqs = new PostingsAndFreq[this.this$0.getTerms().length];
                Terms fieldTerms = reader2.terms(this.getField());
                if (fieldTerms == null) {
                    return null;
                }
                if (!fieldTerms.hasPositions()) {
                    boolean $i$a$-check-PhraseQuery$createWeight$1$getPhraseMatcher$22 = false;
                    String $i$a$-check-PhraseQuery$createWeight$1$getPhraseMatcher$22 = "field \"" + this.getField() + "\" was indexed without position data; cannot run PhraseQuery (phrase=" + this.getQuery() + ")";
                    throw new IllegalStateException($i$a$-check-PhraseQuery$createWeight$1$getPhraseMatcher$22.toString());
                }
                TermsEnum te = fieldTerms.iterator();
                float totalMatchCost = 0.0f;
                int n = this.this$0.getTerms().length;
                for (int i = 0; i < n; ++i) {
                    TermState state2;
                    IOSupplier<TermState> supplier;
                    Term t = this.this$0.getTerms()[i];
                    TermStates[] termStatesArray = this.states;
                    if (this.states == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"states");
                        termStatesArray = null;
                    }
                    IOSupplier<TermState> iOSupplier = supplier = termStatesArray[i].get(context);
                    TermState termState2 = state2 = iOSupplier != null ? iOSupplier.get() : null;
                    if (state2 == null) {
                        boolean condition$iv2 = org.gnit.lucenekmp.search.PhraseQuery$Companion.access$termNotInReader(PhraseQuery.Companion, reader2, t);
                        boolean $i$f$assert2 = false;
                        if (_Assertions.ENABLED && !condition$iv2) {
                            boolean bl = false;
                            String string = "no termstate found but term exists in reader";
                            throw new AssertionError((Object)string);
                        }
                        return null;
                    }
                    te.seekExact(t.bytes(), state2);
                    PostingsEnum postingsEnum = null;
                    ImpactsEnum impactsEnum = null;
                    if (this.$scoreMode == ScoreMode.TOP_SCORES) {
                        impactsEnum = te.impacts(exposeOffsets ? PostingsEnum.Companion.getOFFSETS() : PostingsEnum.Companion.getPOSITIONS());
                        postingsEnum = impactsEnum;
                    } else {
                        postingsEnum = te.postings(null, exposeOffsets ? PostingsEnum.Companion.getOFFSETS() : PostingsEnum.Companion.getPOSITIONS());
                        impactsEnum = new SlowImpactsEnum(postingsEnum);
                    }
                    Term[] termArray = new Term[]{t};
                    postingsFreqs[i] = new PostingsAndFreq(postingsEnum, impactsEnum, this.this$0.getPositions()[i], termArray);
                    totalMatchCost += PhraseQuery.Companion.termPositionsCost(te);
                }
                if (this.this$0.getSlop() == 0) {
                    ArrayUtil.Companion.timSort(postingsFreqs);
                    return new ExactPhraseMatcher(postingsFreqs, this.$scoreMode, scorer2, totalMatchCost);
                }
                return new SloppyPhraseMatcher(postingsFreqs, this.this$0.getSlop(), this.$scoreMode, scorer2, totalMatchCost, exposeOffsets);
            }
        };
    }

    @Override
    @NotNull
    public String toString(@Nullable String f) {
        int i;
        StringBuilder buffer = new StringBuilder();
        if (this.field != null && !Intrinsics.areEqual((Object)this.field, (Object)f)) {
            buffer.append(this.field);
            buffer.append(":");
        }
        buffer.append("\"");
        int maxPosition = 0;
        maxPosition = this.positions.length == 0 ? -1 : this.positions[this.positions.length - 1];
        String[] pieces = new String[maxPosition + 1];
        int n = this.terms.length;
        for (i = 0; i < n; ++i) {
            int pos = this.positions[i];
            Object s = pieces[pos];
            s = s == null ? this.terms[i].text() : (String)s + "|" + this.terms[i].text();
            pieces[pos] = s;
        }
        n = pieces.length;
        for (i = 0; i < n; ++i) {
            String s;
            if (i > 0) {
                buffer.append(' ');
            }
            StringBuilder stringBuilder = (s = pieces[i]) == null ? buffer.append("") : buffer.append(s);
        }
        buffer.append("\"");
        if (this.slop != 0) {
            buffer.append("~");
            buffer.append(this.slop);
        }
        String string = buffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return this.sameClassAs(other) && this.equalsTo((PhraseQuery)KClasses.cast((KClass)Reflection.getOrCreateKotlinClass(this.getClass()), (Object)other));
    }

    private final boolean equalsTo(PhraseQuery other) {
        return this.slop == other.slop && Arrays.equals(this.terms, other.terms) && Arrays.equals(this.positions, other.positions);
    }

    @Override
    public int hashCode() {
        int h = this.classHash();
        h = 31 * h + this.slop;
        h = 31 * h + Arrays.hashCode(this.terms);
        h = 31 * h + Arrays.hashCode(this.positions);
        return h;
    }

    public /* synthetic */ PhraseQuery(int slop, Term[] terms, int[] positions, DefaultConstructorMarker $constructor_marker) {
        this(slop, terms, positions);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005J\u001a\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\b2\b\b\u0002\u0010\u000e\u001a\u00020\u0005H\u0007J\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/gnit/lucenekmp/search/PhraseQuery$Builder;", "", "<init>", "()V", "slop", "", "terms", "", "Lorg/gnit/lucenekmp/index/Term;", "positions", "Lorg/gnit/lucenekmp/internal/hppc/IntArrayList;", "setSlop", "add", "term", "position", "build", "Lorg/gnit/lucenekmp/search/PhraseQuery;", "core"})
    @SourceDebugExtension(value={"SMAP\nPhraseQuery.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PhraseQuery.kt\norg/gnit/lucenekmp/search/PhraseQuery$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,594:1\n1#2:595\n37#3:596\n36#3,3:597\n*S KotlinDebug\n*F\n+ 1 PhraseQuery.kt\norg/gnit/lucenekmp/search/PhraseQuery$Builder\n*L\n118#1:596\n118#1:597,3\n*E\n"})
    public static final class Builder {
        private int slop;
        @NotNull
        private final List<Term> terms = new ArrayList();
        @NotNull
        private final IntArrayList positions = new IntArrayList();

        @NotNull
        public final Builder setSlop(int slop) {
            this.slop = slop;
            return this;
        }

        @JvmOverloads
        @NotNull
        public final Builder add(@NotNull Term term, int position) {
            int lastPosition;
            Intrinsics.checkNotNullParameter((Object)term, (String)"term");
            if (!(position >= 0)) {
                boolean $i$a$-require-PhraseQuery$Builder$add$52 = false;
                String $i$a$-require-PhraseQuery$Builder$add$52 = "Positions must be >= 0, got " + position;
                throw new IllegalArgumentException($i$a$-require-PhraseQuery$Builder$add$52.toString());
            }
            if (!this.positions.isEmpty() && !(position >= (lastPosition = this.positions.get(this.positions.size() - 1)))) {
                boolean bl = false;
                String string = "Positions must be added in order, got " + position + " after " + lastPosition;
                throw new IllegalArgumentException(string.toString());
            }
            if (!(this.terms.isEmpty() || Intrinsics.areEqual((Object)term.field(), (Object)this.terms.get(0).field()))) {
                boolean bl = false;
                String string = "All terms must be on the same field, got " + term.field() + " and " + this.terms.get(0).field();
                throw new IllegalArgumentException(string.toString());
            }
            this.terms.add(term);
            this.positions.add(position);
            return this;
        }

        public static /* synthetic */ Builder add$default(Builder builder, Term term, int n, int n2, Object object) {
            if ((n2 & 2) != 0) {
                n = builder.positions.isEmpty() ? 0 : 1 + builder.positions.get(builder.positions.size() - 1);
            }
            return builder.add(term, n);
        }

        @NotNull
        public final PhraseQuery build() {
            Collection $this$toTypedArray$iv = this.terms;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Term[] terms = thisCollection$iv.toArray(new Term[0]);
            return new PhraseQuery(this.slop, terms, this.positions.toArray(), null);
        }

        @JvmOverloads
        @NotNull
        public final Builder add(@NotNull Term term) {
            Intrinsics.checkNotNullParameter((Object)term, (String)"term");
            return Builder.add$default(this, term, 0, 2, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J/\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\t\"\u00020\fH\u0002\u00a2\u0006\u0002\u0010\u000eJ/\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\t\"\u00020\u0010H\u0002\u00a2\u0006\u0002\u0010\u0011J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\nH\u0002R\u000e\u0010\u0012\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/gnit/lucenekmp/search/PhraseQuery$Companion;", "", "<init>", "()V", "incrementalPositions", "", "length", "", "toTerms", "", "Lorg/gnit/lucenekmp/index/Term;", "field", "", "termStrings", "(Ljava/lang/String;[Ljava/lang/String;)[Lorg/gnit/lucenekmp/index/Term;", "termBytes", "Lorg/gnit/lucenekmp/util/BytesRef;", "(Ljava/lang/String;[Lorg/gnit/lucenekmp/util/BytesRef;)[Lorg/gnit/lucenekmp/index/Term;", "TERM_POSNS_SEEK_OPS_PER_DOC", "TERM_OPS_PER_POS", "termPositionsCost", "", "termsEnum", "Lorg/gnit/lucenekmp/index/TermsEnum;", "termNotInReader", "", "reader", "Lorg/gnit/lucenekmp/index/LeafReader;", "term", "core"})
    @SourceDebugExtension(value={"SMAP\nPhraseQuery.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PhraseQuery.kt\norg/gnit/lucenekmp/search/PhraseQuery$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 4 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n*L\n1#1,594:1\n1#2:595\n3#3,8:596\n10#4:604\n*S KotlinDebug\n*F\n+ 1 PhraseQuery.kt\norg/gnit/lucenekmp/search/PhraseQuery$Companion\n*L\n578#1:596,8\n578#1:604\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final int[] incrementalPositions(int length) {
            int[] positions = new int[length];
            for (int i = 0; i < length; ++i) {
                positions[i] = i;
            }
            return positions;
        }

        private final Term[] toTerms(String field, String ... termStrings) {
            Term[] terms = new Term[termStrings.length];
            int n = terms.length;
            for (int i = 0; i < n; ++i) {
                if (termStrings[i] == null) {
                    boolean bl = false;
                    String string = "Cannot add a null term to PhraseQuery";
                    throw new IllegalArgumentException(string.toString());
                }
                terms[i] = new Term(field, termStrings[i]);
            }
            return terms;
        }

        private final Term[] toTerms(String field, BytesRef ... termBytes) {
            Term[] terms = new Term[termBytes.length];
            int n = terms.length;
            for (int i = 0; i < n; ++i) {
                if (termBytes[i] == null) {
                    boolean bl = false;
                    String string = "Cannot add a null term to PhraseQuery";
                    throw new IllegalArgumentException(string.toString());
                }
                terms[i] = new Term(field, termBytes[i]);
            }
            return terms;
        }

        public final float termPositionsCost(@NotNull TermsEnum termsEnum) throws IOException {
            Intrinsics.checkNotNullParameter((Object)termsEnum, (String)"termsEnum");
            int docFreq = termsEnum.docFreq();
            boolean condition$iv = docFreq > 0;
            boolean $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv) {
                boolean bl = false;
                String string = "assertion failed";
                throw new AssertionError((Object)string);
            }
            long totalTermFreq = termsEnum.totalTermFreq();
            float expOccurrencesInMatchingDoc = (float)totalTermFreq / (float)docFreq;
            return (float)128 + expOccurrencesInMatchingDoc * (float)7;
        }

        private final boolean termNotInReader(LeafReader reader2, Term term) throws IOException {
            return reader2.docFreq(term) == 0;
        }

        public static final /* synthetic */ boolean access$termNotInReader(Companion $this, LeafReader reader2, Term term) {
            return $this.termNotInReader(reader2, term);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B5\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\t\"\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fB/\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\r\u00a2\u0006\u0004\b\u000b\u0010\u000eJ\u0011\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u0000H\u0096\u0002J\b\u0010\u001c\u001a\u00020\u0007H\u0016J\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0096\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001d\u0010\b\u001a\f\u0012\u0006\b\u0001\u0012\u00020\n\u0018\u00010\t\u00a2\u0006\n\n\u0002\u0010\u0017\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0018\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0014\u00a8\u0006!"}, d2={"Lorg/gnit/lucenekmp/search/PhraseQuery$PostingsAndFreq;", "", "postings", "Lorg/gnit/lucenekmp/index/PostingsEnum;", "impacts", "Lorg/gnit/lucenekmp/index/ImpactsEnum;", "position", "", "terms", "", "Lorg/gnit/lucenekmp/index/Term;", "<init>", "(Lorg/gnit/lucenekmp/index/PostingsEnum;Lorg/gnit/lucenekmp/index/ImpactsEnum;I[Lorg/gnit/lucenekmp/index/Term;)V", "", "(Lorg/gnit/lucenekmp/index/PostingsEnum;Lorg/gnit/lucenekmp/index/ImpactsEnum;ILjava/util/List;)V", "getPostings", "()Lorg/gnit/lucenekmp/index/PostingsEnum;", "getImpacts", "()Lorg/gnit/lucenekmp/index/ImpactsEnum;", "getPosition", "()I", "getTerms", "()[Lorg/gnit/lucenekmp/index/Term;", "[Lorg/gnit/lucenekmp/index/Term;", "nTerms", "getNTerms", "compareTo", "other", "hashCode", "equals", "", "obj", "", "core"})
    @SourceDebugExtension(value={"SMAP\nPhraseQuery.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PhraseQuery.kt\norg/gnit/lucenekmp/search/PhraseQuery$PostingsAndFreq\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,594:1\n37#2:595\n36#2,3:596\n*S KotlinDebug\n*F\n+ 1 PhraseQuery.kt\norg/gnit/lucenekmp/search/PhraseQuery$PostingsAndFreq\n*L\n267#1:595\n267#1:596,3\n*E\n"})
    public static final class PostingsAndFreq
    implements Comparable<PostingsAndFreq> {
        @NotNull
        private final PostingsEnum postings;
        @NotNull
        private final ImpactsEnum impacts;
        private final int position;
        @Nullable
        private final Term[] terms;
        private final int nTerms;

        @NotNull
        public final PostingsEnum getPostings() {
            return this.postings;
        }

        @NotNull
        public final ImpactsEnum getImpacts() {
            return this.impacts;
        }

        public final int getPosition() {
            return this.position;
        }

        @Nullable
        public final Term[] getTerms() {
            return this.terms;
        }

        public final int getNTerms() {
            return this.nTerms;
        }

        public PostingsAndFreq(@NotNull PostingsEnum postings, @NotNull ImpactsEnum impacts2, int position, Term ... terms) {
            Intrinsics.checkNotNullParameter((Object)postings, (String)"postings");
            Intrinsics.checkNotNullParameter((Object)impacts2, (String)"impacts");
            Intrinsics.checkNotNullParameter((Object)terms, (String)"terms");
            this.postings = postings;
            this.impacts = impacts2;
            this.position = position;
            this.nTerms = terms.length;
            if (this.nTerms > 0) {
                if (terms.length == 1) {
                    this.terms = terms;
                } else {
                    Term[] terms2 = new Term[terms.length];
                    System.INSTANCE.arraycopyKt(terms, 0, terms2, 0, terms.length);
                    org.gnit.lucenekmp.jdkport.Arrays.INSTANCE.sort(terms2);
                    this.terms = terms2;
                }
            } else {
                this.terms = null;
            }
        }

        public PostingsAndFreq(@NotNull PostingsEnum postings, @NotNull ImpactsEnum impacts2, int position, @NotNull List<Term> terms) {
            Intrinsics.checkNotNullParameter((Object)postings, (String)"postings");
            Intrinsics.checkNotNullParameter((Object)impacts2, (String)"impacts");
            Intrinsics.checkNotNullParameter(terms, (String)"terms");
            this.postings = postings;
            this.impacts = impacts2;
            this.position = position;
            this.nTerms = terms.size();
            if (this.nTerms > 0) {
                Collection $this$toTypedArray$iv = terms;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                Term[] terms2 = thisCollection$iv.toArray(new Term[0]);
                if (this.nTerms > 1) {
                    org.gnit.lucenekmp.jdkport.Arrays.INSTANCE.sort(terms2);
                }
                this.terms = terms2;
            } else {
                this.terms = null;
            }
        }

        @Override
        public int compareTo(@NotNull PostingsAndFreq other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            if (this.position != other.position) {
                return this.position - other.position;
            }
            if (this.nTerms != other.nTerms) {
                return this.nTerms - other.nTerms;
            }
            if (this.nTerms == 0) {
                return 0;
            }
            Intrinsics.checkNotNull((Object)this.terms);
            int n = this.terms.length;
            for (int i = 0; i < n; ++i) {
                Term term = this.terms[i];
                Intrinsics.checkNotNull((Object)other.terms);
                int res = term.compareTo(other.terms[i]);
                if (res == 0) continue;
                return res;
            }
            return 0;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = prime * result + this.position;
            int n = this.nTerms;
            for (int i = 0; i < n; ++i) {
                Intrinsics.checkNotNull((Object)this.terms);
                result = prime * result + this.terms[i].hashCode();
            }
            return result;
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PostingsAndFreq other = (PostingsAndFreq)obj;
            if (this.position != other.position) {
                return false;
            }
            if (this.terms == null) {
                return other.terms == null;
            }
            return Arrays.equals(this.terms, other.terms);
        }
    }
}

