/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.search;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.index.NumericDocValues;
import org.gnit.lucenekmp.search.DocIdSetIterator;
import org.gnit.lucenekmp.search.ImpactsDISI;
import org.gnit.lucenekmp.search.MaxScoreCache;
import org.gnit.lucenekmp.search.PhraseMatcher;
import org.gnit.lucenekmp.search.ScoreMode;
import org.gnit.lucenekmp.search.Scorer;
import org.gnit.lucenekmp.search.TwoPhaseIterator;
import org.gnit.lucenekmp.search.similarities.Similarity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020\u001dH\u0016J\b\u0010+\u001a\u00020\u0011H\u0016J\u0010\u0010,\u001a\u00020)2\u0006\u0010-\u001a\u00020)H\u0016J\u0010\u0010.\u001a\u00020\u001d2\u0006\u0010/\u001a\u00020)H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR$\u0010!\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u001d@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u001f\"\u0004\b#\u0010$R\u000e\u0010%\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lorg/gnit/lucenekmp/search/PhraseScorer;", "Lorg/gnit/lucenekmp/search/Scorer;", "matcher", "Lorg/gnit/lucenekmp/search/PhraseMatcher;", "scoreMode", "Lorg/gnit/lucenekmp/search/ScoreMode;", "simScorer", "Lorg/gnit/lucenekmp/search/similarities/Similarity$SimScorer;", "norms", "Lorg/gnit/lucenekmp/index/NumericDocValues;", "<init>", "(Lorg/gnit/lucenekmp/search/PhraseMatcher;Lorg/gnit/lucenekmp/search/ScoreMode;Lorg/gnit/lucenekmp/search/similarities/Similarity$SimScorer;Lorg/gnit/lucenekmp/index/NumericDocValues;)V", "getMatcher", "()Lorg/gnit/lucenekmp/search/PhraseMatcher;", "getScoreMode", "()Lorg/gnit/lucenekmp/search/ScoreMode;", "approximation", "Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "getApproximation", "()Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "impactsApproximation", "Lorg/gnit/lucenekmp/search/ImpactsDISI;", "getImpactsApproximation", "()Lorg/gnit/lucenekmp/search/ImpactsDISI;", "maxScoreCache", "Lorg/gnit/lucenekmp/search/MaxScoreCache;", "getMaxScoreCache", "()Lorg/gnit/lucenekmp/search/MaxScoreCache;", "matchCost", "", "getMatchCost", "()F", "minScore", "minCompetitiveScore", "getMinCompetitiveScore", "setMinCompetitiveScore", "(F)V", "freq", "twoPhaseIterator", "Lorg/gnit/lucenekmp/search/TwoPhaseIterator;", "docID", "", "score", "iterator", "advanceShallow", "target", "getMaxScore", "upTo", "core"})
public final class PhraseScorer
extends Scorer {
    @NotNull
    private final PhraseMatcher matcher;
    @NotNull
    private final ScoreMode scoreMode;
    @NotNull
    private final Similarity.SimScorer simScorer;
    @Nullable
    private final NumericDocValues norms;
    @NotNull
    private final DocIdSetIterator approximation;
    @NotNull
    private final ImpactsDISI impactsApproximation;
    @NotNull
    private final MaxScoreCache maxScoreCache;
    private final float matchCost;
    private float minCompetitiveScore;
    private float freq;

    public PhraseScorer(@NotNull PhraseMatcher matcher, @NotNull ScoreMode scoreMode, @NotNull Similarity.SimScorer simScorer, @Nullable NumericDocValues norms) {
        Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
        Intrinsics.checkNotNullParameter((Object)((Object)scoreMode), (String)"scoreMode");
        Intrinsics.checkNotNullParameter((Object)simScorer, (String)"simScorer");
        this.matcher = matcher;
        this.scoreMode = scoreMode;
        this.simScorer = simScorer;
        this.norms = norms;
        this.approximation = this.matcher.approximation();
        this.impactsApproximation = this.matcher.impactsApproximation();
        this.maxScoreCache = this.impactsApproximation.getMaxScoreCache();
        this.matchCost = this.matcher.getMatchCost();
    }

    @NotNull
    public final PhraseMatcher getMatcher() {
        return this.matcher;
    }

    @NotNull
    public final ScoreMode getScoreMode() {
        return this.scoreMode;
    }

    @NotNull
    public final DocIdSetIterator getApproximation() {
        return this.approximation;
    }

    @NotNull
    public final ImpactsDISI getImpactsApproximation() {
        return this.impactsApproximation;
    }

    @NotNull
    public final MaxScoreCache getMaxScoreCache() {
        return this.maxScoreCache;
    }

    public final float getMatchCost() {
        return this.matchCost;
    }

    @Override
    public float getMinCompetitiveScore() {
        return this.minCompetitiveScore;
    }

    @Override
    public void setMinCompetitiveScore(float minScore) {
        this.setMinCompetitiveScore(minScore);
        this.impactsApproximation.setMinCompetitiveScore(minScore);
    }

    @Override
    @NotNull
    public TwoPhaseIterator twoPhaseIterator() {
        DocIdSetIterator docIdSetIterator = this.approximation;
        return new TwoPhaseIterator(this, docIdSetIterator){
            final /* synthetic */ PhraseScorer this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public boolean matches() throws IOException {
                this.this$0.getMatcher().reset();
                if (this.this$0.getScoreMode() == ScoreMode.TOP_SCORES && this.this$0.getMinCompetitiveScore() > 0.0f) {
                    float maxFreq = this.this$0.getMatcher().maxFreq();
                    long norm = 1L;
                    if (PhraseScorer.access$getNorms$p(this.this$0) != null && PhraseScorer.access$getNorms$p(this.this$0).advanceExact(this.this$0.docID())) {
                        norm = PhraseScorer.access$getNorms$p(this.this$0).longValue();
                    }
                    if (PhraseScorer.access$getSimScorer$p(this.this$0).score(maxFreq, norm) < this.this$0.getMinCompetitiveScore()) {
                        return false;
                    }
                }
                PhraseScorer.access$setFreq$p(this.this$0, 0.0f);
                return this.this$0.getMatcher().nextMatch();
            }

            public float matchCost() {
                return this.this$0.getMatchCost();
            }
        };
    }

    @Override
    public int docID() {
        return this.approximation.docID();
    }

    @Override
    public float score() throws IOException {
        if (this.freq == 0.0f) {
            this.freq = this.matcher.sloppyWeight();
            while (this.matcher.nextMatch()) {
                this.freq += this.matcher.sloppyWeight();
            }
        }
        long norm = 1L;
        if (this.norms != null && this.norms.advanceExact(this.docID())) {
            norm = this.norms.longValue();
        }
        return this.simScorer.score(this.freq, norm);
    }

    @Override
    @NotNull
    public DocIdSetIterator iterator() {
        return TwoPhaseIterator.Companion.asDocIdSetIterator(this.twoPhaseIterator());
    }

    @Override
    public int advanceShallow(int target) throws IOException {
        return this.maxScoreCache.advanceShallow(target);
    }

    @Override
    public float getMaxScore(int upTo) throws IOException {
        return this.maxScoreCache.getMaxScore(upTo);
    }

    public static final /* synthetic */ NumericDocValues access$getNorms$p(PhraseScorer $this) {
        return $this.norms;
    }

    public static final /* synthetic */ Similarity.SimScorer access$getSimScorer$p(PhraseScorer $this) {
        return $this.simScorer;
    }

    public static final /* synthetic */ void access$setFreq$p(PhraseScorer $this, float f) {
        $this.freq = f;
    }
}

