/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.search;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.gnit.lucenekmp.index.LeafReaderContext;
import org.gnit.lucenekmp.index.NumericDocValues;
import org.gnit.lucenekmp.search.Explanation;
import org.gnit.lucenekmp.search.IndexSearcher;
import org.gnit.lucenekmp.search.Matches;
import org.gnit.lucenekmp.search.MatchesIterator;
import org.gnit.lucenekmp.search.MatchesUtils;
import org.gnit.lucenekmp.search.PhraseMatcher;
import org.gnit.lucenekmp.search.PhraseScorer;
import org.gnit.lucenekmp.search.Query;
import org.gnit.lucenekmp.search.ScoreMode;
import org.gnit.lucenekmp.search.ScorerSupplier;
import org.gnit.lucenekmp.search.Weight;
import org.gnit.lucenekmp.search.similarities.Similarity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B)\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0006\u001a\u00020\u0007H$J\"\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u001eH$J\u0012\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010!\u001a\u00020\"2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020$H\u0016J\u001a\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010'\u001a\u00020\u001e2\u0006\u0010(\u001a\u00020\u001bH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006)"}, d2={"Lorg/gnit/lucenekmp/search/PhraseWeight;", "Lorg/gnit/lucenekmp/search/Weight;", "query", "Lorg/gnit/lucenekmp/search/Query;", "field", "", "searcher", "Lorg/gnit/lucenekmp/search/IndexSearcher;", "scoreMode", "Lorg/gnit/lucenekmp/search/ScoreMode;", "<init>", "(Lorg/gnit/lucenekmp/search/Query;Ljava/lang/String;Lorg/gnit/lucenekmp/search/IndexSearcher;Lorg/gnit/lucenekmp/search/ScoreMode;)V", "getField", "()Ljava/lang/String;", "getScoreMode", "()Lorg/gnit/lucenekmp/search/ScoreMode;", "stats", "Lorg/gnit/lucenekmp/search/similarities/Similarity$SimScorer;", "getStats", "()Lorg/gnit/lucenekmp/search/similarities/Similarity$SimScorer;", "similarity", "Lorg/gnit/lucenekmp/search/similarities/Similarity;", "getSimilarity", "()Lorg/gnit/lucenekmp/search/similarities/Similarity;", "getPhraseMatcher", "Lorg/gnit/lucenekmp/search/PhraseMatcher;", "context", "Lorg/gnit/lucenekmp/index/LeafReaderContext;", "scorer", "exposeOffsets", "", "scorerSupplier", "Lorg/gnit/lucenekmp/search/ScorerSupplier;", "explain", "Lorg/gnit/lucenekmp/search/Explanation;", "doc", "", "matches", "Lorg/gnit/lucenekmp/search/Matches;", "isCacheable", "ctx", "core"})
public abstract class PhraseWeight
extends Weight {
    @NotNull
    private final String field;
    @NotNull
    private final ScoreMode scoreMode;
    @NotNull
    private final Similarity.SimScorer stats;
    @NotNull
    private final Similarity similarity;

    protected PhraseWeight(@NotNull Query query, @NotNull String field, @NotNull IndexSearcher searcher, @NotNull ScoreMode scoreMode) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)searcher, (String)"searcher");
        Intrinsics.checkNotNullParameter((Object)((Object)scoreMode), (String)"scoreMode");
        super(query);
        this.field = field;
        this.scoreMode = scoreMode;
        this.similarity = searcher.getSimilarity();
        Similarity.SimScorer stats = this.getStats(searcher);
        if (stats == null) {
            stats = new Similarity.SimScorer(){

                @Override
                public float score(float freq, long norm) {
                    return 1.0f;
                }
            };
        }
        this.stats = stats;
    }

    @NotNull
    public final String getField() {
        return this.field;
    }

    @NotNull
    public final ScoreMode getScoreMode() {
        return this.scoreMode;
    }

    @NotNull
    public final Similarity.SimScorer getStats() {
        return this.stats;
    }

    @NotNull
    public final Similarity getSimilarity() {
        return this.similarity;
    }

    @Nullable
    protected abstract Similarity.SimScorer getStats(@NotNull IndexSearcher var1) throws IOException;

    @Nullable
    protected abstract PhraseMatcher getPhraseMatcher(@NotNull LeafReaderContext var1, @NotNull Similarity.SimScorer var2, boolean var3) throws IOException;

    @Override
    @Nullable
    public ScorerSupplier scorerSupplier(@NotNull LeafReaderContext context) throws IOException {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        PhraseMatcher matcher = this.getPhraseMatcher(context, this.stats, false);
        if (matcher == null) {
            return null;
        }
        NumericDocValues norms = this.scoreMode.needsScores() ? context.reader().getNormValues(this.field) : null;
        PhraseScorer scorer2 = new PhraseScorer(matcher, this.scoreMode, this.stats, norms);
        return new Weight.DefaultScorerSupplier(scorer2);
    }

    @Override
    @NotNull
    public Explanation explain(@NotNull LeafReaderContext context, int doc) throws IOException {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        PhraseMatcher matcher = this.getPhraseMatcher(context, this.stats, false);
        if (matcher == null || matcher.approximation().advance(doc) != doc) {
            return Explanation.Companion.noMatch("no matching terms", new Explanation[0]);
        }
        matcher.reset();
        if (!matcher.nextMatch()) {
            return Explanation.Companion.noMatch("no matching phrase", new Explanation[0]);
        }
        float freq = matcher.sloppyWeight();
        while (matcher.nextMatch()) {
            freq += matcher.sloppyWeight();
        }
        Explanation freqExplanation = Explanation.Companion.match((Number)Float.valueOf(freq), "phraseFreq=" + freq, new Explanation[0]);
        NumericDocValues norms = this.scoreMode.needsScores() ? context.reader().getNormValues(this.field) : null;
        long norm = 1L;
        if (norms != null && norms.advanceExact(doc)) {
            norm = norms.longValue();
        }
        Explanation scoreExplanation = this.stats.explain(freqExplanation, norm);
        Explanation[] explanationArray = new Explanation[]{scoreExplanation};
        return Explanation.Companion.match(scoreExplanation.getValue(), "weight(" + this.getQuery() + " in " + doc + ") [" + Reflection.getOrCreateKotlinClass(this.similarity.getClass()).getSimpleName() + "], result of:", explanationArray);
    }

    @Override
    @Nullable
    public Matches matches(@NotNull LeafReaderContext context, int doc) throws IOException {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return MatchesUtils.INSTANCE.forField(this.field, () -> PhraseWeight.matches$lambda$0(this, context, doc));
    }

    @Override
    public boolean isCacheable(@NotNull LeafReaderContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        return true;
    }

    private static final MatchesIterator matches$lambda$0(PhraseWeight this$0, LeafReaderContext $context, int $doc) {
        PhraseMatcher matcher = this$0.getPhraseMatcher($context, this$0.stats, true);
        if (matcher != null && matcher.approximation().advance($doc) != $doc) {
        }
        PhraseMatcher phraseMatcher = matcher;
        Intrinsics.checkNotNull((Object)phraseMatcher);
        phraseMatcher.reset();
        if (!matcher.nextMatch()) {
        }
        return new MatchesIterator(matcher, this$0){
            private boolean started;
            final /* synthetic */ PhraseMatcher $matcher;
            final /* synthetic */ PhraseWeight this$0;
            {
                this.$matcher = $matcher;
                this.this$0 = $receiver;
            }

            public final boolean getStarted() {
                return this.started;
            }

            public final void setStarted(boolean bl) {
                this.started = bl;
            }

            public boolean next() throws IOException {
                if (!this.started) {
                    boolean bl;
                    boolean it = bl = true;
                    boolean bl2 = false;
                    this.started = it;
                    return bl;
                }
                return this.$matcher.nextMatch();
            }

            public int startPosition() {
                return this.$matcher.startPosition();
            }

            public int endPosition() {
                return this.$matcher.endPosition();
            }

            public int startOffset() throws IOException {
                return this.$matcher.startOffset();
            }

            public int endOffset() throws IOException {
                return this.$matcher.endOffset();
            }

            public MatchesIterator getSubMatches() {
                return null;
            }

            public Query getQuery() {
                return this.this$0.getQuery();
            }
        };
    }
}

