/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.AbstractMutableCollection;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KClasses;
import org.gnit.lucenekmp.index.LeafReader;
import org.gnit.lucenekmp.index.LeafReaderContext;
import org.gnit.lucenekmp.index.PointValues;
import org.gnit.lucenekmp.index.PrefixCodedTerms;
import org.gnit.lucenekmp.jdkport.UncheckedIOException;
import org.gnit.lucenekmp.search.ConstantScoreScorer;
import org.gnit.lucenekmp.search.ConstantScoreWeight;
import org.gnit.lucenekmp.search.DocIdSetIterator;
import org.gnit.lucenekmp.search.IndexSearcher;
import org.gnit.lucenekmp.search.PointInSetQuery;
import org.gnit.lucenekmp.search.Query;
import org.gnit.lucenekmp.search.QueryVisitor;
import org.gnit.lucenekmp.search.ScoreMode;
import org.gnit.lucenekmp.search.Scorer;
import org.gnit.lucenekmp.search.ScorerSupplier;
import org.gnit.lucenekmp.search.Weight;
import org.gnit.lucenekmp.util.Accountable;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.BytesRefBuilder;
import org.gnit.lucenekmp.util.BytesRefIterator;
import org.gnit.lucenekmp.util.DocIdSetBuilder;
import org.gnit.lucenekmp.util.IntsRef;
import org.gnit.lucenekmp.util.RamUsageEstimator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\u0010\u001f\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\b\b&\u0018\u0000 62\u00020\u00012\u00020\u0002:\u00043456B)\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J \u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\b\u0010+\u001a\u00020\u0006H\u0016J\u0013\u0010,\u001a\u00020-2\b\u0010.\u001a\u0004\u0018\u00010/H\u0096\u0002J\u0010\u00100\u001a\u00020-2\u0006\u0010.\u001a\u00020\u0000H\u0002J\u0012\u00101\u001a\u00020\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004H\u0016J\u0010\u00101\u001a\u00020\u00042\u0006\u00102\u001a\u00020(H$J\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020(0'8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010*\u00a8\u00067"}, d2={"Lorg/gnit/lucenekmp/search/PointInSetQuery;", "Lorg/gnit/lucenekmp/search/Query;", "Lorg/gnit/lucenekmp/util/Accountable;", "field", "", "numDims", "", "bytesPerDim", "packedPoints", "Lorg/gnit/lucenekmp/search/PointInSetQuery$Stream;", "<init>", "(Ljava/lang/String;IILorg/gnit/lucenekmp/search/PointInSetQuery$Stream;)V", "getField", "()Ljava/lang/String;", "sortedPackedPoints", "Lorg/gnit/lucenekmp/index/PrefixCodedTerms;", "getSortedPackedPoints", "()Lorg/gnit/lucenekmp/index/PrefixCodedTerms;", "sortedPackedPointsHashCode", "getSortedPackedPointsHashCode", "()I", "getNumDims", "getBytesPerDim", "ramBytesUsed", "", "getRamBytesUsed", "()J", "visit", "", "visitor", "Lorg/gnit/lucenekmp/search/QueryVisitor;", "createWeight", "Lorg/gnit/lucenekmp/search/Weight;", "searcher", "Lorg/gnit/lucenekmp/search/IndexSearcher;", "scoreMode", "Lorg/gnit/lucenekmp/search/ScoreMode;", "boost", "", "", "", "getPackedPoints", "()Ljava/util/Collection;", "hashCode", "equals", "", "other", "", "equalsTo", "toString", "value", "Stream", "MergePointVisitor", "SinglePointVisitor", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nPointInSetQuery.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PointInSetQuery.kt\norg/gnit/lucenekmp/search/PointInSetQuery\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,502:1\n1#2:503\n*E\n"})
public abstract class PointInSetQuery
extends Query
implements Accountable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String field;
    @NotNull
    private final PrefixCodedTerms sortedPackedPoints;
    private final int sortedPackedPointsHashCode;
    private final int numDims;
    private final int bytesPerDim;
    private final long ramBytesUsed;
    private static final long BASE_RAM_BYTES = RamUsageEstimator.Companion.shallowSizeOfInstance(Reflection.getOrCreateKotlinClass(PointInSetQuery.class));

    protected PointInSetQuery(@NotNull String field, int numDims, int bytesPerDim, @NotNull Stream packedPoints2) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)packedPoints2, (String)"packedPoints");
        this.field = field;
        if (!(bytesPerDim >= 1 && bytesPerDim <= 16)) {
            boolean $i$a$-require-PointInSetQuery$32 = false;
            String $i$a$-require-PointInSetQuery$32 = "bytesPerDim must be > 0 and <= 16; got " + bytesPerDim;
            throw new IllegalArgumentException($i$a$-require-PointInSetQuery$32.toString());
        }
        this.bytesPerDim = bytesPerDim;
        if (!(numDims >= 1 && numDims <= PointValues.Companion.getMAX_INDEX_DIMENSIONS())) {
            boolean $i$a$-require-PointInSetQuery$62 = false;
            String $i$a$-require-PointInSetQuery$62 = "numDims must be > 0 and <= " + PointValues.Companion.getMAX_INDEX_DIMENSIONS() + "; got " + numDims;
            throw new IllegalArgumentException($i$a$-require-PointInSetQuery$62.toString());
        }
        this.numDims = numDims;
        PrefixCodedTerms.Builder builder = new PrefixCodedTerms.Builder();
        BytesRefBuilder previous = null;
        BytesRef current = null;
        while (true) {
            BytesRef bytesRef;
            BytesRef it = bytesRef = packedPoints2.next();
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            if (bytesRef == null) break;
            if (!(current.getLength() == numDims * bytesPerDim)) {
                boolean bl2 = false;
                String string = "packed point length should be " + numDims * bytesPerDim + " but got " + current.getLength() + "; field=\"" + this.field + "\" numDims=" + numDims + " bytesPerDim=" + bytesPerDim;
                throw new IllegalArgumentException(string.toString());
            }
            if (previous == null) {
                previous = new BytesRefBuilder();
            } else {
                int cmp = previous.get().compareTo(current);
                if (cmp == 0) continue;
                if (!(cmp <= 0)) {
                    boolean bl3 = false;
                    String string = "values are out of order: saw " + previous + " before " + current;
                    throw new IllegalArgumentException(string.toString());
                }
            }
            builder.add(this.field, current);
            previous.copyBytes(current);
        }
        this.sortedPackedPoints = builder.finish();
        this.sortedPackedPointsHashCode = this.sortedPackedPoints.hashCode();
        this.ramBytesUsed = BASE_RAM_BYTES + RamUsageEstimator.Companion.sizeOfObject(this.field) + RamUsageEstimator.Companion.sizeOfObject(this.sortedPackedPoints);
    }

    @NotNull
    public final String getField() {
        return this.field;
    }

    @NotNull
    public final PrefixCodedTerms getSortedPackedPoints() {
        return this.sortedPackedPoints;
    }

    public final int getSortedPackedPointsHashCode() {
        return this.sortedPackedPointsHashCode;
    }

    public final int getNumDims() {
        return this.numDims;
    }

    public final int getBytesPerDim() {
        return this.bytesPerDim;
    }

    public final long getRamBytesUsed() {
        return this.ramBytesUsed;
    }

    @Override
    public void visit(@NotNull QueryVisitor visitor2) {
        Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
        if (visitor2.acceptField(this.field)) {
            visitor2.visitLeaf(this);
        }
    }

    @Override
    @NotNull
    public Weight createWeight(@NotNull IndexSearcher searcher, @NotNull ScoreMode scoreMode, float boost) {
        Intrinsics.checkNotNullParameter((Object)searcher, (String)"searcher");
        Intrinsics.checkNotNullParameter((Object)((Object)scoreMode), (String)"scoreMode");
        return new ConstantScoreWeight(this, boost, scoreMode){
            final /* synthetic */ PointInSetQuery this$0;
            final /* synthetic */ ScoreMode $scoreMode;
            {
                this.this$0 = $receiver;
                this.$scoreMode = $scoreMode;
                super($receiver, $boost);
            }

            public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                LeafReader reader2 = context.reader();
                PointValues values2 = reader2.getPointValues(this.this$0.getField());
                if (values2 == null) {
                    return null;
                }
                boolean bl = values2.getNumIndexDimensions() == this.this$0.getNumDims();
                PointInSetQuery pointInSetQuery = this.this$0;
                if (!bl) {
                    boolean $i$a$-require-PointInSetQuery$createWeight$1$scorerSupplier$32 = false;
                    String $i$a$-require-PointInSetQuery$createWeight$1$scorerSupplier$32 = "field=\"" + pointInSetQuery.getField() + "\" was indexed with numIndexDims=" + values2.getNumIndexDimensions() + " but this query has numIndexDims=" + pointInSetQuery.getNumDims();
                    throw new IllegalArgumentException($i$a$-require-PointInSetQuery$createWeight$1$scorerSupplier$32.toString());
                }
                bl = values2.getBytesPerDimension() == this.this$0.getBytesPerDim();
                pointInSetQuery = this.this$0;
                if (!bl) {
                    boolean bl2 = false;
                    String string = "field=\"" + pointInSetQuery.getField() + "\" was indexed with bytesPerDim=" + values2.getBytesPerDimension() + " but this query has bytesPerDim=" + pointInSetQuery.getBytesPerDim();
                    throw new IllegalArgumentException(string.toString());
                }
                if (this.this$0.getNumDims() == 1) {
                    return new ScorerSupplier(reader2, values2, this.this$0, this, this.$scoreMode){
                        private long cost;
                        final /* synthetic */ LeafReader $reader;
                        final /* synthetic */ PointValues $values;
                        final /* synthetic */ PointInSetQuery this$0;
                        final /* synthetic */ createWeight.1 this$1;
                        final /* synthetic */ ScoreMode $scoreMode;
                        {
                            this.$reader = $reader;
                            this.$values = $values;
                            this.this$0 = $receiver;
                            this.this$1 = $receiver2;
                            this.$scoreMode = $scoreMode;
                            this.cost = -1L;
                        }

                        public final long getCost() {
                            return this.cost;
                        }

                        public final void setCost(long l) {
                            this.cost = l;
                        }

                        public Scorer get(long leadCost) throws IOException {
                            DocIdSetBuilder result = new DocIdSetBuilder(this.$reader.maxDoc(), this.$values);
                            this.$values.intersect(this.this$0.new MergePointVisitor(this.this$0.getSortedPackedPoints().iterator(), result));
                            DocIdSetIterator iterator2 = result.build().iterator();
                            float f = this.this$1.score();
                            DocIdSetIterator docIdSetIterator = iterator2;
                            Intrinsics.checkNotNull((Object)docIdSetIterator);
                            return new ConstantScoreScorer(f, this.$scoreMode, docIdSetIterator);
                        }

                        public long cost() {
                            try {
                                if (this.cost == -1L) {
                                    DocIdSetBuilder result = new DocIdSetBuilder(this.$reader.maxDoc(), this.$values);
                                    this.cost = this.$values.estimateDocCount(this.this$0.new MergePointVisitor(this.this$0.getSortedPackedPoints().iterator(), result));
                                    if (!(this.cost >= 0L)) {
                                        String string = "Failed requirement.";
                                        throw new IllegalArgumentException(string.toString());
                                    }
                                }
                                return this.cost;
                            }
                            catch (IOException e) {
                                throw new UncheckedIOException(e);
                            }
                        }
                    };
                }
                return new ScorerSupplier(reader2, values2, this.this$0, this, this.$scoreMode){
                    private long cost;
                    final /* synthetic */ LeafReader $reader;
                    final /* synthetic */ PointValues $values;
                    final /* synthetic */ PointInSetQuery this$0;
                    final /* synthetic */ createWeight.1 this$1;
                    final /* synthetic */ ScoreMode $scoreMode;
                    {
                        this.$reader = $reader;
                        this.$values = $values;
                        this.this$0 = $receiver;
                        this.this$1 = $receiver2;
                        this.$scoreMode = $scoreMode;
                        this.cost = -1L;
                    }

                    public final long getCost() {
                        return this.cost;
                    }

                    public final void setCost(long l) {
                        this.cost = l;
                    }

                    public Scorer get(long leadCost) throws IOException {
                        DocIdSetBuilder result = new DocIdSetBuilder(this.$reader.maxDoc(), this.$values);
                        SinglePointVisitor visitor2 = this.this$0.new SinglePointVisitor(result);
                        PrefixCodedTerms.TermIterator iterator2 = this.this$0.getSortedPackedPoints().iterator();
                        BytesRef point = iterator2.next();
                        while (point != null) {
                            visitor2.setPoint(point);
                            this.$values.intersect(visitor2);
                            point = iterator2.next();
                        }
                        return new ConstantScoreScorer(this.this$1.score(), this.$scoreMode, result.build().iterator());
                    }

                    public long cost() {
                        try {
                            if (this.cost == -1L) {
                                DocIdSetBuilder result = new DocIdSetBuilder(this.$reader.maxDoc(), this.$values);
                                SinglePointVisitor visitor2 = this.this$0.new SinglePointVisitor(result);
                                PrefixCodedTerms.TermIterator iterator2 = this.this$0.getSortedPackedPoints().iterator();
                                this.cost = 0L;
                                BytesRef point = iterator2.next();
                                while (point != null) {
                                    visitor2.setPoint(point);
                                    this.cost += this.$values.estimateDocCount(visitor2);
                                    point = iterator2.next();
                                }
                                if (!(this.cost >= 0L)) {
                                    String string = "Failed requirement.";
                                    throw new IllegalArgumentException(string.toString());
                                }
                            }
                            return this.cost;
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                    }
                };
            }

            public boolean isCacheable(LeafReaderContext ctx) {
                Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                return true;
            }
        };
    }

    @NotNull
    public final Collection<byte[]> getPackedPoints() {
        return (Collection)new AbstractMutableCollection<byte[]>(this){
            final /* synthetic */ PointInSetQuery this$0;
            {
                this.this$0 = $receiver;
            }

            public Iterator<byte[]> iterator() {
                int size2 = (int)this.this$0.getSortedPackedPoints().size();
                PrefixCodedTerms.TermIterator iterator2 = this.this$0.getSortedPackedPoints().iterator();
                return new Iterator<byte[]>(size2, iterator2){
                    private int upto;
                    final /* synthetic */ int $size;
                    final /* synthetic */ PrefixCodedTerms.TermIterator $iterator;
                    {
                        this.$size = $size;
                        this.$iterator = $iterator;
                    }

                    public final int getUpto() {
                        return this.upto;
                    }

                    public final void setUpto(int n) {
                        this.upto = n;
                    }

                    public boolean hasNext() {
                        return this.upto < this.$size;
                    }

                    public byte[] next() {
                        if (this.upto == this.$size) {
                            throw new NoSuchElementException();
                        }
                        int n = this.upto;
                        this.upto = n + 1;
                        BytesRef bytesRef = this.$iterator.next();
                        if (bytesRef == null) {
                            throw new NoSuchElementException();
                        }
                        BytesRef next = bytesRef;
                        return BytesRef.Companion.deepCopyOf(next).getBytes();
                    }

                    public void remove() {
                        throw new UnsupportedOperationException("Removal not supported");
                    }
                };
            }

            public boolean add(byte[] element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                throw new UnsupportedOperationException("Adding not supported");
            }

            public int getSize() {
                return (int)this.this$0.getSortedPackedPoints().size();
            }
        };
    }

    @Override
    public int hashCode() {
        int hash = this.classHash();
        hash = 31 * hash + this.field.hashCode();
        hash = 31 * hash + this.sortedPackedPointsHashCode;
        hash = 31 * hash + this.numDims;
        hash = 31 * hash + this.bytesPerDim;
        return hash;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return this.sameClassAs(other) && this.equalsTo((PointInSetQuery)KClasses.cast((KClass)Reflection.getOrCreateKotlinClass(this.getClass()), (Object)other));
    }

    private final boolean equalsTo(PointInSetQuery other) {
        return Intrinsics.areEqual((Object)other.field, (Object)this.field) && other.numDims == this.numDims && other.bytesPerDim == this.bytesPerDim && other.sortedPackedPointsHashCode == this.sortedPackedPointsHashCode && other.sortedPackedPoints.equals(this.sortedPackedPoints);
    }

    @Override
    @NotNull
    public String toString(@Nullable String field) {
        StringBuilder sb = new StringBuilder();
        if (!Intrinsics.areEqual((Object)this.field, (Object)field)) {
            sb.append(this.field);
            sb.append(':');
        }
        sb.append("{");
        PrefixCodedTerms.TermIterator iterator2 = this.sortedPackedPoints.iterator();
        byte[] pointBytes = new byte[this.numDims * this.bytesPerDim];
        boolean first = true;
        BytesRef point = iterator2.next();
        while (point != null) {
            if (!first) {
                sb.append(" ");
            }
            first = false;
            ArraysKt.copyInto((byte[])point.getBytes(), (byte[])pointBytes, (int)0, (int)point.getOffset(), (int)(point.getOffset() + point.getLength()));
            sb.append(this.toString(pointBytes));
            point = iterator2.next();
        }
        sb.append("}");
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    protected abstract String toString(@NotNull byte[] var1);

    @Override
    public long ramBytesUsed() {
        return this.ramBytesUsed;
    }

    @Override
    @NotNull
    public Collection<Accountable> getChildResources() {
        return Accountable.super.getChildResources();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/gnit/lucenekmp/search/PointInSetQuery$Companion;", "", "<init>", "()V", "BASE_RAM_BYTES", "", "getBASE_RAM_BYTES", "()J", "core"})
    public static final class Companion {
        private Companion() {
        }

        protected final long getBASE_RAM_BYTES() {
            return BASE_RAM_BYTES;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u0014H\u0016J\u0018\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u0016J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u0016H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/gnit/lucenekmp/search/PointInSetQuery$MergePointVisitor;", "Lorg/gnit/lucenekmp/index/PointValues$IntersectVisitor;", "iterator", "Lorg/gnit/lucenekmp/index/PrefixCodedTerms$TermIterator;", "result", "Lorg/gnit/lucenekmp/util/DocIdSetBuilder;", "<init>", "(Lorg/gnit/lucenekmp/search/PointInSetQuery;Lorg/gnit/lucenekmp/index/PrefixCodedTerms$TermIterator;Lorg/gnit/lucenekmp/util/DocIdSetBuilder;)V", "nextQueryPoint", "Lorg/gnit/lucenekmp/util/BytesRef;", "comparator", "Lorg/gnit/lucenekmp/util/ArrayUtil$Companion$ByteArrayComparator;", "adder", "Lorg/gnit/lucenekmp/util/DocIdSetBuilder$BulkAdder;", "grow", "", "count", "", "visit", "docID", "Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "packedValue", "", "matches", "", "compare", "Lorg/gnit/lucenekmp/index/PointValues$Relation;", "minPackedValue", "maxPackedValue", "core"})
    private final class MergePointVisitor
    implements PointValues.IntersectVisitor {
        @NotNull
        private final PrefixCodedTerms.TermIterator iterator;
        @NotNull
        private final DocIdSetBuilder result;
        @Nullable
        private BytesRef nextQueryPoint;
        @NotNull
        private final ArrayUtil.Companion.ByteArrayComparator comparator;
        @Nullable
        private DocIdSetBuilder.BulkAdder adder;

        public MergePointVisitor(@NotNull PrefixCodedTerms.TermIterator iterator2, DocIdSetBuilder result) {
            Intrinsics.checkNotNullParameter((Object)iterator2, (String)"iterator");
            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
            this.iterator = iterator2;
            this.result = result;
            this.nextQueryPoint = this.iterator.next();
            this.comparator = ArrayUtil.Companion.getUnsignedComparator(PointInSetQuery.this.getBytesPerDim());
        }

        @Override
        public void grow(int count) {
            this.adder = this.result.grow(count);
        }

        @Override
        public void visit(int docID) {
            DocIdSetBuilder.BulkAdder bulkAdder = this.adder;
            Intrinsics.checkNotNull((Object)bulkAdder);
            bulkAdder.add(docID);
        }

        @Override
        public void visit(@NotNull DocIdSetIterator iterator2) throws IOException {
            Intrinsics.checkNotNullParameter((Object)iterator2, (String)"iterator");
            DocIdSetBuilder.BulkAdder bulkAdder = this.adder;
            Intrinsics.checkNotNull((Object)bulkAdder);
            bulkAdder.add(iterator2);
        }

        @Override
        public void visit(int docID, @NotNull byte[] packedValue) {
            Intrinsics.checkNotNullParameter((Object)packedValue, (String)"packedValue");
            if (this.matches(packedValue)) {
                this.visit(docID);
            }
        }

        @Override
        public void visit(@NotNull DocIdSetIterator iterator2, @NotNull byte[] packedValue) throws IOException {
            Intrinsics.checkNotNullParameter((Object)iterator2, (String)"iterator");
            Intrinsics.checkNotNullParameter((Object)packedValue, (String)"packedValue");
            if (this.matches(packedValue)) {
                DocIdSetBuilder.BulkAdder bulkAdder = this.adder;
                Intrinsics.checkNotNull((Object)bulkAdder);
                bulkAdder.add(iterator2);
            }
        }

        public final boolean matches(@NotNull byte[] packedValue) {
            Intrinsics.checkNotNullParameter((Object)packedValue, (String)"packedValue");
            while (this.nextQueryPoint != null) {
                BytesRef bytesRef = this.nextQueryPoint;
                Intrinsics.checkNotNull((Object)bytesRef);
                byte[] byArray = bytesRef.getBytes();
                BytesRef bytesRef2 = this.nextQueryPoint;
                Intrinsics.checkNotNull((Object)bytesRef2);
                int cmp = this.comparator.compare(byArray, bytesRef2.getOffset(), packedValue, 0);
                if (cmp == 0) {
                    return true;
                }
                if (cmp >= 0) break;
                this.nextQueryPoint = this.iterator.next();
            }
            return false;
        }

        @Override
        @NotNull
        public PointValues.Relation compare(@NotNull byte[] minPackedValue, @NotNull byte[] maxPackedValue) {
            Intrinsics.checkNotNullParameter((Object)minPackedValue, (String)"minPackedValue");
            Intrinsics.checkNotNullParameter((Object)maxPackedValue, (String)"maxPackedValue");
            while (this.nextQueryPoint != null) {
                BytesRef bytesRef = this.nextQueryPoint;
                Intrinsics.checkNotNull((Object)bytesRef);
                byte[] byArray = bytesRef.getBytes();
                BytesRef bytesRef2 = this.nextQueryPoint;
                Intrinsics.checkNotNull((Object)bytesRef2);
                int cmpMin = this.comparator.compare(byArray, bytesRef2.getOffset(), minPackedValue, 0);
                if (cmpMin < 0) {
                    this.nextQueryPoint = this.iterator.next();
                    continue;
                }
                BytesRef bytesRef3 = this.nextQueryPoint;
                Intrinsics.checkNotNull((Object)bytesRef3);
                byte[] byArray2 = bytesRef3.getBytes();
                BytesRef bytesRef4 = this.nextQueryPoint;
                Intrinsics.checkNotNull((Object)bytesRef4);
                int cmpMax = this.comparator.compare(byArray2, bytesRef4.getOffset(), maxPackedValue, 0);
                if (cmpMax > 0) {
                    return PointValues.Relation.CELL_OUTSIDE_QUERY;
                }
                if (cmpMin == 0 && cmpMax == 0) {
                    return PointValues.Relation.CELL_INSIDE_QUERY;
                }
                return PointValues.Relation.CELL_CROSSES_QUERY;
            }
            return PointValues.Relation.CELL_OUTSIDE_QUERY;
        }

        @Override
        public void visit(@NotNull IntsRef ref) throws IOException {
            PointValues.IntersectVisitor.super.visit(ref);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\tH\u0016J\u0018\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\tH\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/gnit/lucenekmp/search/PointInSetQuery$SinglePointVisitor;", "Lorg/gnit/lucenekmp/index/PointValues$IntersectVisitor;", "result", "Lorg/gnit/lucenekmp/util/DocIdSetBuilder;", "<init>", "(Lorg/gnit/lucenekmp/search/PointInSetQuery;Lorg/gnit/lucenekmp/util/DocIdSetBuilder;)V", "comparator", "Lorg/gnit/lucenekmp/util/ArrayUtil$Companion$ByteArrayComparator;", "pointBytes", "", "adder", "Lorg/gnit/lucenekmp/util/DocIdSetBuilder$BulkAdder;", "setPoint", "", "point", "Lorg/gnit/lucenekmp/util/BytesRef;", "grow", "count", "", "visit", "docID", "iterator", "Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "packedValue", "compare", "Lorg/gnit/lucenekmp/index/PointValues$Relation;", "minPackedValue", "maxPackedValue", "core"})
    public final class SinglePointVisitor
    implements PointValues.IntersectVisitor {
        @NotNull
        private final DocIdSetBuilder result;
        @NotNull
        private final ArrayUtil.Companion.ByteArrayComparator comparator;
        @NotNull
        private final byte[] pointBytes;
        @Nullable
        private DocIdSetBuilder.BulkAdder adder;

        public SinglePointVisitor(DocIdSetBuilder result) {
            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
            this.result = result;
            this.comparator = ArrayUtil.Companion.getUnsignedComparator(PointInSetQuery.this.getBytesPerDim());
            this.pointBytes = new byte[PointInSetQuery.this.getBytesPerDim() * PointInSetQuery.this.getNumDims()];
        }

        public final void setPoint(@NotNull BytesRef point) {
            Intrinsics.checkNotNullParameter((Object)point, (String)"point");
            if (!(point.getLength() == this.pointBytes.length)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            ArraysKt.copyInto((byte[])point.getBytes(), (byte[])this.pointBytes, (int)0, (int)point.getOffset(), (int)(point.getOffset() + point.getLength()));
        }

        @Override
        public void grow(int count) {
            this.adder = this.result.grow(count);
        }

        @Override
        public void visit(int docID) {
            DocIdSetBuilder.BulkAdder bulkAdder = this.adder;
            Intrinsics.checkNotNull((Object)bulkAdder);
            bulkAdder.add(docID);
        }

        @Override
        public void visit(@NotNull DocIdSetIterator iterator2) throws IOException {
            Intrinsics.checkNotNullParameter((Object)iterator2, (String)"iterator");
            DocIdSetBuilder.BulkAdder bulkAdder = this.adder;
            Intrinsics.checkNotNull((Object)bulkAdder);
            bulkAdder.add(iterator2);
        }

        @Override
        public void visit(int docID, @NotNull byte[] packedValue) {
            Intrinsics.checkNotNullParameter((Object)packedValue, (String)"packedValue");
            if (!(packedValue.length == this.pointBytes.length)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (Arrays.equals(packedValue, this.pointBytes)) {
                this.visit(docID);
            }
        }

        @Override
        public void visit(@NotNull DocIdSetIterator iterator2, @NotNull byte[] packedValue) throws IOException {
            Intrinsics.checkNotNullParameter((Object)iterator2, (String)"iterator");
            Intrinsics.checkNotNullParameter((Object)packedValue, (String)"packedValue");
            if (!(packedValue.length == this.pointBytes.length)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (Arrays.equals(packedValue, this.pointBytes)) {
                DocIdSetBuilder.BulkAdder bulkAdder = this.adder;
                Intrinsics.checkNotNull((Object)bulkAdder);
                bulkAdder.add(iterator2);
            }
        }

        @Override
        @NotNull
        public PointValues.Relation compare(@NotNull byte[] minPackedValue, @NotNull byte[] maxPackedValue) {
            Intrinsics.checkNotNullParameter((Object)minPackedValue, (String)"minPackedValue");
            Intrinsics.checkNotNullParameter((Object)maxPackedValue, (String)"maxPackedValue");
            boolean crosses = false;
            int n = PointInSetQuery.this.getNumDims();
            for (int dim = 0; dim < n; ++dim) {
                int offset = dim * PointInSetQuery.this.getBytesPerDim();
                int cmpMin = this.comparator.compare(minPackedValue, offset, this.pointBytes, offset);
                if (cmpMin > 0) {
                    return PointValues.Relation.CELL_OUTSIDE_QUERY;
                }
                int cmpMax = this.comparator.compare(maxPackedValue, offset, this.pointBytes, offset);
                if (cmpMax < 0) {
                    return PointValues.Relation.CELL_OUTSIDE_QUERY;
                }
                if (cmpMin == 0 && cmpMax == 0) continue;
                crosses = true;
            }
            if (crosses) {
                return PointValues.Relation.CELL_CROSSES_QUERY;
            }
            return PointValues.Relation.CELL_INSIDE_QUERY;
        }

        @Override
        public void visit(@NotNull IntsRef ref) throws IOException {
            PointValues.IntersectVisitor.super.visit(ref);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\u0004\u001a\u0004\u0018\u00010\u0005H&\u00a8\u0006\u0006"}, d2={"Lorg/gnit/lucenekmp/search/PointInSetQuery$Stream;", "Lorg/gnit/lucenekmp/util/BytesRefIterator;", "<init>", "()V", "next", "Lorg/gnit/lucenekmp/util/BytesRef;", "core"})
    public static abstract class Stream
    implements BytesRefIterator {
        @Override
        @Nullable
        public abstract BytesRef next();
    }
}

