/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.search;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.search.BulkScorer;
import org.gnit.lucenekmp.search.DocIdSetIterator;
import org.gnit.lucenekmp.search.LeafCollector;
import org.gnit.lucenekmp.search.Scorer;
import org.gnit.lucenekmp.search.TwoPhaseIterator;
import org.gnit.lucenekmp.util.Bits;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0005\u0010\bB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\t\u00a2\u0006\u0004\b\u0005\u0010\nJ*\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u000eH\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/gnit/lucenekmp/search/ReqExclBulkScorer;", "Lorg/gnit/lucenekmp/search/BulkScorer;", "req", "excl", "Lorg/gnit/lucenekmp/search/Scorer;", "<init>", "(Lorg/gnit/lucenekmp/search/BulkScorer;Lorg/gnit/lucenekmp/search/Scorer;)V", "Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "(Lorg/gnit/lucenekmp/search/BulkScorer;Lorg/gnit/lucenekmp/search/DocIdSetIterator;)V", "Lorg/gnit/lucenekmp/search/TwoPhaseIterator;", "(Lorg/gnit/lucenekmp/search/BulkScorer;Lorg/gnit/lucenekmp/search/TwoPhaseIterator;)V", "exclApproximation", "exclTwoPhase", "score", "", "collector", "Lorg/gnit/lucenekmp/search/LeafCollector;", "acceptDocs", "Lorg/gnit/lucenekmp/util/Bits;", "min", "max", "cost", "", "core"})
public final class ReqExclBulkScorer
extends BulkScorer {
    @NotNull
    private final BulkScorer req;
    @NotNull
    private final DocIdSetIterator exclApproximation;
    @Nullable
    private final TwoPhaseIterator exclTwoPhase;

    public ReqExclBulkScorer(@NotNull BulkScorer req2, @NotNull Scorer excl) {
        Intrinsics.checkNotNullParameter((Object)req2, (String)"req");
        Intrinsics.checkNotNullParameter((Object)excl, (String)"excl");
        this.req = req2;
        this.exclTwoPhase = excl.twoPhaseIterator();
        this.exclApproximation = this.exclTwoPhase != null ? this.exclTwoPhase.approximation() : excl.iterator();
    }

    public ReqExclBulkScorer(@NotNull BulkScorer req2, @NotNull DocIdSetIterator excl) {
        Intrinsics.checkNotNullParameter((Object)req2, (String)"req");
        Intrinsics.checkNotNullParameter((Object)excl, (String)"excl");
        this.req = req2;
        this.exclTwoPhase = null;
        this.exclApproximation = excl;
    }

    public ReqExclBulkScorer(@NotNull BulkScorer req2, @NotNull TwoPhaseIterator excl) {
        Intrinsics.checkNotNullParameter((Object)req2, (String)"req");
        Intrinsics.checkNotNullParameter((Object)excl, (String)"excl");
        this.req = req2;
        this.exclTwoPhase = excl;
        this.exclApproximation = excl.approximation();
    }

    @Override
    public int score(@NotNull LeafCollector collector2, @Nullable Bits acceptDocs, int min, int max) throws IOException {
        Intrinsics.checkNotNullParameter((Object)collector2, (String)"collector");
        int upTo = min;
        int exclDoc = this.exclApproximation.docID();
        while (upTo < max) {
            if (exclDoc < upTo) {
                exclDoc = this.exclApproximation.advance(upTo);
            }
            if (exclDoc == upTo) {
                if (this.exclTwoPhase == null || this.exclTwoPhase.matches()) {
                    ++upTo;
                }
                exclDoc = this.exclApproximation.nextDoc();
                continue;
            }
            upTo = this.req.score(collector2, acceptDocs, upTo, Math.min(exclDoc, max));
        }
        if (upTo == max) {
            upTo = this.req.score(collector2, acceptDocs, upTo, upTo);
        }
        return upTo;
    }

    @Override
    public long cost() {
        return this.req.cost();
    }
}

