/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.search.DocIdSetIterator;
import org.gnit.lucenekmp.search.Scorable;
import org.gnit.lucenekmp.search.ScoreMode;
import org.gnit.lucenekmp.search.Scorer;
import org.gnit.lucenekmp.search.TwoPhaseIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\n\u0010\u0014\u001a\u0004\u0018\u00010\fH\u0016J\b\u0010\u0015\u001a\u00020\tH\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0010H\u0016J\u0010\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0017H\u0016J\u0010\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u0017H\u0016J\u0015\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007\u00a2\u0006\u0002\b\u001fR\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$\u00a8\u0006%"}, d2={"Lorg/gnit/lucenekmp/search/ReqOptSumScorer;", "Lorg/gnit/lucenekmp/search/Scorer;", "reqScorer", "optScorer", "scoreMode", "Lorg/gnit/lucenekmp/search/ScoreMode;", "<init>", "(Lorg/gnit/lucenekmp/search/Scorer;Lorg/gnit/lucenekmp/search/Scorer;Lorg/gnit/lucenekmp/search/ScoreMode;)V", "reqApproximation", "Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "optApproximation", "optTwoPhase", "Lorg/gnit/lucenekmp/search/TwoPhaseIterator;", "approximation", "twoPhase", "minScore", "", "reqMaxScore", "optIsRequired", "", "twoPhaseIterator", "iterator", "docID", "", "score", "advanceShallow", "target", "getMaxScore", "upTo", "setMinCompetitiveScore", "", "setMinCompetitiveScoreKt", "children", "", "Lorg/gnit/lucenekmp/search/Scorable$ChildScorable;", "getChildren", "()Ljava/util/Collection;", "core"})
public final class ReqOptSumScorer
extends Scorer {
    @NotNull
    private final Scorer reqScorer;
    @NotNull
    private final Scorer optScorer;
    @NotNull
    private final DocIdSetIterator reqApproximation;
    @NotNull
    private final DocIdSetIterator optApproximation;
    @Nullable
    private final TwoPhaseIterator optTwoPhase;
    @NotNull
    private final DocIdSetIterator approximation;
    @Nullable
    private final TwoPhaseIterator twoPhase;
    private float minScore;
    private final float reqMaxScore;
    private boolean optIsRequired;

    public ReqOptSumScorer(final @NotNull Scorer reqScorer, @NotNull Scorer optScorer, @NotNull ScoreMode scoreMode) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)reqScorer, (String)"reqScorer");
        Intrinsics.checkNotNullParameter((Object)optScorer, (String)"optScorer");
        Intrinsics.checkNotNullParameter((Object)((Object)scoreMode), (String)"scoreMode");
        this.reqScorer = reqScorer;
        this.optScorer = optScorer;
        final TwoPhaseIterator reqTwoPhase = reqScorer.twoPhaseIterator();
        this.optTwoPhase = optScorer.twoPhaseIterator();
        Object object2 = reqTwoPhase;
        if (object2 == null || (object2 = ((TwoPhaseIterator)object2).approximation()) == null) {
            object2 = this.reqApproximation = reqScorer.iterator();
        }
        if ((object = this.optTwoPhase) == null || (object = ((TwoPhaseIterator)object).approximation()) == null) {
            object = this.optApproximation = optScorer.iterator();
        }
        if (scoreMode != ScoreMode.TOP_SCORES) {
            this.approximation = this.reqApproximation;
            this.reqMaxScore = Float.POSITIVE_INFINITY;
        } else {
            reqScorer.advanceShallow(0);
            optScorer.advanceShallow(0);
            this.reqMaxScore = reqScorer.getMaxScore(Integer.MAX_VALUE);
            this.approximation = new DocIdSetIterator(){
                private int upTo = -1;
                private float maxScore;

                public final int getUpTo() {
                    return this.upTo;
                }

                public final void setUpTo(int n) {
                    this.upTo = n;
                }

                public final float getMaxScore() {
                    return this.maxScore;
                }

                public final void setMaxScore(float f) {
                    this.maxScore = f;
                }

                private final void moveToNextBlock(int target) throws IOException {
                    this.upTo = this.advanceShallow(target);
                    float reqMaxScoreBlock = reqScorer.getMaxScore(this.upTo);
                    this.maxScore = this.getMaxScore(this.upTo);
                    optIsRequired = reqMaxScoreBlock < minScore;
                }

                private final int advanceImpacts(int target) throws IOException {
                    int target2 = target;
                    if (target2 > this.upTo) {
                        this.moveToNextBlock(target2);
                    }
                    while (!(this.maxScore >= minScore)) {
                        if (this.upTo == Integer.MAX_VALUE) {
                            return Integer.MAX_VALUE;
                        }
                        target2 = this.upTo + 1;
                        this.moveToNextBlock(target2);
                    }
                    return target2;
                }

                @Override
                public int nextDoc() throws IOException {
                    return this.advanceInternal(reqApproximation.docID() + 1);
                }

                @Override
                public int advance(int target) throws IOException {
                    return this.advanceInternal(target);
                }

                /*
                 * Unable to fully structure code
                 */
                private final int advanceInternal(int target) throws IOException {
                    if (target == 0x7FFFFFFF) {
                        ReqOptSumScorer.access$getReqApproximation$p(this).advance(target);
                        return 0x7FFFFFFF;
                    }
                    reqDoc = target;
                    block0: while (true) {
                        if (!(ReqOptSumScorer.access$getMinScore$p(this) == 0.0f)) {
                            reqDoc = this.advanceImpacts(reqDoc);
                        }
                        if (ReqOptSumScorer.access$getReqApproximation$p(this).docID() < reqDoc) {
                            reqDoc = ReqOptSumScorer.access$getReqApproximation$p(this).advance(reqDoc);
                        }
                        if (reqDoc == 0x7FFFFFFF || !ReqOptSumScorer.access$getOptIsRequired$p(this)) {
                            return reqDoc;
                        }
                        upperBound = ReqOptSumScorer.access$getReqMaxScore$p(this) < ReqOptSumScorer.access$getMinScore$p(this) ? 0x7FFFFFFF : this.upTo;
                        if (reqDoc > upperBound) continue;
                        do {
                            if ((optDoc = ReqOptSumScorer.access$getOptApproximation$p(this).docID()) < reqDoc) {
                                optDoc = ReqOptSumScorer.access$getOptApproximation$p(this).advance(reqDoc);
                            }
                            if (optDoc > upperBound) {
                                reqDoc = upperBound + 1;
                                continue block0;
                            }
                            if (optDoc == reqDoc || (reqDoc = ReqOptSumScorer.access$getReqApproximation$p(this).advance(optDoc)) <= upperBound) ** break;
                            continue block0;
                        } while (reqDoc != 0x7FFFFFFF && optDoc != reqDoc);
                        break;
                    }
                    return reqDoc;
                }

                @Override
                public int docID() {
                    return reqApproximation.docID();
                }

                @Override
                public long cost() {
                    return reqApproximation.cost();
                }
            };
        }
        if (reqTwoPhase == null && this.optTwoPhase == null) {
            this.twoPhase = null;
        } else {
            DocIdSetIterator docIdSetIterator = this.approximation;
            this.twoPhase = new TwoPhaseIterator(docIdSetIterator){

                @Override
                public boolean matches() throws IOException {
                    if (reqTwoPhase != null && !reqTwoPhase.matches()) {
                        return false;
                    }
                    if (optTwoPhase != null) {
                        if (optIsRequired) {
                            if (reqScorer.docID() != optApproximation.docID()) {
                                if (optApproximation.docID() < reqScorer.docID()) {
                                    optApproximation.advance(reqScorer.docID());
                                }
                                if (reqScorer.docID() != optApproximation.docID()) {
                                    return false;
                                }
                            }
                            if (!optTwoPhase.matches()) {
                                optApproximation.nextDoc();
                                return false;
                            }
                        } else if (optApproximation.docID() == reqScorer.docID() && !optTwoPhase.matches()) {
                            optApproximation.nextDoc();
                        }
                    }
                    return true;
                }

                @Override
                public float matchCost() {
                    float matchCost = 1.0f;
                    if (reqTwoPhase != null) {
                        matchCost += reqTwoPhase.matchCost();
                    }
                    if (optTwoPhase != null) {
                        matchCost += optTwoPhase.matchCost();
                    }
                    return matchCost;
                }
            };
        }
    }

    @Override
    @Nullable
    public TwoPhaseIterator twoPhaseIterator() {
        return this.twoPhase;
    }

    @Override
    @NotNull
    public DocIdSetIterator iterator() {
        return this.twoPhase == null ? this.approximation : TwoPhaseIterator.Companion.asDocIdSetIterator(this.twoPhase);
    }

    @Override
    public int docID() {
        return this.reqScorer.docID();
    }

    @Override
    public float score() throws IOException {
        int curDoc = this.reqScorer.docID();
        float score2 = this.reqScorer.score();
        int optScorerDoc = this.optApproximation.docID();
        if (optScorerDoc < curDoc) {
            optScorerDoc = this.optApproximation.advance(curDoc);
            if (this.optTwoPhase != null && optScorerDoc == curDoc && !this.optTwoPhase.matches()) {
                optScorerDoc = this.optApproximation.nextDoc();
            }
        }
        if (optScorerDoc == curDoc) {
            score2 += this.optScorer.score();
        }
        return score2;
    }

    @Override
    public int advanceShallow(int target) throws IOException {
        int upTo = this.reqScorer.advanceShallow(target);
        if (this.optScorer.docID() <= target) {
            upTo = Math.min(upTo, this.optScorer.advanceShallow(target));
        } else if (this.optScorer.docID() != Integer.MAX_VALUE) {
            upTo = Math.min(upTo, this.optScorer.docID() - 1);
        }
        return upTo;
    }

    @Override
    public float getMaxScore(int upTo) throws IOException {
        float maxScore = this.reqScorer.getMaxScore(upTo);
        if (this.optScorer.docID() <= upTo) {
            maxScore += this.optScorer.getMaxScore(upTo);
        }
        return maxScore;
    }

    @JvmName(name="setMinCompetitiveScoreKt")
    public final void setMinCompetitiveScoreKt(float minScore) throws IOException {
        this.minScore = minScore;
        if (this.reqMaxScore < minScore) {
            this.optIsRequired = true;
            if (this.reqMaxScore == 0.0f) {
                this.optScorer.setMinCompetitiveScore(minScore);
            }
        }
    }

    @Override
    @NotNull
    public Collection<Scorable.ChildScorable> getChildren() {
        ArrayList<Scorable.ChildScorable> children = new ArrayList<Scorable.ChildScorable>(2);
        children.add(new Scorable.ChildScorable(this.reqScorer, "MUST"));
        children.add(new Scorable.ChildScorable(this.optScorer, "SHOULD"));
        return children;
    }

    public static final /* synthetic */ float access$getReqMaxScore$p(ReqOptSumScorer $this) {
        return $this.reqMaxScore;
    }
}

