/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.search;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.gnit.lucenekmp.codecs.lucene101.Lucene101PostingsFormat;
import org.gnit.lucenekmp.search.DocIdSetIterator;
import org.gnit.lucenekmp.search.FilterDocIdSetIterator;
import org.gnit.lucenekmp.search.FilterScorable;
import org.gnit.lucenekmp.search.Scorable;
import org.gnit.lucenekmp.search.TermScorer;
import org.gnit.lucenekmp.util.Bits;
import org.gnit.lucenekmp.util.FixedBitSet;
import org.gnit.lucenekmp.util.PriorityQueue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0015R\u0012\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/gnit/lucenekmp/search/ScorerUtil;", "", "<init>", "()V", "DEFAULT_IMPACTS_ENUM_CLASS", "Lkotlin/reflect/KClass;", "DEFAULT_ACCEPT_DOCS_CLASS", "costWithMinShouldMatch", "", "costs", "Lkotlin/sequences/Sequence;", "numScorers", "", "minShouldMatch", "likelyImpactsEnum", "Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "it", "likelyTermScorer", "Lorg/gnit/lucenekmp/search/Scorable;", "scorable", "likelyLiveDocs", "Lorg/gnit/lucenekmp/util/Bits;", "acceptDocs", "FilterBits", "core"})
@SourceDebugExtension(value={"SMAP\nScorerUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScorerUtil.kt\norg/gnit/lucenekmp/search/ScorerUtil\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,93:1\n1321#2,2:94\n*S KotlinDebug\n*F\n+ 1 ScorerUtil.kt\norg/gnit/lucenekmp/search/ScorerUtil\n*L\n36#1:94,2\n*E\n"})
public final class ScorerUtil {
    @NotNull
    public static final ScorerUtil INSTANCE = new ScorerUtil();
    @NotNull
    private static final KClass<?> DEFAULT_IMPACTS_ENUM_CLASS = Lucene101PostingsFormat.Companion.getImpactsEnumImpl();
    @NotNull
    private static final KClass<?> DEFAULT_ACCEPT_DOCS_CLASS = Reflection.getOrCreateKotlinClass(new FixedBitSet(1).asReadOnlyBits().getClass());

    private ScorerUtil() {
    }

    public final long costWithMinShouldMatch(@NotNull Sequence<Long> costs, int numScorers, int minShouldMatch) {
        Intrinsics.checkNotNullParameter(costs, (String)"costs");
        int n = numScorers - minShouldMatch + 1;
        PriorityQueue pq2 = new PriorityQueue<Long>(n){

            public boolean lessThan(long a, long b) {
                return a > b;
            }
        };
        Sequence<Long> $this$forEach$iv = costs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            long p0 = ((Number)element$iv).longValue();
            boolean bl = false;
            pq2.insertWithOverflow(p0);
        }
        return SequencesKt.sumOfLong((Sequence)CollectionsKt.asSequence((Iterable)pq2));
    }

    @NotNull
    public final DocIdSetIterator likelyImpactsEnum(@NotNull DocIdSetIterator it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        DocIdSetIterator it2 = it;
        if (Reflection.getOrCreateKotlinClass(it2.getClass()) != DEFAULT_IMPACTS_ENUM_CLASS && it2 instanceof FilterDocIdSetIterator) {
            it2 = new FilterDocIdSetIterator(it2);
        }
        return it2;
    }

    @NotNull
    public final Scorable likelyTermScorer(@NotNull Scorable scorable) {
        Intrinsics.checkNotNullParameter((Object)scorable, (String)"scorable");
        Scorable scorable2 = scorable;
        if (Reflection.getOrCreateKotlinClass(scorable2.getClass()) != Reflection.getOrCreateKotlinClass(TermScorer.class) && scorable2 instanceof FilterScorable) {
            scorable2 = new FilterScorable(scorable2);
        }
        return scorable2;
    }

    @Nullable
    public final Bits likelyLiveDocs(@Nullable Bits acceptDocs) {
        return acceptDocs == null ? acceptDocs : (Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(acceptDocs.getClass()), DEFAULT_ACCEPT_DOCS_CLASS) ? acceptDocs : (Bits)new FilterBits(acceptDocs));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/gnit/lucenekmp/search/ScorerUtil$FilterBits;", "Lorg/gnit/lucenekmp/util/Bits;", "in", "<init>", "(Lorg/gnit/lucenekmp/util/Bits;)V", "get", "", "index", "", "length", "core"})
    private static final class FilterBits
    implements Bits {
        @NotNull
        private final Bits in;

        public FilterBits(@NotNull Bits in) {
            Intrinsics.checkNotNullParameter((Object)in, (String)"in");
            this.in = in;
        }

        @Override
        public boolean get(int index) {
            return this.in.get(index);
        }

        @Override
        public int length() {
            return this.in.length();
        }

        @Override
        public void applyMask(@NotNull FixedBitSet bitSet, int offset) {
            Bits.super.applyMask(bitSet, offset);
        }
    }
}

