/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.search;

import java.io.IOException;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.search.IndexSearcher;
import org.gnit.lucenekmp.search.SortField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u001b\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006B\t\b\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0007J\u0010\u0010\f\u001a\u00020\u00002\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0006\u0010\u0016\u001a\u00020\u0012R\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lorg/gnit/lucenekmp/search/Sort;", "", "fields", "", "Lorg/gnit/lucenekmp/search/SortField;", "<init>", "([Lorg/gnit/lucenekmp/search/SortField;)V", "()V", "[Lorg/gnit/lucenekmp/search/SortField;", "sort", "getSort", "()[Lorg/gnit/lucenekmp/search/SortField;", "rewrite", "searcher", "Lorg/gnit/lucenekmp/search/IndexSearcher;", "toString", "", "equals", "", "o", "hashCode", "", "needsScores", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nSort.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Sort.kt\norg/gnit/lucenekmp/search/Sort\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,113:1\n1#2:114\n*E\n"})
public final class Sort {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SortField[] fields;
    @NotNull
    private static final Sort RELEVANCE = new Sort();
    @NotNull
    private static final Sort INDEXORDER;

    public Sort(SortField ... fields) {
        Intrinsics.checkNotNullParameter((Object)fields, (String)"fields");
        if (!(!(fields.length == 0))) {
            boolean bl = false;
            String string = "There must be at least 1 sort field";
            throw new IllegalArgumentException(string.toString());
        }
        this.fields = Arrays.copyOf(fields, fields.length);
    }

    public Sort() {
        SortField[] sortFieldArray = new SortField[]{SortField.Companion.getFIELD_SCORE()};
        this(sortFieldArray);
    }

    @NotNull
    public final SortField[] getSort() {
        return this.fields;
    }

    @NotNull
    public final Sort rewrite(@Nullable IndexSearcher searcher) throws IOException {
        Sort sort2;
        boolean changed = false;
        SortField[] rewrittenSortFields = new SortField[this.fields.length];
        int n = this.fields.length;
        for (int i = 0; i < n; ++i) {
            SortField sortField = this.fields[i];
            IndexSearcher indexSearcher = searcher;
            Intrinsics.checkNotNull((Object)indexSearcher);
            rewrittenSortFields[i] = sortField.rewrite(indexSearcher);
            if (this.fields[i] == rewrittenSortFields[i]) continue;
            changed = true;
        }
        if (changed) {
            SortField[] sortFieldArray = rewrittenSortFields;
            Sort sort3 = new Sort(Arrays.copyOf(sortFieldArray, sortFieldArray.length));
            sort2 = sort3;
        } else {
            sort2 = this;
        }
        return sort2;
    }

    @NotNull
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        int n = this.fields.length;
        for (int i = 0; i < n; ++i) {
            buffer.append(this.fields[i].toString());
            if (i + 1 >= this.fields.length) continue;
            buffer.append(',');
        }
        String string = buffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Sort)) {
            return false;
        }
        Object other = o;
        return Arrays.equals(this.fields, ((Sort)other).fields);
    }

    public int hashCode() {
        return 1168832101 + Arrays.hashCode(this.fields);
    }

    public final boolean needsScores() {
        for (SortField sortField : this.fields) {
            if (!sortField.needsScores()) continue;
            return true;
        }
        return false;
    }

    static {
        SortField[] sortFieldArray = new SortField[]{SortField.Companion.getFIELD_DOC()};
        INDEXORDER = new Sort(sortFieldArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\n"}, d2={"Lorg/gnit/lucenekmp/search/Sort$Companion;", "", "<init>", "()V", "RELEVANCE", "Lorg/gnit/lucenekmp/search/Sort;", "getRELEVANCE", "()Lorg/gnit/lucenekmp/search/Sort;", "INDEXORDER", "getINDEXORDER", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Sort getRELEVANCE() {
            return RELEVANCE;
        }

        @NotNull
        public final Sort getINDEXORDER() {
            return INDEXORDER;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

