/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.search;

import java.io.IOException;
import java.util.Comparator;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.comparisons.ComparisonsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.index.DocValues;
import org.gnit.lucenekmp.index.IndexSorter;
import org.gnit.lucenekmp.index.LeafReader;
import org.gnit.lucenekmp.index.NumericDocValues;
import org.gnit.lucenekmp.index.SortFieldProvider;
import org.gnit.lucenekmp.index.SortedDocValues;
import org.gnit.lucenekmp.jdkport.Objects;
import org.gnit.lucenekmp.search.FieldComparator;
import org.gnit.lucenekmp.search.FieldComparatorSource;
import org.gnit.lucenekmp.search.IndexSearcher;
import org.gnit.lucenekmp.search.Pruning;
import org.gnit.lucenekmp.search.comparators.DocComparator;
import org.gnit.lucenekmp.search.comparators.DoubleComparator;
import org.gnit.lucenekmp.search.comparators.FloatComparator;
import org.gnit.lucenekmp.search.comparators.IntComparator;
import org.gnit.lucenekmp.search.comparators.LongComparator;
import org.gnit.lucenekmp.search.comparators.TermOrdValComparator;
import org.gnit.lucenekmp.store.DataInput;
import org.gnit.lucenekmp.store.DataOutput;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.NumericUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 G2\u00020\u0001:\u0003EFGB\u001b\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B#\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\u0006\u0010\nB\u001b\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\u0006\u0010\rB#\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\u0006\u0010\u000eJ\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J\u0015\u0010\u001b\u001a\u00020$2\u0006\u0010\u0018\u001a\u00020\u0001H\u0007\u00a2\u0006\u0002\b'J\u001a\u0010(\u001a\u00020$2\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0006\u0010)\u001a\u00020\u0005J\b\u0010*\u001a\u0004\u0018\u00010\fJ\b\u0010+\u001a\u00020\u0003H\u0016J\u0013\u0010,\u001a\u00020\t2\b\u0010-\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010.\u001a\u00020/H\u0016J\u001e\u00104\u001a\u00020$2\u0016\u00105\u001a\u0012\u0012\u0004\u0012\u00020201j\b\u0012\u0004\u0012\u000202`3J\u0016\u00106\u001a\u0012\u0012\u0004\u0012\u00020201j\b\u0012\u0004\u0012\u000202`3J\u001a\u00107\u001a\u0006\u0012\u0002\b\u0003082\u0006\u00109\u001a\u00020/2\u0006\u0010:\u001a\u00020;J\u000e\u0010<\u001a\u00020\u00002\u0006\u0010=\u001a\u00020>J\u0006\u0010?\u001a\u00020\tJ\b\u0010@\u001a\u0004\u0018\u00010AR\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0001X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR,\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\t8G@GX\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u001f\u0010 \u001a\u0004\b!\u0010\u0014\"\u0004\b\"\u0010\u0016R\u001e\u00100\u001a\u0012\u0012\u0004\u0012\u00020201j\b\u0012\u0004\u0012\u000202`3X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010B\u001a\u00020\t2\u0006\u0010B\u001a\u00020\t8G@GX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bC\u0010\u0014\"\u0004\bD\u0010\u0016\u00a8\u0006H"}, d2={"Lorg/gnit/lucenekmp/search/SortField;", "", "field", "", "type", "Lorg/gnit/lucenekmp/search/SortField$Type;", "<init>", "(Ljava/lang/String;Lorg/gnit/lucenekmp/search/SortField$Type;)V", "reverse", "", "(Ljava/lang/String;Lorg/gnit/lucenekmp/search/SortField$Type;Z)V", "comparator", "Lorg/gnit/lucenekmp/search/FieldComparatorSource;", "(Ljava/lang/String;Lorg/gnit/lucenekmp/search/FieldComparatorSource;)V", "(Ljava/lang/String;Lorg/gnit/lucenekmp/search/FieldComparatorSource;Z)V", "getField", "()Ljava/lang/String;", "setField", "(Ljava/lang/String;)V", "getReverse", "()Z", "setReverse", "(Z)V", "comparatorSource", "missingValue", "getMissingValue", "()Ljava/lang/Object;", "setMissingValue", "(Ljava/lang/Object;)V", "value", "optimizeSortWithIndexedData", "getOptimizeSortWithIndexedData$annotations", "()V", "getOptimizeSortWithIndexedData", "setOptimizeSortWithIndexedData", "serialize", "", "out", "Lorg/gnit/lucenekmp/store/DataOutput;", "setMissingValueKt", "initFieldType", "getType", "getComparatorSource", "toString", "equals", "o", "hashCode", "", "bytesComparator", "Ljava/util/Comparator;", "Lorg/gnit/lucenekmp/util/BytesRef;", "Lkotlin/Comparator;", "setBytesComparator", "b", "getBytesComparator", "getComparator", "Lorg/gnit/lucenekmp/search/FieldComparator;", "numHits", "pruning", "Lorg/gnit/lucenekmp/search/Pruning;", "rewrite", "searcher", "Lorg/gnit/lucenekmp/search/IndexSearcher;", "needsScores", "getIndexSorter", "Lorg/gnit/lucenekmp/index/IndexSorter;", "optimizeSortWithPoints", "getOptimizeSortWithPoints", "setOptimizeSortWithPoints", "Type", "Provider", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nSortField.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SortField.kt\norg/gnit/lucenekmp/search/SortField\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,649:1\n1#2:650\n*E\n"})
public final class SortField {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private String field;
    private Type type;
    private boolean reverse;
    @Nullable
    private FieldComparatorSource comparatorSource;
    @Nullable
    private Object missingValue;
    private boolean optimizeSortWithIndexedData;
    @NotNull
    private Comparator<BytesRef> bytesComparator;
    @NotNull
    private static final SortField FIELD_SCORE = new SortField(null, Type.SCORE);
    @NotNull
    private static final SortField FIELD_DOC = new SortField(null, Type.DOC);
    @NotNull
    private static final Object STRING_FIRST = new Object(){

        public String toString() {
            return "SortField.STRING_FIRST";
        }
    };
    @NotNull
    private static final Object STRING_LAST = new Object(){

        public String toString() {
            return "SortField.STRING_LAST";
        }
    };

    @Nullable
    public final String getField() {
        return this.field;
    }

    public final void setField(@Nullable String string) {
        this.field = string;
    }

    public final boolean getReverse() {
        return this.reverse;
    }

    public final void setReverse(boolean bl) {
        this.reverse = bl;
    }

    @Nullable
    protected final Object getMissingValue() {
        return this.missingValue;
    }

    protected final void setMissingValue(@Nullable Object object) {
        this.missingValue = object;
    }

    @Deprecated(message="")
    public final boolean getOptimizeSortWithIndexedData() {
        return this.optimizeSortWithIndexedData;
    }

    @Deprecated(message="should only be used for compatibility with 8.x indices that got created with\n        inconsistent data across fields, or the wrong sort configuration in the index sort")
    public final void setOptimizeSortWithIndexedData(boolean bl) {
        this.optimizeSortWithIndexedData = bl;
    }

    @Deprecated(message="")
    public static /* synthetic */ void getOptimizeSortWithIndexedData$annotations() {
    }

    public SortField(@Nullable String field, @NotNull Type type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.optimizeSortWithIndexedData = true;
        this.bytesComparator = ComparisonsKt.naturalOrder();
        this.initFieldType(field, type);
    }

    public SortField(@Nullable String field, @NotNull Type type, boolean reverse) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.optimizeSortWithIndexedData = true;
        this.bytesComparator = ComparisonsKt.naturalOrder();
        this.initFieldType(field, type);
        this.reverse = reverse;
    }

    private final void serialize(DataOutput out) throws IOException {
        String string = this.field;
        if (string == null) {
            string = "";
        }
        out.writeString(string);
        Type type = this.type;
        if (type == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"type");
            type = null;
        }
        out.writeString(type.toString());
        out.writeInt(this.reverse ? 1 : 0);
        if (this.missingValue == null) {
            out.writeInt(0);
        } else {
            out.writeInt(1);
            Type type2 = this.type;
            if (type2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"type");
                type2 = null;
            }
            switch (WhenMappings.$EnumSwitchMapping$0[type2.ordinal()]) {
                case 1: {
                    if (this.missingValue == STRING_LAST) {
                        out.writeInt(0);
                        break;
                    }
                    if (this.missingValue == STRING_FIRST) {
                        out.writeInt(1);
                        break;
                    }
                    throw new IllegalArgumentException("Cannot serialize missing value of " + this.missingValue + " for type STRING");
                }
                case 2: {
                    Object object = this.missingValue;
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
                    out.writeInt((Integer)object);
                    break;
                }
                case 3: {
                    Object object = this.missingValue;
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Long");
                    out.writeLong((Long)object);
                    break;
                }
                case 4: {
                    Object object = this.missingValue;
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Float");
                    out.writeInt(NumericUtils.INSTANCE.floatToSortableInt(((Float)object).floatValue()));
                    break;
                }
                case 5: {
                    Object object = this.missingValue;
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Double");
                    out.writeLong(NumericUtils.INSTANCE.doubleToSortableLong((Double)object));
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    Type type3 = this.type;
                    if (type3 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"type");
                        type3 = null;
                    }
                    throw new IllegalArgumentException("Cannot serialize SortField of type " + type3);
                }
                default: {
                    Type type4 = this.type;
                    if (type4 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"type");
                        type4 = null;
                    }
                    throw new IllegalArgumentException("Cannot serialize SortField of type " + type4);
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @JvmName(name="setMissingValueKt")
    public final void setMissingValueKt(@NotNull Object missingValue) {
        Intrinsics.checkNotNullParameter((Object)missingValue, (String)"missingValue");
        v0 = this.type;
        if (v0 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"type");
            v0 = null;
        }
        if (v0 == Type.STRING) ** GOTO lbl-1000
        v1 = this.type;
        if (v1 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"type");
            v1 = null;
        }
        if (v1 == Type.STRING_VAL) lbl-1000:
        // 2 sources

        {
            if (!(missingValue == SortField.STRING_FIRST || missingValue == SortField.STRING_LAST)) {
                $i$a$-require-SortField$setMissingValue$1 = false;
                $i$a$-require-SortField$setMissingValue$1 = "For STRING type, missing value must be either STRING_FIRST or STRING_LAST";
                throw new IllegalArgumentException($i$a$-require-SortField$setMissingValue$1.toString());
            }
        } else {
            v2 = this.type;
            if (v2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"type");
                v2 = null;
            }
            if (v2 == Type.INT) {
                if (!(missingValue.getClass() == Integer.class)) {
                    $i$a$-require-SortField$setMissingValue$2 = false;
                    $i$a$-require-SortField$setMissingValue$2 = "Missing values for Type.INT can only be of type java.lang.Integer, but got " + Reflection.getOrCreateKotlinClass(missingValue.getClass());
                    throw new IllegalArgumentException($i$a$-require-SortField$setMissingValue$2.toString());
                }
            } else {
                v3 = this.type;
                if (v3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"type");
                    v3 = null;
                }
                if (v3 == Type.LONG) {
                    if (!(missingValue.getClass() == Long.class)) {
                        $i$a$-require-SortField$setMissingValue$3 = false;
                        $i$a$-require-SortField$setMissingValue$3 = "Missing values for Type.LONG can only be of type java.lang.Long, but got " + Reflection.getOrCreateKotlinClass(missingValue.getClass());
                        throw new IllegalArgumentException($i$a$-require-SortField$setMissingValue$3.toString());
                    }
                } else {
                    v4 = this.type;
                    if (v4 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"type");
                        v4 = null;
                    }
                    if (v4 == Type.FLOAT) {
                        if (!(missingValue.getClass() == Float.class)) {
                            $i$a$-require-SortField$setMissingValue$4 = false;
                            $i$a$-require-SortField$setMissingValue$4 = "Missing values for Type.FLOAT can only be of type java.lang.Float, but got " + Reflection.getOrCreateKotlinClass(missingValue.getClass());
                            throw new IllegalArgumentException($i$a$-require-SortField$setMissingValue$4.toString());
                        }
                    } else {
                        v5 = this.type;
                        if (v5 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"type");
                            v5 = null;
                        }
                        if (v5 == Type.DOUBLE) {
                            if (!(missingValue.getClass() == Double.class)) {
                                $i$a$-require-SortField$setMissingValue$5 = false;
                                var2_11 = "Missing values for Type.DOUBLE can only be of type java.lang.Double, but got " + Reflection.getOrCreateKotlinClass(missingValue.getClass());
                                throw new IllegalArgumentException(var2_11.toString());
                            }
                        } else {
                            throw new IllegalArgumentException("Missing value only works for numeric or STRING types");
                        }
                    }
                }
            }
        }
        this.missingValue = missingValue;
    }

    public SortField(@Nullable String field, @NotNull FieldComparatorSource comparator2) {
        Intrinsics.checkNotNullParameter((Object)comparator2, (String)"comparator");
        this.optimizeSortWithIndexedData = true;
        this.bytesComparator = ComparisonsKt.naturalOrder();
        this.initFieldType(field, Type.CUSTOM);
        this.comparatorSource = comparator2;
    }

    public SortField(@Nullable String field, @NotNull FieldComparatorSource comparator2, boolean reverse) {
        Intrinsics.checkNotNullParameter((Object)comparator2, (String)"comparator");
        this.optimizeSortWithIndexedData = true;
        this.bytesComparator = ComparisonsKt.naturalOrder();
        this.initFieldType(field, Type.CUSTOM);
        this.reverse = reverse;
        this.comparatorSource = comparator2;
    }

    private final void initFieldType(String field, Type type) {
        this.type = type;
        if (field == null) {
            if (!(type == Type.SCORE || type == Type.DOC)) {
                boolean bl = false;
                String string = "field can only be null when type is SCORE or DOC";
                throw new IllegalArgumentException(string.toString());
            }
        } else {
            this.field = field;
        }
    }

    @NotNull
    public final Type getType() {
        Type type = this.type;
        if (type == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"type");
            type = null;
        }
        return type;
    }

    @Nullable
    public final FieldComparatorSource getComparatorSource() {
        return this.comparatorSource;
    }

    @NotNull
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        Type type = this.type;
        if (type == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"type");
            type = null;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 10: {
                StringBuilder stringBuilder = buffer.append("<score>");
                break;
            }
            case 7: {
                StringBuilder stringBuilder = buffer.append("<doc>");
                break;
            }
            case 1: {
                StringBuilder stringBuilder = buffer.append("<string: \"").append(this.field).append("\">");
                break;
            }
            case 9: {
                StringBuilder stringBuilder = buffer.append("<string_val: \"").append(this.field).append("\">");
                break;
            }
            case 2: {
                StringBuilder stringBuilder = buffer.append("<int: \"").append(this.field).append("\">");
                break;
            }
            case 3: {
                StringBuilder stringBuilder = buffer.append("<long: \"").append(this.field).append("\">");
                break;
            }
            case 4: {
                StringBuilder stringBuilder = buffer.append("<float: \"").append(this.field).append("\">");
                break;
            }
            case 5: {
                StringBuilder stringBuilder = buffer.append("<double: \"").append(this.field).append("\">");
                break;
            }
            case 6: {
                StringBuilder stringBuilder = buffer.append("<custom:\"").append(this.field).append("\": ").append(this.comparatorSource).append('>');
                break;
            }
            case 8: {
                StringBuilder stringBuilder = buffer.append("<rewriteable: \"").append(this.field).append("\">");
                break;
            }
            default: {
                StringBuilder stringBuilder = buffer.append("<: \"").append(this.field).append("\">");
            }
        }
        if (this.reverse) {
            buffer.append('!');
        }
        if (this.missingValue != null) {
            buffer.append(" missingValue=");
            buffer.append(this.missingValue);
        }
        String string = buffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object o) {
        Type type;
        if (this == o) {
            return true;
        }
        if (!(o instanceof SortField)) {
            return false;
        }
        SortField other = (SortField)o;
        if (!Intrinsics.areEqual((Object)other.field, (Object)this.field)) return false;
        Type type2 = other.type;
        if (type2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"type");
            type2 = null;
        }
        if ((type = this.type) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"type");
            type = null;
        }
        if (type2 != type) return false;
        if (other.reverse != this.reverse) return false;
        if (!Intrinsics.areEqual((Object)this.comparatorSource, (Object)other.comparatorSource)) return false;
        if (!Intrinsics.areEqual((Object)this.missingValue, (Object)other.missingValue)) return false;
        return true;
    }

    public int hashCode() {
        Object[] objectArray = new Object[5];
        objectArray[0] = this.field;
        Type type = this.type;
        if (type == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"type");
            type = null;
        }
        objectArray[1] = type;
        objectArray[2] = this.reverse;
        objectArray[3] = this.comparatorSource;
        objectArray[4] = this.missingValue;
        return Objects.INSTANCE.hash(objectArray);
    }

    public final void setBytesComparator(@NotNull Comparator<BytesRef> b) {
        Intrinsics.checkNotNullParameter(b, (String)"b");
        this.bytesComparator = b;
    }

    @NotNull
    public final Comparator<BytesRef> getBytesComparator() {
        return this.bytesComparator;
    }

    @NotNull
    public final FieldComparator<?> getComparator(int numHits, @NotNull Pruning pruning) {
        Intrinsics.checkNotNullParameter((Object)((Object)pruning), (String)"pruning");
        FieldComparator fieldComparator = null;
        Type type = this.type;
        if (type == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"type");
            type = null;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 10: {
                fieldComparator = new FieldComparator.RelevanceComparator(numHits);
                break;
            }
            case 7: {
                fieldComparator = new DocComparator(numHits, this.reverse, pruning);
                break;
            }
            case 2: {
                String string = this.field;
                Intrinsics.checkNotNull((Object)string);
                fieldComparator = new IntComparator(numHits, string, (Integer)this.missingValue, this.reverse, pruning);
                break;
            }
            case 4: {
                String string = this.field;
                Intrinsics.checkNotNull((Object)string);
                Object object = this.missingValue;
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Float");
                fieldComparator = new FloatComparator(numHits, string, ((Float)object).floatValue(), this.reverse, pruning);
                break;
            }
            case 3: {
                String string = this.field;
                Intrinsics.checkNotNull((Object)string);
                Object object = this.missingValue;
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Long");
                fieldComparator = new LongComparator(numHits, string, (Long)object, this.reverse, pruning);
                break;
            }
            case 5: {
                String string = this.field;
                Intrinsics.checkNotNull((Object)string);
                Object object = this.missingValue;
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Double");
                fieldComparator = new DoubleComparator(numHits, string, (Double)object, this.reverse, pruning);
                break;
            }
            case 6: {
                if (this.comparatorSource == null) {
                    String string = "Required value was null.";
                    throw new IllegalStateException(string.toString());
                }
                FieldComparatorSource fieldComparatorSource = this.comparatorSource;
                Intrinsics.checkNotNull((Object)fieldComparatorSource);
                String string = this.field;
                Intrinsics.checkNotNull((Object)string);
                fieldComparator = fieldComparatorSource.newComparator(string, numHits, pruning, this.reverse);
                break;
            }
            case 1: {
                String string = this.field;
                Intrinsics.checkNotNull((Object)string);
                fieldComparator = new TermOrdValComparator(numHits, string, this.missingValue == STRING_LAST, this.reverse, pruning);
                break;
            }
            case 9: {
                String string = this.field;
                Intrinsics.checkNotNull((Object)string);
                fieldComparator = new FieldComparator.TermValComparator(numHits, string, this.missingValue == STRING_LAST);
                break;
            }
            case 8: {
                throw new IllegalStateException("SortField needs to be rewritten through Sort.rewrite(..) and SortField.rewrite(..)");
            }
            default: {
                Type type2 = this.type;
                if (type2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"type");
                    type2 = null;
                }
                throw new IllegalStateException("Illegal sort type: " + type2);
            }
        }
        if (!this.optimizeSortWithIndexedData) {
            fieldComparator.disableSkipping();
        }
        return fieldComparator;
    }

    @NotNull
    public final SortField rewrite(@NotNull IndexSearcher searcher) throws IOException {
        Intrinsics.checkNotNullParameter((Object)searcher, (String)"searcher");
        return this;
    }

    public final boolean needsScores() {
        Type type = this.type;
        if (type == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"type");
            type = null;
        }
        return type == Type.SCORE;
    }

    @Nullable
    public final IndexSorter getIndexSorter() {
        if (this.field == null) {
            return null;
        }
        String string = this.field;
        Intrinsics.checkNotNull((Object)string);
        String fieldName = string;
        Type type = this.type;
        if (type == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"type");
            type = null;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                Object object = this.missingValue;
                if (object == null) {
                    object = STRING_LAST;
                }
                Object missVal = object;
                return new IndexSorter.StringSorter("SortField", missVal, this.reverse, new IndexSorter.SortedDocValuesProvider(fieldName){
                    final /* synthetic */ String $fieldName;
                    {
                        this.$fieldName = $fieldName;
                    }

                    public SortedDocValues get(LeafReader reader2) throws IOException {
                        Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
                        return DocValues.INSTANCE.getSorted(reader2, this.$fieldName);
                    }
                });
            }
            case 2: {
                Object object = this.missingValue;
                Integer n = object instanceof Integer ? (Integer)object : null;
                int missVal = n != null ? n : 0;
                return new IndexSorter.IntSorter("SortField", missVal, this.reverse, new IndexSorter.NumericDocValuesProvider(fieldName){
                    final /* synthetic */ String $fieldName;
                    {
                        this.$fieldName = $fieldName;
                    }

                    public NumericDocValues get(LeafReader reader2) throws IOException {
                        Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
                        return DocValues.INSTANCE.getNumeric(reader2, this.$fieldName);
                    }
                });
            }
            case 3: {
                Object object = this.missingValue;
                Long l = object instanceof Long ? (Long)object : null;
                long missVal = l != null ? l : 0L;
                return new IndexSorter.LongSorter("SortField", missVal, this.reverse, new IndexSorter.NumericDocValuesProvider(fieldName){
                    final /* synthetic */ String $fieldName;
                    {
                        this.$fieldName = $fieldName;
                    }

                    public NumericDocValues get(LeafReader reader2) throws IOException {
                        Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
                        return DocValues.INSTANCE.getNumeric(reader2, this.$fieldName);
                    }
                });
            }
            case 5: {
                Object object = this.missingValue;
                Double d = object instanceof Double ? (Double)object : null;
                double missVal = d != null ? d : 0.0;
                return new IndexSorter.DoubleSorter("SortField", missVal, this.reverse, new IndexSorter.NumericDocValuesProvider(fieldName){
                    final /* synthetic */ String $fieldName;
                    {
                        this.$fieldName = $fieldName;
                    }

                    public NumericDocValues get(LeafReader reader2) throws IOException {
                        Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
                        return DocValues.INSTANCE.getNumeric(reader2, this.$fieldName);
                    }
                });
            }
            case 4: {
                Object object = this.missingValue;
                Float f = object instanceof Float ? (Float)object : null;
                float missVal = f != null ? f.floatValue() : 0.0f;
                return new IndexSorter.FloatSorter("SortField", Float.valueOf(missVal), this.reverse, new IndexSorter.NumericDocValuesProvider(fieldName){
                    final /* synthetic */ String $fieldName;
                    {
                        this.$fieldName = $fieldName;
                    }

                    public NumericDocValues get(LeafReader reader2) throws IOException {
                        Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
                        return DocValues.INSTANCE.getNumeric(reader2, this.$fieldName);
                    }
                });
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return null;
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    @Deprecated(message="This is a duplicate method for {@code SortField#getOptimizeSortWithIndexedData}.")
    public final boolean getOptimizeSortWithPoints() {
        return this.optimizeSortWithIndexedData;
    }

    @Deprecated(message="should only be used for compatibility with 8.x indices that got created with\n        inconsistent data across fields, or the wrong sort configuration in the index sort. This is\n        a duplicate method for {@code SortField#setOptimizeSortWithIndexedData}.")
    public final void setOptimizeSortWithPoints(boolean optimizeSortWithPoints) {
        this.optimizeSortWithIndexedData = optimizeSortWithPoints;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0004R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\u000e\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010\u00a8\u0006\u0013"}, d2={"Lorg/gnit/lucenekmp/search/SortField$Companion;", "", "<init>", "()V", "FIELD_SCORE", "Lorg/gnit/lucenekmp/search/SortField;", "getFIELD_SCORE", "()Lorg/gnit/lucenekmp/search/SortField;", "FIELD_DOC", "getFIELD_DOC", "readType", "Lorg/gnit/lucenekmp/search/SortField$Type;", "in", "Lorg/gnit/lucenekmp/store/DataInput;", "STRING_FIRST", "getSTRING_FIRST", "()Ljava/lang/Object;", "STRING_LAST", "getSTRING_LAST", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SortField getFIELD_SCORE() {
            return FIELD_SCORE;
        }

        @NotNull
        public final SortField getFIELD_DOC() {
            return FIELD_DOC;
        }

        @NotNull
        protected final Type readType(@NotNull DataInput in) throws IOException {
            Intrinsics.checkNotNullParameter((Object)in, (String)"in");
            String type = in.readString();
            try {
                return Type.valueOf(type);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Can't deserialize SortField - unknown type " + type, e);
            }
        }

        @NotNull
        public final Object getSTRING_FIRST() {
            return STRING_FIRST;
        }

        @NotNull
        public final Object getSTRING_LAST() {
            return STRING_LAST;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/gnit/lucenekmp/search/SortField$Provider;", "Lorg/gnit/lucenekmp/index/SortFieldProvider;", "<init>", "()V", "readSortField", "Lorg/gnit/lucenekmp/search/SortField;", "in", "Lorg/gnit/lucenekmp/store/DataInput;", "writeSortField", "", "sf", "out", "Lorg/gnit/lucenekmp/store/DataOutput;", "Companion", "core"})
    public static final class Provider
    extends SortFieldProvider {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        public static final String NAME = "SortField";

        public Provider() {
            super(NAME);
        }

        @Override
        @NotNull
        public SortField readSortField(@NotNull DataInput in) throws IOException {
            Intrinsics.checkNotNullParameter((Object)in, (String)"in");
            SortField sf = new SortField(in.readString(), Companion.readType(in), in.readInt() == 1);
            if (in.readInt() == 1) {
                Type type = sf.type;
                if (type == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"type");
                    type = null;
                }
                switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                    case 1: {
                        int missingString = in.readInt();
                        if (missingString == 1) {
                            sf.setMissingValueKt(Companion.getSTRING_FIRST());
                            break;
                        }
                        sf.setMissingValueKt(Companion.getSTRING_LAST());
                        break;
                    }
                    case 2: {
                        sf.setMissingValueKt(in.readInt());
                        break;
                    }
                    case 3: {
                        sf.setMissingValueKt(in.readLong());
                        break;
                    }
                    case 4: {
                        sf.setMissingValueKt(Float.valueOf(NumericUtils.INSTANCE.sortableIntToFloat(in.readInt())));
                        break;
                    }
                    case 5: {
                        sf.setMissingValueKt(NumericUtils.INSTANCE.sortableLongToDouble(in.readLong()));
                        break;
                    }
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: {
                        Type type2 = sf.type;
                        if (type2 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"type");
                            type2 = null;
                        }
                        throw new IllegalArgumentException("Cannot deserialize sort of type " + type2);
                    }
                    default: {
                        Type type3 = sf.type;
                        if (type3 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"type");
                            type3 = null;
                        }
                        throw new IllegalArgumentException("Cannot deserialize sort of type " + type3);
                    }
                }
            }
            return sf;
        }

        @Override
        public void writeSortField(@NotNull SortField sf, @NotNull DataOutput out) throws IOException {
            Intrinsics.checkNotNullParameter((Object)sf, (String)"sf");
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            sf.serialize(out);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/gnit/lucenekmp/search/SortField$Provider$Companion;", "", "<init>", "()V", "NAME", "", "core"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Type.values().length];
                try {
                    nArray[Type.STRING.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Type.INT.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Type.LONG.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Type.FLOAT.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Type.DOUBLE.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Type.CUSTOM.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Type.DOC.ordinal()] = 7;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Type.REWRITEABLE.ordinal()] = 8;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Type.STRING_VAL.ordinal()] = 9;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Type.SCORE.ordinal()] = 10;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\r\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\r\u00a8\u0006\u000e"}, d2={"Lorg/gnit/lucenekmp/search/SortField$Type;", "", "<init>", "(Ljava/lang/String;I)V", "SCORE", "DOC", "STRING", "INT", "FLOAT", "LONG", "DOUBLE", "CUSTOM", "STRING_VAL", "REWRITEABLE", "core"})
    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type SCORE = new Type();
        public static final /* enum */ Type DOC = new Type();
        public static final /* enum */ Type STRING = new Type();
        public static final /* enum */ Type INT = new Type();
        public static final /* enum */ Type FLOAT = new Type();
        public static final /* enum */ Type LONG = new Type();
        public static final /* enum */ Type DOUBLE = new Type();
        public static final /* enum */ Type CUSTOM = new Type();
        public static final /* enum */ Type STRING_VAL = new Type();
        public static final /* enum */ Type REWRITEABLE = new Type();
        private static final /* synthetic */ Type[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String value) {
            return Enum.valueOf(Type.class, value);
        }

        @NotNull
        public static EnumEntries<Type> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = typeArray = new Type[]{Type.SCORE, Type.DOC, Type.STRING, Type.INT, Type.FLOAT, Type.LONG, Type.DOUBLE, Type.CUSTOM, Type.STRING_VAL, Type.REWRITEABLE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Type.values().length];
            try {
                nArray[Type.STRING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Type.INT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Type.LONG.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Type.FLOAT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Type.DOUBLE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Type.CUSTOM.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Type.DOC.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Type.REWRITEABLE.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Type.STRING_VAL.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Type.SCORE.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

