/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.LongCompanionObject;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.index.Impact;
import org.gnit.lucenekmp.index.Impacts;
import org.gnit.lucenekmp.index.ImpactsEnum;
import org.gnit.lucenekmp.index.ImpactsSource;
import org.gnit.lucenekmp.index.LeafReaderContext;
import org.gnit.lucenekmp.index.NumericDocValues;
import org.gnit.lucenekmp.index.PostingsEnum;
import org.gnit.lucenekmp.index.SlowImpactsEnum;
import org.gnit.lucenekmp.index.Term;
import org.gnit.lucenekmp.index.TermState;
import org.gnit.lucenekmp.index.TermStates;
import org.gnit.lucenekmp.index.Terms;
import org.gnit.lucenekmp.index.TermsEnum;
import org.gnit.lucenekmp.jdkport.FloatExtKt;
import org.gnit.lucenekmp.jdkport.LongExtKt;
import org.gnit.lucenekmp.jdkport.UncheckedIOException;
import org.gnit.lucenekmp.search.BooleanClause;
import org.gnit.lucenekmp.search.BooleanQuery;
import org.gnit.lucenekmp.search.CollectionStatistics;
import org.gnit.lucenekmp.search.ConstantScoreScorer;
import org.gnit.lucenekmp.search.DisiWrapper;
import org.gnit.lucenekmp.search.DisjunctionDISIApproximation;
import org.gnit.lucenekmp.search.DisjunctionMatchesIterator;
import org.gnit.lucenekmp.search.DocIdSetIterator;
import org.gnit.lucenekmp.search.Explanation;
import org.gnit.lucenekmp.search.FilterScorer;
import org.gnit.lucenekmp.search.ImpactsDISI;
import org.gnit.lucenekmp.search.IndexSearcher;
import org.gnit.lucenekmp.search.Matches;
import org.gnit.lucenekmp.search.MatchesIterator;
import org.gnit.lucenekmp.search.MatchesUtils;
import org.gnit.lucenekmp.search.MaxScoreCache;
import org.gnit.lucenekmp.search.Query;
import org.gnit.lucenekmp.search.QueryVisitor;
import org.gnit.lucenekmp.search.ScoreMode;
import org.gnit.lucenekmp.search.Scorer;
import org.gnit.lucenekmp.search.ScorerSupplier;
import org.gnit.lucenekmp.search.SynonymQuery;
import org.gnit.lucenekmp.search.TermQuery;
import org.gnit.lucenekmp.search.TermScorer;
import org.gnit.lucenekmp.search.TermStatistics;
import org.gnit.lucenekmp.search.Weight;
import org.gnit.lucenekmp.search.similarities.Similarity;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.IOSupplier;
import org.gnit.lucenekmp.util.PriorityQueue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\b\u0018\u0000 *2\u00020\u0001:\u0007$%&'()*B\u001f\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rJ\u0012\u0010\u000f\u001a\u00020\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0096\u0002J\u0010\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J \u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00182\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016R\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006+"}, d2={"Lorg/gnit/lucenekmp/search/SynonymQuery;", "Lorg/gnit/lucenekmp/search/Query;", "terms", "", "Lorg/gnit/lucenekmp/search/SynonymQuery$TermAndBoost;", "field", "", "<init>", "([Lorg/gnit/lucenekmp/search/SynonymQuery$TermAndBoost;Ljava/lang/String;)V", "[Lorg/gnit/lucenekmp/search/SynonymQuery$TermAndBoost;", "getField", "()Ljava/lang/String;", "getTerms", "", "Lorg/gnit/lucenekmp/index/Term;", "toString", "hashCode", "", "equals", "", "other", "", "rewrite", "indexSearcher", "Lorg/gnit/lucenekmp/search/IndexSearcher;", "visit", "", "visitor", "Lorg/gnit/lucenekmp/search/QueryVisitor;", "createWeight", "Lorg/gnit/lucenekmp/search/Weight;", "searcher", "scoreMode", "Lorg/gnit/lucenekmp/search/ScoreMode;", "boost", "", "Builder", "SynonymWeight", "SynonymScorer", "DisiWrapperFreq", "FreqBoostTermScorer", "TermAndBoost", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nSynonymQuery.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SynonymQuery.kt\norg/gnit/lucenekmp/search/SynonymQuery\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,713:1\n11228#2:714\n11563#2,3:715\n11228#2:718\n11563#2,3:719\n37#3:722\n36#3,3:723\n*S KotlinDebug\n*F\n+ 1 SynonymQuery.kt\norg/gnit/lucenekmp/search/SynonymQuery\n*L\n93#1:714\n93#1:715,3\n140#1:718\n140#1:719,3\n140#1:722\n140#1:723,3\n*E\n"})
public final class SynonymQuery
extends Query {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TermAndBoost[] terms;
    @NotNull
    private final String field;

    private SynonymQuery(TermAndBoost[] terms, String field) {
        this.terms = terms;
        this.field = field;
    }

    @NotNull
    public final String getField() {
        return this.field;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Term> getTerms() {
        void $this$mapTo$iv$iv;
        TermAndBoost[] $this$map$iv = this.terms;
        boolean $i$f$map = false;
        TermAndBoost[] termAndBoostArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void t;
            void item$iv$iv;
            void var9_9 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Term(this.field, t.getTerm()));
        }
        return CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
    }

    @Override
    @NotNull
    public String toString(@Nullable String field) {
        StringBuilder builder = new StringBuilder("Synonym(");
        int n = this.terms.length;
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                builder.append(" ");
            }
            Query termQuery = new TermQuery(new Term(this.field, this.terms[i].getTerm()));
            builder.append(termQuery.toString(field));
            if (this.terms[i].getBoost() == 1.0f) continue;
            builder.append("^");
            builder.append(this.terms[i].getBoost());
        }
        builder.append(")");
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Override
    public int hashCode() {
        return 31 * this.classHash() + Arrays.hashCode(this.terms) + this.field.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(@Nullable Object other) {
        if (!this.sameClassAs(other)) return false;
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.search.SynonymQuery");
        if (!Intrinsics.areEqual((Object)this.field, (Object)((SynonymQuery)other).field)) return false;
        if (!Arrays.equals(this.terms, ((SynonymQuery)other).terms)) return false;
        return true;
    }

    @Override
    @NotNull
    public Query rewrite(@NotNull IndexSearcher indexSearcher) {
        Intrinsics.checkNotNullParameter((Object)indexSearcher, (String)"indexSearcher");
        if (this.terms.length == 0) {
            return new BooleanQuery.Builder().build();
        }
        if (this.terms.length == 1 && this.terms[0].getBoost() == 1.0f) {
            return new TermQuery(new Term(this.field, this.terms[0].getTerm()));
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visit(@NotNull QueryVisitor visitor2) {
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
        if (!visitor2.acceptField(this.field)) {
            return;
        }
        QueryVisitor v = visitor2.getSubVisitor(BooleanClause.Occur.SHOULD, this);
        Object $this$map$iv = this.terms;
        boolean $i$f$map = false;
        TermAndBoost[] termAndBoostArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((TermAndBoost[])$this$map$iv).length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void t;
            void item$iv$iv;
            void var12_11 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Term(this.field, t.getTerm()));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        Term[] ts = thisCollection$iv.toArray(new Term[0]);
        v.consumeTerms(this, Arrays.copyOf(ts, ts.length));
    }

    @Override
    @NotNull
    public Weight createWeight(@NotNull IndexSearcher searcher, @NotNull ScoreMode scoreMode, float boost) {
        Intrinsics.checkNotNullParameter((Object)searcher, (String)"searcher");
        Intrinsics.checkNotNullParameter((Object)((Object)scoreMode), (String)"scoreMode");
        if (scoreMode.needsScores()) {
            return new SynonymWeight(this, searcher, scoreMode, boost);
        }
        BooleanQuery.Builder bq = new BooleanQuery.Builder();
        for (TermAndBoost term : this.terms) {
            bq.add(new TermQuery(new Term(this.field, term.getTerm())), BooleanClause.Occur.SHOULD);
        }
        return searcher.rewrite(bq.build()).createWeight(searcher, ScoreMode.COMPLETE_NO_SCORES, boost);
    }

    public /* synthetic */ SynonymQuery(TermAndBoost[] terms, String field, DefaultConstructorMarker $constructor_marker) {
        this(terms, field);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\t\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\rH\u0007J\u0016\u0010\t\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/gnit/lucenekmp/search/SynonymQuery$Builder;", "", "field", "", "<init>", "(Ljava/lang/String;)V", "terms", "", "Lorg/gnit/lucenekmp/search/SynonymQuery$TermAndBoost;", "addTerm", "term", "Lorg/gnit/lucenekmp/index/Term;", "boost", "", "Lorg/gnit/lucenekmp/util/BytesRef;", "build", "Lorg/gnit/lucenekmp/search/SynonymQuery;", "core"})
    @SourceDebugExtension(value={"SMAP\nSynonymQuery.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SynonymQuery.kt\norg/gnit/lucenekmp/search/SynonymQuery$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,713:1\n1#2:714\n1011#3,2:715\n37#4:717\n36#4,3:718\n*S KotlinDebug\n*F\n+ 1 SynonymQuery.kt\norg/gnit/lucenekmp/search/SynonymQuery$Builder\n*L\n86#1:715,2\n87#1:717\n87#1:718,3\n*E\n"})
    public static final class Builder {
        @NotNull
        private final String field;
        @NotNull
        private final List<TermAndBoost> terms;

        public Builder(@NotNull String field) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            this.field = field;
            this.terms = new ArrayList();
        }

        @JvmOverloads
        @NotNull
        public final Builder addTerm(@NotNull Term term, float boost) {
            Intrinsics.checkNotNullParameter((Object)term, (String)"term");
            if (!Intrinsics.areEqual((Object)this.field, (Object)term.field())) {
                boolean bl = false;
                String string = "Synonyms must be across the same field";
                throw new IllegalArgumentException(string.toString());
            }
            return this.addTerm(term.bytes(), boost);
        }

        public static /* synthetic */ Builder addTerm$default(Builder builder, Term term, float f, int n, Object object) {
            if ((n & 2) != 0) {
                f = 1.0f;
            }
            return builder.addTerm(term, f);
        }

        /*
         * Unable to fully structure code
         */
        @NotNull
        public final Builder addTerm(@NotNull BytesRef term, float boost) {
            Intrinsics.checkNotNullParameter((Object)term, (String)"term");
            if (FloatExtKt.isNaN(FloatCompanionObject.INSTANCE, boost)) ** GOTO lbl-1000
            if (FloatExtKt.compare(FloatCompanionObject.INSTANCE, boost, 0.0f) > 0 && FloatExtKt.compare(FloatCompanionObject.INSTANCE, boost, 1.0f) <= 0) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = false;
            }
            if (!v0) {
                $i$a$-require-SynonymQuery$Builder$addTerm$2 = false;
                var3_4 = "boost must be a positive float between 0 (exclusive) and 1 (inclusive)";
                throw new IllegalArgumentException(var3_4.toString());
            }
            this.terms.add(new TermAndBoost(term, boost));
            if (this.terms.size() > IndexSearcher.Companion.getMaxClauseCount()) {
                throw new IndexSearcher.TooManyClauses(null, 1, null);
            }
            return this;
        }

        @NotNull
        public final SynonymQuery build() {
            List<TermAndBoost> $this$sortBy$iv = this.terms;
            boolean $i$f$sortBy = false;
            if ($this$sortBy$iv.size() > 1) {
                CollectionsKt.sortWith($this$sortBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        TermAndBoost it = (TermAndBoost)a;
                        boolean bl = false;
                        Comparable comparable = it.getTerm();
                        it = (TermAndBoost)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)it.getTerm());
                    }
                });
            }
            Collection $this$toTypedArray$iv = this.terms;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return new SynonymQuery(thisCollection$iv.toArray(new TermAndBoost[0]), this.field, null);
        }

        @JvmOverloads
        @NotNull
        public final Builder addTerm(@NotNull Term term) {
            Intrinsics.checkNotNullParameter((Object)term, (String)"term");
            return Builder.addTerm$default(this, term, 0.0f, 2, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J!\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/gnit/lucenekmp/search/SynonymQuery$Companion;", "", "<init>", "()V", "mergeImpacts", "Lorg/gnit/lucenekmp/index/ImpactsSource;", "impactsEnums", "", "Lorg/gnit/lucenekmp/index/ImpactsEnum;", "boosts", "", "([Lorg/gnit/lucenekmp/index/ImpactsEnum;[F)Lorg/gnit/lucenekmp/index/ImpactsSource;", "core"})
    @SourceDebugExtension(value={"SMAP\nSynonymQuery.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SynonymQuery.kt\norg/gnit/lucenekmp/search/SynonymQuery$Companion\n+ 2 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 3 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n*L\n1#1,713:1\n3#2,8:714\n10#3:722\n*S KotlinDebug\n*F\n+ 1 SynonymQuery.kt\norg/gnit/lucenekmp/search/SynonymQuery$Companion\n*L\n545#1:714,8\n545#1:722\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ImpactsSource mergeImpacts(@NotNull ImpactsEnum[] impactsEnums, @NotNull float[] boosts) {
            Intrinsics.checkNotNullParameter((Object)impactsEnums, (String)"impactsEnums");
            Intrinsics.checkNotNullParameter((Object)boosts, (String)"boosts");
            boolean condition$iv = impactsEnums.length == boosts.length;
            boolean $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv) {
                boolean bl = false;
                String string = "assertion failed";
                throw new AssertionError((Object)string);
            }
            return new ImpactsSource(impactsEnums, boosts){
                final /* synthetic */ ImpactsEnum[] $impactsEnums;
                final /* synthetic */ float[] $boosts;
                {
                    this.$impactsEnums = $impactsEnums;
                    this.$boosts = $boosts;
                }

                public Impacts getImpacts() {
                    Impacts[] impacts2 = new Impacts[this.$impactsEnums.length];
                    Impacts tmpLead = null;
                    int n = this.$impactsEnums.length;
                    for (int i = 0; i < n; ++i) {
                        impacts2[i] = this.$impactsEnums[i].getImpacts();
                        if (tmpLead != null && impacts2[i].getDocIdUpTo(0) >= tmpLead.getDocIdUpTo(0)) continue;
                        tmpLead = impacts2[i];
                    }
                    Impacts impacts3 = tmpLead;
                    Intrinsics.checkNotNull(impacts3);
                    Impacts lead = impacts3;
                    return new Impacts(lead, this.$impactsEnums, impacts2, this.$boosts, this){
                        final /* synthetic */ Impacts $lead;
                        final /* synthetic */ ImpactsEnum[] $impactsEnums;
                        final /* synthetic */ Impacts[] $impacts;
                        final /* synthetic */ float[] $boosts;
                        final /* synthetic */ mergeImpacts.1 this$0;
                        {
                            this.$lead = $lead;
                            this.$impactsEnums = $impactsEnums;
                            this.$impacts = $impacts;
                            this.$boosts = $boosts;
                            this.this$0 = $receiver;
                        }

                        public int numLevels() {
                            return this.$lead.numLevels();
                        }

                        public int getDocIdUpTo(int level) {
                            return this.$lead.getDocIdUpTo(level);
                        }

                        public final int getLevel(Impacts impacts2, int docIdUpTo) {
                            Intrinsics.checkNotNullParameter((Object)impacts2, (String)"impacts");
                            int numLevels = impacts2.numLevels();
                            for (int level = 0; level < numLevels; ++level) {
                                if (impacts2.getDocIdUpTo(level) < docIdUpTo) continue;
                                return level;
                            }
                            return -1;
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public List<Impact> getImpacts(int level) {
                            void condition$iv;
                            int i;
                            int docIdUpTo = this.getDocIdUpTo(level);
                            List toMerge = new ArrayList<E>();
                            int n = this.$impactsEnums.length;
                            for (i = 0; i < n; ++i) {
                                if (this.$impactsEnums[i].docID() > docIdUpTo) continue;
                                int impactsLevel = this.getLevel(this.$impacts[i], docIdUpTo);
                                if (impactsLevel == -1) {
                                    Object[] objectArray = new Impact[]{new Impact(Integer.MAX_VALUE, 1L)};
                                    return CollectionsKt.mutableListOf((Object[])objectArray);
                                }
                                List impactList = null;
                                if (!(this.$boosts[i] == 1.0f)) {
                                    void $this$mapTo$iv$iv;
                                    void $this$map$iv;
                                    float boost = this.$boosts[i];
                                    Iterable iterable = this.$impacts[i].getImpacts(impactsLevel);
                                    boolean $i$f$map = false;
                                    void var11_19 = $this$map$iv;
                                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                    boolean $i$f$mapTo = false;
                                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                                        void impact;
                                        Impact impact2 = (Impact)item$iv$iv;
                                        Collection collection = destination$iv$iv;
                                        boolean bl = false;
                                        collection.add(new Impact((int)Math.ceil((float)impact.getFreq() * boost), impact.getNorm()));
                                    }
                                    impactList = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
                                } else {
                                    impactList = this.$impacts[i].getImpacts(impactsLevel);
                                }
                                toMerge.add(impactList);
                            }
                            i = !((Collection)toMerge).isEmpty() ? 1 : 0;
                            boolean $i$f$assert = false;
                            if (_Assertions.ENABLED && condition$iv == false) {
                                boolean bl = false;
                                String string = "assertion failed";
                                throw new AssertionError((Object)string);
                            }
                            if (toMerge.size() == 1) {
                                return (List)toMerge.get(0);
                            }
                            n = this.$impacts.length;
                            PriorityQueue pq2 = new PriorityQueue<mergeImpacts.SubIterator>(n){

                                public boolean lessThan(mergeImpacts.SubIterator a, mergeImpacts.SubIterator b) {
                                    Intrinsics.checkNotNullParameter((Object)a, (String)"a");
                                    Intrinsics.checkNotNullParameter((Object)b, (String)"b");
                                    if (a.getCurrent() == null) {
                                        return false;
                                    }
                                    if (b.getCurrent() == null) {
                                        return true;
                                    }
                                    Impact impact = a.getCurrent();
                                    Intrinsics.checkNotNull((Object)impact);
                                    long l = impact.getNorm();
                                    Impact impact2 = b.getCurrent();
                                    Intrinsics.checkNotNull((Object)impact2);
                                    return LongExtKt.compareUnsigned(LongCompanionObject.INSTANCE, l, impact2.getNorm()) < 0;
                                }
                            };
                            for (List impacts2 : toMerge) {
                                pq2.add(new mergeImpacts.SubIterator(this.this$0, impacts2.iterator()));
                            }
                            List mergedImpacts = new ArrayList<E>();
                            long sumTf = 0L;
                            mergeImpacts.SubIterator top = (mergeImpacts.SubIterator)pq2.top();
                            do {
                                Impact impact;
                                Impact impact3 = top.getCurrent();
                                Intrinsics.checkNotNull((Object)impact3);
                                long norm = impact3.getNorm();
                                do {
                                    Impact impact4 = top.getCurrent();
                                    Intrinsics.checkNotNull((Object)impact4);
                                    sumTf += (long)(impact4.getFreq() - top.getPreviousFreq());
                                    top.next();
                                    top = (mergeImpacts.SubIterator)pq2.updateTop();
                                    if (top.getCurrent() == null) break;
                                    impact = top.getCurrent();
                                    Intrinsics.checkNotNull((Object)impact);
                                } while (impact.getNorm() == norm);
                                int freqUpperBound = (int)Math.min(Integer.MAX_VALUE, sumTf);
                                if (mergedImpacts.isEmpty()) {
                                    mergedImpacts.add(new Impact(freqUpperBound, norm));
                                    continue;
                                }
                                Impact prevImpact = (Impact)mergedImpacts.get(mergedImpacts.size() - 1);
                                boolean condition$iv2 = LongExtKt.compareUnsigned(LongCompanionObject.INSTANCE, prevImpact.getNorm(), norm) < 0;
                                boolean $i$f$assert2 = false;
                                if (_Assertions.ENABLED && !condition$iv2) {
                                    boolean bl = false;
                                    String string = "assertion failed";
                                    throw new AssertionError((Object)string);
                                }
                                if (freqUpperBound <= prevImpact.getFreq()) continue;
                                mergedImpacts.add(new Impact(freqUpperBound, norm));
                            } while (top.getCurrent() != null);
                            return mergedImpacts;
                        }
                    };
                }

                public void advanceShallow(int target) throws IOException {
                    for (ImpactsEnum impactsEnum : this.$impactsEnums) {
                        if (impactsEnum.docID() >= target) continue;
                        impactsEnum.advanceShallow(target);
                    }
                }
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u000e\u001a\u00020\u0005R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000f"}, d2={"Lorg/gnit/lucenekmp/search/SynonymQuery$DisiWrapperFreq;", "Lorg/gnit/lucenekmp/search/DisiWrapper;", "scorer", "Lorg/gnit/lucenekmp/search/Scorer;", "boost", "", "<init>", "(Lorg/gnit/lucenekmp/search/Scorer;F)V", "getBoost", "()F", "pe", "Lorg/gnit/lucenekmp/index/PostingsEnum;", "getPe", "()Lorg/gnit/lucenekmp/index/PostingsEnum;", "freq", "core"})
    private static final class DisiWrapperFreq
    extends DisiWrapper {
        private final float boost;
        @NotNull
        private final PostingsEnum pe;

        public DisiWrapperFreq(@NotNull Scorer scorer2, float boost) {
            Intrinsics.checkNotNullParameter((Object)scorer2, (String)"scorer");
            super(scorer2, false);
            this.boost = boost;
            DocIdSetIterator docIdSetIterator = scorer2.iterator();
            Intrinsics.checkNotNull((Object)docIdSetIterator, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.index.PostingsEnum");
            this.pe = (PostingsEnum)docIdSetIterator;
        }

        public final float getBoost() {
            return this.boost;
        }

        @NotNull
        public final PostingsEnum getPe() {
            return this.pe;
        }

        public final float freq() throws IOException {
            return this.boost * (float)this.pe.freq();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\b\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010\u0014\u001a\u00020\u0003J\b\u0010\u0015\u001a\u00020\u0003H\u0016J\u0010\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u0018H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0004\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R$\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u00038V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001d\u0010\r\"\u0004\b\u001e\u0010\u001f\u00a8\u0006 "}, d2={"Lorg/gnit/lucenekmp/search/SynonymQuery$FreqBoostTermScorer;", "Lorg/gnit/lucenekmp/search/FilterScorer;", "boost", "", "in", "Lorg/gnit/lucenekmp/search/TermScorer;", "scorer", "Lorg/gnit/lucenekmp/search/similarities/Similarity$SimScorer;", "norms", "Lorg/gnit/lucenekmp/index/NumericDocValues;", "<init>", "(FLorg/gnit/lucenekmp/search/TermScorer;Lorg/gnit/lucenekmp/search/similarities/Similarity$SimScorer;Lorg/gnit/lucenekmp/index/NumericDocValues;)V", "getBoost", "()F", "getIn", "()Lorg/gnit/lucenekmp/search/TermScorer;", "getScorer", "()Lorg/gnit/lucenekmp/search/similarities/Similarity$SimScorer;", "getNorms", "()Lorg/gnit/lucenekmp/index/NumericDocValues;", "freq", "score", "getMaxScore", "upTo", "", "advanceShallow", "target", "minScore", "minCompetitiveScore", "getMinCompetitiveScore", "setMinCompetitiveScore", "(F)V", "core"})
    private static final class FreqBoostTermScorer
    extends FilterScorer {
        private final float boost;
        @NotNull
        private final TermScorer in;
        @NotNull
        private final Similarity.SimScorer scorer;
        @NotNull
        private final NumericDocValues norms;

        /*
         * Unable to fully structure code
         */
        public FreqBoostTermScorer(float boost, @NotNull TermScorer in, @NotNull Similarity.SimScorer scorer, @NotNull NumericDocValues norms) {
            Intrinsics.checkNotNullParameter((Object)in, (String)"in");
            Intrinsics.checkNotNullParameter((Object)scorer, (String)"scorer");
            Intrinsics.checkNotNullParameter((Object)norms, (String)"norms");
            super(in);
            if (FloatExtKt.isNaN(FloatCompanionObject.INSTANCE, boost) || FloatExtKt.compare(FloatCompanionObject.INSTANCE, boost, 0.0f) < 0) ** GOTO lbl-1000
            if (FloatExtKt.compare(FloatCompanionObject.INSTANCE, boost, 1.0f) <= 0) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = false;
            }
            if (!v0) {
                $i$a$-require-SynonymQuery$FreqBoostTermScorer$1 = false;
                var5_6 = "boost must be a positive float between 0 (exclusive) and 1 (inclusive)";
                throw new IllegalArgumentException(var5_6.toString());
            }
            this.boost = boost;
            this.in = in;
            this.scorer = scorer;
            this.norms = norms;
        }

        public final float getBoost() {
            return this.boost;
        }

        @Override
        @NotNull
        protected TermScorer getIn() {
            return this.in;
        }

        @NotNull
        public final Similarity.SimScorer getScorer() {
            return this.scorer;
        }

        @NotNull
        public final NumericDocValues getNorms() {
            return this.norms;
        }

        public final float freq() throws IOException {
            return this.boost * (float)this.getIn().freq();
        }

        @Override
        public float score() throws IOException {
            long norm = 1L;
            if (this.norms != null && this.norms.advanceExact(this.getIn().docID())) {
                norm = this.norms.longValue();
            }
            return this.scorer.score(this.freq(), norm);
        }

        @Override
        public float getMaxScore(int upTo) throws IOException {
            return this.getIn().getMaxScore(upTo);
        }

        @Override
        public int advanceShallow(int target) throws IOException {
            return this.getIn().advanceShallow(target);
        }

        @Override
        public float getMinCompetitiveScore() {
            throw new UnsupportedOperationException("minCompetitiveScore is not supported for FreqBoostTermScorer");
        }

        @Override
        public void setMinCompetitiveScore(float minScore) {
            this.getIn().setMinCompetitiveScoreKt(minScore);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\f\b\u0002\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0006\u0010\u0012\u001a\u00020\u0013J\b\u0010\u0014\u001a\u00020\u0013H\u0016J\b\u0010\u0002\u001a\u00020\u0003H\u0016J\u0010\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0011H\u0016J\u0010\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u00138V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001e\u00a8\u0006\u001f"}, d2={"Lorg/gnit/lucenekmp/search/SynonymQuery$SynonymScorer;", "Lorg/gnit/lucenekmp/search/Scorer;", "iterator", "Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "disjunctionDisi", "Lorg/gnit/lucenekmp/search/DisjunctionDISIApproximation;", "impactsDisi", "Lorg/gnit/lucenekmp/search/ImpactsDISI;", "scorer", "Lorg/gnit/lucenekmp/search/similarities/Similarity$SimScorer;", "norms", "Lorg/gnit/lucenekmp/index/NumericDocValues;", "<init>", "(Lorg/gnit/lucenekmp/search/DocIdSetIterator;Lorg/gnit/lucenekmp/search/DisjunctionDISIApproximation;Lorg/gnit/lucenekmp/search/ImpactsDISI;Lorg/gnit/lucenekmp/search/similarities/Similarity$SimScorer;Lorg/gnit/lucenekmp/index/NumericDocValues;)V", "maxScoreCache", "Lorg/gnit/lucenekmp/search/MaxScoreCache;", "docID", "", "freq", "", "score", "getMaxScore", "upTo", "advanceShallow", "target", "minScore", "minCompetitiveScore", "getMinCompetitiveScore", "()F", "setMinCompetitiveScore", "(F)V", "core"})
    private static final class SynonymScorer
    extends Scorer {
        @NotNull
        private final DocIdSetIterator iterator;
        @NotNull
        private final DisjunctionDISIApproximation disjunctionDisi;
        @NotNull
        private final ImpactsDISI impactsDisi;
        @NotNull
        private final Similarity.SimScorer scorer;
        @NotNull
        private final NumericDocValues norms;
        @NotNull
        private final MaxScoreCache maxScoreCache;

        public SynonymScorer(@NotNull DocIdSetIterator iterator2, @NotNull DisjunctionDISIApproximation disjunctionDisi, @NotNull ImpactsDISI impactsDisi, @NotNull Similarity.SimScorer scorer2, @NotNull NumericDocValues norms) {
            Intrinsics.checkNotNullParameter((Object)iterator2, (String)"iterator");
            Intrinsics.checkNotNullParameter((Object)disjunctionDisi, (String)"disjunctionDisi");
            Intrinsics.checkNotNullParameter((Object)impactsDisi, (String)"impactsDisi");
            Intrinsics.checkNotNullParameter((Object)scorer2, (String)"scorer");
            Intrinsics.checkNotNullParameter((Object)norms, (String)"norms");
            this.iterator = iterator2;
            this.disjunctionDisi = disjunctionDisi;
            this.impactsDisi = impactsDisi;
            this.scorer = scorer2;
            this.norms = norms;
            this.maxScoreCache = this.impactsDisi.getMaxScoreCache();
        }

        @Override
        public int docID() {
            return this.iterator.docID();
        }

        public final float freq() throws IOException {
            DisiWrapper disiWrapper = this.disjunctionDisi.topList();
            Intrinsics.checkNotNull((Object)disiWrapper, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.search.SynonymQuery.DisiWrapperFreq");
            DisiWrapperFreq w = (DisiWrapperFreq)disiWrapper;
            float freq = w.freq();
            DisiWrapper disiWrapper2 = w.getNext();
            Intrinsics.checkNotNull((Object)disiWrapper2, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.search.SynonymQuery.DisiWrapperFreq");
            w = (DisiWrapperFreq)disiWrapper2;
            while (true) {
                freq += w.freq();
                DisiWrapper disiWrapper3 = w.getNext();
                Intrinsics.checkNotNull((Object)disiWrapper3, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.search.SynonymQuery.DisiWrapperFreq");
                w = (DisiWrapperFreq)disiWrapper3;
            }
        }

        @Override
        public float score() throws IOException {
            long norm = 1L;
            if (this.norms != null && this.norms.advanceExact(this.iterator.docID())) {
                norm = this.norms.longValue();
            }
            return this.scorer.score(this.freq(), norm);
        }

        @Override
        @NotNull
        public DocIdSetIterator iterator() {
            return this.iterator;
        }

        @Override
        public float getMaxScore(int upTo) throws IOException {
            return this.maxScoreCache.getMaxScore(upTo);
        }

        @Override
        public int advanceShallow(int target) throws IOException {
            return this.maxScoreCache.advanceShallow(target);
        }

        @Override
        public float getMinCompetitiveScore() {
            throw new UnsupportedOperationException("minCompetitiveScore is not supported for SynonymScorer");
        }

        @Override
        public void setMinCompetitiveScore(float minScore) {
            this.impactsDisi.setMinCompetitiveScore(minScore);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0080\u0004\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0017H\u0016R\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/gnit/lucenekmp/search/SynonymQuery$SynonymWeight;", "Lorg/gnit/lucenekmp/search/Weight;", "query", "Lorg/gnit/lucenekmp/search/Query;", "searcher", "Lorg/gnit/lucenekmp/search/IndexSearcher;", "scoreMode", "Lorg/gnit/lucenekmp/search/ScoreMode;", "boost", "", "<init>", "(Lorg/gnit/lucenekmp/search/SynonymQuery;Lorg/gnit/lucenekmp/search/Query;Lorg/gnit/lucenekmp/search/IndexSearcher;Lorg/gnit/lucenekmp/search/ScoreMode;F)V", "termStates", "", "Lorg/gnit/lucenekmp/index/TermStates;", "[Lorg/gnit/lucenekmp/index/TermStates;", "similarity", "Lorg/gnit/lucenekmp/search/similarities/Similarity;", "simWeight", "Lorg/gnit/lucenekmp/search/similarities/Similarity$SimScorer;", "matches", "Lorg/gnit/lucenekmp/search/Matches;", "context", "Lorg/gnit/lucenekmp/index/LeafReaderContext;", "doc", "", "explain", "Lorg/gnit/lucenekmp/search/Explanation;", "scorerSupplier", "Lorg/gnit/lucenekmp/search/ScorerSupplier;", "isCacheable", "", "ctx", "core"})
    @SourceDebugExtension(value={"SMAP\nSynonymQuery.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SynonymQuery.kt\norg/gnit/lucenekmp/search/SynonymQuery$SynonymWeight\n+ 2 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 3 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,713:1\n3#2,8:714\n3#2,8:727\n10#3:722\n10#3:735\n11228#4:723\n11563#4,3:724\n*S KotlinDebug\n*F\n+ 1 SynonymQuery.kt\norg/gnit/lucenekmp/search/SynonymQuery$SynonymWeight\n*L\n178#1:714,8\n253#1:727,8\n178#1:722\n253#1:735\n219#1:723\n219#1:724,3\n*E\n"})
    public final class SynonymWeight
    extends Weight {
        @NotNull
        private final TermStates[] termStates;
        @NotNull
        private final Similarity similarity;
        @Nullable
        private final Similarity.SimScorer simWeight;
        @NotNull
        private final ScoreMode scoreMode;

        public SynonymWeight(@NotNull Query query, @NotNull IndexSearcher searcher, ScoreMode scoreMode, float boost) {
            Intrinsics.checkNotNullParameter((Object)query, (String)"query");
            Intrinsics.checkNotNullParameter((Object)searcher, (String)"searcher");
            Intrinsics.checkNotNullParameter((Object)((Object)scoreMode), (String)"scoreMode");
            super(query);
            boolean condition$iv = scoreMode.needsScores();
            boolean $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv) {
                boolean $i$a$-assert-AssertKt$assert$22 = false;
                String $i$a$-assert-AssertKt$assert$22 = "assertion failed";
                throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$22);
            }
            this.scoreMode = scoreMode;
            CollectionStatistics collectionStats = searcher.collectionStatistics(SynonymQuery.this.getField());
            long docFreq = 0L;
            long totalTermFreq = 0L;
            this.termStates = new TermStates[SynonymQuery.this.terms.length];
            int n = this.termStates.length;
            for (int i = 0; i < n; ++i) {
                TermStates ts;
                Term term = new Term(SynonymQuery.this.getField(), SynonymQuery.this.terms[i].getTerm());
                this.termStates[i] = ts = TermStates.Companion.build(searcher, term, true);
                if (ts.docFreq() <= 0) continue;
                TermStatistics termStats = searcher.termStatistics(term, ts.docFreq(), ts.totalTermFreq());
                docFreq = Math.max(termStats.getDocFreq(), docFreq);
                totalTermFreq += termStats.getTotalTermFreq();
            }
            this.similarity = searcher.getSimilarity();
            if (docFreq > 0L) {
                TermStatistics pseudoStats = new TermStatistics(new BytesRef("synonym pseudo-term"), docFreq, totalTermFreq);
                CollectionStatistics collectionStatistics = collectionStats;
                Intrinsics.checkNotNull((Object)collectionStatistics);
                TermStatistics[] termStatisticsArray = new TermStatistics[]{pseudoStats};
                this.simWeight = this.similarity.scorer(boost, collectionStatistics, termStatisticsArray);
            } else {
                this.simWeight = null;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Matches matches(@NotNull LeafReaderContext context, int doc) throws IOException {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Terms indexTerms = context.reader().terms(SynonymQuery.this.getField());
            if (indexTerms == null) {
                Matches matches2 = super.matches(context, doc);
                Intrinsics.checkNotNull((Object)matches2);
                return matches2;
            }
            TermAndBoost[] termAndBoostArray = SynonymQuery.this.terms;
            SynonymQuery synonymQuery = SynonymQuery.this;
            boolean $i$f$map = false;
            void var8_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void t;
                void item$iv$iv;
                void var14_13 = item$iv$iv = $this$mapTo$iv$iv[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new Term(synonymQuery.getField(), t.getTerm()));
            }
            List termList = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
            Matches matches3 = MatchesUtils.INSTANCE.forField(SynonymQuery.this.getField(), () -> SynonymWeight.matches$lambda$1(context, doc, this, SynonymQuery.this, termList));
            Intrinsics.checkNotNull((Object)matches3);
            return matches3;
        }

        @Override
        @NotNull
        public Explanation explain(@NotNull LeafReaderContext context, int doc) throws IOException {
            int newDoc;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Scorer scorer2 = this.scorer(context);
            if (scorer2 != null && (newDoc = scorer2.iterator().advance(doc)) == doc) {
                float freq = 0.0f;
                Scorer scorer3 = scorer2;
                if (scorer3 instanceof SynonymScorer) {
                    freq = ((SynonymScorer)scorer2).freq();
                } else if (scorer3 instanceof FreqBoostTermScorer) {
                    freq = ((FreqBoostTermScorer)scorer2).freq();
                } else {
                    boolean condition$iv = scorer2 instanceof TermScorer;
                    boolean $i$f$assert = false;
                    if (_Assertions.ENABLED && !condition$iv) {
                        boolean $i$a$-assert-AssertKt$assert$22 = false;
                        String $i$a$-assert-AssertKt$assert$22 = "assertion failed";
                        throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$22);
                    }
                    freq = ((TermScorer)scorer2).freq();
                }
                Explanation freqExplanation = Explanation.Companion.match((Number)Float.valueOf(freq), "termFreq=" + freq, new Explanation[0]);
                NumericDocValues norms = context.reader().getNormValues(SynonymQuery.this.getField());
                long norm = 1L;
                if (norms != null && norms.advanceExact(doc)) {
                    norm = norms.longValue();
                }
                Similarity.SimScorer simScorer = this.simWeight;
                Intrinsics.checkNotNull((Object)simScorer);
                Explanation scoreExplanation = simScorer.explain(freqExplanation, norm);
                Explanation[] explanationArray = new Explanation[]{scoreExplanation};
                return Explanation.Companion.match(scoreExplanation.getValue(), "weight(" + this.getQuery() + " in " + doc + ") [" + Reflection.getOrCreateKotlinClass(this.similarity.getClass()).getSimpleName() + "], result of:", explanationArray);
            }
            return Explanation.Companion.noMatch("no matching term", new Explanation[0]);
        }

        @Override
        @NotNull
        public ScorerSupplier scorerSupplier(@NotNull LeafReaderContext context) throws IOException {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            int n = 0;
            int n2 = SynonymQuery.this.terms.length;
            IOSupplier[] iOSupplierArray = new IOSupplier[n2];
            while (n < n2) {
                int n3 = n++;
                Intrinsics.checkNotNull(this.termStates[n3].get(context), (String)"null cannot be cast to non-null type org.gnit.lucenekmp.util.IOSupplier<org.gnit.lucenekmp.index.TermState>");
            }
            IOSupplier[] termStateSuppliers = iOSupplierArray;
            return new ScorerSupplier(SynonymQuery.this, termStateSuppliers, context, this){
                public List<PostingsEnum> iterators;
                public List<ImpactsEnum> impacts;
                public List<Float> termBoosts;
                private long cost;
                final /* synthetic */ SynonymQuery this$0;
                final /* synthetic */ IOSupplier<TermState>[] $termStateSuppliers;
                final /* synthetic */ LeafReaderContext $context;
                final /* synthetic */ SynonymWeight this$1;
                {
                    this.this$0 = $receiver;
                    this.$termStateSuppliers = $termStateSuppliers;
                    this.$context = $context;
                    this.this$1 = $receiver2;
                }

                public final List<PostingsEnum> getIterators() {
                    List<PostingsEnum> list = this.iterators;
                    if (list != null) {
                        return list;
                    }
                    Intrinsics.throwUninitializedPropertyAccessException((String)"iterators");
                    return null;
                }

                public final void setIterators(List<PostingsEnum> list) {
                    Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
                    this.iterators = list;
                }

                public final List<ImpactsEnum> getImpacts() {
                    List<ImpactsEnum> list = this.impacts;
                    if (list != null) {
                        return list;
                    }
                    Intrinsics.throwUninitializedPropertyAccessException((String)"impacts");
                    return null;
                }

                public final void setImpacts(List<ImpactsEnum> list) {
                    Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
                    this.impacts = list;
                }

                public final List<Float> getTermBoosts() {
                    List<Float> list = this.termBoosts;
                    if (list != null) {
                        return list;
                    }
                    Intrinsics.throwUninitializedPropertyAccessException((String)"termBoosts");
                    return null;
                }

                public final void setTermBoosts(List<Float> list) {
                    Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
                    this.termBoosts = list;
                }

                public final long getCost() {
                    return this.cost;
                }

                public final void setCost(long l) {
                    this.cost = l;
                }

                public final void init() throws IOException {
                    if (this.getIterators() != null) {
                        return;
                    }
                    this.setIterators((List<PostingsEnum>)new ArrayList<E>());
                    this.setImpacts((List<ImpactsEnum>)new ArrayList<E>());
                    this.setTermBoosts((List<Float>)new ArrayList<E>());
                    this.cost = 0L;
                    int n = SynonymQuery.access$getTerms$p(this.this$0).length;
                    for (int i = 0; i < n; ++i) {
                        TermState state2;
                        IOSupplier<TermState> supplier;
                        IOSupplier<TermState> iOSupplier = supplier = this.$termStateSuppliers[i];
                        TermState termState2 = state2 = iOSupplier == null ? null : iOSupplier.get();
                        if (state2 == null) continue;
                        Terms terms = this.$context.reader().terms(this.this$0.getField());
                        Intrinsics.checkNotNull((Object)terms);
                        TermsEnum termsEnum = terms.iterator();
                        termsEnum.seekExact(SynonymQuery.access$getTerms$p(this.this$0)[i].getTerm(), state2);
                        if (SynonymWeight.access$getScoreMode$p(this.this$1) == ScoreMode.TOP_SCORES) {
                            ImpactsEnum impactsEnum = termsEnum.impacts(PostingsEnum.Companion.getFREQS());
                            this.getIterators().add(impactsEnum);
                            v3 = this.getImpacts().add(impactsEnum);
                        } else {
                            PostingsEnum postingsEnum = termsEnum.postings(null, PostingsEnum.Companion.getFREQS());
                            this.getIterators().add(postingsEnum);
                            v3 = this.getImpacts().add(new SlowImpactsEnum(postingsEnum));
                        }
                        this.getTermBoosts().add(Float.valueOf(SynonymQuery.access$getTerms$p(this.this$0)[i].getBoost()));
                    }
                    for (PostingsEnum iterator2 : this.getIterators()) {
                        this.cost += iterator2.cost();
                    }
                }

                public Scorer get(long leadCost) throws IOException {
                    this.init();
                    if (this.getIterators().isEmpty()) {
                        return new ConstantScoreScorer(0.0f, SynonymWeight.access$getScoreMode$p(this.this$1), DocIdSetIterator.Companion.empty());
                    }
                    NumericDocValues numericDocValues = this.$context.reader().getNormValues(this.this$0.getField());
                    Intrinsics.checkNotNull((Object)numericDocValues);
                    NumericDocValues norms = numericDocValues;
                    if (this.getIterators().size() == 1) {
                        TermScorer termScorer;
                        if (SynonymWeight.access$getScoreMode$p(this.this$1) == ScoreMode.TOP_SCORES) {
                            PostingsEnum postingsEnum = this.getImpacts().get(0);
                            Similarity.SimScorer simScorer = SynonymWeight.access$getSimWeight$p(this.this$1);
                            Intrinsics.checkNotNull((Object)simScorer);
                            termScorer = new TermScorer(postingsEnum, simScorer, norms);
                        } else {
                            Similarity.SimScorer simScorer = SynonymWeight.access$getSimWeight$p(this.this$1);
                            Intrinsics.checkNotNull((Object)simScorer);
                            termScorer = new TermScorer(this.getIterators().get(0), simScorer, norms);
                        }
                        TermScorer scorer2 = termScorer;
                        float boost = ((Number)this.getTermBoosts().get(0)).floatValue();
                        return SynonymWeight.access$getScoreMode$p(this.this$1) == ScoreMode.COMPLETE_NO_SCORES || boost == 1.0f ? (Scorer)scorer2 : (Scorer)new FreqBoostTermScorer(boost, scorer2, SynonymWeight.access$getSimWeight$p(this.this$1), norms);
                    }
                    List wrappers = new ArrayList<E>();
                    int n = ((Collection)this.getIterators()).size();
                    for (int i = 0; i < n; ++i) {
                        PostingsEnum postings = this.getIterators().get(i);
                        Similarity.SimScorer simScorer = SynonymWeight.access$getSimWeight$p(this.this$1);
                        Intrinsics.checkNotNull((Object)simScorer);
                        TermScorer termScorer = new TermScorer(postings, simScorer, norms);
                        float boost = ((Number)this.getTermBoosts().get(i)).floatValue();
                        DisiWrapperFreq wrapper = new DisiWrapperFreq((Scorer)termScorer, boost);
                        wrappers.add(wrapper);
                    }
                    DisjunctionDISIApproximation disjunctionIterator = new DisjunctionDISIApproximation(wrappers, leadCost);
                    DocIdSetIterator iterator2 = disjunctionIterator;
                    float[] boosts = new float[this.getImpacts().size()];
                    int boost = boosts.length;
                    for (int i = 0; i < boost; ++i) {
                        boosts[i] = ((Number)this.getTermBoosts().get(i)).floatValue();
                    }
                    Collection $this$toTypedArray$iv = this.getImpacts();
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    ImpactsSource impactsSource2 = SynonymQuery.Companion.mergeImpacts(thisCollection$iv.toArray(new ImpactsEnum[0]), boosts);
                    Similarity.SimScorer simScorer = SynonymWeight.access$getSimWeight$p(this.this$1);
                    Intrinsics.checkNotNull((Object)simScorer);
                    MaxScoreCache maxScoreCache = new MaxScoreCache(impactsSource2, simScorer);
                    ImpactsDISI impactsDisi = new ImpactsDISI(iterator2, maxScoreCache);
                    if (SynonymWeight.access$getScoreMode$p(this.this$1) == ScoreMode.TOP_SCORES) {
                        iterator2 = impactsDisi;
                    }
                    return new SynonymScorer(iterator2, disjunctionIterator, impactsDisi, SynonymWeight.access$getSimWeight$p(this.this$1), norms);
                }

                public long cost() {
                    try {
                        this.init();
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                    return this.cost;
                }
            };
        }

        @Override
        public boolean isCacheable(@NotNull LeafReaderContext ctx) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            return true;
        }

        private static final MatchesIterator matches$lambda$1(LeafReaderContext $context, int $doc, SynonymWeight this$0, SynonymQuery this$1, List $termList) {
            MatchesIterator matchesIterator = DisjunctionMatchesIterator.Companion.fromTerms($context, $doc, this$0.getQuery(), this$1.getField(), $termList);
            Intrinsics.checkNotNull((Object)matchesIterator);
            return matchesIterator;
        }

        public static final /* synthetic */ ScoreMode access$getScoreMode$p(SynonymWeight $this) {
            return $this.scoreMode;
        }

        public static final /* synthetic */ Similarity.SimScorer access$getSimWeight$p(SynonymWeight $this) {
            return $this.simWeight;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/gnit/lucenekmp/search/SynonymQuery$TermAndBoost;", "", "term", "Lorg/gnit/lucenekmp/util/BytesRef;", "boost", "", "<init>", "(Lorg/gnit/lucenekmp/util/BytesRef;F)V", "getTerm", "()Lorg/gnit/lucenekmp/util/BytesRef;", "getBoost", "()F", "core"})
    private static final class TermAndBoost {
        @NotNull
        private final BytesRef term;
        private final float boost;

        public TermAndBoost(@NotNull BytesRef term, float boost) {
            Intrinsics.checkNotNullParameter((Object)term, (String)"term");
            this.term = term;
            this.boost = boost;
        }

        @NotNull
        public final BytesRef getTerm() {
            return this.term;
        }

        public final float getBoost() {
            return this.boost;
        }
    }
}

