/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.search;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.index.PostingsEnum;
import org.gnit.lucenekmp.search.MatchesIterator;
import org.gnit.lucenekmp.search.Query;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\tH\u0016J\b\u0010\u0010\u001a\u00020\tH\u0016J\b\u0010\u0011\u001a\u00020\tH\u0016J\b\u0010\u0012\u001a\u00020\tH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\u0013\u001a\u0004\u0018\u00010\u00018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lorg/gnit/lucenekmp/search/TermMatchesIterator;", "Lorg/gnit/lucenekmp/search/MatchesIterator;", "query", "Lorg/gnit/lucenekmp/search/Query;", "pe", "Lorg/gnit/lucenekmp/index/PostingsEnum;", "<init>", "(Lorg/gnit/lucenekmp/search/Query;Lorg/gnit/lucenekmp/index/PostingsEnum;)V", "upto", "", "pos", "getQuery", "()Lorg/gnit/lucenekmp/search/Query;", "next", "", "startPosition", "endPosition", "startOffset", "endOffset", "subMatches", "getSubMatches", "()Lorg/gnit/lucenekmp/search/MatchesIterator;", "core"})
public final class TermMatchesIterator
implements MatchesIterator {
    private int upto;
    private int pos;
    @NotNull
    private final PostingsEnum pe;
    @NotNull
    private final Query query;

    public TermMatchesIterator(@NotNull Query query, @NotNull PostingsEnum pe) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)pe, (String)"pe");
        this.pe = pe;
        this.query = query;
        this.upto = pe.freq();
    }

    @Override
    @NotNull
    public Query getQuery() {
        return this.query;
    }

    @Override
    public boolean next() throws IOException {
        int n = this.upto;
        this.upto = n + -1;
        if (n > 0) {
            this.pos = this.pe.nextPosition();
            return true;
        }
        return false;
    }

    @Override
    public int startPosition() {
        return this.pos;
    }

    @Override
    public int endPosition() {
        return this.pos;
    }

    @Override
    public int startOffset() throws IOException {
        return this.pe.startOffset();
    }

    @Override
    public int endOffset() throws IOException {
        return this.pe.endOffset();
    }

    @Override
    @Nullable
    public MatchesIterator getSubMatches() {
        return null;
    }
}

