/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.search;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.index.Term;
import org.gnit.lucenekmp.search.AutomatonQuery;
import org.gnit.lucenekmp.search.MultiTermQuery;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.automaton.Automata;
import org.gnit.lucenekmp.util.automaton.Automaton;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0006\u0010\u0011\u001a\u00020\bJ\u0006\u0010\u0012\u001a\u00020\bJ\u0012\u0010\u0013\u001a\u00020\u00032\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0013\u0010\u0016\u001a\u00020\b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0096\u0002R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/gnit/lucenekmp/search/TermRangeQuery;", "Lorg/gnit/lucenekmp/search/AutomatonQuery;", "field", "", "lowerTerm", "Lorg/gnit/lucenekmp/util/BytesRef;", "upperTerm", "includeLower", "", "includeUpper", "rewriteMethod", "Lorg/gnit/lucenekmp/search/MultiTermQuery$RewriteMethod;", "<init>", "(Ljava/lang/String;Lorg/gnit/lucenekmp/util/BytesRef;Lorg/gnit/lucenekmp/util/BytesRef;ZZLorg/gnit/lucenekmp/search/MultiTermQuery$RewriteMethod;)V", "getLowerTerm", "()Lorg/gnit/lucenekmp/util/BytesRef;", "getUpperTerm", "includesLower", "includesUpper", "toString", "hashCode", "", "equals", "obj", "", "Companion", "core"})
public final class TermRangeQuery
extends AutomatonQuery {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final BytesRef lowerTerm;
    @Nullable
    private final BytesRef upperTerm;
    private final boolean includeLower;
    private final boolean includeUpper;

    public TermRangeQuery(@NotNull String field, @NotNull BytesRef lowerTerm, @Nullable BytesRef upperTerm, boolean includeLower, boolean includeUpper, @NotNull MultiTermQuery.RewriteMethod rewriteMethod) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)lowerTerm, (String)"lowerTerm");
        Intrinsics.checkNotNullParameter((Object)rewriteMethod, (String)"rewriteMethod");
        super(new Term(field, lowerTerm), Companion.toAutomaton(lowerTerm, upperTerm, includeLower, includeUpper), true, rewriteMethod);
        this.lowerTerm = lowerTerm;
        this.upperTerm = upperTerm;
        this.includeLower = includeLower;
        this.includeUpper = includeUpper;
    }

    public /* synthetic */ TermRangeQuery(String string, BytesRef bytesRef, BytesRef bytesRef2, boolean bl, boolean bl2, MultiTermQuery.RewriteMethod rewriteMethod, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            rewriteMethod = MultiTermQuery.Companion.getCONSTANT_SCORE_BLENDED_REWRITE();
        }
        this(string, bytesRef, bytesRef2, bl, bl2, rewriteMethod);
    }

    @Nullable
    public final BytesRef getLowerTerm() {
        return this.lowerTerm;
    }

    @Nullable
    public final BytesRef getUpperTerm() {
        return this.upperTerm;
    }

    public final boolean includesLower() {
        return this.includeLower;
    }

    public final boolean includesUpper() {
        return this.includeUpper;
    }

    @Override
    @NotNull
    public String toString(@Nullable String field) {
        StringBuilder buffer = new StringBuilder();
        if (!Intrinsics.areEqual((Object)field, (Object)field)) {
            buffer.append(field);
            buffer.append(":");
        }
        buffer.append(this.includeLower ? (char)'[' : '{');
        buffer.append(this.lowerTerm != null ? (Intrinsics.areEqual((Object)"*", (Object)Term.Companion.toString(this.lowerTerm)) ? "\\*" : Term.Companion.toString(this.lowerTerm)) : "*");
        buffer.append(" TO ");
        buffer.append(this.upperTerm != null ? (Intrinsics.areEqual((Object)"*", (Object)Term.Companion.toString(this.upperTerm)) ? "\\*" : Term.Companion.toString(this.upperTerm)) : "*");
        buffer.append(this.includeUpper ? (char)']' : '}');
        String string = buffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = prime * result + (this.includeLower ? 1231 : 1237);
        result = prime * result + (this.includeUpper ? 1231 : 1237);
        result = prime * result + (this.lowerTerm == null ? 0 : this.lowerTerm.hashCode());
        result = prime * result + (this.upperTerm == null ? 0 : this.upperTerm.hashCode());
        return result;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        Class<?> clazz = this.getClass();
        Object object = obj;
        Intrinsics.checkNotNull((Object)object);
        if (clazz != object.getClass()) {
            return false;
        }
        TermRangeQuery other = (TermRangeQuery)obj;
        if (this.includeLower != other.includeLower) {
            return false;
        }
        if (this.includeUpper != other.includeUpper) {
            return false;
        }
        if (this.lowerTerm == null ? other.lowerTerm != null : !Intrinsics.areEqual((Object)this.lowerTerm, (Object)other.lowerTerm)) {
            return false;
        }
        return !(this.upperTerm == null ? other.upperTerm != null : !Intrinsics.areEqual((Object)this.upperTerm, (Object)other.upperTerm));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ<\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0006\u001a\u0004\u0018\u00010\u000f2\b\u0010\b\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u00a8\u0006\u0012"}, d2={"Lorg/gnit/lucenekmp/search/TermRangeQuery$Companion;", "", "<init>", "()V", "toAutomaton", "Lorg/gnit/lucenekmp/util/automaton/Automaton;", "lowerTerm", "Lorg/gnit/lucenekmp/util/BytesRef;", "upperTerm", "includeLower", "", "includeUpper", "newStringRange", "Lorg/gnit/lucenekmp/search/TermRangeQuery;", "field", "", "rewriteMethod", "Lorg/gnit/lucenekmp/search/MultiTermQuery$RewriteMethod;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Automaton toAutomaton(@Nullable BytesRef lowerTerm, @Nullable BytesRef upperTerm, boolean includeLower, boolean includeUpper) {
            boolean includeLower2 = includeLower;
            boolean includeUpper2 = includeUpper;
            if (lowerTerm == null) {
                includeLower2 = true;
            }
            if (upperTerm == null) {
                includeUpper2 = true;
            }
            return Automata.INSTANCE.makeBinaryInterval(lowerTerm, includeLower2, upperTerm, includeUpper2);
        }

        @NotNull
        public final TermRangeQuery newStringRange(@NotNull String field, @Nullable String lowerTerm, @Nullable String upperTerm, boolean includeLower, boolean includeUpper, @NotNull MultiTermQuery.RewriteMethod rewriteMethod) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            Intrinsics.checkNotNullParameter((Object)rewriteMethod, (String)"rewriteMethod");
            BytesRef lower = lowerTerm == null ? null : new BytesRef(lowerTerm);
            BytesRef upper = upperTerm == null ? null : new BytesRef(upperTerm);
            BytesRef bytesRef = lower;
            Intrinsics.checkNotNull((Object)bytesRef);
            return new TermRangeQuery(field, bytesRef, upper, includeLower, includeUpper, rewriteMethod);
        }

        public static /* synthetic */ TermRangeQuery newStringRange$default(Companion companion, String string, String string2, String string3, boolean bl, boolean bl2, MultiTermQuery.RewriteMethod rewriteMethod, int n, Object object) {
            if ((n & 0x20) != 0) {
                rewriteMethod = MultiTermQuery.Companion.getCONSTANT_SCORE_BLENDED_REWRITE();
            }
            return companion.newStringRange(string, string2, string3, bl, bl2, rewriteMethod);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

