/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.search;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.index.QueryTimeout;
import org.gnit.lucenekmp.search.BulkScorer;
import org.gnit.lucenekmp.search.LeafCollector;
import org.gnit.lucenekmp.util.Bits;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00132\u00020\u0001:\u0002\u0012\u0013B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J*\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\tH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/gnit/lucenekmp/search/TimeLimitingBulkScorer;", "Lorg/gnit/lucenekmp/search/BulkScorer;", "bulkScorer", "queryTimeout", "Lorg/gnit/lucenekmp/index/QueryTimeout;", "<init>", "(Lorg/gnit/lucenekmp/search/BulkScorer;Lorg/gnit/lucenekmp/index/QueryTimeout;)V", "in", "score", "", "collector", "Lorg/gnit/lucenekmp/search/LeafCollector;", "acceptDocs", "Lorg/gnit/lucenekmp/util/Bits;", "min", "max", "cost", "", "TimeExceededException", "Companion", "core"})
public final class TimeLimitingBulkScorer
extends BulkScorer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final QueryTimeout queryTimeout;
    @NotNull
    private final BulkScorer in;
    public static final int INTERVAL = 100;

    public TimeLimitingBulkScorer(@NotNull BulkScorer bulkScorer, @NotNull QueryTimeout queryTimeout) {
        Intrinsics.checkNotNullParameter((Object)bulkScorer, (String)"bulkScorer");
        Intrinsics.checkNotNullParameter((Object)queryTimeout, (String)"queryTimeout");
        this.queryTimeout = queryTimeout;
        this.in = bulkScorer;
    }

    @Override
    public int score(@NotNull LeafCollector collector2, @Nullable Bits acceptDocs, int min, int max) throws IOException {
        Intrinsics.checkNotNullParameter((Object)collector2, (String)"collector");
        int min2 = min;
        int interval = 100;
        while (min2 < max) {
            int newMax = (int)Math.min((long)min2 + (long)interval, (long)max);
            int newInterval = interval + (interval >> 1);
            if (interval < newInterval) {
                interval = newInterval;
            }
            if (this.queryTimeout.shouldExit()) {
                throw new TimeExceededException();
            }
            min2 = this.in.score(collector2, acceptDocs, min2, newMax);
        }
        return min2;
    }

    @Override
    public long cost() {
        return this.in.cost();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/gnit/lucenekmp/search/TimeLimitingBulkScorer$Companion;", "", "<init>", "()V", "INTERVAL", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0000\b\u0000\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/gnit/lucenekmp/search/TimeLimitingBulkScorer$TimeExceededException;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "<init>", "()V", "fillInStackTrace", "", "core"})
    public static final class TimeExceededException
    extends RuntimeException {
        public TimeExceededException() {
            super("TimeLimit Exceeded");
        }

        @Override
        @NotNull
        public final Throwable fillInStackTrace() {
            return this;
        }
    }
}

