/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.jdkport.Math;
import org.gnit.lucenekmp.search.FieldComparator;
import org.gnit.lucenekmp.search.FieldDoc;
import org.gnit.lucenekmp.search.Pruning;
import org.gnit.lucenekmp.search.ScoreDoc;
import org.gnit.lucenekmp.search.Sort;
import org.gnit.lucenekmp.search.SortField;
import org.gnit.lucenekmp.search.TopFieldDocs;
import org.gnit.lucenekmp.search.TotalHits;
import org.gnit.lucenekmp.util.PriorityQueue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0011\b\u0016\u0018\u0000 \u00162\u00020\u0001:\u0005\u0012\u0013\u0014\u0015\u0016B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\"\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0011\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0017"}, d2={"Lorg/gnit/lucenekmp/search/TopDocs;", "", "totalHits", "Lorg/gnit/lucenekmp/search/TotalHits;", "scoreDocs", "", "Lorg/gnit/lucenekmp/search/ScoreDoc;", "<init>", "(Lorg/gnit/lucenekmp/search/TotalHits;[Lorg/gnit/lucenekmp/search/ScoreDoc;)V", "getTotalHits", "()Lorg/gnit/lucenekmp/search/TotalHits;", "setTotalHits", "(Lorg/gnit/lucenekmp/search/TotalHits;)V", "getScoreDocs", "()[Lorg/gnit/lucenekmp/search/ScoreDoc;", "setScoreDocs", "([Lorg/gnit/lucenekmp/search/ScoreDoc;)V", "[Lorg/gnit/lucenekmp/search/ScoreDoc;", "ShardRef", "ScoreMergeSortQueue", "MergeSortQueue", "ShardIndexAndDoc", "Companion", "core"})
public class TopDocs {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private TotalHits totalHits;
    @NotNull
    private ScoreDoc[] scoreDocs;
    @NotNull
    private static final Comparator<ScoreDoc> SHARD_INDEX_TIE_BREAKER = TopDocs::SHARD_INDEX_TIE_BREAKER$lambda$0;
    @NotNull
    private static final Comparator<ScoreDoc> DOC_ID_TIE_BREAKER = TopDocs::DOC_ID_TIE_BREAKER$lambda$1;
    @NotNull
    private static final Comparator<ScoreDoc> DEFAULT_TIE_BREAKER = TopDocs::DEFAULT_TIE_BREAKER$lambda$2;

    public TopDocs(@NotNull TotalHits totalHits, @NotNull ScoreDoc[] scoreDocs) {
        Intrinsics.checkNotNullParameter((Object)totalHits, (String)"totalHits");
        Intrinsics.checkNotNullParameter((Object)scoreDocs, (String)"scoreDocs");
        this.totalHits = totalHits;
        this.scoreDocs = scoreDocs;
    }

    @NotNull
    public final TotalHits getTotalHits() {
        return this.totalHits;
    }

    public final void setTotalHits(@NotNull TotalHits totalHits) {
        Intrinsics.checkNotNullParameter((Object)totalHits, (String)"<set-?>");
        this.totalHits = totalHits;
    }

    @NotNull
    public final ScoreDoc[] getScoreDocs() {
        return this.scoreDocs;
    }

    public final void setScoreDocs(@NotNull ScoreDoc[] scoreDocArray) {
        Intrinsics.checkNotNullParameter((Object)scoreDocArray, (String)"<set-?>");
        this.scoreDocs = scoreDocArray;
    }

    private static final int SHARD_INDEX_TIE_BREAKER$lambda$0(ScoreDoc a, ScoreDoc b) {
        return Intrinsics.compare((int)a.getShardIndex(), (int)b.getShardIndex());
    }

    private static final int DOC_ID_TIE_BREAKER$lambda$1(ScoreDoc a, ScoreDoc b) {
        return Intrinsics.compare((int)a.getDoc(), (int)b.getDoc());
    }

    private static final int DEFAULT_TIE_BREAKER$lambda$2(ScoreDoc a, ScoreDoc b) {
        int result = SHARD_INDEX_TIE_BREAKER.compare(a, b);
        return result != 0 ? result : DOC_ID_TIE_BREAKER.compare(a, b);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J>\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00062\u0016\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u0007J!\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u0017\u00a2\u0006\u0002\u0010\u0018J)\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u0017\u00a2\u0006\u0002\u0010\u001aJA\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u00172\u0016\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u0007\u00a2\u0006\u0002\u0010\u001bJ)\u0010\u0012\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0017\u00a2\u0006\u0002\u0010\u001fJ1\u0010\u0012\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0017\u00a2\u0006\u0002\u0010 JI\u0010\u0012\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00172\u0016\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u0007\u00a2\u0006\u0002\u0010!JM\u0010\"\u001a\u00020\u00132\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0019\u001a\u00020\u00152\u0006\u0010#\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u00172\u0016\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u0007H\u0002\u00a2\u0006\u0002\u0010$J)\u0010%\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010&\u001a\u00020\u00152\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00130\u0017\u00a2\u0006\u0002\u0010\u001aR\u001e\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/gnit/lucenekmp/search/TopDocs$Companion;", "", "<init>", "()V", "SHARD_INDEX_TIE_BREAKER", "Ljava/util/Comparator;", "Lorg/gnit/lucenekmp/search/ScoreDoc;", "Lkotlin/Comparator;", "DOC_ID_TIE_BREAKER", "DEFAULT_TIE_BREAKER", "tieBreakLessThan", "", "first", "Lorg/gnit/lucenekmp/search/TopDocs$ShardRef;", "firstDoc", "second", "secondDoc", "tieBreaker", "merge", "Lorg/gnit/lucenekmp/search/TopDocs;", "topN", "", "shardHits", "", "(I[Lorg/gnit/lucenekmp/search/TopDocs;)Lorg/gnit/lucenekmp/search/TopDocs;", "start", "(II[Lorg/gnit/lucenekmp/search/TopDocs;)Lorg/gnit/lucenekmp/search/TopDocs;", "(II[Lorg/gnit/lucenekmp/search/TopDocs;Ljava/util/Comparator;)Lorg/gnit/lucenekmp/search/TopDocs;", "Lorg/gnit/lucenekmp/search/TopFieldDocs;", "sort", "Lorg/gnit/lucenekmp/search/Sort;", "(Lorg/gnit/lucenekmp/search/Sort;I[Lorg/gnit/lucenekmp/search/TopFieldDocs;)Lorg/gnit/lucenekmp/search/TopFieldDocs;", "(Lorg/gnit/lucenekmp/search/Sort;II[Lorg/gnit/lucenekmp/search/TopFieldDocs;)Lorg/gnit/lucenekmp/search/TopFieldDocs;", "(Lorg/gnit/lucenekmp/search/Sort;II[Lorg/gnit/lucenekmp/search/TopFieldDocs;Ljava/util/Comparator;)Lorg/gnit/lucenekmp/search/TopFieldDocs;", "mergeAux", "size", "(Lorg/gnit/lucenekmp/search/Sort;II[Lorg/gnit/lucenekmp/search/TopDocs;Ljava/util/Comparator;)Lorg/gnit/lucenekmp/search/TopDocs;", "rrf", "k", "hits", "core"})
    @SourceDebugExtension(value={"SMAP\nTopDocs.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TopDocs.kt\norg/gnit/lucenekmp/search/TopDocs$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,391:1\n1#2:392\n11228#3:393\n11563#3,3:394\n11228#3:401\n11563#3,3:402\n37#4:397\n36#4,3:398\n37#4:405\n36#4,3:406\n*S KotlinDebug\n*F\n+ 1 TopDocs.kt\norg/gnit/lucenekmp/search/TopDocs$Companion\n*L\n227#1:393\n227#1:394,3\n249#1:401\n249#1:402,3\n227#1:397\n227#1:398,3\n249#1:405\n249#1:406,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean tieBreakLessThan(@NotNull ShardRef first, @NotNull ScoreDoc firstDoc, @NotNull ShardRef second, @NotNull ScoreDoc secondDoc, @NotNull Comparator<ScoreDoc> tieBreaker) {
            Intrinsics.checkNotNullParameter((Object)first, (String)"first");
            Intrinsics.checkNotNullParameter((Object)firstDoc, (String)"firstDoc");
            Intrinsics.checkNotNullParameter((Object)second, (String)"second");
            Intrinsics.checkNotNullParameter((Object)secondDoc, (String)"secondDoc");
            Intrinsics.checkNotNullParameter(tieBreaker, (String)"tieBreaker");
            int value = tieBreaker.compare(firstDoc, secondDoc);
            if (value == 0) {
                if (!(first.getHitIndex() != second.getHitIndex())) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                return first.getHitIndex() < second.getHitIndex();
            }
            return value < 0;
        }

        @NotNull
        public final TopDocs merge(int topN, @NotNull TopDocs[] shardHits) {
            Intrinsics.checkNotNullParameter((Object)shardHits, (String)"shardHits");
            return this.merge(0, topN, shardHits);
        }

        @NotNull
        public final TopDocs merge(int start, int topN, @NotNull TopDocs[] shardHits) {
            Intrinsics.checkNotNullParameter((Object)shardHits, (String)"shardHits");
            return this.mergeAux(null, start, topN, shardHits, DEFAULT_TIE_BREAKER);
        }

        @NotNull
        public final TopDocs merge(int start, int topN, @NotNull TopDocs[] shardHits, @NotNull Comparator<ScoreDoc> tieBreaker) {
            Intrinsics.checkNotNullParameter((Object)shardHits, (String)"shardHits");
            Intrinsics.checkNotNullParameter(tieBreaker, (String)"tieBreaker");
            return this.mergeAux(null, start, topN, shardHits, tieBreaker);
        }

        @NotNull
        public final TopFieldDocs merge(@NotNull Sort sort2, int topN, @NotNull TopFieldDocs[] shardHits) {
            Intrinsics.checkNotNullParameter((Object)sort2, (String)"sort");
            Intrinsics.checkNotNullParameter((Object)shardHits, (String)"shardHits");
            return this.merge(sort2, 0, topN, shardHits);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final TopFieldDocs merge(@NotNull Sort sort2, int start, int topN, @NotNull TopFieldDocs[] shardHits) {
            void $this$toTypedArray$iv;
            Collection<TopDocs> collection;
            void $this$mapTo$iv$iv;
            Collection $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)sort2, (String)"sort");
            Intrinsics.checkNotNullParameter((Object)shardHits, (String)"shardHits");
            TopFieldDocs[] topFieldDocsArray = shardHits;
            int n = topN;
            int n2 = start;
            Sort sort3 = sort2;
            Companion companion = this;
            boolean $i$f$map = false;
            void var8_11 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            int n3 = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n3; ++i) {
                void it;
                void item$iv$iv;
                void var14_17 = item$iv$iv = $this$mapTo$iv$iv[i];
                collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.search.TopDocs");
                collection.add((TopDocs)it);
            }
            collection = (List)destination$iv$iv;
            $this$map$iv = collection;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            TopDocs topDocs = companion.mergeAux(sort3, n2, n, thisCollection$iv.toArray(new TopDocs[0]), DEFAULT_TIE_BREAKER);
            Intrinsics.checkNotNull((Object)topDocs, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.search.TopFieldDocs");
            return (TopFieldDocs)topDocs;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final TopFieldDocs merge(@NotNull Sort sort2, int start, int topN, @NotNull TopFieldDocs[] shardHits, @NotNull Comparator<ScoreDoc> tieBreaker) {
            void $this$toTypedArray$iv;
            Collection<TopDocs> collection;
            void $this$mapTo$iv$iv;
            Collection $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)sort2, (String)"sort");
            Intrinsics.checkNotNullParameter((Object)shardHits, (String)"shardHits");
            Intrinsics.checkNotNullParameter(tieBreaker, (String)"tieBreaker");
            TopFieldDocs[] topFieldDocsArray = shardHits;
            int n = topN;
            int n2 = start;
            Sort sort3 = sort2;
            Companion companion = this;
            boolean $i$f$map = false;
            void var9_12 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            int n3 = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n3; ++i) {
                void it;
                void item$iv$iv;
                void var15_18 = item$iv$iv = $this$mapTo$iv$iv[i];
                collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.search.TopDocs");
                collection.add((TopDocs)it);
            }
            collection = (List)destination$iv$iv;
            $this$map$iv = collection;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            TopDocs topDocs = companion.mergeAux(sort3, n2, n, thisCollection$iv.toArray(new TopDocs[0]), tieBreaker);
            Intrinsics.checkNotNull((Object)topDocs, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.search.TopFieldDocs");
            return (TopFieldDocs)topDocs;
        }

        private final TopDocs mergeAux(Sort sort2, int start, int size2, TopDocs[] shardHits, Comparator<ScoreDoc> tieBreaker) {
            PriorityQueue queue2 = sort2 == null ? (PriorityQueue)new ScoreMergeSortQueue(shardHits, tieBreaker) : (PriorityQueue)new MergeSortQueue(sort2, shardHits, tieBreaker);
            long totalHitCount = 0L;
            TotalHits.Relation totalHitsRelation = TotalHits.Relation.EQUAL_TO;
            int availHitCount = 0;
            int n = shardHits.length;
            for (int shardIDX = 0; shardIDX < n; ++shardIDX) {
                TopDocs shard = shardHits[shardIDX];
                totalHitCount += shard.getTotalHits().getValue();
                if (shard.getTotalHits().getRelation() == TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO) {
                    totalHitsRelation = TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO;
                }
                if (!(!(shard.getScoreDocs().length == 0))) continue;
                availHitCount += shard.getScoreDocs().length;
                queue2.add(new ShardRef(shardIDX));
            }
            ScoreDoc[] hits = null;
            boolean unsetShardIndex = false;
            if (availHitCount <= start) {
                hits = new ScoreDoc[]{};
            } else {
                hits = new ScoreDoc[java.lang.Math.min(size2, availHitCount - start)];
                int requestedResultWindow = start + size2;
                int numIterOnHits = java.lang.Math.min(availHitCount, requestedResultWindow);
                for (int hitUpto = 0; hitUpto < numIterOnHits; ++hitUpto) {
                    if (!(queue2.size() > 0)) {
                        String string = "Failed requirement.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    ShardRef ref = (ShardRef)queue2.top();
                    ScoreDoc[] scoreDocArray = shardHits[ref.getShardIndex()].getScoreDocs();
                    int n2 = ref.getHitIndex();
                    ref.setHitIndex(n2 + 1);
                    ScoreDoc hit = scoreDocArray[n2];
                    if (hitUpto > 0 && !(unsetShardIndex == (hit.getShardIndex() == -1))) {
                        boolean bl = false;
                        String string = "Inconsistent order of shard indices";
                        throw new IllegalArgumentException(string.toString());
                    }
                    unsetShardIndex |= hit.getShardIndex() == -1;
                    if (hitUpto >= start) {
                        hits[hitUpto - start] = hit;
                    }
                    ShardRef shardRef = ref.getHitIndex() < shardHits[ref.getShardIndex()].getScoreDocs().length ? (ShardRef)queue2.updateTop() : (ShardRef)queue2.pop();
                }
            }
            TotalHits totalHits = new TotalHits(totalHitCount, totalHitsRelation);
            return sort2 == null ? new TopDocs(totalHits, hits) : (TopDocs)new TopFieldDocs(totalHits, hits, sort2.getSort());
        }

        @NotNull
        public final TopDocs rrf(int topN, int k, @NotNull TopDocs[] hits) {
            int thisShardIndexSet;
            Intrinsics.checkNotNullParameter((Object)hits, (String)"hits");
            if (!(topN >= 1)) {
                boolean $i$a$-require-TopDocs$Companion$rrf$42 = false;
                String $i$a$-require-TopDocs$Companion$rrf$42 = "topN must be >= 1, got " + topN;
                throw new IllegalArgumentException($i$a$-require-TopDocs$Companion$rrf$42.toString());
            }
            if (!(k >= 1)) {
                boolean $i$a$-require-TopDocs$Companion$rrf$52 = false;
                String $i$a$-require-TopDocs$Companion$rrf$52 = "k must be >= 1, got " + k;
                throw new IllegalArgumentException($i$a$-require-TopDocs$Companion$rrf$52.toString());
            }
            Boolean shardIndexSet = null;
            int n = hits.length;
            for (int $i$a$-require-TopDocs$Companion$rrf$52 = 0; $i$a$-require-TopDocs$Companion$rrf$52 < n; ++$i$a$-require-TopDocs$Companion$rrf$52) {
                TopDocs topDocs = hits[$i$a$-require-TopDocs$Companion$rrf$52];
                for (ScoreDoc scoreDoc : topDocs.getScoreDocs()) {
                    int n2 = thisShardIndexSet = scoreDoc.getShardIndex() != -1 ? 1 : 0;
                    if (shardIndexSet == null) {
                        shardIndexSet = thisShardIndexSet != 0;
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)shardIndexSet, (Object)(thisShardIndexSet != 0))) continue;
                    boolean $i$a$-require-TopDocs$Companion$rrf$62 = false;
                    String $i$a$-require-TopDocs$Companion$rrf$62 = "All hits must either have their ScoreDoc#shardIndex set, or unset (-1), not a mix of both.";
                    throw new IllegalArgumentException($i$a$-require-TopDocs$Companion$rrf$62.toString());
                }
            }
            Map rrfScore = new LinkedHashMap();
            long totalHitCount = 0L;
            for (TopDocs topDoc : hits) {
                totalHitCount = java.lang.Math.max(totalHitCount, topDoc.getTotalHits().getValue());
                thisShardIndexSet = topDoc.getScoreDocs().length;
                for (int i = 0; i < thisShardIndexSet; ++i) {
                    ScoreDoc scoreDoc = topDoc.getScoreDocs()[i];
                    int rank = i + 1;
                    double rrfScoreContribution = 1.0 / (double)Math.INSTANCE.addExact(k, rank);
                    ShardIndexAndDoc key = new ShardIndexAndDoc(scoreDoc.getShardIndex(), scoreDoc.getDoc());
                    Double d = (Double)rrfScore.get(key);
                    double oldValue = d != null ? d : 0.0;
                    rrfScore.put(key, oldValue + rrfScoreContribution);
                }
            }
            List rrfScoreRank = CollectionsKt.toMutableList((Collection)rrfScore.entrySet());
            Comparator comparator2 = new Comparator(){

                public final int compare(T a, T b) {
                    Map.Entry it = (Map.Entry)b;
                    boolean bl = false;
                    Comparable comparable = (Comparable)it.getValue();
                    it = (Map.Entry)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)it.getValue()));
                }
            };
            comparator2 = new Comparator(comparator2){
                final /* synthetic */ Comparator $this_thenBy;
                {
                    this.$this_thenBy = $receiver;
                }

                public final int compare(T a, T b) {
                    int n;
                    int previousCompare = this.$this_thenBy.compare(a, b);
                    if (previousCompare != 0) {
                        n = previousCompare;
                    } else {
                        Map.Entry it = (Map.Entry)a;
                        boolean bl = false;
                        Comparable comparable = Integer.valueOf(((ShardIndexAndDoc)it.getKey()).getDoc());
                        it = (Map.Entry)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        n = ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(((ShardIndexAndDoc)it.getKey()).getDoc()));
                    }
                    return n;
                }
            };
            CollectionsKt.sortWith((List)rrfScoreRank, (Comparator)new Comparator(comparator2){
                final /* synthetic */ Comparator $this_thenBy;
                {
                    this.$this_thenBy = $receiver;
                }

                public final int compare(T a, T b) {
                    int n;
                    int previousCompare = this.$this_thenBy.compare(a, b);
                    if (previousCompare != 0) {
                        n = previousCompare;
                    } else {
                        Map.Entry it = (Map.Entry)a;
                        boolean bl = false;
                        Comparable comparable = Integer.valueOf(((ShardIndexAndDoc)it.getKey()).getShardIndex());
                        it = (Map.Entry)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        n = ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(((ShardIndexAndDoc)it.getKey()).getShardIndex()));
                    }
                    return n;
                }
            });
            ScoreDoc[] rrfScoreDocs = new ScoreDoc[java.lang.Math.min(topN, rrfScoreRank.size())];
            int n3 = rrfScoreDocs.length;
            for (int i = 0; i < n3; ++i) {
                Map.Entry entry = (Map.Entry)rrfScoreRank.get(i);
                int doc = ((ShardIndexAndDoc)entry.getKey()).getDoc();
                int shardIndex = ((ShardIndexAndDoc)entry.getKey()).getShardIndex();
                float score2 = (float)((Number)entry.getValue()).doubleValue();
                rrfScoreDocs[i] = new ScoreDoc(doc, score2, shardIndex);
            }
            TotalHits totalHits = new TotalHits(totalHitCount, TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO);
            return new TopDocs(totalHits, rrfScoreDocs);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B5\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0016\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n0\tj\b\u0012\u0004\u0012\u00020\n`\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00022\u0006\u0010\u001f\u001a\u00020\u0002H\u0016R!\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n0\tj\b\u0012\u0004\u0012\u00020\n`\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR!\u0010\u0005\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u00060\u0006\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0010\u0010\u0011R\u001f\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u00140\u0006\u00a2\u0006\n\n\u0002\u0010\u0017\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006 "}, d2={"Lorg/gnit/lucenekmp/search/TopDocs$MergeSortQueue;", "Lorg/gnit/lucenekmp/util/PriorityQueue;", "Lorg/gnit/lucenekmp/search/TopDocs$ShardRef;", "sort", "Lorg/gnit/lucenekmp/search/Sort;", "shardHits", "", "Lorg/gnit/lucenekmp/search/TopDocs;", "tieBreaker", "Ljava/util/Comparator;", "Lorg/gnit/lucenekmp/search/ScoreDoc;", "Lkotlin/Comparator;", "<init>", "(Lorg/gnit/lucenekmp/search/Sort;[Lorg/gnit/lucenekmp/search/TopDocs;Ljava/util/Comparator;)V", "getTieBreaker", "()Ljava/util/Comparator;", "getShardHits", "()[[Lorg/gnit/lucenekmp/search/ScoreDoc;", "[[Lorg/gnit/lucenekmp/search/ScoreDoc;", "comparators", "Lorg/gnit/lucenekmp/search/FieldComparator;", "getComparators", "()[Lorg/gnit/lucenekmp/search/FieldComparator;", "[Lorg/gnit/lucenekmp/search/FieldComparator;", "reverseMul", "", "getReverseMul", "()[I", "lessThan", "", "first", "second", "core"})
    @SourceDebugExtension(value={"SMAP\nTopDocs.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TopDocs.kt\norg/gnit/lucenekmp/search/TopDocs$MergeSortQueue\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,391:1\n1#2:392\n*E\n"})
    private static final class MergeSortQueue
    extends PriorityQueue<ShardRef> {
        @NotNull
        private final Comparator<ScoreDoc> tieBreaker;
        @NotNull
        private final ScoreDoc[][] shardHits;
        @NotNull
        private final FieldComparator<?>[] comparators;
        @NotNull
        private final int[] reverseMul;

        public MergeSortQueue(@NotNull Sort sort2, @NotNull TopDocs[] shardHits, @NotNull Comparator<ScoreDoc> tieBreaker) {
            Intrinsics.checkNotNullParameter((Object)sort2, (String)"sort");
            Intrinsics.checkNotNullParameter((Object)shardHits, (String)"shardHits");
            Intrinsics.checkNotNullParameter(tieBreaker, (String)"tieBreaker");
            super(shardHits.length, null, 2, null);
            this.tieBreaker = tieBreaker;
            this.shardHits = new ScoreDoc[shardHits.length][];
            int n = shardHits.length;
            for (int shardIDX = 0; shardIDX < n; ++shardIDX) {
                ScoreDoc[] shard = shardHits[shardIDX].getScoreDocs();
                this.shardHits[shardIDX] = shard;
                for (ScoreDoc sd : shard) {
                    if (!(sd instanceof FieldDoc)) {
                        boolean bl = false;
                        String string = "shard " + shardIDX + " was not sorted by the provided Sort (expected FieldDoc but got ScoreDoc)";
                        throw new IllegalArgumentException(string.toString());
                    }
                    FieldDoc fd = (FieldDoc)sd;
                    if (fd.getFields() != null) continue;
                    boolean bl = false;
                    String string = "shard " + shardIDX + " did not set sort field values (FieldDoc.fields is null)";
                    throw new IllegalArgumentException(string.toString());
                }
            }
            SortField[] sortFields = sort2.getSort();
            this.comparators = new FieldComparator[sortFields.length];
            this.reverseMul = new int[sortFields.length];
            for (SortField sortField : sortFields) {
                this.comparators[compIDX] = sortField.getComparator(1, Pruning.NONE);
                this.reverseMul[compIDX] = sortField.getReverse() ? -1 : 1;
            }
        }

        @NotNull
        public final Comparator<ScoreDoc> getTieBreaker() {
            return this.tieBreaker;
        }

        @NotNull
        public final ScoreDoc[][] getShardHits() {
            return this.shardHits;
        }

        @NotNull
        public final FieldComparator<?>[] getComparators() {
            return this.comparators;
        }

        @NotNull
        public final int[] getReverseMul() {
            return this.reverseMul;
        }

        @Override
        public boolean lessThan(@NotNull ShardRef first, @NotNull ShardRef second) {
            Intrinsics.checkNotNullParameter((Object)first, (String)"first");
            Intrinsics.checkNotNullParameter((Object)second, (String)"second");
            if (!(!Intrinsics.areEqual((Object)first, (Object)second))) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            ScoreDoc[] scoreDocArray = this.shardHits[first.getShardIndex()];
            Intrinsics.checkNotNull((Object)scoreDocArray);
            ScoreDoc scoreDoc = scoreDocArray[first.getHitIndex()];
            Intrinsics.checkNotNull((Object)scoreDoc, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.search.FieldDoc");
            FieldDoc firstFD = (FieldDoc)scoreDoc;
            ScoreDoc[] scoreDocArray2 = this.shardHits[second.getShardIndex()];
            Intrinsics.checkNotNull((Object)scoreDocArray2);
            ScoreDoc scoreDoc2 = scoreDocArray2[second.getHitIndex()];
            Intrinsics.checkNotNull((Object)scoreDoc2, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.search.FieldDoc");
            FieldDoc secondFD = (FieldDoc)scoreDoc2;
            int n = this.comparators.length;
            for (int compIDX = 0; compIDX < n; ++compIDX) {
                FieldComparator<?> comp;
                Intrinsics.checkNotNull(this.comparators[compIDX]);
                int n2 = this.reverseMul[compIDX];
                Object[] objectArray = firstFD.getFields();
                Intrinsics.checkNotNull((Object)objectArray);
                Object object = objectArray[compIDX];
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.search.FieldComparator<kotlin.Any?>");
                FieldComparator fieldComparator = (FieldComparator)object;
                Object[] objectArray2 = secondFD.getFields();
                Intrinsics.checkNotNull((Object)objectArray2);
                Object object2 = objectArray2[compIDX];
                Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.search.FieldComparator<kotlin.Any?>");
                int cmp = n2 * comp.compareValues(fieldComparator, (FieldComparator)object2);
                if (cmp == 0) continue;
                return cmp < 0;
            }
            return Companion.tieBreakLessThan(first, firstFD, second, secondFD, this.tieBreaker);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B-\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0016\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0002H\u0016R!\u0010\u0003\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00040\u0004\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\rR!\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0015"}, d2={"Lorg/gnit/lucenekmp/search/TopDocs$ScoreMergeSortQueue;", "Lorg/gnit/lucenekmp/util/PriorityQueue;", "Lorg/gnit/lucenekmp/search/TopDocs$ShardRef;", "shardHits", "", "Lorg/gnit/lucenekmp/search/TopDocs;", "tieBreakerComparator", "Ljava/util/Comparator;", "Lorg/gnit/lucenekmp/search/ScoreDoc;", "Lkotlin/Comparator;", "<init>", "([Lorg/gnit/lucenekmp/search/TopDocs;Ljava/util/Comparator;)V", "getShardHits", "()[[Lorg/gnit/lucenekmp/search/ScoreDoc;", "[[Lorg/gnit/lucenekmp/search/ScoreDoc;", "getTieBreakerComparator", "()Ljava/util/Comparator;", "lessThan", "", "first", "second", "core"})
    private static final class ScoreMergeSortQueue
    extends PriorityQueue<ShardRef> {
        @NotNull
        private final ScoreDoc[][] shardHits;
        @NotNull
        private final Comparator<ScoreDoc> tieBreakerComparator;

        public ScoreMergeSortQueue(@NotNull TopDocs[] shardHits, @NotNull Comparator<ScoreDoc> tieBreakerComparator) {
            Intrinsics.checkNotNullParameter((Object)shardHits, (String)"shardHits");
            Intrinsics.checkNotNullParameter(tieBreakerComparator, (String)"tieBreakerComparator");
            super(shardHits.length, null, 2, null);
            this.shardHits = new ScoreDoc[shardHits.length][];
            int n = shardHits.length;
            for (int shardIDX = 0; shardIDX < n; ++shardIDX) {
                this.shardHits[shardIDX] = shardHits[shardIDX].getScoreDocs();
            }
            this.tieBreakerComparator = tieBreakerComparator;
        }

        @NotNull
        public final ScoreDoc[][] getShardHits() {
            return this.shardHits;
        }

        @NotNull
        public final Comparator<ScoreDoc> getTieBreakerComparator() {
            return this.tieBreakerComparator;
        }

        @Override
        public boolean lessThan(@NotNull ShardRef first, @NotNull ShardRef second) {
            Intrinsics.checkNotNullParameter((Object)first, (String)"first");
            Intrinsics.checkNotNullParameter((Object)second, (String)"second");
            if (!(!Intrinsics.areEqual((Object)first, (Object)second))) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            ScoreDoc[] scoreDocArray = this.shardHits[first.getShardIndex()];
            Intrinsics.checkNotNull((Object)scoreDocArray);
            ScoreDoc firstScoreDoc = scoreDocArray[first.getHitIndex()];
            ScoreDoc[] scoreDocArray2 = this.shardHits[second.getShardIndex()];
            Intrinsics.checkNotNull((Object)scoreDocArray2);
            ScoreDoc secondScoreDoc = scoreDocArray2[second.getHitIndex()];
            if (firstScoreDoc.getScore() < secondScoreDoc.getScore()) {
                return false;
            }
            if (firstScoreDoc.getScore() > secondScoreDoc.getScore()) {
                return true;
            }
            return Companion.tieBreakLessThan(first, firstScoreDoc, second, secondScoreDoc, this.tieBreakerComparator);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Lorg/gnit/lucenekmp/search/TopDocs$ShardIndexAndDoc;", "", "shardIndex", "", "doc", "<init>", "(II)V", "getShardIndex", "()I", "getDoc", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "core"})
    private static final class ShardIndexAndDoc {
        private final int shardIndex;
        private final int doc;

        public ShardIndexAndDoc(int shardIndex, int doc) {
            this.shardIndex = shardIndex;
            this.doc = doc;
        }

        public final int getShardIndex() {
            return this.shardIndex;
        }

        public final int getDoc() {
            return this.doc;
        }

        public final int component1() {
            return this.shardIndex;
        }

        public final int component2() {
            return this.doc;
        }

        @NotNull
        public final ShardIndexAndDoc copy(int shardIndex, int doc) {
            return new ShardIndexAndDoc(shardIndex, doc);
        }

        public static /* synthetic */ ShardIndexAndDoc copy$default(ShardIndexAndDoc shardIndexAndDoc, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = shardIndexAndDoc.shardIndex;
            }
            if ((n3 & 2) != 0) {
                n2 = shardIndexAndDoc.doc;
            }
            return shardIndexAndDoc.copy(n, n2);
        }

        @NotNull
        public String toString() {
            return "ShardIndexAndDoc(shardIndex=" + this.shardIndex + ", doc=" + this.doc + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.shardIndex);
            result = result * 31 + Integer.hashCode(this.doc);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ShardIndexAndDoc)) {
                return false;
            }
            ShardIndexAndDoc shardIndexAndDoc = (ShardIndexAndDoc)other;
            if (this.shardIndex != shardIndexAndDoc.shardIndex) {
                return false;
            }
            return this.doc == shardIndexAndDoc.doc;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000b\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\u0007\"\u0004\b\n\u0010\u0005\u00a8\u0006\r"}, d2={"Lorg/gnit/lucenekmp/search/TopDocs$ShardRef;", "", "shardIndex", "", "<init>", "(I)V", "getShardIndex", "()I", "hitIndex", "getHitIndex", "setHitIndex", "toString", "", "core"})
    public static final class ShardRef {
        private final int shardIndex;
        private int hitIndex;

        public ShardRef(int shardIndex) {
            this.shardIndex = shardIndex;
        }

        public final int getShardIndex() {
            return this.shardIndex;
        }

        public final int getHitIndex() {
            return this.hitIndex;
        }

        public final void setHitIndex(int n) {
            this.hitIndex = n;
        }

        @NotNull
        public String toString() {
            return "ShardRef(shardIndex=" + this.shardIndex + " hitIndex=" + this.hitIndex + ")";
        }
    }
}

