/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.index.LeafReaderContext;
import org.gnit.lucenekmp.index.ReaderUtil;
import org.gnit.lucenekmp.jdkport.Objects;
import org.gnit.lucenekmp.search.CollectionTerminatedException;
import org.gnit.lucenekmp.search.DocIdSetIterator;
import org.gnit.lucenekmp.search.DocIdStream;
import org.gnit.lucenekmp.search.FieldComparator;
import org.gnit.lucenekmp.search.FieldDoc;
import org.gnit.lucenekmp.search.FieldValueHitQueue;
import org.gnit.lucenekmp.search.IndexSearcher;
import org.gnit.lucenekmp.search.LeafCollector;
import org.gnit.lucenekmp.search.LeafFieldComparator;
import org.gnit.lucenekmp.search.MaxScoreAccumulator;
import org.gnit.lucenekmp.search.MultiLeafFieldComparator;
import org.gnit.lucenekmp.search.Query;
import org.gnit.lucenekmp.search.Scorable;
import org.gnit.lucenekmp.search.ScoreCachingWrappingScorer;
import org.gnit.lucenekmp.search.ScoreDoc;
import org.gnit.lucenekmp.search.ScoreMode;
import org.gnit.lucenekmp.search.Scorer;
import org.gnit.lucenekmp.search.ScorerSupplier;
import org.gnit.lucenekmp.search.Sort;
import org.gnit.lucenekmp.search.SortField;
import org.gnit.lucenekmp.search.TopDocs;
import org.gnit.lucenekmp.search.TopDocsCollector;
import org.gnit.lucenekmp.search.TopFieldDocs;
import org.gnit.lucenekmp.search.TotalHits;
import org.gnit.lucenekmp.search.Weight;
import org.gnit.lucenekmp.util.PriorityQueue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0007\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u0000 S2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0004PQRSB9\b\u0002\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\b\u00106\u001a\u000207H\u0016J\u0010\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=H\u0004J\u0010\u0010>\u001a\u00020;2\u0006\u0010<\u001a\u00020=H\u0004J\u0016\u0010?\u001a\u00020;2\u0006\u0010@\u001a\u00020\u00062\u0006\u0010A\u001a\u00020\u0006J\u000e\u0010B\u001a\u00020;2\u0006\u0010A\u001a\u00020\u0006J#\u0010C\u001a\u00020;2\f\u0010D\u001a\b\u0012\u0004\u0012\u00020F0E2\u0006\u0010G\u001a\u00020\u0006H\u0014\u00a2\u0006\u0002\u0010HJ%\u0010I\u001a\u00020J2\u000e\u0010D\u001a\n\u0012\u0004\u0012\u00020F\u0018\u00010E2\u0006\u0010K\u001a\u00020\u0006H\u0014\u00a2\u0006\u0002\u0010LJ\b\u0010M\u001a\u00020NH\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR\u0015\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0011R\u001e\u0010\u0019\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001e\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u0011\u0010'\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u000fR\u001c\u0010)\u001a\u0004\u0018\u00010\u0002X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\u001a\u0010.\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010\u0011\"\u0004\b0\u00101R\u001a\u00102\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u0010\u000f\"\u0004\b4\u00105R\u0011\u00106\u001a\u000207\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u00109R\u0011\u0010O\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\bO\u0010\u0011\u00a8\u0006T"}, d2={"Lorg/gnit/lucenekmp/search/TopFieldCollector;", "Lorg/gnit/lucenekmp/search/TopDocsCollector;", "Lorg/gnit/lucenekmp/search/FieldValueHitQueue$Entry;", "pq", "Lorg/gnit/lucenekmp/search/FieldValueHitQueue;", "numHits", "", "totalHitsThreshold", "needsScores", "", "minScoreAcc", "Lorg/gnit/lucenekmp/search/MaxScoreAccumulator;", "<init>", "(Lorg/gnit/lucenekmp/search/FieldValueHitQueue;IIZLorg/gnit/lucenekmp/search/MaxScoreAccumulator;)V", "getNumHits", "()I", "getNeedsScores", "()Z", "getTotalHitsThreshold", "firstComparator", "Lorg/gnit/lucenekmp/search/FieldComparator;", "getFirstComparator", "()Lorg/gnit/lucenekmp/search/FieldComparator;", "canSetMinScore", "getCanSetMinScore", "searchSortPartOfIndexSort", "getSearchSortPartOfIndexSort", "()Ljava/lang/Boolean;", "setSearchSortPartOfIndexSort", "(Ljava/lang/Boolean;)V", "Ljava/lang/Boolean;", "getMinScoreAcc", "()Lorg/gnit/lucenekmp/search/MaxScoreAccumulator;", "minCompetitiveScore", "", "getMinCompetitiveScore", "()F", "setMinCompetitiveScore", "(F)V", "numComparators", "getNumComparators", "bottom", "getBottom", "()Lorg/gnit/lucenekmp/search/FieldValueHitQueue$Entry;", "setBottom", "(Lorg/gnit/lucenekmp/search/FieldValueHitQueue$Entry;)V", "queueFull", "getQueueFull", "setQueueFull", "(Z)V", "docBase", "getDocBase", "setDocBase", "(I)V", "scoreMode", "Lorg/gnit/lucenekmp/search/ScoreMode;", "getScoreMode", "()Lorg/gnit/lucenekmp/search/ScoreMode;", "updateGlobalMinCompetitiveScore", "", "scorer", "Lorg/gnit/lucenekmp/search/Scorable;", "updateMinCompetitiveScore", "add", "slot", "doc", "updateBottom", "populateResults", "results", "", "Lorg/gnit/lucenekmp/search/ScoreDoc;", "howMany", "([Lorg/gnit/lucenekmp/search/ScoreDoc;I)V", "newTopDocs", "Lorg/gnit/lucenekmp/search/TopDocs;", "start", "([Lorg/gnit/lucenekmp/search/ScoreDoc;I)Lorg/gnit/lucenekmp/search/TopDocs;", "topDocs", "Lorg/gnit/lucenekmp/search/TopFieldDocs;", "isEarlyTerminated", "TopFieldLeafCollector", "SimpleFieldCollector", "PagingFieldCollector", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nTopFieldCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TopFieldCollector.kt\norg/gnit/lucenekmp/search/TopFieldCollector\n+ 2 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 3 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n*L\n1#1,471:1\n3#2,8:472\n10#3:480\n*S KotlinDebug\n*F\n+ 1 TopFieldCollector.kt\norg/gnit/lucenekmp/search/TopFieldCollector\n*L\n344#1:472,8\n344#1:480\n*E\n"})
public abstract class TopFieldCollector
extends TopDocsCollector<FieldValueHitQueue.Entry> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int numHits;
    private final boolean needsScores;
    private final int totalHitsThreshold;
    @NotNull
    private final FieldComparator<?> firstComparator;
    private final boolean canSetMinScore;
    @Nullable
    private Boolean searchSortPartOfIndexSort;
    @Nullable
    private final MaxScoreAccumulator minScoreAcc;
    private float minCompetitiveScore;
    private final int numComparators;
    @Nullable
    private FieldValueHitQueue.Entry bottom;
    private boolean queueFull;
    private int docBase;
    @NotNull
    private final ScoreMode scoreMode;
    @NotNull
    private static final ScoreDoc[] EMPTY_SCOREDOCS = new ScoreDoc[0];

    private TopFieldCollector(FieldValueHitQueue<FieldValueHitQueue.Entry> pq2, int numHits, int totalHitsThreshold, boolean needsScores, MaxScoreAccumulator minScoreAcc) {
        super(pq2);
        this.numHits = numHits;
        this.needsScores = needsScores;
        this.totalHitsThreshold = Math.max(totalHitsThreshold, this.numHits);
        this.numComparators = pq2.getComparators().length;
        this.firstComparator = pq2.getComparators()[0];
        int reverseMul = pq2.getReverseMul()[0];
        if (this.firstComparator.getClass() == FieldComparator.RelevanceComparator.class && reverseMul == 1 && totalHitsThreshold != Integer.MAX_VALUE) {
            this.scoreMode = ScoreMode.TOP_SCORES;
            this.canSetMinScore = true;
        } else {
            this.canSetMinScore = false;
            this.scoreMode = totalHitsThreshold != Integer.MAX_VALUE ? (this.needsScores ? ScoreMode.TOP_DOCS_WITH_SCORES : ScoreMode.TOP_DOCS) : (this.needsScores ? ScoreMode.COMPLETE : ScoreMode.COMPLETE_NO_SCORES);
        }
        this.minScoreAcc = minScoreAcc;
    }

    public final int getNumHits() {
        return this.numHits;
    }

    public final boolean getNeedsScores() {
        return this.needsScores;
    }

    public final int getTotalHitsThreshold() {
        return this.totalHitsThreshold;
    }

    @NotNull
    public final FieldComparator<?> getFirstComparator() {
        return this.firstComparator;
    }

    public final boolean getCanSetMinScore() {
        return this.canSetMinScore;
    }

    @Nullable
    public final Boolean getSearchSortPartOfIndexSort() {
        return this.searchSortPartOfIndexSort;
    }

    public final void setSearchSortPartOfIndexSort(@Nullable Boolean bl) {
        this.searchSortPartOfIndexSort = bl;
    }

    @Nullable
    public final MaxScoreAccumulator getMinScoreAcc() {
        return this.minScoreAcc;
    }

    public final float getMinCompetitiveScore() {
        return this.minCompetitiveScore;
    }

    public final void setMinCompetitiveScore(float f) {
        this.minCompetitiveScore = f;
    }

    public final int getNumComparators() {
        return this.numComparators;
    }

    @Nullable
    public final FieldValueHitQueue.Entry getBottom() {
        return this.bottom;
    }

    public final void setBottom(@Nullable FieldValueHitQueue.Entry entry) {
        this.bottom = entry;
    }

    public final boolean getQueueFull() {
        return this.queueFull;
    }

    public final void setQueueFull(boolean bl) {
        this.queueFull = bl;
    }

    public final int getDocBase() {
        return this.docBase;
    }

    public final void setDocBase(int n) {
        this.docBase = n;
    }

    @NotNull
    public final ScoreMode getScoreMode() {
        return this.scoreMode;
    }

    @Override
    @NotNull
    public ScoreMode scoreMode() {
        return this.scoreMode;
    }

    protected final void updateGlobalMinCompetitiveScore(@NotNull Scorable scorer2) throws IOException {
        Intrinsics.checkNotNullParameter((Object)scorer2, (String)"scorer");
        if (this.minScoreAcc == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        if (this.canSetMinScore) {
            long maxMinScore = this.minScoreAcc.getRaw();
            float score2 = MaxScoreAccumulator.Companion.toScore(maxMinScore);
            if (maxMinScore != Long.MIN_VALUE && score2 > this.minCompetitiveScore) {
                scorer2.setMinCompetitiveScore(score2);
                this.minCompetitiveScore = score2;
                this.setTotalHitsRelation(TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO);
            }
        }
    }

    protected final void updateMinCompetitiveScore(@NotNull Scorable scorer2) throws IOException {
        Intrinsics.checkNotNullParameter((Object)scorer2, (String)"scorer");
        if (this.canSetMinScore && this.queueFull && this.getTotalHits() > this.totalHitsThreshold) {
            if (this.bottom == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            FieldValueHitQueue.Entry entry = this.bottom;
            Intrinsics.checkNotNull((Object)entry);
            Object obj = this.firstComparator.value(entry.getSlot());
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type kotlin.Float");
            float minScore = ((Float)obj).floatValue();
            if (minScore > this.minCompetitiveScore) {
                scorer2.setMinCompetitiveScore(minScore);
                this.minCompetitiveScore = minScore;
                this.setTotalHitsRelation(TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO);
                if (this.minScoreAcc != null) {
                    this.minScoreAcc.accumulate(this.docBase, minScore);
                }
            }
        }
    }

    public final void add(int slot, int doc) {
        this.bottom = this.getPq().add(new FieldValueHitQueue.Entry(slot, this.docBase + doc));
        boolean condition$iv = slot < this.numHits;
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "assertion failed";
            throw new AssertionError((Object)string);
        }
        this.queueFull = slot == this.numHits - 1;
    }

    public final void updateBottom(int doc) {
        FieldValueHitQueue.Entry entry = this.bottom;
        Intrinsics.checkNotNull((Object)entry);
        entry.setDoc(this.docBase + doc);
        this.bottom = (FieldValueHitQueue.Entry)this.getPq().updateTop();
    }

    @Override
    protected void populateResults(@NotNull ScoreDoc[] results2, int howMany) {
        Intrinsics.checkNotNullParameter((Object)results2, (String)"results");
        PriorityQueue priorityQueue = this.getPq();
        Intrinsics.checkNotNull(priorityQueue, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.search.FieldValueHitQueue<org.gnit.lucenekmp.search.FieldValueHitQueue.Entry>");
        FieldValueHitQueue queue2 = (FieldValueHitQueue)priorityQueue;
        for (int i = howMany - 1; -1 < i; --i) {
            Object t = queue2.pop();
            Intrinsics.checkNotNull(t);
            results2[i] = queue2.fillFields((FieldValueHitQueue.Entry)t);
        }
    }

    @Override
    @NotNull
    protected TopDocs newTopDocs(@Nullable ScoreDoc[] results2, int start) {
        ScoreDoc[] results3 = results2;
        if (results3 == null) {
            results3 = EMPTY_SCOREDOCS;
        }
        TotalHits totalHits = new TotalHits(this.getTotalHits(), this.getTotalHitsRelation());
        PriorityQueue priorityQueue = this.getPq();
        Intrinsics.checkNotNull(priorityQueue, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.search.FieldValueHitQueue<org.gnit.lucenekmp.search.FieldValueHitQueue.Entry>");
        return new TopFieldDocs(totalHits, results3, ((FieldValueHitQueue)priorityQueue).getFields());
    }

    @Override
    @NotNull
    public TopFieldDocs topDocs() {
        TopDocs topDocs = super.topDocs();
        Intrinsics.checkNotNull((Object)topDocs, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.search.TopFieldDocs");
        return (TopFieldDocs)topDocs;
    }

    public final boolean isEarlyTerminated() {
        return this.getTotalHitsRelation() == TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO;
    }

    public /* synthetic */ TopFieldCollector(FieldValueHitQueue pq2, int numHits, int totalHitsThreshold, boolean needsScores, MaxScoreAccumulator minScoreAcc, DefaultConstructorMarker $constructor_marker) {
        this(pq2, numHits, totalHitsThreshold, needsScores, minScoreAcc);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002J)\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0002\u0010\u0016R\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000e\u00a8\u0006\u0017"}, d2={"Lorg/gnit/lucenekmp/search/TopFieldCollector$Companion;", "", "<init>", "()V", "canEarlyTerminate", "", "searchSort", "Lorg/gnit/lucenekmp/search/Sort;", "indexSort", "canEarlyTerminateOnDocId", "canEarlyTerminateOnPrefix", "EMPTY_SCOREDOCS", "", "Lorg/gnit/lucenekmp/search/ScoreDoc;", "[Lorg/gnit/lucenekmp/search/ScoreDoc;", "populateScores", "", "topDocs", "searcher", "Lorg/gnit/lucenekmp/search/IndexSearcher;", "query", "Lorg/gnit/lucenekmp/search/Query;", "([Lorg/gnit/lucenekmp/search/ScoreDoc;Lorg/gnit/lucenekmp/search/IndexSearcher;Lorg/gnit/lucenekmp/search/Query;)V", "core"})
    @SourceDebugExtension(value={"SMAP\nTopFieldCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TopFieldCollector.kt\norg/gnit/lucenekmp/search/TopFieldCollector$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 4 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n*L\n1#1,471:1\n1#2:472\n3#3,8:473\n10#4:481\n*S KotlinDebug\n*F\n+ 1 TopFieldCollector.kt\norg/gnit/lucenekmp/search/TopFieldCollector$Companion\n*L\n463#1:473,8\n463#1:481\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean canEarlyTerminate(@NotNull Sort searchSort, @NotNull Sort indexSort) {
            Intrinsics.checkNotNullParameter((Object)searchSort, (String)"searchSort");
            Intrinsics.checkNotNullParameter((Object)indexSort, (String)"indexSort");
            return this.canEarlyTerminateOnDocId(searchSort) || this.canEarlyTerminateOnPrefix(searchSort, indexSort);
        }

        private final boolean canEarlyTerminateOnDocId(Sort searchSort) {
            SortField[] fields1 = searchSort.getSort();
            return Intrinsics.areEqual((Object)SortField.Companion.getFIELD_DOC(), (Object)fields1[0]);
        }

        private final boolean canEarlyTerminateOnPrefix(Sort searchSort, Sort indexSort) {
            if (indexSort != null) {
                Object[] fields2;
                Object[] fields1 = searchSort.getSort();
                if (fields1.length > (fields2 = indexSort.getSort()).length) {
                    return false;
                }
                return Intrinsics.areEqual((Object)ArraysKt.toList((Object[])fields1), ArraysKt.toList((Object[])fields2).subList(0, fields1.length));
            }
            return false;
        }

        public final void populateScores(@NotNull ScoreDoc[] topDocs, @NotNull IndexSearcher searcher, @NotNull Query query) throws IOException {
            Object[] topDocs2;
            Intrinsics.checkNotNullParameter((Object)topDocs, (String)"topDocs");
            Intrinsics.checkNotNullParameter((Object)searcher, (String)"searcher");
            Intrinsics.checkNotNullParameter((Object)query, (String)"query");
            Object[] objectArray = topDocs2 = topDocs;
            ScoreDoc[] scoreDocArray = Arrays.copyOf(objectArray, objectArray.length);
            Intrinsics.checkNotNullExpressionValue((Object)scoreDocArray, (String)"copyOf(...)");
            topDocs2 = scoreDocArray;
            ArraysKt.sortWith((Object[])topDocs2, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    ScoreDoc it = (ScoreDoc)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getDoc());
                    it = (ScoreDoc)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getDoc()));
                }
            });
            Weight weight = searcher.createWeight(searcher.rewrite(query), ScoreMode.COMPLETE, 1.0f);
            List<LeafReaderContext> contexts = searcher.getIndexReader().leaves();
            LeafReaderContext currentContext = null;
            Scorer currentScorer = null;
            for (Object scoreDoc : topDocs2) {
                int leafDoc;
                if (currentContext == null || ((ScoreDoc)scoreDoc).getDoc() >= currentContext.getDocBase() + currentContext.reader().maxDoc()) {
                    Objects.INSTANCE.checkIndex(((ScoreDoc)scoreDoc).getDoc(), searcher.getIndexReader().maxDoc());
                    int newContextIndex = ReaderUtil.INSTANCE.subIndex(((ScoreDoc)scoreDoc).getDoc(), contexts);
                    currentContext = contexts.get(newContextIndex);
                    ScorerSupplier scorerSupplier2 = weight.scorerSupplier(currentContext);
                    if (scorerSupplier2 == null) {
                        boolean bl = false;
                        String string = "Doc id " + ((ScoreDoc)scoreDoc).getDoc() + " doesn't match the query";
                        throw new IllegalArgumentException(string.toString());
                    }
                    currentScorer = scorerSupplier2.get(1L);
                }
                boolean condition$iv = (leafDoc = ((ScoreDoc)scoreDoc).getDoc() - currentContext.getDocBase()) >= 0;
                boolean $i$f$assert = false;
                if (_Assertions.ENABLED && !condition$iv) {
                    boolean bl = false;
                    String string = "assertion failed";
                    throw new AssertionError((Object)string);
                }
                Scorer scorer2 = currentScorer;
                Intrinsics.checkNotNull(scorer2);
                int advanced = scorer2.iterator().advance(leafDoc);
                if (!(leafDoc == advanced)) {
                    boolean bl = false;
                    String string = "Doc id " + ((ScoreDoc)scoreDoc).getDoc() + " doesn't match the query";
                    throw new IllegalArgumentException(string.toString());
                }
                ((ScoreDoc)scoreDoc).setScore(currentScorer.score());
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 \u00a8\u0006%"}, d2={"Lorg/gnit/lucenekmp/search/TopFieldCollector$PagingFieldCollector;", "Lorg/gnit/lucenekmp/search/TopFieldCollector;", "sort", "Lorg/gnit/lucenekmp/search/Sort;", "queue", "Lorg/gnit/lucenekmp/search/FieldValueHitQueue;", "Lorg/gnit/lucenekmp/search/FieldValueHitQueue$Entry;", "after", "Lorg/gnit/lucenekmp/search/FieldDoc;", "numHits", "", "totalHitsThreshold", "minScoreAcc", "Lorg/gnit/lucenekmp/search/MaxScoreAccumulator;", "<init>", "(Lorg/gnit/lucenekmp/search/Sort;Lorg/gnit/lucenekmp/search/FieldValueHitQueue;Lorg/gnit/lucenekmp/search/FieldDoc;IILorg/gnit/lucenekmp/search/MaxScoreAccumulator;)V", "getSort", "()Lorg/gnit/lucenekmp/search/Sort;", "getQueue", "()Lorg/gnit/lucenekmp/search/FieldValueHitQueue;", "getAfter", "()Lorg/gnit/lucenekmp/search/FieldDoc;", "weight", "Lorg/gnit/lucenekmp/search/Weight;", "getWeight", "()Lorg/gnit/lucenekmp/search/Weight;", "setWeight", "(Lorg/gnit/lucenekmp/search/Weight;)V", "collectedHits", "getCollectedHits", "()I", "setCollectedHits", "(I)V", "getLeafCollector", "Lorg/gnit/lucenekmp/search/LeafCollector;", "context", "Lorg/gnit/lucenekmp/index/LeafReaderContext;", "core"})
    public static final class PagingFieldCollector
    extends TopFieldCollector {
        @NotNull
        private final Sort sort;
        @NotNull
        private final FieldValueHitQueue<FieldValueHitQueue.Entry> queue;
        @NotNull
        private final FieldDoc after;
        @Nullable
        private Weight weight;
        private int collectedHits;

        public PagingFieldCollector(@NotNull Sort sort2, @NotNull FieldValueHitQueue<FieldValueHitQueue.Entry> queue2, @NotNull FieldDoc after, int numHits, int totalHitsThreshold, @Nullable MaxScoreAccumulator minScoreAcc) {
            Intrinsics.checkNotNullParameter((Object)sort2, (String)"sort");
            Intrinsics.checkNotNullParameter(queue2, (String)"queue");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            super(queue2, numHits, totalHitsThreshold, sort2.needsScores(), minScoreAcc, null);
            this.sort = sort2;
            this.queue = queue2;
            this.after = after;
            FieldComparator<?>[] comparators = this.queue.getComparators();
            int n = comparators.length;
            for (int i = 0; i < n; ++i) {
                FieldComparator<?> comparator2 = comparators[i];
                Object[] objectArray = this.after.getFields();
                Intrinsics.checkNotNull((Object)objectArray);
                Object object = objectArray[i];
                Intrinsics.checkNotNull((Object)object);
                comparator2.setTopValue(object);
            }
        }

        @NotNull
        public final Sort getSort() {
            return this.sort;
        }

        @NotNull
        public final FieldValueHitQueue<FieldValueHitQueue.Entry> getQueue() {
            return this.queue;
        }

        @NotNull
        public final FieldDoc getAfter() {
            return this.after;
        }

        @Override
        @Nullable
        public Weight getWeight() {
            return this.weight;
        }

        @Override
        public void setWeight(@Nullable Weight weight) {
            this.weight = weight;
        }

        public final int getCollectedHits() {
            return this.collectedHits;
        }

        public final void setCollectedHits(int n) {
            this.collectedHits = n;
        }

        @Override
        @NotNull
        public LeafCollector getLeafCollector(@NotNull LeafReaderContext context) throws IOException {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            this.setMinCompetitiveScore(0.0f);
            this.setDocBase(context.getDocBase());
            int afterDoc = this.after.getDoc() - this.getDocBase();
            FieldValueHitQueue<FieldValueHitQueue.Entry> fieldValueHitQueue = this.queue;
            Sort sort2 = this.sort;
            LeafCollector collector2 = new TopFieldLeafCollector(this, context, afterDoc, fieldValueHitQueue, sort2){
                final /* synthetic */ PagingFieldCollector this$0;
                final /* synthetic */ int $afterDoc;
                {
                    this.this$0 = $receiver;
                    this.$afterDoc = $afterDoc;
                    super($super_call_param$1, $super_call_param$2, $context);
                }

                public void collect(int doc) throws IOException {
                    this.countHit(doc);
                    if (this.this$0.getQueueFull() && this.thresholdCheck(doc)) {
                        return;
                    }
                    int topCmp = this.getReverseMul() * this.getComparator().compareTop(doc);
                    if (topCmp > 0 || topCmp == 0 && doc <= this.$afterDoc) {
                        if (this.this$0.getTotalHitsRelation() == TotalHits.Relation.EQUAL_TO) {
                            Scorable scorable = this.getScorer();
                            Intrinsics.checkNotNull((Object)scorable);
                            this.this$0.updateMinCompetitiveScore(scorable);
                        }
                        return;
                    }
                    if (this.this$0.getQueueFull()) {
                        this.collectCompetitiveHit(doc);
                    } else {
                        int n = this.this$0.getCollectedHits();
                        this.this$0.setCollectedHits(n + 1);
                        this.collectAnyHit(doc, this.this$0.getCollectedHits());
                    }
                }
            };
            if (this.getNeedsScores()) {
                collector2 = ScoreCachingWrappingScorer.Companion.wrap(collector2);
            }
            return collector2;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001c"}, d2={"Lorg/gnit/lucenekmp/search/TopFieldCollector$SimpleFieldCollector;", "Lorg/gnit/lucenekmp/search/TopFieldCollector;", "sort", "Lorg/gnit/lucenekmp/search/Sort;", "queue", "Lorg/gnit/lucenekmp/search/FieldValueHitQueue;", "Lorg/gnit/lucenekmp/search/FieldValueHitQueue$Entry;", "numHits", "", "totalHitsThreshold", "minScoreAcc", "Lorg/gnit/lucenekmp/search/MaxScoreAccumulator;", "<init>", "(Lorg/gnit/lucenekmp/search/Sort;Lorg/gnit/lucenekmp/search/FieldValueHitQueue;IILorg/gnit/lucenekmp/search/MaxScoreAccumulator;)V", "getSort", "()Lorg/gnit/lucenekmp/search/Sort;", "getQueue", "()Lorg/gnit/lucenekmp/search/FieldValueHitQueue;", "weight", "Lorg/gnit/lucenekmp/search/Weight;", "getWeight", "()Lorg/gnit/lucenekmp/search/Weight;", "setWeight", "(Lorg/gnit/lucenekmp/search/Weight;)V", "getLeafCollector", "Lorg/gnit/lucenekmp/search/LeafCollector;", "context", "Lorg/gnit/lucenekmp/index/LeafReaderContext;", "core"})
    public static final class SimpleFieldCollector
    extends TopFieldCollector {
        @NotNull
        private final Sort sort;
        @NotNull
        private final FieldValueHitQueue<FieldValueHitQueue.Entry> queue;
        @Nullable
        private Weight weight;

        public SimpleFieldCollector(@NotNull Sort sort2, @NotNull FieldValueHitQueue<FieldValueHitQueue.Entry> queue2, int numHits, int totalHitsThreshold, @Nullable MaxScoreAccumulator minScoreAcc) {
            Intrinsics.checkNotNullParameter((Object)sort2, (String)"sort");
            Intrinsics.checkNotNullParameter(queue2, (String)"queue");
            super(queue2, numHits, totalHitsThreshold, sort2.needsScores(), minScoreAcc, null);
            this.sort = sort2;
            this.queue = queue2;
        }

        @NotNull
        public final Sort getSort() {
            return this.sort;
        }

        @NotNull
        public final FieldValueHitQueue<FieldValueHitQueue.Entry> getQueue() {
            return this.queue;
        }

        @Override
        @Nullable
        public Weight getWeight() {
            return this.weight;
        }

        @Override
        public void setWeight(@Nullable Weight weight) {
            this.weight = weight;
        }

        @Override
        @NotNull
        public LeafCollector getLeafCollector(@NotNull LeafReaderContext context) throws IOException {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            this.setMinCompetitiveScore(0.0f);
            this.setDocBase(context.getDocBase());
            FieldValueHitQueue<FieldValueHitQueue.Entry> fieldValueHitQueue = this.queue;
            Sort sort2 = this.sort;
            LeafCollector collector2 = new TopFieldLeafCollector(this, context, fieldValueHitQueue, sort2){
                final /* synthetic */ SimpleFieldCollector this$0;
                {
                    this.this$0 = $receiver;
                    super($super_call_param$1, $super_call_param$2, $context);
                }

                public void collect(int doc) throws IOException {
                    this.countHit(doc);
                    if (this.this$0.getQueueFull()) {
                        if (this.thresholdCheck(doc)) {
                            return;
                        }
                        this.collectCompetitiveHit(doc);
                    } else {
                        this.collectAnyHit(doc, this.this$0.getTotalHits());
                    }
                }
            };
            if (this.getNeedsScores()) {
                collector2 = ScoreCachingWrappingScorer.Companion.wrap(collector2);
            }
            return collector2;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u00a2\u0004\u0018\u00002\u00020\u0001B%\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0010J\u000e\u0010\"\u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\u0010J\u000e\u0010#\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0010J\u0016\u0010$\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00102\u0006\u0010%\u001a\u00020\u0010J\n\u0010&\u001a\u0004\u0018\u00010'H\u0016R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R(\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001e\u00a8\u0006("}, d2={"Lorg/gnit/lucenekmp/search/TopFieldCollector$TopFieldLeafCollector;", "Lorg/gnit/lucenekmp/search/LeafCollector;", "queue", "Lorg/gnit/lucenekmp/search/FieldValueHitQueue;", "Lorg/gnit/lucenekmp/search/FieldValueHitQueue$Entry;", "sort", "Lorg/gnit/lucenekmp/search/Sort;", "context", "Lorg/gnit/lucenekmp/index/LeafReaderContext;", "<init>", "(Lorg/gnit/lucenekmp/search/TopFieldCollector;Lorg/gnit/lucenekmp/search/FieldValueHitQueue;Lorg/gnit/lucenekmp/search/Sort;Lorg/gnit/lucenekmp/index/LeafReaderContext;)V", "comparator", "Lorg/gnit/lucenekmp/search/LeafFieldComparator;", "getComparator", "()Lorg/gnit/lucenekmp/search/LeafFieldComparator;", "reverseMul", "", "getReverseMul", "()I", "scorer", "Lorg/gnit/lucenekmp/search/Scorable;", "getScorer", "()Lorg/gnit/lucenekmp/search/Scorable;", "setScorer", "(Lorg/gnit/lucenekmp/search/Scorable;)V", "collectedAllCompetitiveHits", "", "getCollectedAllCompetitiveHits", "()Z", "setCollectedAllCompetitiveHits", "(Z)V", "countHit", "", "doc", "thresholdCheck", "collectCompetitiveHit", "collectAnyHit", "hitsCollected", "competitiveIterator", "Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "core"})
    private abstract class TopFieldLeafCollector
    implements LeafCollector {
        @NotNull
        private final LeafFieldComparator comparator;
        private final int reverseMul;
        @Nullable
        private Scorable scorer;
        private boolean collectedAllCompetitiveHits;

        public TopFieldLeafCollector(@NotNull FieldValueHitQueue<FieldValueHitQueue.Entry> queue2, @NotNull Sort sort2, LeafReaderContext context) {
            Intrinsics.checkNotNullParameter(queue2, (String)"queue");
            Intrinsics.checkNotNullParameter((Object)sort2, (String)"sort");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (TopFieldCollector.this.getSearchSortPartOfIndexSort() == null) {
                Sort indexSort = context.reader().getMetaData().getSort();
                TopFieldCollector.this.setSearchSortPartOfIndexSort(indexSort != null ? Boolean.valueOf(Companion.canEarlyTerminate(sort2, indexSort)) : Boolean.valueOf(false));
                if (Intrinsics.areEqual((Object)TopFieldCollector.this.getSearchSortPartOfIndexSort(), (Object)true)) {
                    TopFieldCollector.this.getFirstComparator().disableSkipping();
                }
            }
            LeafFieldComparator[] comparators = queue2.getComparators(context);
            int[] reverseMuls = queue2.getReverseMul();
            if (comparators.length == 1) {
                this.reverseMul = reverseMuls[0];
                this.comparator = comparators[0];
            } else {
                this.reverseMul = 1;
                this.comparator = new MultiLeafFieldComparator(comparators, reverseMuls);
            }
        }

        @NotNull
        public final LeafFieldComparator getComparator() {
            return this.comparator;
        }

        public final int getReverseMul() {
            return this.reverseMul;
        }

        @Override
        @Nullable
        public Scorable getScorer() {
            return this.scorer;
        }

        @Override
        public void setScorer(@Nullable Scorable scorer2) {
            this.scorer = scorer2;
            Scorable scorable = scorer2;
            Intrinsics.checkNotNull((Object)scorable);
            this.comparator.setScorer(scorable);
            if (TopFieldCollector.this.getMinScoreAcc() == null) {
                TopFieldCollector.this.updateMinCompetitiveScore(scorer2);
            } else {
                TopFieldCollector.this.updateGlobalMinCompetitiveScore(scorer2);
            }
        }

        public final boolean getCollectedAllCompetitiveHits() {
            return this.collectedAllCompetitiveHits;
        }

        public final void setCollectedAllCompetitiveHits(boolean bl) {
            this.collectedAllCompetitiveHits = bl;
        }

        public final void countHit(int doc) throws IOException {
            TopFieldCollector.this.setTotalHits(TopFieldCollector.this.getTotalHits() + 1);
            int hitCountSoFar = TopFieldCollector.this.getTotalHits();
            if (TopFieldCollector.this.getMinScoreAcc() != null && ((long)hitCountSoFar & TopFieldCollector.this.getMinScoreAcc().getModInterval()) == 0L) {
                Scorable scorable = this.getScorer();
                Intrinsics.checkNotNull((Object)scorable);
                TopFieldCollector.this.updateGlobalMinCompetitiveScore(scorable);
            }
            if (!TopFieldCollector.this.getScoreMode().isExhaustive() && TopFieldCollector.this.getTotalHitsRelation() == TotalHits.Relation.EQUAL_TO && TopFieldCollector.this.getTotalHits() > TopFieldCollector.this.getTotalHitsThreshold()) {
                this.comparator.setHitsThresholdReached();
                TopFieldCollector.this.setTotalHitsRelation(TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO);
            }
        }

        public final boolean thresholdCheck(int doc) throws IOException {
            if (this.collectedAllCompetitiveHits || this.reverseMul * this.comparator.compareBottom(doc) <= 0) {
                Boolean bl = TopFieldCollector.this.getSearchSortPartOfIndexSort();
                Intrinsics.checkNotNull((Object)bl);
                if (bl.booleanValue()) {
                    if (TopFieldCollector.this.getTotalHits() > TopFieldCollector.this.getTotalHitsThreshold()) {
                        TopFieldCollector.this.setTotalHitsRelation(TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO);
                        throw new CollectionTerminatedException();
                    }
                    this.collectedAllCompetitiveHits = true;
                } else if (TopFieldCollector.this.getTotalHitsRelation() == TotalHits.Relation.EQUAL_TO) {
                    Scorable scorable = this.getScorer();
                    Intrinsics.checkNotNull((Object)scorable);
                    TopFieldCollector.this.updateMinCompetitiveScore(scorable);
                }
                return true;
            }
            return false;
        }

        public final void collectCompetitiveHit(int doc) throws IOException {
            FieldValueHitQueue.Entry entry = TopFieldCollector.this.getBottom();
            Intrinsics.checkNotNull((Object)entry);
            this.comparator.copy(entry.getSlot(), doc);
            TopFieldCollector.this.updateBottom(doc);
            FieldValueHitQueue.Entry entry2 = TopFieldCollector.this.getBottom();
            Intrinsics.checkNotNull((Object)entry2);
            this.comparator.setBottom(entry2.getSlot());
            Scorable scorable = this.getScorer();
            Intrinsics.checkNotNull((Object)scorable);
            TopFieldCollector.this.updateMinCompetitiveScore(scorable);
        }

        public final void collectAnyHit(int doc, int hitsCollected) throws IOException {
            int slot = hitsCollected - 1;
            this.comparator.copy(slot, doc);
            TopFieldCollector.this.add(slot, doc);
            if (TopFieldCollector.this.getQueueFull()) {
                FieldValueHitQueue.Entry entry = TopFieldCollector.this.getBottom();
                Intrinsics.checkNotNull((Object)entry);
                this.comparator.setBottom(entry.getSlot());
                Scorable scorable = this.getScorer();
                Intrinsics.checkNotNull((Object)scorable);
                TopFieldCollector.this.updateMinCompetitiveScore(scorable);
            }
        }

        @Override
        @Nullable
        public DocIdSetIterator competitiveIterator() throws IOException {
            return this.comparator.competitiveIterator();
        }

        @Override
        public void collect(@NotNull DocIdStream stream) throws IOException {
            LeafCollector.super.collect(stream);
        }

        @Override
        public void finish() throws IOException {
            LeafCollector.super.finish();
        }
    }
}

