/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.search;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.index.LeafReaderContext;
import org.gnit.lucenekmp.jdkport.Math;
import org.gnit.lucenekmp.search.DocIdSetIterator;
import org.gnit.lucenekmp.search.DocIdStream;
import org.gnit.lucenekmp.search.HitQueue;
import org.gnit.lucenekmp.search.LeafCollector;
import org.gnit.lucenekmp.search.MaxScoreAccumulator;
import org.gnit.lucenekmp.search.Scorable;
import org.gnit.lucenekmp.search.ScoreDoc;
import org.gnit.lucenekmp.search.ScoreMode;
import org.gnit.lucenekmp.search.TopDocs;
import org.gnit.lucenekmp.search.TopDocsCollector;
import org.gnit.lucenekmp.search.TotalHits;
import org.gnit.lucenekmp.search.Weight;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B-\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0015\u001a\u00020\u0004H\u0014J%\u0010\u0016\u001a\u00020\u00172\u000e\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u0004H\u0014\u00a2\u0006\u0002\u0010\u001bJ\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006\""}, d2={"Lorg/gnit/lucenekmp/search/TopScoreDocCollector;", "Lorg/gnit/lucenekmp/search/TopDocsCollector;", "Lorg/gnit/lucenekmp/search/ScoreDoc;", "numHits", "", "after", "totalHitsThreshold", "minScoreAcc", "Lorg/gnit/lucenekmp/search/MaxScoreAccumulator;", "<init>", "(ILorg/gnit/lucenekmp/search/ScoreDoc;ILorg/gnit/lucenekmp/search/MaxScoreAccumulator;)V", "getTotalHitsThreshold", "()I", "getMinScoreAcc", "()Lorg/gnit/lucenekmp/search/MaxScoreAccumulator;", "weight", "Lorg/gnit/lucenekmp/search/Weight;", "getWeight", "()Lorg/gnit/lucenekmp/search/Weight;", "setWeight", "(Lorg/gnit/lucenekmp/search/Weight;)V", "topDocsSize", "newTopDocs", "Lorg/gnit/lucenekmp/search/TopDocs;", "results", "", "start", "([Lorg/gnit/lucenekmp/search/ScoreDoc;I)Lorg/gnit/lucenekmp/search/TopDocs;", "scoreMode", "Lorg/gnit/lucenekmp/search/ScoreMode;", "getLeafCollector", "Lorg/gnit/lucenekmp/search/LeafCollector;", "context", "Lorg/gnit/lucenekmp/index/LeafReaderContext;", "core"})
@SourceDebugExtension(value={"SMAP\nTopScoreDocCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TopScoreDocCollector.kt\norg/gnit/lucenekmp/search/TopScoreDocCollector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,180:1\n1869#2,2:181\n*S KotlinDebug\n*F\n+ 1 TopScoreDocCollector.kt\norg/gnit/lucenekmp/search/TopScoreDocCollector\n*L\n35#1:181,2\n*E\n"})
public final class TopScoreDocCollector
extends TopDocsCollector<ScoreDoc> {
    @Nullable
    private final ScoreDoc after;
    private final int totalHitsThreshold;
    @Nullable
    private final MaxScoreAccumulator minScoreAcc;
    @Nullable
    private Weight weight;

    public TopScoreDocCollector(int numHits, @Nullable ScoreDoc after, int totalHitsThreshold, @Nullable MaxScoreAccumulator minScoreAcc) {
        super(new HitQueue(numHits, true));
        this.after = after;
        this.totalHitsThreshold = totalHitsThreshold;
        this.minScoreAcc = minScoreAcc;
    }

    public final int getTotalHitsThreshold() {
        return this.totalHitsThreshold;
    }

    @Nullable
    public final MaxScoreAccumulator getMinScoreAcc() {
        return this.minScoreAcc;
    }

    @Override
    @Nullable
    public Weight getWeight() {
        return this.weight;
    }

    @Override
    public void setWeight(@Nullable Weight weight) {
        this.weight = weight;
    }

    @Override
    protected int topDocsSize() {
        int[] validTopHitCount = new int[1];
        Iterable $this$forEach$iv = this.getPq();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ScoreDoc scoreDoc = (ScoreDoc)element$iv;
            boolean bl = false;
            if (scoreDoc.getDoc() == Integer.MAX_VALUE) continue;
            int n = validTopHitCount[0];
            validTopHitCount[0] = n + 1;
        }
        return validTopHitCount[0];
    }

    @Override
    @NotNull
    protected TopDocs newTopDocs(@Nullable ScoreDoc[] results2, int start) {
        return results2 == null ? new TopDocs(new TotalHits(this.getTotalHits(), this.getTotalHitsRelation()), new ScoreDoc[0]) : new TopDocs(new TotalHits(this.getTotalHits(), this.getTotalHitsRelation()), results2);
    }

    @Override
    @NotNull
    public ScoreMode scoreMode() {
        return this.totalHitsThreshold == Integer.MAX_VALUE ? ScoreMode.COMPLETE : ScoreMode.TOP_SCORES;
    }

    @Override
    @NotNull
    public LeafCollector getLeafCollector(@NotNull LeafReaderContext context) throws IOException {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        int docBase = context.getDocBase();
        ScoreDoc after = this.after;
        float afterScore = 0.0f;
        int afterDoc = 0;
        if (after == null) {
            afterScore = Float.POSITIVE_INFINITY;
            afterDoc = Integer.MAX_VALUE;
        } else {
            afterScore = after.getScore();
            afterDoc = after.getDoc() - context.getDocBase();
        }
        return new LeafCollector(this, after, afterScore, afterDoc, docBase){
            private ScoreDoc pqTop;
            private float minCompetitiveScore;
            private Scorable scorer;
            final /* synthetic */ TopScoreDocCollector this$0;
            final /* synthetic */ ScoreDoc $after;
            final /* synthetic */ float $afterScore;
            final /* synthetic */ int $afterDoc;
            final /* synthetic */ int $docBase;
            {
                this.this$0 = $receiver;
                this.$after = $after;
                this.$afterScore = $afterScore;
                this.$afterDoc = $afterDoc;
                this.$docBase = $docBase;
                this.pqTop = (ScoreDoc)$receiver.getPq().top();
            }

            public Scorable getScorer() {
                return this.scorer;
            }

            public void setScorer(Scorable value) {
                this.scorer = value;
                if (this.this$0.getMinScoreAcc() == null) {
                    Scorable scorable = value;
                    Intrinsics.checkNotNull((Object)scorable);
                    this.updateMinCompetitiveScore(scorable);
                } else {
                    Scorable scorable = value;
                    Intrinsics.checkNotNull((Object)scorable);
                    this.updateGlobalMinCompetitiveScore(scorable);
                }
            }

            public void collect(int doc) throws IOException {
                Scorable scorable = this.getScorer();
                Intrinsics.checkNotNull((Object)scorable);
                float score2 = scorable.score();
                this.this$0.setTotalHits(this.this$0.getTotalHits() + 1);
                int hitCountSoFar = this.this$0.getTotalHits();
                if (this.this$0.getMinScoreAcc() != null && ((long)hitCountSoFar & this.this$0.getMinScoreAcc().getModInterval()) == 0L) {
                    Scorable scorable2 = this.getScorer();
                    Intrinsics.checkNotNull((Object)scorable2);
                    this.updateGlobalMinCompetitiveScore(scorable2);
                }
                if (this.$after != null && (score2 > this.$afterScore || score2 == this.$afterScore && doc <= this.$afterDoc)) {
                    if (this.this$0.getTotalHitsRelation() == TotalHits.Relation.EQUAL_TO) {
                        Scorable scorable3 = this.getScorer();
                        Intrinsics.checkNotNull((Object)scorable3);
                        this.updateMinCompetitiveScore(scorable3);
                    }
                    return;
                }
                if (score2 <= this.pqTop.getScore()) {
                    if (hitCountSoFar == this.this$0.getTotalHitsThreshold() + 1) {
                        Scorable scorable4 = this.getScorer();
                        Intrinsics.checkNotNull((Object)scorable4);
                        this.updateMinCompetitiveScore(scorable4);
                    }
                } else {
                    this.collectCompetitiveHit(doc, score2);
                }
            }

            public final void collectCompetitiveHit(int doc, float score2) throws IOException {
                this.pqTop.setDoc(doc + this.$docBase);
                this.pqTop.setScore(score2);
                this.pqTop = (ScoreDoc)this.this$0.getPq().updateTop();
                Scorable scorable = this.getScorer();
                Intrinsics.checkNotNull((Object)scorable);
                this.updateMinCompetitiveScore(scorable);
            }

            public final void updateGlobalMinCompetitiveScore(Scorable scorer2) throws IOException {
                Intrinsics.checkNotNullParameter((Object)scorer2, (String)"scorer");
                if (this.this$0.getMinScoreAcc() == null) {
                    String string = "Required value was null.";
                    throw new IllegalStateException(string.toString());
                }
                long maxMinScore = this.this$0.getMinScoreAcc().getRaw();
                if (maxMinScore != Long.MIN_VALUE) {
                    float score2 = MaxScoreAccumulator.Companion.toScore(maxMinScore);
                    float f = score2 = this.$docBase >= MaxScoreAccumulator.Companion.docId(maxMinScore) ? Math.INSTANCE.nextUp(score2) : score2;
                    if (score2 > this.minCompetitiveScore) {
                        scorer2.setMinCompetitiveScore(score2);
                        this.minCompetitiveScore = score2;
                        this.this$0.setTotalHitsRelation(TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO);
                    }
                }
            }

            public final void updateMinCompetitiveScore(Scorable scorer2) throws IOException {
                float localMinScore;
                Intrinsics.checkNotNullParameter((Object)scorer2, (String)"scorer");
                if (this.this$0.getTotalHits() > this.this$0.getTotalHitsThreshold() && (localMinScore = Math.INSTANCE.nextUp(this.pqTop.getScore())) > this.minCompetitiveScore) {
                    scorer2.setMinCompetitiveScore(localMinScore);
                    this.this$0.setTotalHitsRelation(TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO);
                    this.minCompetitiveScore = localMinScore;
                    if (this.this$0.getMinScoreAcc() != null) {
                        this.this$0.getMinScoreAcc().accumulate(this.pqTop.getDoc(), this.pqTop.getScore());
                    }
                }
            }

            public void collect(DocIdStream stream) throws IOException {
                LeafCollector.super.collect(stream);
            }

            public DocIdSetIterator competitiveIterator() throws IOException {
                return LeafCollector.super.competitiveIterator();
            }

            public void finish() throws IOException {
                LeafCollector.super.finish();
            }
        };
    }
}

