/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.DoubleCompanionObject;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.gnit.lucenekmp.jdkport.Collections;
import org.gnit.lucenekmp.jdkport.DoubleExtKt;
import org.gnit.lucenekmp.jdkport.FloatExtKt;
import org.gnit.lucenekmp.jdkport.Math;
import org.gnit.lucenekmp.search.DisiPriorityQueue;
import org.gnit.lucenekmp.search.DisiPriorityQueueN;
import org.gnit.lucenekmp.search.DisiWrapper;
import org.gnit.lucenekmp.search.DocIdSetIterator;
import org.gnit.lucenekmp.search.Scorable;
import org.gnit.lucenekmp.search.ScoreMode;
import org.gnit.lucenekmp.search.Scorer;
import org.gnit.lucenekmp.search.ScorerUtil;
import org.gnit.lucenekmp.search.TwoPhaseIterator;
import org.gnit.lucenekmp.util.MathUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u001b\n\u0002\u0010\u000b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0015\b\u0000\u0018\u0000 c2\u00020\u0001:\u0001cB-\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010C\u001a\u00020DH\u0002J\u0015\u0010\u0011\u001a\u00020E2\u0006\u0010F\u001a\u00020\u000eH\u0007\u00a2\u0006\u0002\bGJ\b\u0010L\u001a\u00020MH\u0016J\b\u0010N\u001a\u00020OH\u0016J\u0010\u0010P\u001a\u00020E2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010Q\u001a\u00020E2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010R\u001a\u00020E2\u0006\u0010S\u001a\u00020\u0005H\u0002J\u0012\u0010T\u001a\u0004\u0018\u00010\u00172\u0006\u0010S\u001a\u00020\u0005H\u0002J\u0010\u0010U\u001a\u00020E2\u0006\u0010V\u001a\u00020\u0017H\u0002J\b\u0010U\u001a\u00020EH\u0002J\u0010\u0010W\u001a\u00020E2\u0006\u0010S\u001a\u00020\u0005H\u0002J\u0010\u0010X\u001a\u00020E2\u0006\u0010S\u001a\u00020\u0005H\u0002J\b\u0010Y\u001a\u00020EH\u0002J\b\u0010Z\u001a\u00020EH\u0002J\b\u0010[\u001a\u00020\u000eH\u0016J\u0010\u0010\\\u001a\u00020\u00052\u0006\u0010S\u001a\u00020\u0005H\u0016J\u0010\u0010]\u001a\u00020\u000e2\u0006\u00109\u001a\u00020\u0005H\u0016J\b\u0010^\u001a\u00020\u0005H\u0016J\u0012\u0010_\u001a\u0004\u0018\u00010\u00172\u0006\u0010`\u001a\u00020\u0017H\u0002J\u0010\u0010a\u001a\u00020E2\u0006\u0010`\u001a\u00020\u0017H\u0002J\b\u0010b\u001a\u00020\u0017H\u0002R\u000e\u0010\f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u00020\u000eX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00010\u0014X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0015R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u0011\u0010'\u001a\u00020(\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u001b\u0010+\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u0014\u00a2\u0006\n\n\u0002\u0010.\u001a\u0004\b,\u0010-R\u001a\u0010/\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u00101\"\u0004\b2\u00103R\u001a\u00104\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u0010\u001e\"\u0004\b6\u0010 R\u0011\u00107\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u00101R\u001a\u00109\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010\u001e\"\u0004\b;\u0010 R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010\u001eR\u001a\u0010=\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u0010\u001e\"\u0004\b?\u0010 R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010AR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\bB\u00101R\u001a\u0010H\u001a\b\u0012\u0004\u0012\u00020I0\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bJ\u0010K\u00a8\u0006d"}, d2={"Lorg/gnit/lucenekmp/search/WANDScorer;", "Lorg/gnit/lucenekmp/search/Scorer;", "scorers", "", "minShouldMatch", "", "scoreMode", "Lorg/gnit/lucenekmp/search/ScoreMode;", "leadCost", "", "<init>", "(Ljava/util/Collection;ILorg/gnit/lucenekmp/search/ScoreMode;J)V", "scalingFactor", "minCompetitiveScore", "", "getMinCompetitiveScore", "()F", "setMinCompetitiveScore", "(F)V", "allScorers", "", "[Lorg/gnit/lucenekmp/search/Scorer;", "lead", "Lorg/gnit/lucenekmp/search/DisiWrapper;", "getLead", "()Lorg/gnit/lucenekmp/search/DisiWrapper;", "setLead", "(Lorg/gnit/lucenekmp/search/DisiWrapper;)V", "doc", "getDoc", "()I", "setDoc", "(I)V", "leadScore", "", "getLeadScore", "()D", "setLeadScore", "(D)V", "head", "Lorg/gnit/lucenekmp/search/DisiPriorityQueue;", "getHead", "()Lorg/gnit/lucenekmp/search/DisiPriorityQueue;", "tail", "getTail", "()[Lorg/gnit/lucenekmp/search/DisiWrapper;", "[Lorg/gnit/lucenekmp/search/DisiWrapper;", "tailMaxScore", "getTailMaxScore", "()J", "setTailMaxScore", "(J)V", "tailSize", "getTailSize", "setTailSize", "cost", "getCost", "upTo", "getUpTo", "setUpTo", "getMinShouldMatch", "freq", "getFreq", "setFreq", "getScoreMode", "()Lorg/gnit/lucenekmp/search/ScoreMode;", "getLeadCost", "ensureConsistent", "", "", "minScore", "setMinCompetitiveScoreKt", "children", "Lorg/gnit/lucenekmp/search/Scorable$ChildScorable;", "getChildren", "()Ljava/util/Collection;", "iterator", "Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "twoPhaseIterator", "Lorg/gnit/lucenekmp/search/TwoPhaseIterator;", "addLead", "addUnpositionedLead", "pushBackLeads", "target", "advanceHead", "advanceTail", "disi", "updateMaxScores", "moveToNextBlock", "moveToNextCandidate", "advanceAllTail", "score", "advanceShallow", "getMaxScore", "docID", "insertTailWithOverFlow", "s", "addTail", "popTail", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nWANDScorer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WANDScorer.kt\norg/gnit/lucenekmp/search/WANDScorer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,693:1\n1#2:694\n37#3:695\n36#3,3:696\n1563#4:699\n1634#4,3:700\n*S KotlinDebug\n*F\n+ 1 WANDScorer.kt\norg/gnit/lucenekmp/search/WANDScorer\n*L\n87#1:695\n87#1:696,3\n134#1:699\n134#1:700,3\n*E\n"})
public final class WANDScorer
extends Scorer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int scalingFactor;
    private float minCompetitiveScore;
    @NotNull
    private final Scorer[] allScorers;
    @Nullable
    private DisiWrapper lead;
    private int doc;
    private double leadScore;
    @NotNull
    private final DisiPriorityQueue head;
    @NotNull
    private final DisiWrapper[] tail;
    private long tailMaxScore;
    private int tailSize;
    private final long cost;
    private int upTo;
    private final int minShouldMatch;
    private int freq;
    @NotNull
    private final ScoreMode scoreMode;
    private final long leadCost;
    public static final int FLOAT_MANTISSA_BITS = 24;
    private static final long MAX_SCALED_SCORE = 0xFFFFFFL;

    /*
     * WARNING - void declaration
     */
    public WANDScorer(@NotNull Collection<Scorer> scorers, int minShouldMatch, @NotNull ScoreMode scoreMode, long leadCost) {
        Collection<Long> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(scorers, (String)"scorers");
        Intrinsics.checkNotNullParameter((Object)((Object)scoreMode), (String)"scoreMode");
        if (!(minShouldMatch < scorers.size())) {
            boolean $i$a$-require-WANDScorer$32 = false;
            String $i$a$-require-WANDScorer$32 = "minShouldMatch should be < the number of scorers";
            throw new IllegalArgumentException($i$a$-require-WANDScorer$32.toString());
        }
        Collection<Scorer> $this$toTypedArray$iv = scorers;
        boolean $i$f$toTypedArray = false;
        Collection<Scorer> thisCollection$iv = $this$toTypedArray$iv;
        this.allScorers = thisCollection$iv.toArray(new Scorer[0]);
        this.setMinCompetitiveScore(0.0f);
        if (!(minShouldMatch >= 0)) {
            boolean $i$a$-require-WANDScorer$42 = false;
            String $i$a$-require-WANDScorer$42 = "minShouldMatch should not be negative, but got " + minShouldMatch;
            throw new IllegalArgumentException($i$a$-require-WANDScorer$42.toString());
        }
        this.minShouldMatch = minShouldMatch;
        this.doc = -1;
        this.upTo = -1;
        this.scoreMode = scoreMode;
        this.head = DisiPriorityQueue.Companion.ofMaxSize(scorers.size());
        this.tail = new DisiWrapper[scorers.size()];
        if (this.scoreMode == ScoreMode.TOP_SCORES) {
            double maxScoreSumDouble = 0.0;
            for (Scorer scorer2 : scorers) {
                scorer2.advanceShallow(0);
                float maxScore = scorer2.getMaxScore(Integer.MAX_VALUE);
                maxScoreSumDouble += (double)maxScore;
            }
            float maxScoreSum = (float)MathUtil.INSTANCE.sumUpperBound(maxScoreSumDouble, scorers.size());
            this.scalingFactor = Companion.scalingFactor(maxScoreSum);
        } else {
            this.scalingFactor = 0;
        }
        for (Scorer scorer3 : scorers) {
            this.addUnpositionedLead(new DisiWrapper(scorer3, true));
        }
        Iterable maxScoreSumDouble = scorers;
        ScorerUtil scorerUtil = ScorerUtil.INSTANCE;
        WANDScorer wANDScorer = this;
        boolean $i$f$map = false;
        void maxScoreSum = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Scorer scorer4 = (Scorer)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.iterator().cost());
        }
        collection = (List)destination$iv$iv;
        wANDScorer.cost = scorerUtil.costWithMinShouldMatch((Sequence<Long>)CollectionsKt.asSequence((Iterable)collection), scorers.size(), minShouldMatch);
        this.leadCost = leadCost;
    }

    @Override
    public float getMinCompetitiveScore() {
        return this.minCompetitiveScore;
    }

    @Override
    public void setMinCompetitiveScore(float f) {
        this.minCompetitiveScore = f;
    }

    @Nullable
    public final DisiWrapper getLead() {
        return this.lead;
    }

    public final void setLead(@Nullable DisiWrapper disiWrapper) {
        this.lead = disiWrapper;
    }

    public final int getDoc() {
        return this.doc;
    }

    public final void setDoc(int n) {
        this.doc = n;
    }

    public final double getLeadScore() {
        return this.leadScore;
    }

    public final void setLeadScore(double d) {
        this.leadScore = d;
    }

    @NotNull
    public final DisiPriorityQueue getHead() {
        return this.head;
    }

    @NotNull
    public final DisiWrapper[] getTail() {
        return this.tail;
    }

    public final long getTailMaxScore() {
        return this.tailMaxScore;
    }

    public final void setTailMaxScore(long l) {
        this.tailMaxScore = l;
    }

    public final int getTailSize() {
        return this.tailSize;
    }

    public final void setTailSize(int n) {
        this.tailSize = n;
    }

    public final long getCost() {
        return this.cost;
    }

    public final int getUpTo() {
        return this.upTo;
    }

    public final void setUpTo(int n) {
        this.upTo = n;
    }

    public final int getMinShouldMatch() {
        return this.minShouldMatch;
    }

    public final int getFreq() {
        return this.freq;
    }

    public final void setFreq(int n) {
        this.freq = n;
    }

    @NotNull
    public final ScoreMode getScoreMode() {
        return this.scoreMode;
    }

    public final long getLeadCost() {
        return this.leadCost;
    }

    private final boolean ensureConsistent() throws IOException {
        if (this.scoreMode == ScoreMode.TOP_SCORES) {
            long maxScoreSum = 0L;
            int n = this.tailSize;
            for (int i = 0; i < n; ++i) {
                DisiWrapper disiWrapper = this.tail[i];
                Intrinsics.checkNotNull((Object)disiWrapper);
                if (!(disiWrapper.getDoc() < this.doc)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                DisiWrapper disiWrapper2 = this.tail[i];
                Intrinsics.checkNotNull((Object)disiWrapper2);
                maxScoreSum = Math.INSTANCE.addExact(maxScoreSum, disiWrapper2.getScaledMaxScore());
            }
            if (!(maxScoreSum == this.tailMaxScore)) {
                boolean $i$a$-require-WANDScorer$ensureConsistent$22 = false;
                String $i$a$-require-WANDScorer$ensureConsistent$22 = maxScoreSum + " " + this.tailMaxScore;
                throw new IllegalArgumentException($i$a$-require-WANDScorer$ensureConsistent$22.toString());
            }
            List leadScores = new ArrayList();
            for (DisiWrapper w = this.lead; w != null; w = w.getNext()) {
                if (!(w.getDoc() == this.doc)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                Scorable scorable = w.getScorable();
                Intrinsics.checkNotNull((Object)scorable);
                leadScores.add(Float.valueOf(scorable.score()));
            }
            Collections.INSTANCE.reverse(leadScores);
            double recomputedLeadScore = 0.0;
            Iterator iterator2 = leadScores.iterator();
            while (iterator2.hasNext()) {
                float score2 = ((Number)iterator2.next()).floatValue();
                recomputedLeadScore += (double)score2;
            }
            if (!(recomputedLeadScore == this.leadScore)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (!(this.getMinCompetitiveScore() == 0.0f || (float)this.tailMaxScore < this.getMinCompetitiveScore() || this.tailSize < this.minShouldMatch)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (!(this.doc <= this.upTo)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
        }
        for (DisiWrapper w : this.head) {
            if (this.lead == null) {
                DisiWrapper disiWrapper = w;
                Intrinsics.checkNotNull((Object)disiWrapper);
                if (disiWrapper.getDoc() >= this.doc) continue;
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            DisiWrapper disiWrapper = w;
            Intrinsics.checkNotNull((Object)disiWrapper);
            if (disiWrapper.getDoc() > this.doc) continue;
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return true;
    }

    @JvmName(name="setMinCompetitiveScoreKt")
    public final void setMinCompetitiveScoreKt(float minScore) throws IOException {
        if (!(this.scoreMode == ScoreMode.TOP_SCORES)) {
            boolean bl = false;
            String string = "minCompetitiveScore can only be set for ScoreMode.TOP_SCORES, but got: " + this.scoreMode;
            throw new IllegalArgumentException(string.toString());
        }
        if (!(minScore >= 0.0f)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        long scaledMinScore = WANDScorer.Companion.scaleMinScore(minScore, this.scalingFactor);
        if (!((float)scaledMinScore >= this.getMinCompetitiveScore())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.setMinCompetitiveScore(scaledMinScore);
    }

    @Override
    @NotNull
    public Collection<Scorable.ChildScorable> getChildren() {
        List matchingChildren = new ArrayList();
        this.advanceAllTail();
        for (DisiWrapper s = this.lead; s != null; s = s.getNext()) {
            matchingChildren.add(new Scorable.ChildScorable(s.getScorer(), "SHOULD"));
        }
        return matchingChildren;
    }

    @Override
    @NotNull
    public DocIdSetIterator iterator() {
        return TwoPhaseIterator.Companion.asDocIdSetIterator(this.twoPhaseIterator());
    }

    @Override
    @NotNull
    public TwoPhaseIterator twoPhaseIterator() {
        DocIdSetIterator approximation2 = new DocIdSetIterator(this){
            final /* synthetic */ WANDScorer this$0;
            {
                this.this$0 = $receiver;
            }

            public int docID() {
                return this.this$0.getDoc();
            }

            public int nextDoc() throws IOException {
                return this.advance(this.this$0.getDoc() + 1);
            }

            public int advance(int target) throws IOException {
                int n;
                WANDScorer.access$pushBackLeads(this.this$0, target);
                DisiWrapper headTop = WANDScorer.access$advanceHead(this.this$0, target);
                if (this.this$0.getScoreMode() == ScoreMode.TOP_SCORES && (headTop == null || headTop.getDoc() > this.this$0.getUpTo())) {
                    WANDScorer.access$moveToNextBlock(this.this$0, target);
                    if (!(this.this$0.getUpTo() >= target)) {
                        String string = "Failed requirement.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    headTop = this.this$0.getHead().top();
                }
                DisiWrapper disiWrapper = headTop;
                if (disiWrapper != null) {
                    int n2 = disiWrapper.getDoc();
                    WANDScorer wANDScorer = this.this$0;
                    int it = n2;
                    boolean bl = false;
                    wANDScorer.setDoc(it);
                    n = n2;
                } else {
                    int n3 = Integer.MAX_VALUE;
                    WANDScorer wANDScorer = this.this$0;
                    int it = n3;
                    boolean bl = false;
                    wANDScorer.setDoc(it);
                    n = n3;
                }
                return n;
            }

            public long cost() {
                return this.this$0.getCost();
            }
        };
        return new TwoPhaseIterator(approximation2, this){
            final /* synthetic */ WANDScorer this$0;
            {
                this.this$0 = $receiver;
                super($approximation);
            }

            public boolean matches() throws IOException {
                if (!(this.this$0.getLead() == null)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                WANDScorer.access$moveToNextCandidate(this.this$0);
                long scaledLeadScore = 0L;
                if (this.this$0.getScoreMode() == ScoreMode.TOP_SCORES) {
                    scaledLeadScore = WANDScorer.Companion.scaleMaxScore((float)MathUtil.INSTANCE.sumUpperBound(this.this$0.getLeadScore(), 24), WANDScorer.access$getScalingFactor$p(this.this$0));
                }
                while ((float)scaledLeadScore < this.this$0.getMinCompetitiveScore() || this.this$0.getFreq() < this.this$0.getMinShouldMatch()) {
                    if (!WANDScorer.access$ensureConsistent(this.this$0)) {
                        String string = "Failed requirement.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    if ((float)(scaledLeadScore + this.this$0.getTailMaxScore()) < this.this$0.getMinCompetitiveScore() || this.this$0.getFreq() + this.this$0.getTailSize() < this.this$0.getMinShouldMatch()) {
                        return false;
                    }
                    DisiWrapper prevLead = this.this$0.getLead();
                    WANDScorer.access$advanceTail(this.this$0);
                    if (this.this$0.getScoreMode() != ScoreMode.TOP_SCORES || this.this$0.getLead() == prevLead) continue;
                    DisiWrapper disiWrapper = this.this$0.getLead();
                    Intrinsics.checkNotNull((Object)disiWrapper);
                    if (!(prevLead == disiWrapper.getNext())) {
                        String string = "Failed requirement.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    scaledLeadScore = WANDScorer.Companion.scaleMaxScore((float)MathUtil.INSTANCE.sumUpperBound(this.this$0.getLeadScore(), 24), WANDScorer.access$getScalingFactor$p(this.this$0));
                }
                if (!WANDScorer.access$ensureConsistent(this.this$0)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                return true;
            }

            public float matchCost() {
                return this.this$0.getTail().length;
            }
        };
    }

    private final void addLead(DisiWrapper lead) throws IOException {
        lead.setNext(this.lead);
        this.lead = lead;
        ++this.freq;
        if (this.scoreMode == ScoreMode.TOP_SCORES) {
            Scorable scorable = lead.getScorable();
            Intrinsics.checkNotNull((Object)scorable);
            this.leadScore += (double)scorable.score();
        }
    }

    private final void addUnpositionedLead(DisiWrapper lead) {
        if (!(lead.getDoc() == -1)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        lead.setNext(this.lead);
        this.lead = lead;
        ++this.freq;
    }

    private final void pushBackLeads(int target) throws IOException {
        for (DisiWrapper s = this.lead; s != null; s = s.getNext()) {
            DisiWrapper evicted = this.insertTailWithOverFlow(s);
            if (evicted == null) continue;
            DocIdSetIterator docIdSetIterator = evicted.getIterator();
            Intrinsics.checkNotNull((Object)docIdSetIterator);
            evicted.setDoc(docIdSetIterator.advance(target));
            this.head.add(evicted);
        }
        this.lead = null;
    }

    private final DisiWrapper advanceHead(int target) throws IOException {
        DisiWrapper headTop = this.head.top();
        while (headTop != null && headTop.getDoc() < target) {
            DisiWrapper evicted = this.insertTailWithOverFlow(headTop);
            if (evicted != null) {
                DocIdSetIterator docIdSetIterator = evicted.getIterator();
                Intrinsics.checkNotNull((Object)docIdSetIterator);
                evicted.setDoc(docIdSetIterator.advance(target));
                headTop = this.head.updateTop(evicted);
                continue;
            }
            this.head.pop();
            headTop = this.head.top();
        }
        return headTop;
    }

    private final void advanceTail(DisiWrapper disi) throws IOException {
        DocIdSetIterator docIdSetIterator = disi.getIterator();
        Intrinsics.checkNotNull((Object)docIdSetIterator);
        disi.setDoc(docIdSetIterator.advance(this.doc));
        if (disi.getDoc() == this.doc) {
            this.addLead(disi);
        } else {
            this.head.add(disi);
        }
    }

    private final void advanceTail() throws IOException {
        DisiWrapper top = this.popTail();
        this.advanceTail(top);
    }

    private final void updateMaxScores(int target) throws IOException {
        Object headTop;
        DisiWrapper w;
        int newUpTo = Integer.MAX_VALUE;
        Iterator<DisiWrapper> iterator2 = this.head.iterator();
        while (iterator2.hasNext()) {
            DisiWrapper disiWrapper = w = iterator2.next();
            Intrinsics.checkNotNull((Object)disiWrapper);
            if (disiWrapper.getDoc() > newUpTo || w.getCost() > this.leadCost) continue;
            newUpTo = java.lang.Math.min(w.getScorer().advanceShallow(w.getDoc()), newUpTo);
        }
        if (newUpTo == Integer.MAX_VALUE && this.tailSize > 0) {
            DisiWrapper disiWrapper = this.tail[0];
            Intrinsics.checkNotNull((Object)disiWrapper);
            if (disiWrapper.getCost() <= this.leadCost) {
                DisiWrapper disiWrapper2 = this.tail[0];
                Intrinsics.checkNotNull((Object)disiWrapper2);
                newUpTo = disiWrapper2.getScorer().advanceShallow(target);
                headTop = this.head.top();
                if (headTop != null) {
                    newUpTo = java.lang.Math.max(newUpTo, ((DisiWrapper)headTop).getDoc());
                }
            }
        }
        this.upTo = newUpTo;
        headTop = this.head.iterator();
        while (headTop.hasNext()) {
            DisiWrapper disiWrapper = w = headTop.next();
            Intrinsics.checkNotNull((Object)disiWrapper);
            if (disiWrapper.getDoc() > this.upTo) continue;
            w.setScaledMaxScore(Companion.scaleMaxScore(w.getScorer().getMaxScore(newUpTo), this.scalingFactor));
        }
        this.tailMaxScore = 0L;
        int n = this.tailSize;
        for (int i = 0; i < n; ++i) {
            DisiWrapper w2;
            Intrinsics.checkNotNull((Object)this.tail[i]);
            w2.getScorer().advanceShallow(target);
            w2.setScaledMaxScore(Companion.scaleMaxScore(w2.getScorer().getMaxScore(this.upTo), this.scalingFactor));
            WANDScorer.Companion.upHeapMaxScore(this.tail, i);
            this.tailMaxScore += w2.getScaledMaxScore();
        }
        while (this.tailSize > 0 && (float)this.tailMaxScore >= this.getMinCompetitiveScore()) {
            DisiWrapper w3 = this.popTail();
            DocIdSetIterator docIdSetIterator = w3.getIterator();
            Intrinsics.checkNotNull((Object)docIdSetIterator);
            w3.setDoc(docIdSetIterator.advance(target));
            this.head.add(w3);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void moveToNextBlock(int target) throws IOException {
        target = target;
        if (!(this.lead == null)) {
            var3_3 = "Failed requirement.";
            throw new IllegalArgumentException(var3_3.toString());
        }
        while (this.upTo < 0x7FFFFFFF) {
            if (this.head.size() == 0) {
                target = java.lang.Math.max(target, this.upTo + 1);
                this.updateMaxScores(target);
                continue;
            }
            v0 = this.head.top();
            Intrinsics.checkNotNull((Object)v0);
            if (v0.getDoc() <= this.upTo) break;
            v1 = this.head.top();
            Intrinsics.checkNotNull((Object)v1);
            if (!(v1.getDoc() >= target)) {
                var3_4 = "Failed requirement.";
                throw new IllegalArgumentException(var3_4.toString());
            }
            this.updateMaxScores(target);
            break;
        }
        if (this.head.size() == 0) ** GOTO lbl-1000
        v2 = this.head.top();
        Intrinsics.checkNotNull((Object)v2);
        if (v2.getDoc() <= this.upTo) lbl-1000:
        // 2 sources

        {
            v3 = true;
        } else {
            v3 = false;
        }
        if (!v3) {
            var3_5 = "Failed requirement.";
            throw new IllegalArgumentException(var3_5.toString());
        }
        if (!(this.upTo >= target)) {
            var3_6 = "Failed requirement.";
            throw new IllegalArgumentException(var3_6.toString());
        }
    }

    private final void moveToNextCandidate() throws IOException {
        DisiWrapper disiWrapper = this.lead = this.head.pop();
        Intrinsics.checkNotNull((Object)disiWrapper);
        if (!(this.doc == disiWrapper.getDoc())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        DisiWrapper disiWrapper2 = this.lead;
        Intrinsics.checkNotNull((Object)disiWrapper2);
        disiWrapper2.setNext(null);
        this.freq = 1;
        if (this.scoreMode == ScoreMode.TOP_SCORES) {
            DisiWrapper disiWrapper3 = this.lead;
            Intrinsics.checkNotNull((Object)disiWrapper3);
            Scorable scorable = disiWrapper3.getScorable();
            Intrinsics.checkNotNull((Object)scorable);
            this.leadScore = scorable.score();
        }
        while (this.head.size() > 0) {
            DisiWrapper disiWrapper4 = this.head.top();
            Intrinsics.checkNotNull((Object)disiWrapper4);
            if (disiWrapper4.getDoc() != this.doc) break;
            DisiWrapper disiWrapper5 = this.head.pop();
            Intrinsics.checkNotNull((Object)disiWrapper5);
            this.addLead(disiWrapper5);
        }
    }

    private final void advanceAllTail() throws IOException {
        for (int i = this.tailSize - 1; -1 < i; --i) {
            DisiWrapper disiWrapper = this.tail[i];
            Intrinsics.checkNotNull((Object)disiWrapper);
            this.advanceTail(disiWrapper);
        }
        this.tailSize = 0;
        this.tailMaxScore = 0L;
        if (!this.ensureConsistent()) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Override
    public float score() throws IOException {
        this.advanceAllTail();
        double leadScore = this.leadScore;
        if (this.scoreMode != ScoreMode.TOP_SCORES) {
            for (DisiWrapper s = this.lead; s != null; s = s.getNext()) {
                Scorable scorable = s.getScorable();
                Intrinsics.checkNotNull((Object)scorable);
                leadScore += (double)scorable.score();
            }
        }
        return (float)leadScore;
    }

    @Override
    public int advanceShallow(int target) throws IOException {
        for (Scorer scorer2 : this.allScorers) {
            if (scorer2.docID() >= target) continue;
            scorer2.advanceShallow(target);
        }
        if (target <= this.upTo) {
            return this.upTo;
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public float getMaxScore(int upTo) throws IOException {
        double maxScoreSum = 0.0;
        for (Scorer scorer2 : this.allScorers) {
            if (scorer2.docID() > upTo) continue;
            maxScoreSum += (double)scorer2.getMaxScore(upTo);
        }
        return (float)MathUtil.INSTANCE.sumUpperBound(maxScoreSum, this.allScorers.length);
    }

    @Override
    public int docID() {
        return this.doc;
    }

    private final DisiWrapper insertTailWithOverFlow(DisiWrapper s) {
        DisiWrapper top;
        if ((float)(this.tailMaxScore + s.getScaledMaxScore()) < this.getMinCompetitiveScore() || this.tailSize + 1 < this.minShouldMatch) {
            this.addTail(s);
            this.tailMaxScore += s.getScaledMaxScore();
            return null;
        }
        if (this.tailSize == 0) {
            return s;
        }
        DisiWrapper disiWrapper = top = this.tail[0];
        Intrinsics.checkNotNull((Object)disiWrapper);
        if (!WANDScorer.Companion.greaterMaxScore(disiWrapper, s)) {
            return s;
        }
        this.tail[0] = s;
        WANDScorer.Companion.downHeapMaxScore(this.tail, this.tailSize);
        this.tailMaxScore = this.tailMaxScore - top.getScaledMaxScore() + s.getScaledMaxScore();
        return top;
    }

    private final void addTail(DisiWrapper s) {
        this.tail[this.tailSize] = s;
        WANDScorer.Companion.upHeapMaxScore(this.tail, this.tailSize);
        ++this.tailSize;
    }

    private final DisiWrapper popTail() {
        if (!(this.tailSize > 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        DisiWrapper disiWrapper = this.tail[0];
        Intrinsics.checkNotNull((Object)disiWrapper);
        DisiWrapper result = disiWrapper;
        this.tailSize += -1;
        this.tail[0] = this.tail[this.tailSize];
        WANDScorer.Companion.downHeapMaxScore(this.tail, this.tailSize);
        this.tailMaxScore -= result.getScaledMaxScore();
        return result;
    }

    public static final /* synthetic */ void access$pushBackLeads(WANDScorer $this, int target) {
        $this.pushBackLeads(target);
    }

    public static final /* synthetic */ DisiWrapper access$advanceHead(WANDScorer $this, int target) {
        return $this.advanceHead(target);
    }

    public static final /* synthetic */ void access$moveToNextBlock(WANDScorer $this, int target) {
        $this.moveToNextBlock(target);
    }

    public static final /* synthetic */ void access$moveToNextCandidate(WANDScorer $this) {
        $this.moveToNextCandidate();
    }

    public static final /* synthetic */ int access$getScalingFactor$p(WANDScorer $this) {
        return $this.scalingFactor;
    }

    public static final /* synthetic */ boolean access$ensureConsistent(WANDScorer $this) {
        return $this.ensureConsistent();
    }

    public static final /* synthetic */ void access$advanceTail(WANDScorer $this) {
        $this.advanceTail();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u0005J\u0018\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u0005H\u0002J#\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0005H\u0002\u00a2\u0006\u0002\u0010\u0015J#\u0010\u0016\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0017\u001a\u00020\u0005H\u0002\u00a2\u0006\u0002\u0010\u0015J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u0013H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/gnit/lucenekmp/search/WANDScorer$Companion;", "", "<init>", "()V", "FLOAT_MANTISSA_BITS", "", "MAX_SCALED_SCORE", "", "scalingFactor", "f", "", "scaleMaxScore", "maxScore", "scaleMinScore", "minScore", "upHeapMaxScore", "", "heap", "", "Lorg/gnit/lucenekmp/search/DisiWrapper;", "i", "([Lorg/gnit/lucenekmp/search/DisiWrapper;I)V", "downHeapMaxScore", "size", "greaterMaxScore", "", "w1", "w2", "core"})
    @SourceDebugExtension(value={"SMAP\nWANDScorer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WANDScorer.kt\norg/gnit/lucenekmp/search/WANDScorer$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,693:1\n1#2:694\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final int scalingFactor(float f) {
            if (!(!(f < 0.0f))) {
                boolean bl = false;
                String string = "Scores must be positive or null";
                throw new IllegalArgumentException(string.toString());
            }
            if (f == 0.0f) {
                return this.scalingFactor(Float.MIN_VALUE) + 1;
            }
            if (FloatExtKt.isInfinite(FloatCompanionObject.INSTANCE, f)) {
                return this.scalingFactor(Float.MAX_VALUE) - 1;
            }
            double d = f;
            if (!(d == 0.0 || Math.INSTANCE.getExponent(d) >= DoubleExtKt.getMIN_EXPONENT(DoubleCompanionObject.INSTANCE))) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            return 23 - Math.INSTANCE.getExponent(d);
        }

        public final long scaleMaxScore(float maxScore, int scalingFactor) {
            if (!(!FloatExtKt.isNaN(FloatCompanionObject.INSTANCE, maxScore))) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (!(maxScore >= 0.0f)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            double scaled = Math.INSTANCE.scalb(maxScore, scalingFactor);
            if (scaled > 1.6777215E7) {
                return 0xFFFFFFL;
            }
            return (long)java.lang.Math.ceil(scaled);
        }

        private final long scaleMinScore(float minScore, int scalingFactor) {
            if (!FloatExtKt.isFinite(FloatCompanionObject.INSTANCE, minScore)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (!(minScore >= 0.0f)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            double scaled = Math.INSTANCE.scalb(minScore, scalingFactor);
            return (long)java.lang.Math.floor(scaled);
        }

        private final void upHeapMaxScore(DisiWrapper[] heap, int i) {
            int i2 = i;
            DisiWrapper node = heap[i2];
            int j = DisiPriorityQueueN.Companion.parentNode(i2);
            while (j >= 0 && this.greaterMaxScore(node, heap[j])) {
                heap[i2] = heap[j];
                i2 = j;
                j = DisiPriorityQueueN.Companion.parentNode(j);
            }
            heap[i2] = node;
        }

        private final void downHeapMaxScore(DisiWrapper[] heap, int size2) {
            int i = 0;
            DisiWrapper node = heap[0];
            int j = DisiPriorityQueueN.Companion.leftNode(i);
            if (j < size2) {
                int k = DisiPriorityQueueN.Companion.rightNode(j);
                if (k < size2 && this.greaterMaxScore(heap[k], heap[j])) {
                    j = k;
                }
                if (this.greaterMaxScore(heap[j], node)) {
                    do {
                        heap[i] = heap[j];
                        i = j;
                        k = DisiPriorityQueueN.Companion.rightNode(j = DisiPriorityQueueN.Companion.leftNode(i));
                        if (k >= size2 || !this.greaterMaxScore(heap[k], heap[j])) continue;
                        j = k;
                    } while (j < size2 && this.greaterMaxScore(heap[j], node));
                    heap[i] = node;
                }
            }
        }

        private final boolean greaterMaxScore(DisiWrapper w1, DisiWrapper w2) {
            return w1.getScaledMaxScore() > w2.getScaledMaxScore() ? true : (w1.getScaledMaxScore() < w2.getScaledMaxScore() ? false : w1.getCost() < w2.getCost());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

