/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.search;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.index.Term;
import org.gnit.lucenekmp.jdkport.Character;
import org.gnit.lucenekmp.jdkport.ObjectsKt;
import org.gnit.lucenekmp.search.AutomatonQuery;
import org.gnit.lucenekmp.search.MultiTermQuery;
import org.gnit.lucenekmp.util.automaton.Automata;
import org.gnit.lucenekmp.util.automaton.Automaton;
import org.gnit.lucenekmp.util.automaton.Operations;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0012\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\rH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lorg/gnit/lucenekmp/search/WildcardQuery;", "Lorg/gnit/lucenekmp/search/AutomatonQuery;", "term", "Lorg/gnit/lucenekmp/index/Term;", "determinizeWorkLimit", "", "rewriteMethod", "Lorg/gnit/lucenekmp/search/MultiTermQuery$RewriteMethod;", "<init>", "(Lorg/gnit/lucenekmp/index/Term;ILorg/gnit/lucenekmp/search/MultiTermQuery$RewriteMethod;)V", "getTerm", "()Lorg/gnit/lucenekmp/index/Term;", "toString", "", "field", "Companion", "core"})
public final class WildcardQuery
extends AutomatonQuery {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Term term;
    public static final char WILDCARD_STRING = '*';
    public static final char WILDCARD_CHAR = '?';
    public static final char WILDCARD_ESCAPE = '\\';

    public WildcardQuery(@NotNull Term term, int determinizeWorkLimit, @NotNull MultiTermQuery.RewriteMethod rewriteMethod) {
        Intrinsics.checkNotNullParameter((Object)term, (String)"term");
        Intrinsics.checkNotNullParameter((Object)rewriteMethod, (String)"rewriteMethod");
        super(term, Companion.toAutomaton(term, determinizeWorkLimit), false, rewriteMethod);
        this.term = term;
    }

    public /* synthetic */ WildcardQuery(Term term, int n, MultiTermQuery.RewriteMethod rewriteMethod, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 10000;
        }
        if ((n2 & 4) != 0) {
            rewriteMethod = MultiTermQuery.Companion.getCONSTANT_SCORE_BLENDED_REWRITE();
        }
        this(term, n, rewriteMethod);
    }

    @Override
    @NotNull
    protected Term getTerm() {
        return this.term;
    }

    @Override
    @NotNull
    public String toString(@Nullable String field) {
        StringBuilder buffer = new StringBuilder();
        if (!Intrinsics.areEqual((Object)this.getField(), (Object)field)) {
            buffer.append(this.getField());
            buffer.append(":");
        }
        buffer.append(this.getTerm().text());
        String string = buffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/gnit/lucenekmp/search/WildcardQuery$Companion;", "", "<init>", "()V", "WILDCARD_STRING", "", "WILDCARD_CHAR", "WILDCARD_ESCAPE", "toAutomaton", "Lorg/gnit/lucenekmp/util/automaton/Automaton;", "wildcardquery", "Lorg/gnit/lucenekmp/index/Term;", "determinizeWorkLimit", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Automaton toAutomaton(@NotNull Term wildcardquery, int determinizeWorkLimit) {
            int length;
            Intrinsics.checkNotNullParameter((Object)wildcardquery, (String)"wildcardquery");
            List automata = new ArrayList();
            String wildcardText = wildcardquery.text();
            block5: for (int i = 0; i < wildcardText.length(); i += length) {
                int c = ObjectsKt.codePointAt(wildcardText, i);
                length = Character.Companion.charCount(c);
                switch ((char)c) {
                    case '*': {
                        boolean bl = automata.add(Automata.INSTANCE.makeAnyString());
                        continue block5;
                    }
                    case '?': {
                        boolean bl = automata.add(Automata.INSTANCE.makeAnyChar());
                        continue block5;
                    }
                    case '\\': {
                        if (i + length < wildcardText.length()) {
                            int nextChar = ObjectsKt.codePointAt(wildcardText, i + length);
                            length += Character.Companion.charCount(nextChar);
                            automata.add(Automata.INSTANCE.makeChar(nextChar));
                            break block5;
                        }
                        boolean bl = automata.add(Automata.INSTANCE.makeChar(c));
                        continue block5;
                    }
                    default: {
                        boolean bl = automata.add(Automata.INSTANCE.makeChar(c));
                    }
                }
            }
            return Operations.INSTANCE.determinize(Operations.INSTANCE.concatenate(automata), determinizeWorkLimit);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

