/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.search.comparators;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.IntCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.index.LeafReaderContext;
import org.gnit.lucenekmp.jdkport.IntExtKt;
import org.gnit.lucenekmp.search.DocIdSetIterator;
import org.gnit.lucenekmp.search.FieldComparator;
import org.gnit.lucenekmp.search.LeafFieldComparator;
import org.gnit.lucenekmp.search.Pruning;
import org.gnit.lucenekmp.search.Scorable;
import org.gnit.lucenekmp.search.comparators.MinDocIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001eB\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0002H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0002H\u0016J\u0015\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u001dR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/gnit/lucenekmp/search/comparators/DocComparator;", "Lorg/gnit/lucenekmp/search/FieldComparator;", "", "numHits", "reverse", "", "pruning", "Lorg/gnit/lucenekmp/search/Pruning;", "<init>", "(IZLorg/gnit/lucenekmp/search/Pruning;)V", "docIDs", "", "enableSkipping", "bottom", "topValue", "topValueSet", "bottomValueSet", "hitsThresholdReached", "compare", "slot1", "slot2", "getLeafComparator", "Lorg/gnit/lucenekmp/search/LeafFieldComparator;", "context", "Lorg/gnit/lucenekmp/index/LeafReaderContext;", "setTopValue", "", "value", "slot", "(I)Ljava/lang/Integer;", "DocLeafComparator", "core"})
public final class DocComparator
extends FieldComparator<Integer> {
    @NotNull
    private final int[] docIDs;
    private final boolean enableSkipping;
    private int bottom;
    private int topValue;
    private boolean topValueSet;
    private boolean bottomValueSet;
    private boolean hitsThresholdReached;

    public DocComparator(int numHits, boolean reverse, @NotNull Pruning pruning) {
        Intrinsics.checkNotNullParameter((Object)((Object)pruning), (String)"pruning");
        this.docIDs = new int[numHits];
        this.enableSkipping = !reverse && pruning != Pruning.NONE;
    }

    @Override
    public int compare(int slot1, int slot2) {
        return this.docIDs[slot1] - this.docIDs[slot2];
    }

    @Override
    @NotNull
    public LeafFieldComparator getLeafComparator(@NotNull LeafReaderContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new DocLeafComparator(context);
    }

    @Override
    public void setTopValue(int value) {
        this.topValue = value;
        this.topValueSet = true;
    }

    @Override
    @NotNull
    public Integer value(int slot) {
        return this.docIDs[slot];
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007H\u0016J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0007H\u0016J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0007H\u0016J\u0018\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0007H\u0016J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\n\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\b\u0010\u0016\u001a\u00020\rH\u0016J\u0006\u0010\u0017\u001a\u00020\rR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/gnit/lucenekmp/search/comparators/DocComparator$DocLeafComparator;", "Lorg/gnit/lucenekmp/search/LeafFieldComparator;", "context", "Lorg/gnit/lucenekmp/index/LeafReaderContext;", "<init>", "(Lorg/gnit/lucenekmp/search/comparators/DocComparator;Lorg/gnit/lucenekmp/index/LeafReaderContext;)V", "docBase", "", "minDoc", "maxDoc", "competitiveIterator", "Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "setBottom", "", "slot", "compareBottom", "doc", "compareTop", "copy", "setScorer", "scorer", "Lorg/gnit/lucenekmp/search/Scorable;", "setHitsThresholdReached", "updateIterator", "core"})
    private final class DocLeafComparator
    implements LeafFieldComparator {
        private final int docBase;
        private int minDoc;
        private int maxDoc;
        @Nullable
        private DocIdSetIterator competitiveIterator;

        public DocLeafComparator(LeafReaderContext context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            this.docBase = context.getDocBase();
            if (DocComparator.this.enableSkipping) {
                this.minDoc = DocComparator.this.topValue;
                this.maxDoc = context.reader().maxDoc();
                this.competitiveIterator = DocIdSetIterator.Companion.all(this.maxDoc);
            } else {
                this.minDoc = -1;
                this.maxDoc = -1;
                this.competitiveIterator = null;
            }
        }

        @Override
        public void setBottom(int slot) {
            DocComparator.this.bottom = DocComparator.this.docIDs[slot];
            DocComparator.this.bottomValueSet = true;
            this.updateIterator();
        }

        @Override
        public int compareBottom(int doc) {
            return DocComparator.this.bottom - (this.docBase + doc);
        }

        @Override
        public int compareTop(int doc) {
            int docValue = this.docBase + doc;
            return IntExtKt.compare(IntCompanionObject.INSTANCE, DocComparator.this.topValue, docValue);
        }

        @Override
        public void copy(int slot, int doc) throws IOException {
            ((DocComparator)DocComparator.this).docIDs[slot] = this.docBase + doc;
        }

        @Override
        public void setScorer(@NotNull Scorable scorer2) throws IOException {
            Intrinsics.checkNotNullParameter((Object)scorer2, (String)"scorer");
            this.updateIterator();
        }

        @Override
        @Nullable
        public DocIdSetIterator competitiveIterator() {
            if (!DocComparator.this.enableSkipping) {
                return null;
            }
            return new DocIdSetIterator(this){
                private int docID;
                final /* synthetic */ DocLeafComparator this$0;
                {
                    this.this$0 = $receiver;
                    DocIdSetIterator docIdSetIterator = DocLeafComparator.access$getCompetitiveIterator$p($receiver);
                    Intrinsics.checkNotNull((Object)docIdSetIterator);
                    this.docID = docIdSetIterator.docID();
                }

                public int nextDoc() throws IOException {
                    return this.advance(this.docID + 1);
                }

                public int docID() {
                    return this.docID;
                }

                public long cost() {
                    DocIdSetIterator docIdSetIterator = DocLeafComparator.access$getCompetitiveIterator$p(this.this$0);
                    Intrinsics.checkNotNull((Object)docIdSetIterator);
                    return docIdSetIterator.cost();
                }

                public int advance(int target) throws IOException {
                    int n;
                    DocIdSetIterator docIdSetIterator = DocLeafComparator.access$getCompetitiveIterator$p(this.this$0);
                    Intrinsics.checkNotNull((Object)docIdSetIterator);
                    int it = n = docIdSetIterator.advance(target);
                    boolean bl = false;
                    this.docID = it;
                    return n;
                }
            };
        }

        @Override
        public void setHitsThresholdReached() {
            DocComparator.this.hitsThresholdReached = true;
            this.updateIterator();
        }

        public final void updateIterator() {
            if (!DocComparator.this.enableSkipping || !DocComparator.this.hitsThresholdReached) {
                return;
            }
            if (DocComparator.this.bottomValueSet) {
                this.competitiveIterator = DocIdSetIterator.Companion.empty();
            } else if (DocComparator.this.topValueSet) {
                if (this.docBase + this.maxDoc <= this.minDoc) {
                    this.competitiveIterator = DocIdSetIterator.Companion.empty();
                } else {
                    DocIdSetIterator docIdSetIterator = this.competitiveIterator;
                    Intrinsics.checkNotNull((Object)docIdSetIterator);
                    int segmentMinDoc = Math.max(docIdSetIterator.docID(), this.minDoc - this.docBase);
                    this.competitiveIterator = new MinDocIterator(segmentMinDoc, this.maxDoc);
                }
            }
        }

        public static final /* synthetic */ DocIdSetIterator access$getCompetitiveIterator$p(DocLeafComparator $this) {
            return $this.competitiveIterator;
        }
    }
}

