/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.search.comparators;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.LongCompanionObject;
import org.gnit.lucenekmp.index.LeafReaderContext;
import org.gnit.lucenekmp.jdkport.LongExtKt;
import org.gnit.lucenekmp.search.LeafFieldComparator;
import org.gnit.lucenekmp.search.Pruning;
import org.gnit.lucenekmp.search.comparators.NumericComparator;
import org.gnit.lucenekmp.util.NumericUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0016\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001(B/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0018\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0004H\u0016J\u0015\u0010\u0013\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0002H\u0017\u00a2\u0006\u0002\b\u001dJ\u0015\u0010\u001c\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u0004H\u0016\u00a2\u0006\u0002\u0010\u001fJ\b\u0010 \u001a\u00020\u0002H\u0014J\u0010\u0010!\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020#H\u0014J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u00020\u0002X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0002X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0012\"\u0004\b\u0017\u0010\u0014\u00a8\u0006)"}, d2={"Lorg/gnit/lucenekmp/search/comparators/LongComparator;", "Lorg/gnit/lucenekmp/search/comparators/NumericComparator;", "", "numHits", "", "field", "", "missingValue", "reverse", "", "pruning", "Lorg/gnit/lucenekmp/search/Pruning;", "<init>", "(ILjava/lang/String;JZLorg/gnit/lucenekmp/search/Pruning;)V", "values", "", "topValue", "getTopValue", "()J", "setTopValue", "(J)V", "bottom", "getBottom", "setBottom", "compare", "slot1", "slot2", "", "value", "setTopValueKt", "slot", "(I)Ljava/lang/Long;", "missingValueAsComparableLong", "sortableBytesToLong", "bytes", "", "getLeafComparator", "Lorg/gnit/lucenekmp/search/LeafFieldComparator;", "context", "Lorg/gnit/lucenekmp/index/LeafReaderContext;", "LongLeafComparator", "core"})
public final class LongComparator
extends NumericComparator<Long> {
    @NotNull
    private final long[] values;
    private long topValue;
    private long bottom;

    public LongComparator(int numHits, @NotNull String field, long missingValue, boolean reverse, @NotNull Pruning pruning) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)((Object)pruning), (String)"pruning");
        super(field, missingValue, reverse, pruning, 8);
        this.values = new long[numHits];
    }

    protected final long getTopValue() {
        return this.topValue;
    }

    @Override
    protected final void setTopValue(long l) {
        this.topValue = l;
    }

    protected final long getBottom() {
        return this.bottom;
    }

    protected final void setBottom(long l) {
        this.bottom = l;
    }

    @Override
    public int compare(int slot1, int slot2) {
        return LongExtKt.compare(LongCompanionObject.INSTANCE, this.values[slot1], this.values[slot2]);
    }

    @JvmName(name="setTopValueKt")
    public void setTopValueKt(long value) {
        super.setTopValue(value);
        this.topValue = value;
    }

    @Override
    @NotNull
    public Long value(int slot) {
        return this.values[slot];
    }

    @Override
    protected long missingValueAsComparableLong() {
        Object t = this.getMissingValue();
        Intrinsics.checkNotNull(t);
        return ((Number)t).longValue();
    }

    @Override
    protected long sortableBytesToLong(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        return NumericUtils.INSTANCE.sortableBytesToLong(bytes, 0);
    }

    @Override
    @NotNull
    public LeafFieldComparator getLeafComparator(@NotNull LeafReaderContext context) throws IOException {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new LongLeafComparator(context);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0086\u0004\u0018\u00002\f0\u0001R\b\u0012\u0004\u0012\u00020\u00030\u0002B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nH\u0016J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u0011\u001a\u00020\u0003H\u0014J\b\u0010\u0012\u001a\u00020\u0003H\u0014\u00a8\u0006\u0013"}, d2={"Lorg/gnit/lucenekmp/search/comparators/LongComparator$LongLeafComparator;", "Lorg/gnit/lucenekmp/search/comparators/NumericComparator$NumericLeafComparator;", "Lorg/gnit/lucenekmp/search/comparators/NumericComparator;", "", "context", "Lorg/gnit/lucenekmp/index/LeafReaderContext;", "<init>", "(Lorg/gnit/lucenekmp/search/comparators/LongComparator;Lorg/gnit/lucenekmp/index/LeafReaderContext;)V", "getValueForDoc", "doc", "", "setBottom", "", "slot", "compareBottom", "compareTop", "copy", "bottomAsComparableLong", "topAsComparableLong", "core"})
    public final class LongLeafComparator
    extends NumericComparator.NumericLeafComparator {
        public LongLeafComparator(LeafReaderContext context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            super(LongComparator.this, context);
        }

        private final long getValueForDoc(int doc) throws IOException {
            if (this.getDocValues().advanceExact(doc)) {
                return this.getDocValues().longValue();
            }
            return ((Number)LongComparator.this.getMissingValue()).longValue();
        }

        @Override
        public void setBottom(int slot) throws IOException {
            LongComparator.this.setBottom(LongComparator.this.values[slot]);
            super.setBottom(slot);
        }

        @Override
        public int compareBottom(int doc) throws IOException {
            return LongExtKt.compare(LongCompanionObject.INSTANCE, LongComparator.this.getBottom(), this.getValueForDoc(doc));
        }

        @Override
        public int compareTop(int doc) throws IOException {
            return LongExtKt.compare(LongCompanionObject.INSTANCE, LongComparator.this.getTopValue(), this.getValueForDoc(doc));
        }

        @Override
        public void copy(int slot, int doc) throws IOException {
            ((LongComparator)LongComparator.this).values[slot] = this.getValueForDoc(doc);
            super.copy(slot, doc);
        }

        @Override
        protected long bottomAsComparableLong() {
            return LongComparator.this.getBottom();
        }

        @Override
        protected long topAsComparableLong() {
            return LongComparator.this.getTopValue();
        }
    }
}

