/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.search.comparators;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.LongCompanionObject;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.index.DocValues;
import org.gnit.lucenekmp.index.FieldInfo;
import org.gnit.lucenekmp.index.LeafReaderContext;
import org.gnit.lucenekmp.index.NumericDocValues;
import org.gnit.lucenekmp.index.PointValues;
import org.gnit.lucenekmp.jdkport.LongExtKt;
import org.gnit.lucenekmp.search.DocIdSetIterator;
import org.gnit.lucenekmp.search.FieldComparator;
import org.gnit.lucenekmp.search.LeafFieldComparator;
import org.gnit.lucenekmp.search.Pruning;
import org.gnit.lucenekmp.search.Scorable;
import org.gnit.lucenekmp.search.Scorer;
import org.gnit.lucenekmp.util.DocIdSetBuilder;
import org.gnit.lucenekmp.util.FixedBitSet;
import org.gnit.lucenekmp.util.IntsRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u0014\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0002\b\u0003\b&\u0018\u0000 3*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u000223B1\b\u0004\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00028\u0000\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0015\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010,J\b\u0010\u001e\u001a\u00020*H\u0016J\b\u0010-\u001a\u00020*H\u0016J\b\u0010.\u001a\u00020\u0015H$J\u0010\u0010/\u001a\u00020\u00152\u0006\u00100\u001a\u000201H$R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0006\u001a\u00028\u0000X\u0084\u0004\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u00020\bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0017\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0017\"\u0004\b\u001e\u0010\u001bR\u001a\u0010\u001f\u001a\u00020\bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0017\"\u0004\b!\u0010\u001bR\u001a\u0010\"\u001a\u00020\bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0017\"\u0004\b$\u0010\u001bR\u001a\u0010\t\u001a\u00020\nX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(\u00a8\u00064"}, d2={"Lorg/gnit/lucenekmp/search/comparators/NumericComparator;", "T", "", "Lorg/gnit/lucenekmp/search/FieldComparator;", "field", "", "missingValue", "reverse", "", "pruning", "Lorg/gnit/lucenekmp/search/Pruning;", "bytesCount", "", "<init>", "(Ljava/lang/String;Ljava/lang/Number;ZLorg/gnit/lucenekmp/search/Pruning;I)V", "getField", "()Ljava/lang/String;", "getMissingValue", "()Ljava/lang/Number;", "Ljava/lang/Number;", "missingValueAsLong", "", "getReverse", "()Z", "topValueSet", "getTopValueSet", "setTopValueSet", "(Z)V", "singleSort", "getSingleSort", "setSingleSort", "hitsThresholdReached", "getHitsThresholdReached", "setHitsThresholdReached", "queueFull", "getQueueFull", "setQueueFull", "getPruning", "()Lorg/gnit/lucenekmp/search/Pruning;", "setPruning", "(Lorg/gnit/lucenekmp/search/Pruning;)V", "setTopValue", "", "value", "(Ljava/lang/Number;)V", "disableSkipping", "missingValueAsComparableLong", "sortableBytesToLong", "bytes", "", "NumericLeafComparator", "Companion", "core"})
public abstract class NumericComparator<T extends Number>
extends FieldComparator<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String field;
    @NotNull
    private final T missingValue;
    private final long missingValueAsLong;
    private final boolean reverse;
    private final int bytesCount;
    private boolean topValueSet;
    private boolean singleSort;
    private boolean hitsThresholdReached;
    private boolean queueFull;
    @NotNull
    private Pruning pruning;
    private static final int MIN_SKIP_INTERVAL = 32;
    private static final int MAX_SKIP_INTERVAL = 8192;

    protected NumericComparator(@NotNull String field, @NotNull T missingValue, boolean reverse, @NotNull Pruning pruning, int bytesCount) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter(missingValue, (String)"missingValue");
        Intrinsics.checkNotNullParameter((Object)((Object)pruning), (String)"pruning");
        this.field = field;
        this.missingValue = missingValue;
        this.missingValueAsLong = this.missingValueAsComparableLong();
        this.reverse = reverse;
        this.pruning = pruning;
        this.bytesCount = bytesCount;
    }

    @NotNull
    protected final String getField() {
        return this.field;
    }

    @NotNull
    protected final T getMissingValue() {
        return this.missingValue;
    }

    protected final boolean getReverse() {
        return this.reverse;
    }

    protected final boolean getTopValueSet() {
        return this.topValueSet;
    }

    protected final void setTopValueSet(boolean bl) {
        this.topValueSet = bl;
    }

    protected final boolean getSingleSort() {
        return this.singleSort;
    }

    protected final void setSingleSort(boolean bl) {
        this.singleSort = bl;
    }

    protected final boolean getHitsThresholdReached() {
        return this.hitsThresholdReached;
    }

    protected final void setHitsThresholdReached(boolean bl) {
        this.hitsThresholdReached = bl;
    }

    protected final boolean getQueueFull() {
        return this.queueFull;
    }

    protected final void setQueueFull(boolean bl) {
        this.queueFull = bl;
    }

    @NotNull
    protected final Pruning getPruning() {
        return this.pruning;
    }

    protected final void setPruning(@NotNull Pruning pruning) {
        Intrinsics.checkNotNullParameter((Object)((Object)pruning), (String)"<set-?>");
        this.pruning = pruning;
    }

    @Override
    public void setTopValue(@NotNull T value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.topValueSet = true;
    }

    @Override
    public void setSingleSort() {
        this.singleSort = true;
    }

    @Override
    public void disableSkipping() {
        this.pruning = Pruning.NONE;
    }

    protected abstract long missingValueAsComparableLong();

    protected abstract long sortableBytesToLong(@NotNull byte[] var1);

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/gnit/lucenekmp/search/comparators/NumericComparator$Companion;", "", "<init>", "()V", "MIN_SKIP_INTERVAL", "", "MAX_SKIP_INTERVAL", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\b\u00a6\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u001fH\u0004J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0011H\u0016J\u0018\u0010#\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00112\u0006\u0010$\u001a\u00020\u0011H\u0016J\u0010\u0010%\u001a\u00020!2\u0006\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020!H\u0016J\b\u0010)\u001a\u00020!H\u0002J\n\u0010*\u001a\u0004\u0018\u00010\rH\u0002J\u0010\u0010+\u001a\u00020!2\u0006\u0010,\u001a\u00020\u000fH\u0002J\b\u0010-\u001a\u00020!H\u0002J\b\u0010.\u001a\u00020!H\u0002J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\b\u00101\u001a\u00020\u0014H$J\b\u00102\u001a\u00020\u0014H$R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010/\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u00100\u00a8\u00063"}, d2={"Lorg/gnit/lucenekmp/search/comparators/NumericComparator$NumericLeafComparator;", "Lorg/gnit/lucenekmp/search/LeafFieldComparator;", "context", "Lorg/gnit/lucenekmp/index/LeafReaderContext;", "<init>", "(Lorg/gnit/lucenekmp/search/comparators/NumericComparator;Lorg/gnit/lucenekmp/index/LeafReaderContext;)V", "docValues", "Lorg/gnit/lucenekmp/index/NumericDocValues;", "getDocValues", "()Lorg/gnit/lucenekmp/index/NumericDocValues;", "pointValues", "Lorg/gnit/lucenekmp/index/PointValues;", "pointTree", "Lorg/gnit/lucenekmp/index/PointValues$PointTree;", "enableSkipping", "", "maxDoc", "", "leafTopSet", "minValueAsLong", "", "maxValueAsLong", "competitiveIterator", "Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "iteratorCost", "maxDocVisited", "updateCounter", "currentSkipInterval", "tryUpdateFailCount", "getNumericDocValues", "field", "", "setBottom", "", "slot", "copy", "doc", "setScorer", "scorer", "Lorg/gnit/lucenekmp/search/Scorable;", "setHitsThresholdReached", "updateCompetitiveIterator", "getPointTree", "updateSkipInterval", "success", "encodeBottom", "encodeTop", "isMissingValueCompetitive", "()Z", "bottomAsComparableLong", "topAsComparableLong", "core"})
    @SourceDebugExtension(value={"SMAP\nNumericComparator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NumericComparator.kt\norg/gnit/lucenekmp/search/comparators/NumericComparator$NumericLeafComparator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,415:1\n1#2:416\n*E\n"})
    public abstract class NumericLeafComparator
    implements LeafFieldComparator {
        @NotNull
        private final LeafReaderContext context;
        @NotNull
        private final NumericDocValues docValues;
        @Nullable
        private final PointValues pointValues;
        @Nullable
        private PointValues.PointTree pointTree;
        private boolean enableSkipping;
        private int maxDoc;
        private final boolean leafTopSet;
        private long minValueAsLong;
        private long maxValueAsLong;
        private DocIdSetIterator competitiveIterator;
        private long iteratorCost;
        private int maxDocVisited;
        private int updateCounter;
        private int currentSkipInterval;
        private int tryUpdateFailCount;

        public NumericLeafComparator(LeafReaderContext context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            this.leafTopSet = NumericComparator.this.getTopValueSet();
            this.minValueAsLong = Long.MIN_VALUE;
            this.maxValueAsLong = Long.MAX_VALUE;
            this.iteratorCost = -1L;
            this.maxDocVisited = -1;
            this.currentSkipInterval = 32;
            this.context = context;
            this.docValues = this.getNumericDocValues(context, NumericComparator.this.getField());
            PointValues pointValues = this.pointValues = NumericComparator.this.getPruning() != Pruning.NONE ? context.reader().getPointValues(NumericComparator.this.getField()) : null;
            PointValues.PointTree pointTree2 = this.pointTree = pointValues != null ? pointValues.getPointTree() : null;
            if (this.pointValues != null) {
                FieldInfo info = context.reader().getFieldInfos().fieldInfo(NumericComparator.this.getField());
                boolean bl = info != null && info.getPointDimensionCount() != 0;
                NumericComparator numericComparator = NumericComparator.this;
                if (!bl) {
                    boolean $i$a$-check-NumericComparator$NumericLeafComparator$22 = false;
                    String $i$a$-check-NumericComparator$NumericLeafComparator$22 = "Field " + numericComparator.getField() + " doesn't index points according to FieldInfos yet returns non-null PointValues";
                    throw new IllegalStateException($i$a$-check-NumericComparator$NumericLeafComparator$22.toString());
                }
                bl = info.getPointDimensionCount() <= 1;
                numericComparator = NumericComparator.this;
                if (!bl) {
                    boolean $i$a$-require-NumericComparator$NumericLeafComparator$42 = false;
                    String $i$a$-require-NumericComparator$NumericLeafComparator$42 = "Field " + numericComparator.getField() + " is indexed with multiple dimensions, sorting is not supported";
                    throw new IllegalArgumentException($i$a$-require-NumericComparator$NumericLeafComparator$42.toString());
                }
                bl = info.getPointNumBytes() == NumericComparator.this.bytesCount;
                numericComparator = NumericComparator.this;
                if (!bl) {
                    boolean bl2 = false;
                    String string = "Field " + numericComparator.getField() + " is indexed with " + info.getPointNumBytes() + " bytes per dimension, but " + numericComparator + " expected " + numericComparator.bytesCount;
                    throw new IllegalArgumentException(string.toString());
                }
                this.enableSkipping = true;
                this.maxDoc = context.reader().maxDoc();
                this.competitiveIterator = DocIdSetIterator.Companion.all(this.maxDoc);
                if (this.leafTopSet) {
                    this.encodeTop();
                }
            } else {
                this.enableSkipping = false;
                this.maxDoc = 0;
            }
        }

        @NotNull
        protected final NumericDocValues getDocValues() {
            return this.docValues;
        }

        @NotNull
        protected final NumericDocValues getNumericDocValues(@NotNull LeafReaderContext context, @NotNull String field) throws IOException {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            return DocValues.INSTANCE.getNumeric(context.reader(), field);
        }

        @Override
        public void setBottom(int slot) throws IOException {
            NumericComparator.this.setQueueFull(true);
            this.updateCompetitiveIterator();
        }

        @Override
        public void copy(int slot, int doc) throws IOException {
            this.maxDocVisited = doc;
        }

        @Override
        public void setScorer(@NotNull Scorable scorer2) throws IOException {
            Intrinsics.checkNotNullParameter((Object)scorer2, (String)"scorer");
            if (this.iteratorCost == -1L) {
                this.iteratorCost = scorer2 instanceof Scorer ? ((Scorer)scorer2).iterator().cost() : (long)this.maxDoc;
                this.updateCompetitiveIterator();
            }
        }

        @Override
        public void setHitsThresholdReached() throws IOException {
            NumericComparator.this.setHitsThresholdReached(true);
            this.updateCompetitiveIterator();
        }

        private final void updateCompetitiveIterator() throws IOException {
            if (!this.enableSkipping || !NumericComparator.this.getHitsThresholdReached() || !this.leafTopSet && !NumericComparator.this.getQueueFull()) {
                return;
            }
            PointValues pointValues = this.pointValues;
            Intrinsics.checkNotNull((Object)pointValues);
            if (pointValues.getDocCount() < this.maxDoc && this.isMissingValueCompetitive()) {
                return;
            }
            int n = this.updateCounter;
            this.updateCounter = n + 1;
            if (this.updateCounter > 256 && (this.updateCounter & this.currentSkipInterval - 1) != this.currentSkipInterval - 1) {
                return;
            }
            if (NumericComparator.this.getQueueFull()) {
                this.encodeBottom();
            }
            DocIdSetBuilder result = new DocIdSetBuilder(this.maxDoc);
            PointValues.IntersectVisitor visitor2 = new PointValues.IntersectVisitor(result, this, NumericComparator.this){
                private DocIdSetBuilder.BulkAdder adder;
                final /* synthetic */ DocIdSetBuilder $result;
                final /* synthetic */ NumericLeafComparator this$0;
                final /* synthetic */ NumericComparator<T> this$1;
                {
                    this.$result = $result;
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                }

                public final DocIdSetBuilder.BulkAdder getAdder() {
                    return this.adder;
                }

                public final void setAdder(DocIdSetBuilder.BulkAdder bulkAdder) {
                    this.adder = bulkAdder;
                }

                public void grow(int count) {
                    this.adder = this.$result.grow(count);
                }

                public void visit(int docID) {
                    if (docID <= NumericLeafComparator.access$getMaxDocVisited$p(this.this$0)) {
                        return;
                    }
                    DocIdSetBuilder.BulkAdder bulkAdder = this.adder;
                    Intrinsics.checkNotNull((Object)bulkAdder);
                    bulkAdder.add(docID);
                }

                public void visit(int docID, byte[] packedValue) {
                    Intrinsics.checkNotNullParameter((Object)packedValue, (String)"packedValue");
                    if (docID <= NumericLeafComparator.access$getMaxDocVisited$p(this.this$0)) {
                        return;
                    }
                    long l = this.this$1.sortableBytesToLong(packedValue);
                    if (l >= NumericLeafComparator.access$getMinValueAsLong$p(this.this$0) && l <= NumericLeafComparator.access$getMaxValueAsLong$p(this.this$0)) {
                        DocIdSetBuilder.BulkAdder bulkAdder = this.adder;
                        Intrinsics.checkNotNull((Object)bulkAdder);
                        bulkAdder.add(docID);
                    }
                }

                public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
                    Intrinsics.checkNotNullParameter((Object)minPackedValue, (String)"minPackedValue");
                    Intrinsics.checkNotNullParameter((Object)maxPackedValue, (String)"maxPackedValue");
                    long min = this.this$1.sortableBytesToLong(minPackedValue);
                    long max = this.this$1.sortableBytesToLong(maxPackedValue);
                    if (min > NumericLeafComparator.access$getMaxValueAsLong$p(this.this$0) || max < NumericLeafComparator.access$getMinValueAsLong$p(this.this$0)) {
                        return PointValues.Relation.CELL_OUTSIDE_QUERY;
                    }
                    if (min < NumericLeafComparator.access$getMinValueAsLong$p(this.this$0) || max > NumericLeafComparator.access$getMaxValueAsLong$p(this.this$0)) {
                        return PointValues.Relation.CELL_CROSSES_QUERY;
                    }
                    return PointValues.Relation.CELL_INSIDE_QUERY;
                }

                public void visit(DocIdSetIterator iterator2) throws IOException {
                    PointValues.IntersectVisitor.super.visit(iterator2);
                }

                public void visit(IntsRef ref) throws IOException {
                    PointValues.IntersectVisitor.super.visit(ref);
                }

                public void visit(DocIdSetIterator iterator2, byte[] packedValue) throws IOException {
                    PointValues.IntersectVisitor.super.visit(iterator2, packedValue);
                }
            };
            long threshold = this.iteratorCost >>> 3;
            PointValues.PointTree pointTree2 = this.getPointTree();
            Intrinsics.checkNotNull((Object)pointTree2);
            if (PointValues.Companion.isEstimatedPointCountGreaterThanOrEqualTo(visitor2, pointTree2, threshold)) {
                this.updateSkipInterval(false);
                if ((long)this.pointValues.getDocCount() < this.iteratorCost) {
                    this.competitiveIterator = this.getNumericDocValues(this.context, NumericComparator.this.getField());
                    this.iteratorCost = this.pointValues.getDocCount();
                }
                return;
            }
            this.pointValues.intersect(visitor2);
            this.competitiveIterator = result.build().iterator();
            DocIdSetIterator docIdSetIterator = this.competitiveIterator;
            if (docIdSetIterator == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"competitiveIterator");
                docIdSetIterator = null;
            }
            this.iteratorCost = docIdSetIterator.cost();
            this.updateSkipInterval(true);
        }

        private final PointValues.PointTree getPointTree() throws IOException {
            if (this.pointTree == null) {
                PointValues pointValues = this.pointValues;
                Intrinsics.checkNotNull((Object)pointValues);
                this.pointTree = pointValues.getPointTree();
            }
            return this.pointTree;
        }

        private final void updateSkipInterval(boolean success) {
            if (this.updateCounter > 256) {
                if (success) {
                    this.currentSkipInterval = Math.max(this.currentSkipInterval / 2, 32);
                    this.tryUpdateFailCount = 0;
                } else if (this.tryUpdateFailCount >= 3) {
                    this.currentSkipInterval = Math.min(this.currentSkipInterval * 2, 8192);
                    this.tryUpdateFailCount = 0;
                } else {
                    int n = this.tryUpdateFailCount;
                    this.tryUpdateFailCount = n + 1;
                }
            }
        }

        private final void encodeBottom() {
            if (!NumericComparator.this.getReverse()) {
                this.maxValueAsLong = this.bottomAsComparableLong();
                if (NumericComparator.this.getPruning() == Pruning.GREATER_THAN_OR_EQUAL_TO && this.maxValueAsLong != Long.MIN_VALUE) {
                    long l = this.maxValueAsLong;
                    this.maxValueAsLong = l + -1L;
                }
            } else {
                this.minValueAsLong = this.bottomAsComparableLong();
                if (NumericComparator.this.getPruning() == Pruning.GREATER_THAN_OR_EQUAL_TO && this.minValueAsLong != Long.MAX_VALUE) {
                    long l = this.minValueAsLong;
                    this.minValueAsLong = l + 1L;
                }
            }
        }

        private final void encodeTop() {
            if (!NumericComparator.this.getReverse()) {
                this.minValueAsLong = this.topAsComparableLong();
                if (NumericComparator.this.getSingleSort() && NumericComparator.this.getPruning() == Pruning.GREATER_THAN_OR_EQUAL_TO && NumericComparator.this.getQueueFull() && this.minValueAsLong != Long.MAX_VALUE) {
                    long l = this.minValueAsLong;
                    this.minValueAsLong = l + 1L;
                }
            } else {
                this.maxValueAsLong = this.topAsComparableLong();
                if (NumericComparator.this.getSingleSort() && NumericComparator.this.getPruning() == Pruning.GREATER_THAN_OR_EQUAL_TO && NumericComparator.this.getQueueFull() && this.maxValueAsLong != Long.MIN_VALUE) {
                    long l = this.maxValueAsLong;
                    this.maxValueAsLong = l + -1L;
                }
            }
        }

        private final boolean isMissingValueCompetitive() {
            int result;
            if (NumericComparator.this.getQueueFull()) {
                boolean competitive;
                result = LongExtKt.compare(LongCompanionObject.INSTANCE, NumericComparator.this.missingValueAsLong, this.bottomAsComparableLong());
                boolean bl = NumericComparator.this.getReverse() ? (NumericComparator.this.getPruning() == Pruning.GREATER_THAN_OR_EQUAL_TO ? result > 0 : result >= 0) : (NumericComparator.this.getPruning() == Pruning.GREATER_THAN_OR_EQUAL_TO ? result < 0 : (competitive = result <= 0));
                if (!competitive) {
                    return false;
                }
            }
            if (this.leafTopSet) {
                result = LongExtKt.compare(LongCompanionObject.INSTANCE, NumericComparator.this.missingValueAsLong, this.topAsComparableLong());
                return NumericComparator.this.getReverse() ? result <= 0 : result >= 0;
            }
            return true;
        }

        @Override
        @Nullable
        public DocIdSetIterator competitiveIterator() {
            if (!this.enableSkipping) {
                return null;
            }
            return new DocIdSetIterator(this){
                private int docID;
                final /* synthetic */ NumericLeafComparator this$0;
                {
                    this.this$0 = $receiver;
                    DocIdSetIterator docIdSetIterator = NumericLeafComparator.access$getCompetitiveIterator$p($receiver);
                    if (docIdSetIterator == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"competitiveIterator");
                        docIdSetIterator = null;
                    }
                    this.docID = docIdSetIterator.docID();
                }

                public int nextDoc() throws IOException {
                    return this.advance(this.docID + 1);
                }

                public int docID() {
                    return this.docID;
                }

                public long cost() {
                    DocIdSetIterator docIdSetIterator = NumericLeafComparator.access$getCompetitiveIterator$p(this.this$0);
                    if (docIdSetIterator == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"competitiveIterator");
                        docIdSetIterator = null;
                    }
                    return docIdSetIterator.cost();
                }

                public int advance(int target) throws IOException {
                    int n;
                    DocIdSetIterator docIdSetIterator = NumericLeafComparator.access$getCompetitiveIterator$p(this.this$0);
                    if (docIdSetIterator == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"competitiveIterator");
                        docIdSetIterator = null;
                    }
                    int it = n = docIdSetIterator.advance(target);
                    boolean bl = false;
                    this.docID = it;
                    return n;
                }

                public void intoBitSet(int upTo, FixedBitSet bitSet, int offset) throws IOException {
                    DocIdSetIterator docIdSetIterator;
                    Intrinsics.checkNotNullParameter((Object)bitSet, (String)"bitSet");
                    DocIdSetIterator docIdSetIterator2 = NumericLeafComparator.access$getCompetitiveIterator$p(this.this$0);
                    if (docIdSetIterator2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"competitiveIterator");
                        docIdSetIterator2 = null;
                    }
                    if (docIdSetIterator2.docID() < this.docID) {
                        DocIdSetIterator docIdSetIterator3 = NumericLeafComparator.access$getCompetitiveIterator$p(this.this$0);
                        if (docIdSetIterator3 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"competitiveIterator");
                            docIdSetIterator3 = null;
                        }
                        docIdSetIterator3.advance(this.docID);
                    }
                    if ((docIdSetIterator = NumericLeafComparator.access$getCompetitiveIterator$p(this.this$0)) == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"competitiveIterator");
                        docIdSetIterator = null;
                    }
                    docIdSetIterator.intoBitSet(upTo, bitSet, offset);
                    DocIdSetIterator docIdSetIterator4 = NumericLeafComparator.access$getCompetitiveIterator$p(this.this$0);
                    if (docIdSetIterator4 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"competitiveIterator");
                        docIdSetIterator4 = null;
                    }
                    this.docID = docIdSetIterator4.docID();
                }
            };
        }

        protected abstract long bottomAsComparableLong();

        protected abstract long topAsComparableLong();

        public static final /* synthetic */ int access$getMaxDocVisited$p(NumericLeafComparator $this) {
            return $this.maxDocVisited;
        }

        public static final /* synthetic */ long access$getMinValueAsLong$p(NumericLeafComparator $this) {
            return $this.minValueAsLong;
        }

        public static final /* synthetic */ long access$getMaxValueAsLong$p(NumericLeafComparator $this) {
            return $this.maxValueAsLong;
        }

        public static final /* synthetic */ DocIdSetIterator access$getCompetitiveIterator$p(NumericLeafComparator $this) {
            return $this.competitiveIterator;
        }
    }
}

